/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainFactory;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.IEASResourceDomain;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class EASResourceDomainUtil {
    public static void fetchSHRDomain(Context ctx) throws BOSException {
        try {
            String fid;
            IEASResourceDomain iEASResourceDomain = EASResourceDomainFactory.getLocalInstance((Context)ctx);
            EASResourceDomainCollection coll = iEASResourceDomain.getEASResourceDomainCollection();
            HashMap<String, EASResourceDomainInfo> shrDomainsExsitsInDB = new HashMap<String, EASResourceDomainInfo>(coll.size());
            if (coll != null && coll.size() > 0) {
                int total = coll.size();
                for (int i = 0; i < total; ++i) {
                    shrDomainsExsitsInDB.put(coll.get(i).getPackageName(), coll.get(i));
                }
            }
            coll = null;
            Document doc = SHRSyssettingUtil.getXmlFileByPath((String)SHRSyssettingUtil.getPropertiesPathByFileName((String)"SubSystem_eas.xml"));
            Element rootElement = doc.getRootElement();
            XPath rowXPath = XPath.newInstance((String)"//row");
            List rows = rowXPath.selectNodes((Object)rootElement);
            if (null == rows || rows.size() <= 0) {
                return;
            }
            HashMap<String, String> childAndParentMapping = new HashMap<String, String>();
            HashMap<String, Element> shrDomains = new HashMap<String, Element>();
            for (Object e : rows) {
                String fullname = e.getAttributeValue("fullname").replace(".", "\\");
                String parent = e.getAttributeValue("parent").replace(".", "\\");
                childAndParentMapping.put(fullname, parent);
            }
            String shrRootPackage = "com.kingdee.eas.hr".replace(".", "\\");
            for (Element e : rows) {
                String fullname = e.getAttributeValue("fullname").replace(".", "\\");
                String parent = e.getAttributeValue("parent").replace(".", "\\");
                boolean isSHRDomain = EASResourceDomainUtil.isSHRDomain(shrRootPackage, parent, childAndParentMapping);
                if (!isSHRDomain && !shrRootPackage.equals(fullname)) continue;
                shrDomains.put(fullname, e);
            }
            doc = null;
            if (shrDomains.size() <= 0) {
                return;
            }
            String insertSQL = "INSERT INTO T_RES_EASRESOURCEDOMAIN (FPACKAGENAME,FPROJECT,FDOMAINNAME,FID,FPARENTID) VALUES(?,?,?,?,?)";
            String updateSQL = "UPDATE T_RES_EASRESOURCEDOMAIN SET FDOMAINNAME=? WHERE FID=?";
            String updateSQL2 = "UPDATE T_RES_EASRESOURCEDOMAIN SET FPARENTID= (SELECT FID FROM T_RES_EASRESOURCEDOMAIN where FPACKAGENAME = ?) WHERE FPACKAGENAME=?";
            ArrayList<Object[]> addParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateParamList2 = new ArrayList<Object[]>();
            EASResourceDomainInfo info = null;
            for (Map.Entry entry : shrDomains.entrySet()) {
                String pkgName = (String)entry.getKey();
                Element ee = (Element)entry.getValue();
                info = (EASResourceDomainInfo)shrDomainsExsitsInDB.get(pkgName);
                String alias_l2 = ee.getAttributeValue("alias_l2");
                String fparent = ee.getAttributeValue("parent").replace(".", "\\");
                if (null == info) {
                    fid = BOSUuid.create((String)"CCBA8885").toString();
                    addParamList.add(new Object[]{pkgName, pkgName.substring(pkgName.lastIndexOf("\\") + 1), alias_l2, fid.toString(), null});
                    updateParamList2.add(new Object[]{fparent, pkgName});
                    continue;
                }
                if (info.getDomainName().equals(alias_l2)) continue;
                updateParamList.add(new Object[]{alias_l2, info.getId().toString()});
            }
            shrDomains = null;
            rows = null;
            List list = ResourceType.getEnumList();
            for (ResourceType resourceType : list) {
                String fullname = resourceType.getValue();
                String parent = "com.kingdee.eas.hr".replace(".", "\\");
                info = (EASResourceDomainInfo)shrDomainsExsitsInDB.get(fullname);
                String alias_l2 = resourceType.getAlias();
                if (info == null) {
                    fid = BOSUuid.create((String)"CCBA8885").toString();
                    addParamList.add(new Object[]{fullname, fullname.substring(fullname.lastIndexOf("\\") + 1), alias_l2, fid.toString(), null});
                    updateParamList2.add(new Object[]{parent, fullname});
                    continue;
                }
                if (info.getDomainName().equals(alias_l2)) continue;
                updateParamList.add(new Object[]{alias_l2, info.getId().toString()});
            }
            rows = null;
            shrDomainsExsitsInDB = null;
            if (addParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)insertSQL, addParamList);
            }
            if (updateParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)updateSQL, updateParamList);
            }
            if (updateParamList2.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)updateSQL2, updateParamList2);
            }
            addParamList = null;
            updateParamList = null;
            updateParamList2 = null;
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isSHRDomain(String shrRootPackage, String parent, Map<String, String> childAndParentMapping) {
        if (shrRootPackage.equals(parent)) {
            return true;
        }
        String pParent = childAndParentMapping.get(parent);
        if (StringUtils.isEmpty((String)pParent)) {
            return false;
        }
        return EASResourceDomainUtil.isSHRDomain(shrRootPackage, pParent, childAndParentMapping);
    }
}

