/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.exception.DataAccessException;
import com.kingdee.shr.perfweb.formulaplatform.data.ColumnAttributes;
import com.kingdee.shr.perfweb.formulaplatform.data.DBHelper;
import com.kingdee.shr.perfweb.formulaplatform.data.DBTypes;
import com.kingdee.shr.perfweb.formulaplatform.data.DataSet;
import com.kingdee.shr.perfweb.formulaplatform.data.DataSetGenerator;
import com.kingdee.shr.perfweb.formulaplatform.data.DataTable;
import com.kingdee.shr.perfweb.formulaplatform.data.PreparedSQLInfo;
import com.kingdee.shr.perfweb.formulaplatform.data.ProcOuterTypes;
import com.kingdee.shr.perfweb.formulaplatform.data.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.jtds.jdbc.ClobImpl;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataAccess {
    private static Logger logger = LoggerFactory.getLogger(DataAccess.class);
    public Connection conn = null;
    private final int iQueryTimeout = com.kingdee.shr.compensation.app.formula.data.Context.getQueryTimeout();
    private Context ctx;
    static DBTypes dbtype;

    public static final double doubleValue(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).doubleValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).doubleValue();
        }
        throw new RuntimeException("illegal datatype" + o.getClass());
    }

    public static final float floatValue(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Integer) {
            return ((Integer)o).floatValue();
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).floatValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).floatValue();
        }
        throw new RuntimeException("illegal datatype" + o.getClass());
    }

    public static final int intValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).intValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        throw new RuntimeException("illegal datatype" + o.getClass());
    }

    public static final String stringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd").format(o);
        }
        if (o instanceof TIMESTAMP) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((TIMESTAMP)o).timestampValue());
            }
            catch (SQLException e) {
                throw new RuntimeException("illegal TIMESTAMP data\uff01");
            }
        }
        if (o instanceof CLOB) {
            try {
                CLOB clob = (CLOB)o;
                long l = clob.length();
                int i = (int)l;
                return clob.getSubString(1L, i);
            }
            catch (SQLException e) {
                throw new RuntimeException("illegal CLOB data\uff01");
            }
        }
        if (o instanceof ClobImpl) {
            try {
                ClobImpl clob = (ClobImpl)o;
                long l = clob.length();
                int i = (int)l;
                return clob.getSubString(1L, i);
            }
            catch (SQLException e) {
                throw new RuntimeException("illegal CLOB data\uff01");
            }
        }
        return o.toString();
    }

    private static final int changeOracleTypes(ProcOuterTypes type) {
        if (type == ProcOuterTypes.INT) {
            return 4;
        }
        if (type == ProcOuterTypes.CURSOR) {
            return -10;
        }
        return 12;
    }

    private static final void closeCallableStatement(CallableStatement cs) {
        if (cs != null) {
            cs = null;
        }
    }

    public static final DBTypes DBType() {
        return dbtype;
    }

    public static final DataTable generateDataTable(String tablename, ResultSet rs) throws Exception {
        ArrayList<ColumnAttributes> columns = DataSetGenerator.generateColumns(rs.getMetaData());
        DataTable dt = DataSetGenerator.generateDatas(rs, columns);
        dt.tablename = tablename;
        dt.columns = columns;
        dt.emptyrow = DataSetGenerator.generateEmptyRow(columns);
        return dt;
    }

    public static final void logException(Exception e) {
        logger.error(e.getMessage());
    }

    private static final void setParameterValue(CallableStatement cs, int index, Object value) throws Exception {
        if (value instanceof Integer) {
            cs.setInt(index + 1, (int)((Integer)value));
        } else {
            cs.setString(index + 1, value.toString());
        }
    }

    public void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            DataAccess.logException(e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            DataAccess.logException(e);
        }
    }

    public abstract void CloseCallableStatement(CallableStatement var1);

    public void closeConnection() {
        DBHelper.closeConnection(this.conn);
    }

    public void closeRecordSet(ResultSet rs) throws Exception {
        if (rs == null) {
            return;
        }
        DBHelper.closeResultSet(rs);
    }

    public abstract void DeleteCoderRowRange(String var1, String var2);

    public abstract void DeleteCondition(String var1);

    public abstract void DeletePeopleRowRange(String var1, String var2);

    public abstract void DeleteQuery(String var1);

    public abstract void DeleteUserFace(String var1);

    public void executeBatch(ArrayList sqlLists) {
        this.executeBatch(sqlLists.toArray());
    }

    public void executeBatch(Object[] sqlLists) {
        if (sqlLists == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int i = 0;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            conn.setAutoCommit(false);
            for (i = 0; i < sqlLists.length; ++i) {
                stmt.executeUpdate(sqlLists[i].toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            logger.error("error SQL sqlLists[" + i + "]");
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
        }
    }

    public abstract void ExecuteCallableStatement(CallableStatement var1);

    public int executeNoQuery(String sql) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int affectrows;
            conn = this.getConnection();
            stmt = conn.createStatement();
            int n = affectrows = stmt.executeUpdate(sql);
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
        }
    }

    public void executePreparedBatch(PreparedSQLInfo psi) throws Exception {
        if (psi == null) {
            return;
        }
        List preparedList = psi.getPreparedList();
        if (preparedList == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        boolean isTransaction = false;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(isTransaction);
            for (int i = 0; preparedList != null && i < preparedList.size(); ++i) {
                Set paraSet;
                String preparedSQL;
                HashMap childPrepared = (HashMap)preparedList.get(i);
                if (childPrepared == null || (preparedSQL = (String)childPrepared.get("SQL")) == null || preparedSQL.length() <= 0) continue;
                HashMap parameters = (HashMap)childPrepared.get("PARAMETERS");
                pstmt = conn.prepareStatement(preparedSQL);
                if (parameters != null && (paraSet = parameters.keySet()) != null) {
                    for (Integer key : paraSet) {
                        if (key == null) continue;
                        int parameterIndex = key;
                        pstmt.setObject(parameterIndex, parameters.get(key));
                    }
                }
                pstmt.executeUpdate();
                pstmt.close();
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, pstmt, null);
        }
    }

    public int executePreparedSQL(PreparedSQLInfo psi) throws Exception {
        int rtn = -1;
        if (psi == null) {
            return rtn;
        }
        String preparedSQL = psi.getPreparedSQL();
        Map parameters = psi.getParameters();
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return rtn;
        }
        rtn = this.executePreparedSQL(preparedSQL, parameters);
        return rtn;
    }

    private int executePreparedSQL(String preparedSQL, Map parameters) throws Exception {
        int rtn = -1;
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return rtn;
        }
        PreparedStatement pstmt = null;
        try {
            Set paraSet;
            this.openConnection();
            pstmt = this.conn.prepareStatement(preparedSQL);
            if (parameters != null && (paraSet = parameters.keySet()) != null) {
                for (Integer key : paraSet) {
                    if (key == null) continue;
                    int parameterIndex = key;
                    Object parameterValue = parameters.get(key);
                    pstmt.setObject(parameterIndex, parameterValue);
                }
            }
            rtn = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            String message = "EXECUTE_STATEMENT_FAILED_MSG" + ex;
            logger.error(message, (Throwable)ex);
            throw new SQLException(message);
        }
        finally {
            this.closeAllDBSource(this.conn, pstmt, null);
        }
        return rtn;
    }

    public int executePS(PreparedStatement ps) throws Exception {
        int count = 0;
        try {
            count = ps.executeUpdate();
        }
        catch (SQLException ex) {
            String message = "EXECUTE_SQL_ERROR_MSG" + ex;
            logger.error(message, (Throwable)ex);
            throw new SQLException(message);
        }
        return count;
    }

    public void executeSQL(String SQL) throws Exception {
        Statement stmt = null;
        try {
            this.openConnection();
            stmt = this.conn.createStatement();
            stmt.executeUpdate(SQL);
        }
        catch (SQLException ex) {
            String message = "EXECUTE_STATEMENT_FAILED_MSG" + ex;
            logger.error(message, (Throwable)ex);
            throw new SQLException(message);
        }
        finally {
            this.closeAllDBSource(this.conn, stmt, null);
        }
    }

    public boolean executeTrans(ArrayList sqls) throws Exception {
        Statement stmt = null;
        try {
            int i;
            this.openConnection();
            this.conn.setAutoCommit(false);
            stmt = this.conn.createStatement();
            logger.info("DataAccessOra.java ecuteTrans--------------------------");
            for (i = 0; i < sqls.size(); i += 1) {
                stmt.executeUpdate(sqls.get(i).toString());
            }
            logger.info("DataAccessOra.java ecuteTrans--------------------------");
            this.conn.commit();
            i = 1;
            this.closeAllDBSource(this.conn, stmt, null);
            return i != 0;
        }
        catch (SQLException se) {
            try {
                try {
                    logger.error("", (Throwable)se);
                    if (this.conn != null) {
                        this.conn.rollback();
                    }
                    logger.error("", (Throwable)se);
                    String message = "EXECUTE_SQL_ERROR_MSG" + se;
                    throw new SQLException(message);
                }
                catch (SQLException e) {
                    logger.error("", (Throwable)se);
                    String message = "ROLLBACK_FAILED_MSG" + se;
                    throw new SQLException(message);
                }
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(this.conn, stmt, null);
                throw throwable;
            }
        }
    }

    public abstract String GetBranch(String var1, String var2, String var3);

    public abstract ResultSet GetCoderRowRangeHTML(String var1, String var2);

    public abstract String getCoderRowRangeStatement(String var1, String var2);

    public abstract DataTable GetCodes(String var1, String var2);

    public abstract ResultSet GetConditionByGUID(String var1);

    public abstract ResultSet GetConditionTree(String var1, String var2, String var3);

    public abstract ResultSet GetCondtionDetail(String var1, String var2);

    public Connection getConnection() throws SQLException {
        this.ctx = Tools.getInstance().getCtx();
        return EJBFactory.getConnection((Context)this.ctx);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public abstract ResultSet GetCustomInterfaceByGUID(String var1);

    public abstract String GetDataInHtmlDIV(String var1);

    public abstract String GetDataInHtmlDIVEx(String var1);

    public DataTable getDataTable(String sql) {
        return this.getDataTable(sql, "Table1");
    }

    public DataTable getDataTable(String sql, String name) {
        DataTable dt = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            dt = DataAccess.generateDataTable(name, rs);
            this.closeAllDBSource(conn, stmt, rs);
        }
        catch (Exception e) {
            try {
                logger.error("Exception: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(conn, stmt, rs);
                throw throwable;
            }
        }
        return dt;
    }

    public DataTable getDataForDataTable(String sql) {
        DataTable dt = new DataTable();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ArrayList<ColumnAttributes> columns = DataSetGenerator.generateColumns(rs.getMetaData());
            dt = DataSetGenerator.generateDatas(rs, columns);
            dt.columns = columns;
            dt.emptyrow = DataSetGenerator.generateEmptyRow(columns);
            this.closeAllDBSource(conn, stmt, rs);
        }
        catch (Exception e) {
            try {
                logger.error("Exception: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(conn, stmt, rs);
                throw throwable;
            }
        }
        return dt;
    }

    public DataTable getDataTablePS(PreparedSQLInfo psi) {
        return this.getDataTablePS(psi, "Table1");
    }

    public DataTable getDataTablePS(PreparedSQLInfo psi, String name) {
        DataTable dt = null;
        if (psi == null) {
            return dt;
        }
        String preparedSQL = psi.getPreparedSQL();
        Map parameters = psi.getParameters();
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return dt;
        }
        dt = this.getDataTablePS(preparedSQL, parameters, name);
        return dt;
    }

    private DataTable getDataTablePS(String preparedSQL, Map parameters, String name) {
        DataTable dt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        if (preparedSQL == null || preparedSQL.equals("")) {
            return dt;
        }
        try {
            Set paraSet;
            this.openConnection();
            pstmt = this.conn.prepareStatement(preparedSQL);
            pstmt.setQueryTimeout(this.iQueryTimeout);
            if (parameters != null && (paraSet = parameters.keySet()) != null) {
                for (Integer key : paraSet) {
                    if (key == null) continue;
                    int parameterIndex = key;
                    pstmt.setObject(parameterIndex, parameters.get(key));
                }
            }
            rs = pstmt.executeQuery();
            dt = DataAccess.generateDataTable(name, rs);
            this.closeAllDBSource(this.conn, pstmt, rs);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(this.conn, pstmt, rs);
                throw throwable;
            }
        }
        return dt;
    }

    public abstract DataTable GetEditFieldList(String var1, String var2);

    public abstract String GetFaceUsers(String var1, String var2);

    public abstract ResultSet GetHTML(String var1);

    public abstract ResultSet GetItemByondGroup(String var1);

    public abstract String getOrgRangeCount(String var1);

    public abstract String getOrgRangeStatement(String var1, String var2);

    public abstract ResultSet getPayNode(String var1, int var2);

    public abstract ResultSet GetPeopleRowRangeHTML(String var1);

    public abstract String getPeopleRowRangeStatement(String var1);

    public String getPreparedSQL(String preparedSQL, Map parameters) {
        String interrogation = "?";
        String quotes = "'";
        StringTokenizer token = new StringTokenizer(preparedSQL, interrogation, false);
        StringBuffer buf = new StringBuffer();
        int i = 1;
        while (token.hasMoreTokens()) {
            String tokenChild = token.nextToken();
            buf.append(tokenChild);
            String parameterValue = "";
            if (parameters != null && parameters.get(i) != null) {
                parameterValue = parameters.get(i).toString();
                if (parameterValue == null) {
                    parameterValue = "";
                }
                buf.append(quotes);
                buf.append(parameterValue);
                buf.append(quotes);
            }
            ++i;
        }
        return buf.toString();
    }

    public Object getProcResult(String procname, Object[] parameters, ProcOuterTypes type) throws Exception {
        int i;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Object result = null;
        CallableStatement cs = null;
        StringBuffer sb = new StringBuffer("{call " + procname + "(");
        int psize = parameters.length;
        for (i = 0; i < psize - 1; ++i) {
            sb.append("?,");
        }
        if (type != ProcOuterTypes.NULL) {
            sb.append("?,?)}");
        } else {
            sb.append("?)}");
        }
        try {
            conn = this.getConnection();
            cs = conn.prepareCall(sb.toString());
            for (i = 0; i < psize; ++i) {
                DataAccess.setParameterValue(cs, i, parameters[i]);
            }
            if (type != ProcOuterTypes.NULL) {
                cs.registerOutParameter(psize + 1, DataAccess.changeOracleTypes(type));
            }
            cs.execute();
            int updateCount = -1;
            DataSet ds = new DataSet();
            rs = null;
            int index = 0;
            boolean isds = false;
            do {
                if ((updateCount = cs.getUpdateCount()) != -1) {
                    cs.getMoreResults();
                    continue;
                }
                rs = cs.getResultSet();
                if (rs == null) continue;
                ds.addTable(DataAccess.generateDataTable("pro" + index++, rs));
                if (!isds) {
                    isds = true;
                }
                cs.getMoreResults();
            } while (updateCount != -1 || rs != null);
            if (type != ProcOuterTypes.NULL && (result = cs.getObject(psize + 1)) instanceof ResultSet) {
                rs = (ResultSet)result;
                ds.addTable(DataAccess.generateDataTable(procname, rs));
                if (!isds) {
                    isds = true;
                }
            }
            if (isds) {
                result = ds;
            }
            this.closeAllDBSource(conn, stmt, rs);
            DataAccess.closeCallableStatement(cs);
        }
        catch (Exception e) {
            DataAccess.logException(e);
            this.closeAllDBSource(conn, stmt, rs);
            DataAccess.closeCallableStatement(cs);
            throw e;
        }
        return result;
    }

    public abstract ResultSet GetQueryByGUID(String var1);

    @Deprecated
    public String getSingleData(String sql) {
        String result;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            result = rs.next() ? DataAccess.stringValue(rs.getObject(1)) : "";
            this.closeAllDBSource(conn, stmt, rs);
        }
        catch (Exception e) {
            try {
                DataAccess.logException(e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(conn, stmt, rs);
                throw throwable;
            }
        }
        return result;
    }

    public String getSingleDataPS(PreparedSQLInfo psi) {
        String result = "";
        if (psi == null) {
            return result;
        }
        String preparedSQL = psi.getPreparedSQL();
        Map parameters = psi.getParameters();
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return result;
        }
        result = this.getSingleDataPS(preparedSQL, parameters);
        return result;
    }

    private String getSingleDataPS(String preparedSQL, Map parameters) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return result;
        }
        try {
            Set paraSet;
            this.openConnection();
            pstmt = this.conn.prepareStatement(preparedSQL);
            pstmt.setQueryTimeout(this.iQueryTimeout);
            if (parameters != null && (paraSet = parameters.keySet()) != null) {
                for (Integer key : paraSet) {
                    if (key == null) continue;
                    int parameterIndex = key;
                    pstmt.setObject(parameterIndex, parameters.get(key));
                }
            }
            result = (rs = pstmt.executeQuery()) != null && rs.next() ? DataAccess.stringValue(rs.getObject(1)) : "";
            this.closeAllDBSource(this.conn, pstmt, rs);
        }
        catch (Exception e) {
            try {
                DataAccess.logException(e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(this.conn, pstmt, rs);
                throw throwable;
            }
        }
        return result;
    }

    public abstract ResultSet GetTable(String var1);

    public abstract DataTable GetTableByPage(String var1, int var2, int var3);

    public abstract ResultSet GetTableByPageRs(String var1, int var2, int var3);

    public abstract ResultSet GetTableByPS(PreparedStatement var1);

    public abstract DataTable GetTableByRange(String var1, int var2, int var3);

    public abstract ResultSet GetTableByRangeRs(String var1, int var2, int var3);

    public abstract String gettablexh(String var1, String var2);

    public abstract ResultSet GetUserFace(String var1, String var2);

    public abstract ResultSet GetUserProfile(String var1, String var2);

    public abstract DataTable GetVisibleFields(String var1, String var2, String var3, String var4);

    public abstract DataTable GetVisibleFields(String var1, String var2, String var3, String var4, String var5);

    public abstract DataTable GetVisibleFieldsByWLBDM(String var1, String var2, String var3, String var4);

    public abstract DataTable GetVisibleFieldsByWLBDM(String var1, String var2, String var3, String var4, String var5);

    public abstract com.kingdee.shr.perfweb.formulaplatform.common.DataTable GetVisibleFieldsRs(String var1, String var2, String var3, String var4);

    public abstract DataTable GetVisibleSubSetList(String var1, String var2, String var3);

    public abstract DataTable GetVisibleSubSetList(String var1, String var2, String var3, String var4);

    public abstract void initApayRoll(String var1);

    public abstract String InsertCoderRowRange(String var1, String var2, String var3, String var4, String var5);

    public abstract String InsertCondition(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13);

    public abstract String InsertPeopleRowRange(String var1, String var2, String var3, String var4, String var5);

    public abstract String InsertQuery(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, String var17, String var18, String var19, String var20);

    public abstract String InsertSearchCondition(String var1, String var2, String var3);

    public abstract String InsertUserFace(String var1, String var2, String var3);

    public abstract String LocateNode(String var1, String var2);

    public void openConnection() {
        logger.debug("openConnection()");
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.getConnection();
            }
        }
        catch (Exception ex) {
            try {
                this.closeConnection();
            }
            catch (Exception ex2) {
                String message = "OPEN_CONNECTION_FAILED_MSG" + ex2;
                throw new RuntimeException(message, ex2);
            }
            String message = "OPEN_CONNECTION_FAILED_MSG" + ex;
            logger.error(message, (Throwable)ex);
            throw new RuntimeException(message);
        }
    }

    public ResultSet queryPreparedSQL(PreparedSQLInfo psi) {
        ResultSet rs = null;
        if (psi == null) {
            return rs;
        }
        String preparedSQL = psi.getPreparedSQL();
        Map parameters = psi.getParameters();
        if (preparedSQL == null || preparedSQL.length() <= 0) {
            return rs;
        }
        rs = this.queryPreparedSQL(preparedSQL, parameters);
        return rs;
    }

    private ResultSet queryPreparedSQL(String preparedSQL, Map parameters) {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            Set paraSet;
            if (preparedSQL == null || preparedSQL.equals("")) {
                ResultSet resultSet = rs;
                return resultSet;
            }
            this.openConnection();
            pstmt = this.conn.prepareStatement(preparedSQL);
            pstmt.setQueryTimeout(this.iQueryTimeout);
            if (parameters != null && (paraSet = parameters.keySet()) != null) {
                for (Integer key : paraSet) {
                    if (key == null) continue;
                    int parameterIndex = key;
                    pstmt.setObject(parameterIndex, parameters.get(key));
                }
            }
            rs = pstmt.executeQuery();
        }
        catch (SQLException ex) {
            rs = null;
            String message = "EXECUTE_SQL_ERROR_MSG" + ex;
            logger.error(message, (Throwable)ex);
            if (ex.getMessage().indexOf("ORA-01013:") != -1) {
                throw new RuntimeException("TIMEOUT_ERROR");
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException: ", (Throwable)e);
                }
            }
        }
        return rs;
    }

    public ResultSet queryPS(PreparedStatement ps) {
        try {
            ResultSet rs = ps.executeQuery();
            return rs;
        }
        catch (Exception ex) {
            String message = "EXECUTE_SQL_ERROR_MSG" + ex;
            logger.error(message, (Throwable)ex);
            throw new RuntimeException(message, ex);
        }
    }

    @Deprecated
    public ResultSet querySQL(String SQL) throws EASBizException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (SQL == null || SQL.equals("")) {
                throw new DataAccessException(DataAccessException.EMPTYSQL);
            }
            this.openConnection();
            stmt = this.conn.prepareStatement(SQL);
            stmt.setQueryTimeout(this.iQueryTimeout);
            ResultSet resultSet = rs = stmt.executeQuery();
            return resultSet;
        }
        catch (SQLException ex) {
            String message = "EXECUTE_SQL_ERROR_MSG" + ex;
            logger.error(message, (Throwable)ex);
            if (ex.getMessage().indexOf("ORA-01013:") != -1) {
                throw new RuntimeException("TIMEOUT_ERROR");
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error("SQLException: ", (Throwable)e);
                }
            }
        }
    }

    public abstract String SaveAs(String var1, String var2, String var3);

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public abstract void SetUserProfile(String var1, String var2, String var3);

    public abstract String toSqlOracleInRegexp_likeString(String var1) throws Exception;

    public abstract String toSqlOracleInString(String var1);

    public abstract String UpdateCoderRowRange(String var1, String var2, String var3, String var4, String var5);

    public abstract void UpdateCondition(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14);

    public abstract String UpdatePeopleRowRange(String var1, String var2, String var3, String var4, String var5);

    public abstract void UpdatePhoto(String var1, byte[] var2);

    public abstract void UpdateQuery(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, String var17, String var18, String var19, String var20, String var21);

    public abstract void UpdateSearchCondition(String var1, String var2, String var3, String var4);

    public abstract void UpdateUserFace(String var1, String var2, String var3);
}

