/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentDownloadService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)AttachmentDownloadService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String attachId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String string = attachId = param.get("attachId") != null ? (String)param.get("attachId") : "";
        if (StringUtils.isEmpty((String)attachId)) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.NOTFOUNDATTACHNENT);
        }
        AttachmentInfo ai = AttachmentFactory.getRemoteInstance().getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachId));
        if (ai == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.NOTFOUNDATTACHNENT);
        }
        result.put("fileName", ai.getName());
        result.put("extName", ai.getSimpleName());
        BASE64Encoder base64Encoder = new BASE64Encoder();
        String encode64 = base64Encoder.encode(ai.getFile());
        result.put("file", encode64);
        result.put("byteSize", ai.getSizeInByte());
        result.put("size", ai.getSize());
        return result;
    }

    public static String StringFilter(String str) throws PatternSyntaxException {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }
}

