/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException2;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEditHandlerService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(CommonEditHandlerService.class);
    private static final String QUERY = "query";
    private static final String ENTITY = "entity";

    public Object process(Context context, Map map) throws EASBizException, BOSException {
        String query = (String)map.get(QUERY);
        String entity = (String)map.get(ENTITY);
        if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)entity)) {
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.UIPKORENTITYREQUIRED);
        }
        HashMap<String, ArrayList<HashMap<String, Object>>> reMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        try {
            List<Map<String, Object>> fieldList = this.assembleColumnModel(map);
            EntityViewInfo ev = this.getEntityViewInfo(context, map);
            if (!StringUtils.isEmpty((String)query)) {
                IQueryExecutor executor = this.getExecutor(context, map);
                executor.setObjectView(ev);
                IRowSet iRowSet = executor.executeQuery();
                ArrayList<HashMap<String, Object>> listData = this.commonAfterGetListData(context, iRowSet);
                this.afterGetData(context, map, listData);
                reMap.put("data", listData);
            } else {
                ICoreBase bizInterface = MetaDataUtil.getBizInterface(entity);
                CoreBaseCollection collection = bizInterface.getCollection(ev);
                this.afterGetData(context, map, collection);
                reMap.put("data", (ArrayList<HashMap<String, Object>>)collection);
            }
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.SYSTEMERR);
        }
        return reMap;
    }

    protected FilterInfo getFilter(Context ctx, Map param) throws BOSException {
        String positionName = (String)param.get("positionName");
        String name = (String)param.get("name");
        String orgName = (String)param.get("orgName");
        String perfPlanId = (String)param.get("perfPlanId");
        FilterInfo filter = new FilterInfo();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionName)) {
            filter.getFilterItems().add(new FilterItemInfo("position.name", (Object)positionName, CompareType.LIKE));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)name)) {
            filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)positionName, CompareType.LIKE));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orgName)) {
            filter.getFilterItems().add(new FilterItemInfo("hrUnitOrg.name", (Object)positionName, CompareType.LIKE));
        }
        filter.mergeFilter(this.getDefoFilter(ctx, param), "AND");
        return filter;
    }

    public FilterInfo getDefoFilter(Context ctx, Map param) {
        return null;
    }

    public SelectorItemCollection getSelector(Context ctx, Map param) {
        SelectorItemCollection sc = (SelectorItemCollection)param.get("SelectorItemCollection");
        this.getDefoSelector(sc, param);
        return sc;
    }

    public SelectorItemCollection getDefoSelector(SelectorItemCollection sc, Map param) {
        return null;
    }

    public IQueryExecutor getExecutor(Context ctx, Map map) throws EASBizException {
        MetaDataPK queryPK = MetaDataPK.create((String)((String)map.get(QUERY)));
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo(Context ctx, Map param) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.getFilter(ctx, param));
        ev.setSelector(this.getSelector(ctx, param));
        return ev;
    }

    private ArrayList<HashMap<String, Object>> commonAfterGetListData(Context ctx, IRowSet iRowSet) throws EASBizException {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        try {
            while (iRowSet.next()) {
                HashMap<String, Object> colmn = new HashMap<String, Object>();
                int columnCount = iRowSet.getRowSetMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    colmn.put(iRowSet.getRowSetMetaData().getColumnName(i), iRowSet.getObject(i) == null ? "" : iRowSet.getObject(i));
                }
                list.add(colmn);
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new SHRPerfWebBizException2(SHRPerfWebBizException2.LOADDATAERR);
        }
        return list;
    }

    public void afterGetData(Context ctx, Map map, List list) {
    }

    public void afterGetData(Context ctx, Map map, CoreBaseCollection list) {
    }

    protected List getFields(Context ctx, Map map) {
        return null;
    }

    private List<Map<String, Object>> assembleColumnModel(Map param) throws EASBizException {
        ArrayList<Map<String, Object>> list = null;
        try {
            String queryModel = (String)param.get("fieldList");
            if (StringUtils.isEmpty((String)queryModel)) {
                return null;
            }
            queryModel = queryModel.trim();
            SelectorItemCollection sc = new SelectorItemCollection();
            list = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> map = null;
            HashSet<String> fieldSet = new HashSet<String>();
            String[] queryMode = queryModel.split(";");
            String[] properties = null;
            String columnName = null;
            for (int i = 0; i < queryMode.length; ++i) {
                properties = queryMode[i].split(",|\uff0c");
                columnName = properties[0];
                if (fieldSet.contains(columnName)) continue;
                fieldSet.add(columnName);
                map = new HashMap<String, Object>();
                block10: for (int j = 0; j < properties.length; ++j) {
                    switch (j) {
                        case 0: {
                            map.put("colName", columnName);
                            continue block10;
                        }
                        case 1: {
                            map.put("showName", properties[j]);
                            continue block10;
                        }
                        case 2: {
                            map.put("hidden", Boolean.valueOf(properties[j]));
                            continue block10;
                        }
                        case 3: {
                            map.put("required", Boolean.valueOf(properties[j]));
                            continue block10;
                        }
                        case 4: {
                            map.put("defaultDisplay", Boolean.valueOf(properties[j]));
                        }
                    }
                }
                sc.add(new SelectorItemInfo(columnName));
                list.add(map);
            }
            param.put("SelectorItemCollection", sc);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARSEFIELDOFOSF);
        }
        return list;
    }
}

