/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaTaskInfo;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.QuesCloudRequestUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMultiPerfPlanListService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMultiPerfPlanListService.class.getName());
    public static final String NONE = "0";
    public static final String COMBINEBYCOMPANY = "1";
    public static final String COMBINEBYDEPARTMENT = "2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        int isOrg = 0;
        if (GetMultiPerfPlanListService.isOrg(map)) {
            isOrg = 1;
        }
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaluInstCombineQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        String currentPersonId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        EntityViewInfo evi = GetMultiPerfPlanListService.getEntityView(ctx, currentPersonId, isOrg);
        exec.setObjectView(evi);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        LinkedList data = new LinkedList();
        HashMap resultMap = new HashMap();
        try {
            IRowSet rowSet = exec.executeQuery();
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            Object rowObj = map.get("rows");
            Object pageObj = map.get("page");
            int rows = 50;
            if (rowObj != null) {
                rows = (Integer)rowObj;
            }
            int page = 1;
            if (pageObj != null) {
                page = (Integer)pageObj;
            }
            String baseUrl = QuesCloudRequestUtil.getBaseUrl(ctx);
            Connection conn = null;
            ResultSet rowset = null;
            PagingHelper pagingHelper = new PagingHelper();
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                int dbType = KSqlUtil.getDbType((Connection)conn);
                while (rowSet.next()) {
                    ArrayList userData;
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    int count = md.getColumnCount();
                    for (int i = 1; i <= count; ++i) {
                        String columnName = md.getColumnName(i);
                        Object value = rowSet.getObject(i);
                        rowMap.put(columnName, value);
                    }
                    String batchTaskId = String.valueOf(rowMap.get("batchTaskId"));
                    String sql = this.getSQL(currentPersonId, batchTaskId, COMBINEBYCOMPANY, ctx);
                    if (StringUtils.isEmpty((CharSequence)sql)) {
                        data.add(rowMap);
                        continue;
                    }
                    sql = sql + " and evaObj.FPaperStatus = '200' ";
                    String companyName = null;
                    String departmentName = null;
                    String evaluationPersonName = null;
                    IRowSet totalSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currentPersonId, COMBINEBYCOMPANY, batchTaskId, isOrg});
                    int totalCount = totalSet.size();
                    if (totalCount > 0) {
                        sql = sql + " order by evaObj.fnumber";
                        sql = pagingHelper.getPagingSqlNoOptmize(dbType, sql, (page - 1) * rows, rows);
                        IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currentPersonId, COMBINEBYCOMPANY, batchTaskId, isOrg});
                        IRowSetMetaData rowSetMetaData = dataSet.getRowSetMetaData();
                        userData = new ArrayList();
                        while (dataSet.next()) {
                            HashMap<String, Object> userInfo = new HashMap<String, Object>();
                            int n = rowSetMetaData.getColumnCount();
                            for (int i = 1; i <= n; ++i) {
                                String columnName = rowSetMetaData.getColumnName(i);
                                Object value = dataSet.getObject(i);
                                if (columnName.equalsIgnoreCase("url")) {
                                    if (null != rowMap.get("url")) continue;
                                    rowMap.put("url", null == value ? "" : QuesCloudRequestUtil.mergeTaskUrl(baseUrl, (String)value));
                                    continue;
                                }
                                userInfo.put(columnName, value);
                            }
                            userData.add(userInfo);
                        }
                        for (Map map2 : userData) {
                            String combineType = (String)map2.get("combineType".toUpperCase());
                            if (!StringUtils.isEmpty((CharSequence)combineType)) {
                                if ("4".equals(combineType) || COMBINEBYCOMPANY.equals(combineType)) {
                                    companyName = (String)map2.get("companyName".toUpperCase());
                                } else if ("5".equals(combineType) || COMBINEBYDEPARTMENT.equals(combineType)) {
                                    companyName = (String)map2.get("companyName".toUpperCase());
                                    departmentName = (String)map2.get("departmentName".toUpperCase());
                                }
                            }
                            if (!NONE.equals(combineType) && !COMBINEBYCOMPANY.equals(combineType) && !COMBINEBYDEPARTMENT.equals(combineType)) continue;
                            HashSet<String> set = new HashSet<String>();
                            set.add(batchTaskId);
                            MultiEvaTaskCollection Tasks = QuesCloudRequestUtil.getMultiEvaTasks(ctx, set);
                            for (MultiEvaTaskInfo taskInfo : Tasks) {
                                if (!batchTaskId.equals(taskInfo.getBatchTaskId())) continue;
                                evaluationPersonName = taskInfo.getMultiPerfRelationReport().getRelationDetail().getEvaluationPersonName();
                            }
                        }
                        if (!StringUtils.isEmpty(companyName)) {
                            rowMap.put("company.name", companyName);
                        }
                        if (!StringUtils.isEmpty(departmentName)) {
                            rowMap.put("company.name", companyName);
                            rowMap.put("department.name", departmentName);
                        }
                        if (!StringUtils.isEmpty(evaluationPersonName)) {
                            rowMap.put("relationDetail.evaluationPersonName", evaluationPersonName);
                        } else {
                            rowMap.put("relationDetail.evaluationPersonName", "");
                        }
                    } else {
                        userData = new ArrayList();
                        rowMap.put("url", "");
                    }
                    rowMap.put("page", page);
                    rowMap.put("rows", rows);
                    rowMap.put("total", totalCount);
                    rowMap.put("submit", this.getSubmit(ctx, currentPersonId, batchTaskId, isOrg));
                    rowMap.put("userData", userData);
                    data.add(rowMap);
                }
                resultMap.put("data", data);
            }
            finally {
                SQLUtils.cleanup(rowset, null, (Connection)conn);
            }
        }
        catch (SQLException e) {
            logger.error("GetMultiPerfPlanListService sql error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("GetMultiPerfPlanListService system error", (Throwable)e);
        }
        return resultMap;
    }

    private Integer getSubmit(Context ctx, String currentPersonId, String batchTaskId, int isOrg) {
        String sql = this.getSQL(currentPersonId, batchTaskId, "3", ctx);
        sql = sql + " and evaObj.FPaperStatus in ('200','600')";
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql, (Object[])new Object[]{currentPersonId, "3", batchTaskId, isOrg});
            return CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return 0;
        }
    }

    private String getSQL(String currentPersonId, String batchTaskId, String status, Context ctx) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{currentPersonId, batchTaskId, status})) {
            logger.info("GetMultiPerfPlanListService request : batchTaskId:" + batchTaskId + ",status:" + status);
            return null;
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        return "SELECT  task.FID, task.fcombineShortUrl as url,task.fstatus as status ,evaObj.FName" + mlFlag + " as objName, evaObj.fnumber as objNumber,position.fname" + mlFlag + " as jobName,org.fname" + mlFlag + " as orgName,  company.fname" + mlFlag + " as companyName, department.fname" + mlFlag + " as departmentName, task.FCombineType as combineType,  details.FEvaluationPersonName as evaluationPersonName  FROM T_EVA_MultiEvaTask AS task LEFT OUTER JOIN T_EVA_MultiPerfRelationReport AS report ON task.FMultiPerfRelationReport = report.FID LEFT OUTER JOIN  T_EVA_MultiPerfRelationDetails AS details ON report.FRelationDetailID = details.FID LEFT OUTER JOIN T_EVA_MultiPerfEvaObject AS evaObj ON report.FPerfEvaObjID = evaObj.FID LEFT OUTER JOIN T_EVA_PerfFile AS perfFile ON evaObj.FPerfFileID = perfFile.FID LEFT OUTER JOIN T_ORG_Position AS position ON perfFile.FPositionID = position.FID LEFT OUTER JOIN T_ORG_Admin AS org  ON evaObj.FAdminOrgUnitID = org.FID LEFT OUTER JOIN T_ORG_Admin AS company  ON org.FCompanyId = company.FID LEFT OUTER JOIN T_ORG_Admin AS department  ON org.FDepartmentId = department.FID where  task.FIsEffect = '1' and task.FReceiver  = ?  and task.FStatus = ?  and task.FBatchTaskId = ?  and evaObj.FisOrg = ? ";
    }

    private static EntityViewInfo getEntityView(Context ctx, String currentPersonId, int isOrg) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = PerfPortalUtils.getMultiAssessmentFilterInfo(ctx, "");
        filterInfo.getFilterItems().add(new FilterItemInfo("batchTaskId IS NOT NULL"));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObj.isOrg", (Object)isOrg, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("multiPeriod.name"));
        sic.add(new SelectorItemInfo("multiPeriod.id"));
        sic.add(new SelectorItemInfo("multiPlan.name"));
        sic.add(new SelectorItemInfo("questionnaireName"));
        sic.add(new SelectorItemInfo("questionnaier"));
        sic.add(new SelectorItemInfo("questionnaierVersion"));
        sic.add(new SelectorItemInfo("batchTaskId"));
        sic.add(new SelectorItemInfo("combineType"));
        evi.setSelector(sic);
        return evi;
    }

    private static boolean isOrg(Map map) {
        return map.get("isOrg") != null && map.get("isOrg").toString().equals(COMBINEBYCOMPANY);
    }
}

