/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonPageHelper;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrgAuthorizedService
implements IHRMsfService,
ICustomDataProcessor {
    private static Logger logger = LoggerFactory.getLogger(GetOrgAuthorizedService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Map<Object, Object> result = new HashMap();
        Object paramRows = map.get("rows");
        Object paramPage = map.get("page");
        String orgName = (String)map.get("orgName");
        int rows = 0;
        int page = 0;
        if (paramRows != null) {
            rows = (Integer)paramRows;
        }
        if (paramPage != null) {
            page = (Integer)paramPage;
        }
        if (result != null && result.size() > 0) {
            return result;
        }
        HashSet<String> orgSet = new HashSet<String>();
        try {
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            String baseSQL = GetOrgAuthorizedService.getBaseSQL(ctx, orgSet, orgName);
            String baseOrder = "flevel, fdisplayname" + mlFlag + " asc";
            if (page == 0 && rows == 0) {
                baseSQL = baseSQL + "order by " + baseOrder;
                result.put("rows", this.formatResultData(ctx, DbUtil.executeQuery((Context)ctx, (String)baseSQL), null));
            } else {
                result = CommonPageHelper.getPageCallbackData(ctx, baseSQL, rows, page, baseOrder, this, null);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rs, String type) throws WfBizException {
        ArrayList list = new ArrayList();
        try {
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("id", rs.getString("fid"));
                    item.put("name", rs.getString("fdisplayname" + mlFlag));
                    list.add(item);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return list;
    }

    private static String getBaseSQL(Context ctx, Set<String> belongOrgIDs, String orgName) {
        StringBuffer sb = new StringBuffer();
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        sb.append("select fid, fdisplayname" + mlFlag + " from T_ORG_Admin where 1=1 ");
        sb.append("and fid in (SELECT RANGE.FORGID  FROM T_PM_ORGRANGE RANGE").append(" LEFT OUTER JOIN T_ORG_ADMIN a").append(" ON RANGE.FORGID = a.FID  WHERE  RANGE.FTYPE = 20 ").append("AND a.FISSTARTSHR = 1 ").append(" AND RANGE.FUSERID = '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "') ");
        if (!StringUtils.isEmpty((CharSequence)orgName)) {
            sb.append(" and fdisplayname" + mlFlag + " like '%" + orgName + "%' ");
        }
        return sb.toString();
    }
}

