/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IPerfWorkFlowFacade;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeFactory;
import com.kingdee.shr.perfweb.bean.PerfScoreBatchSaveBean;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.ServerResponseConst;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class GradeTaskNodeBatchSaveService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.osf.GradeTaskNodeBatchSaveService");
    private static final String OPERATETYPE_SAVE = "0";
    private static final String OPERATETYPE_SUBMIT = "1";

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object operateType = map.get("operateType");
        Object scoreDatas = map.get("scoreDatas");
        if (operateType == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OPERATETYPEREQUIRED, ctx));
            return result;
        }
        if (!OPERATETYPE_SAVE.equals(operateType) && !OPERATETYPE_SUBMIT.equals(operateType)) {
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OPERATETYPEINVALID, ctx));
            return result;
        }
        if (scoreDatas == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SCOREINFOREQUIRED, ctx));
            return result;
        }
        Gson gson = new Gson();
        List scoreList = (List)gson.fromJson(String.valueOf(scoreDatas), new TypeToken<List<PerfScoreBatchSaveBean>>(){}.getType());
        if (scoreList != null && scoreList.size() > 0) {
            ArrayList<String> nodeHandlerIds = new ArrayList<String>();
            for (PerfScoreBatchSaveBean saveBean : scoreList) {
                if (StringUtils.isEmpty((String)saveBean.getGradeTaskNodeInstID())) {
                    result.put("resultFlag", "failure");
                    result.put("errorDes", "gradeTaskNodeInstId required");
                    return result;
                }
                if (StringUtils.isEmpty((String)saveBean.getEvaObj())) {
                    result.put("resultFlag", "failure");
                    result.put("errorDes", "evaObj required");
                    return result;
                }
                nodeHandlerIds.add(saveBean.getGradeTaskNodeInstID());
            }
            IPerfWorkFlowFacade iPerfWorkFlowFacade = PerfWorkFlowFacadeFactory.getLocalInstance((Context)ctx);
            Map saveResult = iPerfWorkFlowFacade.saveNodeSumScoreAndGrade(scoreList);
            String saveStatus = (String)saveResult.get("code");
            if (ServerResponseConst.FAILED.equals(saveStatus)) {
                result.put("resultFlag", "failure");
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TOTALSCORENOTALLOWED, ctx, new Object[]{this.joinEvaObjNamesByNodeIds(ctx, (Set)saveResult.get(saveStatus))}));
                return result;
            }
            if ("400".equals(saveStatus)) {
                result.put("resultFlag", "failure");
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AUTOSCOREOVERSCORELEVELERR, ctx, new Object[]{this.joinEvaObjNamesByNodeIds(ctx, (Set)saveResult.get(saveStatus))}));
                return result;
            }
            if ("999".equals(saveStatus)) {
                result.put("resultFlag", "failure");
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LESSTHANQUANTITYSCORSERR, ctx, new Object[]{this.joinEvaObjNamesByNodeIds(ctx, (Set)saveResult.get(saveStatus))}));
                return result;
            }
            if ("LESSLOWLIMIT".equals(saveStatus)) {
                result.put("resultFlag", "failure");
                result.put("errorDes", new SHRPerfWebBizException(SHRPerfWebBizException.SCOREOVERMIN2).getMessage());
                return result;
            }
            if (ServerResponseConst.INVALID.equals(saveStatus)) {
                result.put("resultFlag", "failure");
                Set invalidNodeHandlerIds = (Set)saveResult.get(saveStatus);
                result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVESCOREERRASNODEHANDLERCHANGED, ctx, new Object[]{invalidNodeHandlerIds.size()}));
                return result;
            }
            if (OPERATETYPE_SUBMIT.equals(operateType)) {
                int succCount = 0;
                int failedCount = 0;
                int invalidCount = 0;
                PerfWorkFlowFacadeControllerBean perfWorkFlowFacadeControllerBean = new PerfWorkFlowFacadeControllerBean();
                for (PerfScoreBatchSaveBean perfScoreBatchSaveBean : scoreList) {
                    String gradeTaskNode = perfScoreBatchSaveBean.getGradeTaskNodeInstID();
                    String response = perfWorkFlowFacadeControllerBean.submitPerfScoreNew(ctx, gradeTaskNode, perfScoreBatchSaveBean.getEvaObj(), false, false);
                    if (response.equals(ServerResponseConst.SUCCESS)) {
                        ++succCount;
                        continue;
                    }
                    if (response.equals(ServerResponseConst.INVALID)) {
                        ++invalidCount;
                        continue;
                    }
                    ++failedCount;
                }
                if (invalidCount != 0) {
                    result.put("resultFlag", "failure");
                    result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUBMITSCOREERRASNODEHANDLERCHANGED, ctx, new Object[]{invalidCount}));
                    return result;
                }
                if (succCount == scoreList.size()) {
                    result.put("resultFlag", "success");
                    result.put("successCount", succCount);
                    return result;
                }
                result.put("resultFlag", "success");
                result.put("successCount", succCount);
                result.put("failedCount", failedCount);
                return result;
            }
            result.put("resultFlag", "success");
            return result;
        }
        result.put("resultFlag", "failure");
        result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SAVEFAILED, ctx));
        return result;
    }

    private String joinEvaObjNames(Set<String> evaObjNames) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String evaObjName : evaObjNames) {
            stringBuffer.append(evaObjName).append(",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private String joinEvaObjNamesByNodeIds(Context ctx, Set<String> evaObjIds) throws BOSException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!CollectionUtils.isEmpty(evaObjIds)) {
            String inSql = " ('" + Strings.join((String[])evaObjIds.toArray(new String[evaObjIds.size()]), (String)"','") + "') ";
            GradeTaskNodeInstCollection gradeTaskNodeInstCollection = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx).getGradeTaskNodeInstCollection("select evaObj.name  where id in " + inSql);
            if (gradeTaskNodeInstCollection.size() > 0) {
                Iterator iterator = gradeTaskNodeInstCollection.iterator();
                while (iterator.hasNext()) {
                    PerfEvaObjectInfo evaObj = ((GradeTaskNodeInstInfo)iterator.next()).getEvaObj();
                    if (evaObj == null || evaObj.getName() == null) continue;
                    stringBuffer.append(evaObj.getName()).append(",");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }
}

