/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScore;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScoreLevel;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreLevelCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreLevelFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreLevelInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNotEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonPageHelper;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfGradeTaskNodeService
implements IHRMsfService,
ICustomDataProcessor {
    private static Logger logger = LoggerFactory.getLogger(PerfGradeTaskNodeService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        StringBuffer sb;
        HashMap<String, Object> result = new HashMap<String, Object>();
        PerfGradeTaskNodeService.checkParams(map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        IObjectPK userId = ctx.getCaller();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
        if (user == null || user.getPerson() == null) {
            return null;
        }
        String name = (String)map.get("name");
        String positionName = (String)map.get("positionName");
        String personId = user.getPerson().getId().toString();
        Object periodID = map.get("periodID");
        Object nodeGrade = map.get("nodeGrade");
        Object evaObjIds = map.get("evaObjIDs");
        Object ids = map.get("ids");
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sqlSb = new StringBuffer("select b.FName" + mlFlag + " as FName, ").append("h.FPersonId AS FPerson, ").append("i.FName" + mlFlag + " AS FPositionName, ").append("h.FPositionId AS  FPosition, ").append("a.FNodeSumScore, ").append("a.FNodeGrade, ").append("a.FScoreStatus, ").append("a.FHandleTime, ").append("b.FNumber, ").append("e.FPariMutualID, ").append("e.FScoreRateID, ").append("e.FPerfRateID, ").append("a.FID, ").append("f.FNeedScore, ").append("f.FPerfGradeEvaluate, ").append("f.FWholeComment, ").append("g.FComment, ").append("a.FIsShowWholeGrade, ").append("a.FEvaObjID ").append("from T_EVA_GradeTaskNodeInst a  ").append("left join T_EVA_PerfEvaObject b ").append("on a.FEvaObjID = b.FID ").append("left join T_EVA_PerfPeriod c ").append("on a.FPeriodID=c.FID ").append("left join T_EVA_PerfPlan d ").append("on c.FPerfPlan = d.FID ").append("left join T_EVA_PerformanceRule e ").append("on d.FPerfRuleID = e.FID ").append("left join T_EVA_WFNodeDef f ").append("on a.FWfNodeID = f.FID ").append("left join T_PEF_WholeComment g ").append("on g.FGradeTaskNodeInstID = a.FID ").append("left join T_EVA_PerfFile h ").append("on b.FPerfFileId  = h.FID ").append("left join T_ORG_Position i ").append("on h.FPositionId  = i.FID ").append("where a.FPeriodID='" + periodID + "' ").append(" and a.FNodeHandlerID='" + personId + "' ").append(" and a.FTaskStatus != '0' ");
        if (nodeGrade != null) {
            sqlSb.append(" and a.FNodeGrade='" + nodeGrade + "'");
        }
        if (!StringUtils.isEmpty((CharSequence)name) && name.equals(positionName)) {
            sqlSb.append(" and (b.FName" + mlFlag + " like '%" + name + "%'").append(" or i.FName" + mlFlag + " like '%" + positionName + "%') ");
        } else {
            if (!StringUtils.isEmpty((CharSequence)name)) {
                sqlSb.append(" and b.FName" + mlFlag + " like '%" + name + "%'");
            }
            if (!StringUtils.isEmpty((CharSequence)positionName)) {
                sqlSb.append(" and i.FName" + mlFlag + " like '%" + positionName + "%'");
            }
        }
        if (evaObjIds != null) {
            String[] evaObjIdStr = String.valueOf(evaObjIds).split(",");
            sb = new StringBuffer();
            for (String item : evaObjIdStr) {
                sb.append("'").append(item).append("'").append(",");
            }
            sb.setLength(sb.length() - 1);
            sqlSb.append(" and a.FEvaObjID in (" + sb.toString() + ")");
            sqlSb.append(" and a.FTaskStatus = '1' ");
        } else if (ids != null) {
            String[] idStr = String.valueOf(ids).split(",");
            sb = new StringBuffer();
            for (String item : idStr) {
                sb.append("'").append(item).append("'").append(",");
            }
            sb.setLength(sb.length() - 1);
            sqlSb.append(" and a.FID in (" + sb.toString() + ")");
            sqlSb.append(" and a.FTaskStatus = '1' ");
        }
        Map<Object, Object> dataMap = new HashMap();
        try {
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            dataMap = CommonPageHelper.getPageCallbackData(ctx, sqlSb.toString(), rows, page, "a.FScoreStatus, a.FNodeGrade desc, a.FNodeSumScore desc, a.FID ", this, null);
            result.put("resultFlag", "success");
            List colls = (List)dataMap.get("rows");
            if (colls != null && colls.size() > 0) {
                Map item = (Map)colls.get(0);
                String pariMutualID = (String)item.get("pariMutualID");
                String scoreRateID = (String)item.get("scoreRateID");
                if (!StringUtils.isEmpty((CharSequence)pariMutualID)) {
                    Map<String, Object> perfScoreMap = this.getPerfScores(ctx, pariMutualID);
                    dataMap.put("perfScore", perfScoreMap);
                }
                if (!StringUtils.isEmpty((CharSequence)scoreRateID)) {
                    PerfGoasFillService perfGoasFillService = new PerfGoasFillService();
                    Map<String, String> perfScoreLevelMap = perfGoasFillService.getPerfScoreLevelKV(ctx, scoreRateID);
                    dataMap.put("perfScoreLevel", perfScoreLevelMap);
                }
            }
            result.put("data", dataMap);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETDATAERR, ctx));
            return result;
        }
        return result;
    }

    @Override
    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rs, String type) throws WfBizException {
        ArrayList list = new ArrayList();
        try {
            if (rs != null && rs.size() > 0) {
                HashMap<String, String> personsMap = new HashMap<String, String>();
                HashSet<String> evaObjIds = new HashSet<String>();
                while (rs.next()) {
                    evaObjIds.add(rs.getString("FEvaObjID"));
                }
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("scoringFormula", null, CompareType.ISNOT));
                filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", evaObjIds, CompareType.INCLUDE));
                IndicatorTargetCollection targets = IndicatorTargetFactory.getLocalInstance((Context)ctx).getIndicatorTargetCollection("select evaObj where " + filterInfo.toSql());
                HashSet<String> unvalids = new HashSet<String>();
                if (!targets.isEmpty()) {
                    for (IndicatorTargetInfo info : targets) {
                        unvalids.add(info.getEvaObj().getId().toString());
                    }
                }
                rs.beforeFirst();
                while (rs.next()) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    map.put("name", rs.getString("FName"));
                    String personId = rs.getString("FPerson");
                    String personNumber = rs.getString("FNumber");
                    map.put("number", personNumber);
                    map.put("person", personId);
                    map.put("positionName", rs.getString("FPositionName"));
                    map.put("position", rs.getString("FPosition"));
                    map.put("nodeSumScore", Float.valueOf(rs.getFloat("FNodeSumScore")));
                    map.put("nodeGrade", rs.getString("FNodeGrade"));
                    map.put("scoreStatus", rs.getString("FScoreStatus"));
                    map.put("handleTime", rs.getString("FHandleTime"));
                    String pariMutualID = rs.getString("FPariMutualID");
                    String scoreRateID = rs.getString("FScoreRateID");
                    String perfRateID = rs.getString("FPerfRateID");
                    map.put("pariMutualID", pariMutualID);
                    map.put("scoreRateID", perfRateID);
                    map.put("gradeTaskNodeInstID", rs.getString("FID"));
                    String evaObjId = rs.getString("FEvaObjID");
                    map.put("evaObj", evaObjId);
                    String isShowWholeGrade = rs.getString("FIsShowWholeGrade");
                    if (YesOrNotEnum.YES.getValue().equals(isShowWholeGrade)) {
                        map.put("isNeedScore", rs.getString("FNeedScore"));
                        map.put("isNeedGrade", rs.getString("FPerfGradeEvaluate"));
                    } else {
                        map.put("isNeedScore", YesOrNotEnum.NO.getValue());
                        map.put("isNeedGrade", YesOrNotEnum.NO.getValue());
                    }
                    map.put("isNeedComment", rs.getString("FWholeComment"));
                    map.put("comment", rs.getString("FComment"));
                    map.put("photo", null);
                    map.put("id", rs.getString("FID"));
                    if (unvalids.contains(evaObjId)) {
                        map.put("canBatchDeal", "0");
                    } else {
                        map.put("canBatchDeal", "1");
                    }
                    Float nodeSumScore = (Float)map.get("nodeSumScore");
                    DecimalFormat df = new DecimalFormat("#.##");
                    HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, (String)map.get("id"), evaObjId);
                    if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
                        if (!StringUtils.isEmpty((CharSequence)((String)targrtMap.get("sumScore")))) {
                            BigDecimal score = new BigDecimal(nodeSumScore.floatValue()).subtract(new BigDecimal((String)targrtMap.get("sumScore")));
                            if (score.compareTo(BigDecimal.ZERO) > 0) {
                                map.put("nodeSumScore", df.format(score));
                            } else {
                                map.put("nodeSumScore", "0");
                            }
                        } else {
                            map.put("nodeSumScore", df.format(nodeSumScore));
                        }
                    } else {
                        map.put("nodeSumScore", df.format(nodeSumScore));
                    }
                    list.add(map);
                    personsMap.put(personId, personNumber);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DATADEALERR, ctx));
        }
        return list;
    }

    private Map<String, Object> getPerfScores(Context ctx, String pariMutualID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pariMutualID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IPerfScore iPerfScore = PerfScoreFactory.getLocalInstance((Context)ctx);
        PerfScoreCollection perfScoreCollection = iPerfScore.getPerfScoreCollection(evi);
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (perfScoreCollection != null && perfScoreCollection.size() > 0) {
            PerfScoreInfo perfScoreInfo = perfScoreCollection.get(0);
            itemMap.put("name", perfScoreInfo.getName());
            itemMap.put("description", perfScoreInfo.getDescription());
            itemMap.put("max", perfScoreInfo.getMax());
            itemMap.put("min", perfScoreInfo.getMin());
        }
        return itemMap;
    }

    private Map<String, Object> getPerfScoreLevels(Context ctx, String scoreRateID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)scoreRateID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IPerfScoreLevel iPerfScoreLevel = PerfScoreLevelFactory.getLocalInstance((Context)ctx);
        PerfScoreLevelCollection perfScoreLevelCollection = iPerfScoreLevel.getPerfScoreLevelCollection(evi);
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (perfScoreLevelCollection != null && perfScoreLevelCollection.size() > 0) {
            PerfScoreLevelInfo perfScoreLevelInfo = perfScoreLevelCollection.get(0);
            itemMap.put("name", perfScoreLevelInfo.getName());
            itemMap.put("description", perfScoreLevelInfo.getDescription());
            PerfScorLevelDefineCollection levelDefineCollection = perfScoreLevelInfo.getPerfLevelDefInfo();
            if (levelDefineCollection != null && levelDefineCollection.size() > 0) {
                String[] perfLevels = new String[levelDefineCollection.size()];
                for (int j = 0; j < levelDefineCollection.size(); ++j) {
                    PerfScorLevelDefineInfo defineInfo = levelDefineCollection.get(j);
                    int showNumber = defineInfo.getShowNumber();
                    if (showNumber < 0) {
                        showNumber = 0;
                    }
                    if (showNumber > levelDefineCollection.size()) {
                        showNumber = levelDefineCollection.size();
                    }
                    perfLevels[showNumber - 1] = defineInfo.getPerfLevelName();
                }
                itemMap.put("perfLevelDefInfo", perfLevels);
            }
        }
        return itemMap;
    }

    private static void checkParams(Map map, Map<String, Object> result) {
        Object paramRows = map.get("rows");
        Object paramPage = map.get("page");
        Object periodID = map.get("periodID");
        if (paramRows == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "rows required");
            return;
        }
        if (paramPage == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "page required");
            return;
        }
        if (periodID == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "periodID required");
            return;
        }
        int rows = (Integer)paramRows;
        int page = (Integer)map.get("page");
        if (rows < 0) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "rows must not be less than 0");
            return;
        }
        if (page < 0) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "page must not be less than 0");
            return;
        }
    }
}

