/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataUtil {
    private static Logger logger = LoggerFactory.getLogger(MetaDataUtil.class);
    private static final String EMPTY_STRING = "";

    public static ICoreBase getBizInterface(String entityName) throws BOSException {
        return (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static IBizCtrl getFacadeInterface(String name) throws BOSException {
        FacadeInfo facadeInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFacade((IMetaDataPK)MetaDataPK.create((String)name));
        String interfaceName = facadeInfo.getBusinessInterface();
        Class<?> model = null;
        if (interfaceName != null) {
            try {
                model = Class.forName(interfaceName);
            }
            catch (ClassNotFoundException var5) {
                throw new BOSException("interfaceClass " + interfaceName + " not Found", (Throwable)var5);
            }
        }
        return (IBizCtrl)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)facadeInfo.getType(), model);
    }

    public static ICoreBase getBizInterface(BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        return MetaDataUtil.getBizInterface(entityInfo.getFullName());
    }

    public static Class getObjectValueClass(String entityName) throws EASBizException, ClassNotFoundException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        String clazz = entityInfo.getObjectValueClass();
        return Class.forName(clazz);
    }

    public static IObjectValue newInstance(Class clazz, String entityName) {
        IObjectValue objectInfo = null;
        try {
            objectInfo = (IObjectValue)clazz.newInstance();
        }
        catch (InstantiationException var6) {
            logger.error(var6.getMessage(), (Throwable)var6);
            return null;
        }
        catch (IllegalAccessException var7) {
            logger.error(var7.getMessage(), (Throwable)var7);
            return null;
        }
        if (!StringUtils.isEmpty((String)entityName)) {
            MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
            if (entityInfo.isDynamic() && objectInfo instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)objectInfo;
                commonObject.setBOSType(entityInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        return objectInfo;
    }

    public static IObjectValue newInstance(Class clazz) {
        return MetaDataUtil.newInstance(clazz, null);
    }

    public static EntityObjectInfo getEntityObject(String billId) {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSUuid.read((String)billId).getType());
    }

    public static EntityObjectInfo getEntityObjectByBosType(BOSObjectType bosType) {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
    }

    public static boolean isNeedHistory(String entityName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        return entityInfo.isNeedHistory();
    }

    public static EntityObjectInfo getEntityObjectByEntityName(String entityName) {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            map.put(propertyInfo.getName(), propertyInfo);
        }
        return map;
    }

    public static PropertyInfo getPropertyInfo(String entityName, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        if (!fieldName.contains(".")) {
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
            PropertyInfo propertyInfo = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                propertyInfo = collection.get(i);
                if (!fieldName.equalsIgnoreCase(propertyInfo.getName())) continue;
                return propertyInfo;
            }
            return null;
        }
        return MetaDataUtil.getPropertyInfo(entityName, fieldName.split("\\."));
    }

    public static PropertyInfo getPropertyInfo(String entityName, String[] fieldNames) {
        if (fieldNames != null && !StringUtils.isEmpty((String)entityName)) {
            String fieldName;
            PropertyInfo propertyInfo = null;
            String[] arr$ = fieldNames;
            int len$ = fieldNames.length;
            for (int i$ = 0; i$ < len$ && (propertyInfo = MetaDataUtil.getPropertyInfo(entityName, fieldName = arr$[i$])) != null; ++i$) {
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                entityName = MetaDataUtil.getEntityNameByPropertyInfo(entityName, propertyInfo);
            }
            return propertyInfo;
        }
        return null;
    }

    public static String getEntityNameByPropertyInfo(String entityName, PropertyInfo propertyInfo) {
        String subEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            if (((LinkPropertyInfo)propertyInfo).getRelationship() != null && ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject() != null) {
                subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName();
                if (null != entityName && entityName.equals(subEntityName)) {
                    subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getClientObject().getFullName();
                }
            } else {
                logger.info("property " + propertyInfo.getName() + " cannot find relationship or relationship's supplierObject");
            }
        }
        return subEntityName;
    }

    public static String getEntityNameByFieldName(String entityName, String fieldName) {
        PropertyInfo propertyInfo = MetaDataUtil.getPropertyInfo(entityName, fieldName);
        return MetaDataUtil.getEntityNameByPropertyInfo(entityName, propertyInfo);
    }

    public static Map<String, Object> convertObjectInfoToMap(CoreBaseInfo info, SelectorItemCollection sic, Map<String, PropertyInfo> properyMap) {
        if (info == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = null;
        Object value = null;
        int length = sic.size();
        for (int j = 0; j < length; ++j) {
            key = sic.get(j).getPropertyName();
            value = key.contains("*") ? info.get(key.substring(0, key.indexOf("*") - 1)) : (key.contains(".") ? MetaDataUtil.getRelationValue(info, key.split("\\.")) : info.get(key));
            if ((value = MetaDataUtil.convertValueToAlias(key, value, properyMap)) == null) {
                value = EMPTY_STRING;
            }
            map.put(key, value);
        }
        return map;
    }

    public static Object getRelationValue(Object obj, String[] props) {
        if (!(obj instanceof CoreBaseInfo)) {
            return obj;
        }
        CoreBaseInfo info = (CoreBaseInfo)obj;
        Object value = info.get(props[0]);
        if (props.length == 1) {
            return value;
        }
        Object newValue = null;
        for (int i = 1; i < props.length; ++i) {
            String[] newProps = new String[props.length - 1];
            System.arraycopy(props, 1, newProps, 0, props.length - 1);
            newValue = MetaDataUtil.getRelationValue(value, newProps);
        }
        return newValue;
    }

    private static Object convertValueToAlias(String prop, Object value, Map<String, PropertyInfo> properyMap) {
        if (value != null && properyMap.get(prop) != null) {
            OwnPropertyInfo ownProp;
            PropertyInfo properyInfo = properyMap.get(prop);
            if (properyInfo instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)(ownProp = (OwnPropertyInfo)properyInfo).getDataType())) {
                String enumSource = ownProp.getMetaDataRef();
                value = com.kingdee.shr.base.syssetting.app.util.MetaDataUtil.findEnumByValue((String)enumSource, (Object)value);
            }
            return value;
        }
        return value;
    }

    public static Type getMetaDataType(EntityObjectInfo parentEntityInfo, PropertyInfo propertyInfo) {
        Class type = null;
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownP = (OwnPropertyInfo)propertyInfo;
            DataType dataType = ownP.getDataType();
            type = dataType.equals((Object)DataType.STRING) ? String.class : (dataType.equals((Object)DataType.INTEGER) ? Integer.class : (dataType.equals((Object)DataType.FLOAT) ? Float.class : (dataType.equals((Object)DataType.DOUBLE) ? Double.class : (dataType.equals((Object)DataType.BOOLEAN) ? Boolean.class : (dataType.equals((Object)DataType.ENUM) ? (ownP.getEnumType() != null && !ownP.getEnumType().isDynamic() ? MetaDataUtil.getClass(ownP.getEnumType().getFullName()) : DynamicEnum.class) : MetaDataUtil.getClass(dataType.getJavaTypeName()))))));
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkP = (LinkPropertyInfo)propertyInfo;
            RelationshipInfo ri = linkP.getRelationship();
            String strDataType = null;
            EntityObjectInfo childInfo = ri.getChildObject(parentEntityInfo);
            CardinalityType cardType = ri.getChildCardinality(parentEntityInfo);
            strDataType = CardinalityType.isUnbounded((CardinalityType)cardType) ? childInfo.getObjectCollectionClass() : childInfo.getObjectValueClass();
            type = MetaDataUtil.getClass(strDataType);
        }
        return type;
    }

    public static Class getClass(String className) {
        Class<?> type = null;
        try {
            type = Class.forName(className);
        }
        catch (ClassNotFoundException var3) {
            logger.error(var3.getMessage(), (Throwable)var3);
        }
        return type;
    }

    public static Type getMetadataValueType(IObjectValue objectValue, String property) {
        block9: {
            try {
                Object dataType;
                EntitySelect select = new EntitySelect(objectValue.getBOSType());
                select.propertySelect().select(new String[]{"*"}, new String[]{"dataType"});
                SimpleEntity entity = MetaDataAccessFactory.getRemoteInstance().select(select);
                if (null == entity) break block9;
                SimpleProperty propertyObject = entity.property(property);
                String strDataType = null;
                if (propertyObject == null) {
                    SimplePropertyCollection simplePropertyCollection = entity.properties();
                    for (int nIndex = 0; nIndex < simplePropertyCollection.size(); ++nIndex) {
                        SimpleProperty simpleProperty = simplePropertyCollection.get(nIndex);
                        if (!simpleProperty.getName().equalsIgnoreCase(property)) continue;
                        propertyObject = simpleProperty;
                        break;
                    }
                }
                strDataType = propertyObject == null ? "java.lang.String" : ((dataType = propertyObject.getDataType()) != DataType.OBJECTVALUE && dataType != DataType.OBJECTCOLLECTION ? (dataType == DataType.ENUM ? propertyObject.getRefTypeInfo() : (dataType == DataType.STRING ? "java.lang.String" : (dataType == DataType.INTEGER ? "java.lang.Integer" : (dataType == DataType.FLOAT ? "java.lang.Float" : (dataType == DataType.DOUBLE ? "java.lang.Double" : (dataType == DataType.BOOLEAN ? "java.lang.Boolean" : dataType.getJavaTypeName())))))) : propertyObject.getRefTypeInfo());
                dataType = null;
                try {
                    dataType = Class.forName(strDataType);
                }
                catch (ClassNotFoundException var10) {
                    try {
                        if (propertyObject != null) {
                            dataType = MetaDataUtil.getDepEnumType(entity.toString(), property.toString(), propertyObject.getDataType().toString());
                        }
                    }
                    catch (Exception e) {
                        logger.error(EMPTY_STRING, (Throwable)e);
                    }
                }
                return (Type)dataType;
            }
            catch (BOSException e) {
                logger.error(EMPTY_STRING, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static Type getDepEnumType(String entityName, String fieldName, String fieldDataType) throws ClassNotFoundException {
        Class<?> type = null;
        if (DataType.ENUM.toString().equalsIgnoreCase(fieldDataType)) {
            BizEnumInfo info = MetaDataUtil.getBizEnumInfo(entityName, fieldName);
            if (info == null) {
                return type;
            }
            BizEnumValueType dataType = info.getDataType();
            String dataTypeStr = dataType.toString().toLowerCase();
            dataTypeStr = dataTypeStr.substring(0, 1).toUpperCase() + dataTypeStr.substring(1);
            String typeString = "java.lang." + dataTypeStr;
            type = Class.forName(typeString);
        }
        return type;
    }

    public static boolean asSubEntity(String entityName, String parentName) {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        for (BusinessObjectInfo parent = entityInfo.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentName.equals(parent.getFullName())) continue;
            return true;
        }
        return false;
    }

    public static BizEnumInfo getBizEnumInfo(String entityName, String fieldName) {
        PropertyInfo propertyInfo = MetaDataUtil.getPropertyInfo(entityName, fieldName);
        return MetaDataUtil.getBizEnumInfo(propertyInfo);
    }

    public static BizEnumInfo getBizEnumInfo(PropertyInfo propertyInfo) {
        BizEnumInfo bizEnum = null;
        if (propertyInfo instanceof OwnPropertyInfo) {
            String metadataRef = ((OwnPropertyInfo)propertyInfo).getMetaDataRef();
            String className = MetaDataUtils.getClassName((String)metadataRef);
            String packageName = MetaDataUtils.getPackageName((String)metadataRef);
            bizEnum = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEnum((IMetaDataPK)MetaDataPK.create((String)packageName, (String)className));
        }
        return bizEnum;
    }

    public static String getEntityNameByQueryField(String query, String queryField) {
        return QueryUtils.getEntityNameFromQuery((QueryInfo)MetaDataUtil.getQueryInfo(query), (String)queryField);
    }

    public static QueryInfo getQueryInfo(String query) {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)MetaDataPK.create((String)query));
    }

    public static BOSObjectType getBOSObjectTypeById(String id) {
        return BOSUuid.read((String)id).getType();
    }

    public static boolean isExistEntity(String entityName) {
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(entityName);
        return entityObjectInfo != null;
    }

    public static DataType getQueryFiledDataType(Context ctx, String queryPK, String queryFieldName) {
        SimplePropertyUnit simplePropertyUnit = MetaDataUtil.getSimplePropertyUnitCollection(ctx, queryPK, queryFieldName);
        DataType dataType = null;
        if (null == simplePropertyUnit) {
            return null;
        }
        if (simplePropertyUnit.isReturnTypeEnum()) {
            return DataType.ENUM;
        }
        ConstDataType returnType = simplePropertyUnit.getReturnType();
        if (returnType.equals((Object)ConstDataType.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (returnType.equals((Object)ConstDataType.DATE)) {
            dataType = DataType.DATE;
        } else if (returnType.equals((Object)ConstDataType.INT)) {
            dataType = DataType.INTEGER;
        } else if (returnType.equals((Object)ConstDataType.NUMBER)) {
            dataType = DataType.INTEGER;
        } else if (returnType.equals((Object)ConstDataType.STRING)) {
            dataType = DataType.STRING;
        } else if (returnType.equals((Object)ConstDataType.TIME)) {
            dataType = DataType.TIME;
        } else if (returnType.equals((Object)ConstDataType.TIMESTAMP)) {
            dataType = DataType.TIMESTAMP;
        }
        return dataType;
    }

    public static SimplePropertyUnit getSimplePropertyUnitCollection(Context ctx, String queryPK, String queryFieldName) {
        SimplePropertyUnitCollection propertyUnitCollection = MetaDataUtil.getSimplePropertyUnitCollection0(ctx, queryPK, queryFieldName);
        SimplePropertyUnit simplePropertyUnit = null;
        if (null != propertyUnitCollection && propertyUnitCollection.size() > 0) {
            simplePropertyUnit = propertyUnitCollection.get(0);
        }
        return simplePropertyUnit;
    }

    public static SimplePropertyUnitCollection getSimplePropertyUnitCollection0(Context ctx, String queryPK, String queryFieldName) {
        QuerySelect select = new QuerySelect(queryPK);
        SimpleQuery query = null;
        try {
            select.selectHeaderSelectorFields().propertyUnitSelect().select(new String[]{queryFieldName}, new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"}, ctx.getOriginLocale()).extendPropertySelect().select("*");
            query = MetaDataAccessFactory.getRemoteInstance().select(select);
        }
        catch (Exception e) {
            logger.error(EMPTY_STRING, (Throwable)e);
        }
        return null == query ? null : query.propertyUnits();
    }
}

