/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.ConfirmStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultAppealBill4Org;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaluAdminResponsor;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfOrgEvaSumResponsor;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.ExceptionUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgEvaResultSummaryBizUtil {
    private static final String VIEW = "VIEW";
    private static final String EDIT = "EDIT";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.OrgEvaResultSummaryBizUtil");

    public static Map<String, String> appeal(Context ctx, String summaryId) throws EASBizException, BOSException {
        HashMap<String, String> res = new HashMap<String, String>();
        String id = summaryId;
        OrgEvaResultSummaryCollection evaResultSummaryColl = null;
        IOrgEvaResultSummary iOrgEvaResultSummary = null;
        iOrgEvaResultSummary = OrgEvaResultSummaryFactory.getRemoteInstance();
        evaResultSummaryColl = iOrgEvaResultSummary.getOrgEvaResultSummaryCollection("select id , multiPerfPlan.id, evaPlan.id, evaPlan.appealDays, evaPlan.needConfirm, evaPlan.allowAppeal, adminOrg.id, hrOrgUnit.id, isImportByHand, historyImport,  confirmState, appealState, auditDate, billState, status where id='" + id + "'");
        if (!evaResultSummaryColl.isEmpty()) {
            OrgEvaResultSummaryInfo summaryInfo = evaResultSummaryColl.get(0);
            IEvaResultAppealBill4Org iEvaResultAppealBill4Org = EvaResultAppealBill4OrgFactory.getRemoteInstance();
            if (iEvaResultAppealBill4Org.exists(" where sourceBillId='" + id + "' and valid = 1")) {
                String billId = iEvaResultAppealBill4Org.getEvaResultAppealBill4OrgInfo(" where sourceBillId='" + id + "' and valid = 1").getId().toString();
                res.put("billId", billId);
                res.put("operateState", VIEW);
            } else {
                boolean isAllowAppeal;
                PerfPlanInfo perfPlanInfo = summaryInfo.getEvaPlan();
                boolean bl = isAllowAppeal = perfPlanInfo != null ? perfPlanInfo.isAllowAppeal() : false;
                if (!HRBillStateEnum.AUDITED.equals((Object)summaryInfo.getBillState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTUNSUDIT, ctx));
                }
                if (EvaResultSumStatusEnum.CARRY.equals((Object)summaryInfo.getStatus())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTZHUANED, ctx));
                }
                if (YesOrNoEnum.YES.equals((Object)summaryInfo.getIsImportByHand())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNEEDNOTAPPLY, ctx));
                }
                if (summaryInfo.isHistoryImport()) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISNEEDNOTAPPLY, ctx));
                }
                if (ConfirmStateEnum.CONFIRMED.equals((Object)summaryInfo.getConfirmState())) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTHASSURECANNOTAPPLY, ctx));
                }
                if (!isAllowAppeal) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CRESULTCANNOTAPPLY, ctx));
                }
                MultiPerfPlanInfo multiPerfPlanInfo = summaryInfo.getMultiPerfPlan();
                if (multiPerfPlanInfo != null && multiPerfPlanInfo.getId() != null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.A360CANNOTAPPLAY, ctx));
                }
                if (summaryInfo.getAuditDate() == null) {
                    throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NOAUDITDATECANNOTAPPLY, ctx));
                }
                int appealDays = perfPlanInfo.getAppealDays();
                if (appealDays != 0) {
                    Date now = new Date();
                    long days = DateUtil.dateDiff((String)"d", (Date)summaryInfo.getAuditDate(), (Date)now) + 1L;
                    if ((long)appealDays - days < 0L) {
                        throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERLIMITDATE, ctx));
                    }
                }
                EvaResultAppealBill4OrgInfo appealBillInfo = new EvaResultAppealBill4OrgInfo();
                appealBillInfo.setSourceBillId(id);
                appealBillInfo.setProposer(summaryInfo.getPerson());
                appealBillInfo.setApplyDate(new Date());
                appealBillInfo.setEvaResult(summaryInfo);
                appealBillInfo.setHrOrgUnit(summaryInfo.getHrOrgUnit());
                appealBillInfo.setAdminOrg(summaryInfo.getAdminOrg());
                appealBillInfo.setValid(true);
                appealBillInfo.setNumber("NO" + System.currentTimeMillis());
                String billId = iEvaResultAppealBill4Org.addnew(appealBillInfo).toString();
                res.put("billId", billId);
                res.put("operateState", EDIT);
                res.put("isAddNew", "1");
            }
        }
        return res;
    }

    public static Map<String, Object> confirmCheck(Context ctx, String summaryId) throws BOSException, EASBizException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        IEvaResultAppealBill4Org iEvaResultAppealBill4Org = null;
        iEvaResultAppealBill4Org = EvaResultAppealBill4OrgFactory.getRemoteInstance();
        EvaResultAppealBill4OrgCollection col = iEvaResultAppealBill4Org.getEvaResultAppealBill4OrgCollection("select evaResult.evaPlan.name, evaResult.period.name where sourceBillId='" + summaryId + "' and valid = 1 and (billState is null or billState = " + 0 + ")");
        if (col != null && col.size() > 0) {
            res.put("message", col.get(0).getEvaResult().getEvaPlan().getName() + "-" + col.get(0).getEvaResult().getPeriod().getName() + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HASAPPEAL, ctx));
            res.put("appealBillSaved", 1);
        }
        return res;
    }

    public static void confirm(Context ctx, String summaryId) throws EASBizException, BOSException {
        OrgEvaResultSummaryCollection evaResultSummaryColl = null;
        IOrgEvaResultSummary iOrgEvaResultSummary = null;
        iOrgEvaResultSummary = OrgEvaResultSummaryFactory.getRemoteInstance();
        evaResultSummaryColl = iOrgEvaResultSummary.getOrgEvaResultSummaryCollection("select id , multiPerfPlan.id, evaPlan.id, evaPlan.appealDays, evaPlan.needConfirm, evaPlan.allowAppeal, adminOrg.id, hrOrgUnit.id, isImportByHand, historyImport,  confirmState, appealState, auditDate, billState where id='" + summaryId + "'");
        if (evaResultSummaryColl != null && !evaResultSummaryColl.isEmpty()) {
            boolean isNeedConfirm;
            OrgEvaResultSummaryInfo info = evaResultSummaryColl.get(0);
            if (YesOrNoEnum.YES.equals((Object)info.getIsImportByHand())) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNEEDNOTSAVE, ctx));
            }
            if (info.isHistoryImport()) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISNEEDNOTSAVE, ctx));
            }
            PerfPlanInfo perfPlanInfo = info.getEvaPlan();
            boolean bl = isNeedConfirm = perfPlanInfo != null ? perfPlanInfo.isNeedConfirm() : false;
            if (!isNeedConfirm) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTNEEDNOTAUDIT, ctx));
            }
            if (ConfirmStateEnum.CONFIRMED.equals((Object)info.getConfirmState())) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESULTNEEDNOTAUDITTWICE, ctx));
            }
            IEvaResultAppealBill4Org iEvaResultAppealBill4Org = null;
            iEvaResultAppealBill4Org = EvaResultAppealBill4OrgFactory.getRemoteInstance();
            iEvaResultAppealBill4Org.delete(" where sourceBillId='" + summaryId + "' and valid = 1 and (billState is null or billState = " + 0 + ")");
            if (iEvaResultAppealBill4Org.exists(" where sourceBillId='" + summaryId + "' and valid = 1 and billState <> 3 and billState <> 4")) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVARESULTEXISTSUBMITEDBILL, ctx));
            }
            MultiPerfPlanInfo multiPerfPlanInfo = info.getMultiPerfPlan();
            if (multiPerfPlanInfo != null && multiPerfPlanInfo.getId() != null) {
                throw ExceptionUtil.EASBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.A360CANNOTAPPLAY, ctx));
            }
            info.setConfirmState(ConfirmStateEnum.CONFIRMED);
            iOrgEvaResultSummary.save((CoreBaseInfo)info);
        }
    }

    public static void desposeResponsorBySummaryResult(Context context, List<OrgEvaResultSummaryInfo> recordList) {
        try {
            int LIMITSIZE = 3;
            IPerfOrgEvaSumResponsor iPerfOrgEvaSumResponsor = PerfOrgEvaSumResponsorFactory.getLocalInstance((Context)context);
            IPerfEvaluAdminResponsor iPerfEvaluAdminResponsor = PerfEvaluAdminResponsorFactory.getLocalInstance((Context)context);
            for (OrgEvaResultSummaryInfo orgEvaResultSummaryInfo : recordList) {
                StringBuffer responsor = new StringBuffer();
                if (orgEvaResultSummaryInfo.get("isImportByHand") != null && "1".equals(orgEvaResultSummaryInfo.get("isImportByHand").toString())) {
                    PerfOrgEvaSumResponsorCollection perfOrgEvaSumResponsorCollection = iPerfOrgEvaSumResponsor.getPerfOrgEvaSumResponsorCollection("select person.name,person.id where OrgEvaResultSummaryId='" + orgEvaResultSummaryInfo.get("id").toString() + "'");
                    if (perfOrgEvaSumResponsorCollection != null && perfOrgEvaSumResponsorCollection.size() > 0) {
                        int size = perfOrgEvaSumResponsorCollection.size();
                        size = size > LIMITSIZE ? LIMITSIZE : size;
                        for (int i = 0; i < size; ++i) {
                            PerfOrgEvaSumResponsorInfo info = perfOrgEvaSumResponsorCollection.get(i);
                            responsor.append(",").append(info.getPerson().getName());
                        }
                        responsor.deleteCharAt(0);
                    }
                    if (perfOrgEvaSumResponsorCollection != null && perfOrgEvaSumResponsorCollection.size() > LIMITSIZE) {
                        responsor = responsor.append("...");
                    }
                    orgEvaResultSummaryInfo.put("responsor", (Object)responsor);
                    orgEvaResultSummaryInfo.put("orgResponsors", (Object)responsor);
                    continue;
                }
                OrgEvaResultSummaryBizUtil.getSingleResponsor(iPerfEvaluAdminResponsor, orgEvaResultSummaryInfo);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    private static void getSingleResponsor(IPerfEvaluAdminResponsor iPerfEvaluAdminResponsor, OrgEvaResultSummaryInfo orgEvaResultSummaryInfo) throws BOSException {
        int LIMITSIZE = 3;
        StringBuffer responsor = new StringBuffer();
        Object evaObj = orgEvaResultSummaryInfo.get("evaObj");
        String objId = null;
        if (evaObj != null) {
            PerfEvaObjectInfo perfEvaObjectInfo = (PerfEvaObjectInfo)evaObj;
            objId = perfEvaObjectInfo.getId().toString();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(objId)) {
            PerfEvaluAdminResponsorCollection perfResCollection = iPerfEvaluAdminResponsor.getPerfEvaluAdminResponsorCollection("select person.name where evaObj= '" + objId + "'");
            if (perfResCollection != null && perfResCollection.size() > 0) {
                int size = perfResCollection.size();
                size = size > LIMITSIZE ? LIMITSIZE : size;
                for (int i = 0; i < size; ++i) {
                    PerfEvaluAdminResponsorInfo info = perfResCollection.get(i);
                    responsor.append(",").append(info.getPerson().getName());
                }
                responsor.deleteCharAt(0);
            }
            if (perfResCollection != null && perfResCollection.size() > LIMITSIZE) {
                responsor = responsor.append("...");
            }
            orgEvaResultSummaryInfo.put("responsor", (Object)responsor);
            orgEvaResultSummaryInfo.put("orgResponsors", (Object)responsor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withdrawAppeal(Context ctx, String billId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)billId)) throw ExceptionUtil.EASBizException(new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL));
        IEvaResultAppealBill4Org iEvaResult = EvaResultAppealBill4OrgFactory.getLocalInstance((Context)ctx);
        if (iEvaResult.exists("where billState !=1 and id = '" + billId + "' ")) {
            throw ExceptionUtil.EASBizException(new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL));
        }
        try {
            EvaResultAppealBill4OrgFacadeFactory.getLocalInstance((Context)ctx).delBillByBillID(billId);
            try {
                TheThirdMessageUtil.recycleWFAssign(ctx, billId);
                return;
            }
            catch (Exception e) {
                String message = "recycle the third message failed,billID:('" + billId + "')";
                if (!logger.isDebugEnabled()) return;
                logger.error(message, (Throwable)e);
            }
            return;
        }
        catch (EASBizException e) {
            if (!logger.isDebugEnabled()) throw ExceptionUtil.EASBizException(new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL));
            logger.error("\u3010PERFWEB\u3011-withdraw appeal failed\uff1aevaObj\uff1a" + billId + "\uff01", (Throwable)e);
            throw ExceptionUtil.EASBizException(new SHRPerfWebBizException(SHRPerfWebBizException.THESTATEWITHDRAWFAIL));
        }
    }
}

