/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.bizflow.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.common.IPerfConfig;
import com.kingdee.shr.perfweb.app.common.IPerfConfigBelongPage;
import com.kingdee.shr.perfweb.app.common.PerfConfigBelongPageCollection;
import com.kingdee.shr.perfweb.app.common.PerfConfigBelongPageFactory;
import com.kingdee.shr.perfweb.app.common.PerfConfigCollection;
import com.kingdee.shr.perfweb.app.common.PerfConfigFactory;
import com.kingdee.shr.perfweb.app.common.PerfConfigInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.parquet.Strings;

public class PerfConfigUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfConfigUtils.class);

    public static Map<String, Set<String>> getConfigByUipks(Context ctx, ArrayList<String> uipks) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (CollectionUtil.isEmpty(uipks)) {
            return result;
        }
        try {
            Object[] params = new Object[uipks.size()];
            StringBuilder sql = new StringBuilder("select UIView.fuipk uipk ,perfConfig.fparaName paraName,perfConfig.fparaValue  paraValue  from T_PEF_PerfConfig perfConfig left join T_PEF_PerfConfigBelongPage page on page.FPerfConfigID = perfConfig.fid  left join S_BS_UIView UIView on page.FUiviewID = UIView.fid  where UIView.fuipk in (");
            for (int i = 0; i < uipks.size(); ++i) {
                sql.append("?,");
                params[i] = uipks.get(i);
            }
            String querySql = sql.substring(0, sql.length() - 1) + ")";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
            while (iRowSet.next()) {
                String uipk = iRowSet.getString("uipk");
                if (CollectionUtil.isEmpty((Collection)((Collection)result.get(uipk)))) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(iRowSet.getString("paraName"));
                    result.put(uipk, set);
                    continue;
                }
                ((Set)result.get(uipk)).add(iRowSet.getString("paraName"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    public static HashMap<String, Object> getConfigByUipk(Context ctx, String uipk) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            StringBuilder sql = new StringBuilder("select perfConfig.FCategory category ,perfConfig.fparaName paraName,perfConfig.fparaValue  paraValue  from T_PEF_PerfConfig perfConfig left join T_PEF_PerfConfigBelongPage page on page.FPerfConfigID = perfConfig.fid  left join S_BS_UIView UIView on page.FUiviewID = UIView.fid  where UIView.fuipk = '").append(uipk).append("'").append(" or perfConfig.FParaType = '").append("100").append("'");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (iRowSet.next()) {
                result.put(iRowSet.getString("paraName"), iRowSet.getString("paraValue"));
                result.put(iRowSet.getString("category") + "_" + iRowSet.getString("paraName"), iRowSet.getString("paraValue"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    public static HashMap<String, Object> getConfigByCategory(Context ctx, String categorys) {
        String[] categoryArr = categorys.split(",");
        categorys = "('" + Strings.join((String[])categoryArr, (String)"','") + "')";
        PerfConfigCollection perfConfigColl = null;
        try {
            perfConfigColl = PerfConfigFactory.getLocalInstance((Context)ctx).getPerfConfigCollection("where category in " + categorys + " or paraType = '" + "100" + "'");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return PerfConfigUtils.collToMap(perfConfigColl);
    }

    public static String getConfigByName(Context ctx, String name) {
        PerfConfigCollection perfConfigColl = null;
        try {
            perfConfigColl = PerfConfigFactory.getLocalInstance((Context)ctx).getPerfConfigCollection("where paraName = '" + name + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
                return perfConfigColl.get(0).getParaValue();
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return "";
    }

    public static String getConfigByNumber(Context ctx, String number) {
        PerfConfigCollection perfConfigColl = null;
        try {
            perfConfigColl = PerfConfigFactory.getLocalInstance((Context)ctx).getPerfConfigCollection("where number = '" + number + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
                return perfConfigColl.get(0).getParaValue();
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return "";
    }

    public static void updateConfigByName(Context ctx, String name, String value) {
        PerfConfigCollection perfConfigColl = null;
        try {
            IPerfConfig localInstance = PerfConfigFactory.getLocalInstance((Context)ctx);
            perfConfigColl = localInstance.getPerfConfigCollection("where paraName = '" + name + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
                PerfConfigInfo perfConfigInfo = perfConfigColl.get(0);
                perfConfigInfo.setParaValue(value);
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("paraValue");
                localInstance.updatePartial(perfConfigInfo, selectorItemCollection);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void updateUnusual(Context ctx) {
        PerfConfigCollection perfConfigColl = null;
        try {
            IPerfConfig localInstance = PerfConfigFactory.getLocalInstance((Context)ctx);
            String name = "isManualJudgeGrade";
            perfConfigColl = localInstance.getPerfConfigCollection("where paraName = '" + name + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
                for (int i = 0; i < perfConfigColl.size(); ++i) {
                    PerfConfigInfo perfConfigInfo = perfConfigColl.get(i);
                    String paraValue = perfConfigInfo.getParaValue();
                    if ("true".equals(paraValue)) {
                        perfConfigInfo.setParaValue("0");
                    } else if ("false".equals(paraValue)) {
                        perfConfigInfo.setParaValue("1");
                    }
                    SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                    selectorItemCollection.add("paraValue");
                    localInstance.updatePartial(perfConfigInfo, selectorItemCollection);
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("", (Throwable)e);
        }
    }

    public static String getConfigByName(Context ctx, String name, boolean isOrg) {
        PerfConfigCollection perfConfigColl = null;
        try {
            perfConfigColl = isOrg ? PerfConfigFactory.getLocalInstance((Context)ctx).getPerfConfigCollection("where paraName = '" + name + "' and category like '%org%'") : PerfConfigFactory.getLocalInstance((Context)ctx).getPerfConfigCollection("where paraName = '" + name + "' and category not like '%org%'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
                return perfConfigColl.get(0).getParaValue();
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return "";
    }

    public static HashMap<String, Object> collToMap(PerfConfigCollection perfConfigColl) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)perfConfigColl)) {
            int size = perfConfigColl.size();
            for (int i = 0; i < size; ++i) {
                result.put(perfConfigColl.get(i).getParaName(), perfConfigColl.get(i).getParaValue());
            }
            return result;
        }
        return result;
    }

    public static void updateConfig(Context ctx, String uipk, String paraName, String paraValue) {
        try {
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{uipk, paraName, paraValue})) {
                return;
            }
            IPerfConfig iPerfConfig = PerfConfigFactory.getLocalInstance((Context)ctx);
            IPerfConfigBelongPage iPerfConfigpage = PerfConfigBelongPageFactory.getLocalInstance((Context)ctx);
            PerfConfigBelongPageCollection pageColl = iPerfConfigpage.getPerfConfigBelongPageCollection("select perfConfig.* where uiview.uipk ='" + uipk + "' and perfConfig.paraName = '" + paraName + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)pageColl)) {
                PerfConfigInfo perfConfigInfo = pageColl.get(0).getPerfConfig();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("paraValue");
                perfConfigInfo.setParaValue(paraValue);
                iPerfConfig.updatePartial(perfConfigInfo, sic);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static Long getPerfWebEmailInterval(Context ctx) {
        Long interval = new Long(0L);
        String intervalStr = PerfConfigUtils.getConfigByName(ctx, "perfWebMilInterval");
        if (StringUtils.isBlank((CharSequence)intervalStr)) {
            return interval;
        }
        try {
            interval = Long.parseLong(intervalStr);
            return interval;
        }
        catch (Exception e) {
            logger.error("perfWeb:perfWebMilInterval ", (Throwable)e);
            return interval;
        }
    }
}

