/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.baseconfig.PERFWEB001SHRSqlBuilder;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumCalCacheUtils {
    private static final Logger logger = LoggerFactory.getLogger(SumCalCacheUtils.class);
    private static volatile ConcurrentHashMap<String, String> structureTableMap = new ConcurrentHashMap(16);
    private static volatile ConcurrentHashMap<String, String> tableStructureMap = new ConcurrentHashMap(16);

    public static void refreshStructureTableMap(Context ctx, String schemeNumber) {
        if (StringUtils.isEmpty((String)schemeNumber)) {
            return;
        }
        structureTableMap.clear();
        String sql = "select s.FEntityName,s.FID from T_HR_StructureConfig s left join T_HR_QueryConfig c on s.FID=c.FStructureID inner join T_HR_StructureConfigScheme d on c.FSCHEMEID = d.FID where d.FNUMBER='" + schemeNumber + "' or c.FID='5qCDgI/CRyCNHB3eD0NK7D64rh8='";
        String cmpSql = "select FStructureID,FTableName from T_HR_SCmpQueryConfig where FAPPLICATION =3 and FStructureID is not null";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String entityName = rs.getString("FEntityName");
                String structureId = rs.getString("FID");
                String tableName = null;
                EntityObjectInfo clientEntity = PERFWEB001SHRSqlBuilder.getInstance()._getEntityObject(entityName);
                if (null != clientEntity) {
                    tableName = clientEntity.getTable().getName();
                }
                structureTableMap.put(structureId, tableName);
                tableStructureMap.put(tableName, structureId);
            }
            IRowSet cmpRs = DbUtil.executeQuery((Context)ctx, (String)cmpSql);
            while (cmpRs.next()) {
                String tableName = cmpRs.getString("FTableName");
                String structureId = cmpRs.getString("FStructureID");
                structureTableMap.put(structureId, tableName);
                tableStructureMap.put(tableName, structureId);
            }
        }
        catch (BOSException e) {
            logger.error("", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentHashMap<String, String> getStructureTableMap(Context ctx, String schemeNumber) {
        Class<SumCalCacheUtils> clazz = SumCalCacheUtils.class;
        synchronized (SumCalCacheUtils.class) {
            if (structureTableMap.isEmpty()) {
                SumCalCacheUtils.refreshStructureTableMap(ctx, schemeNumber);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return structureTableMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentHashMap<String, String> getTableStructureMap(Context ctx, String schemeNumber) {
        Class<SumCalCacheUtils> clazz = SumCalCacheUtils.class;
        synchronized (SumCalCacheUtils.class) {
            if (tableStructureMap.isEmpty()) {
                SumCalCacheUtils.refreshStructureTableMap(ctx, schemeNumber);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tableStructureMap;
        }
    }
}

