/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPageHelper {
    private static Logger logger = LoggerFactory.getLogger(CommonPageHelper.class);

    private CommonPageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getPageCallbackData(Context ctx, String sql, int rows, int page, String orderFld, ICustomDataProcessor process, String type) throws BOSException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return resultMap;
        }
        int totalCount = process.getTotalCount(ctx, sql);
        int start = (page - 1) * rows;
        if (!StringUtils.isEmpty((CharSequence)orderFld)) {
            sql = sql + " order by " + orderFld;
        }
        long top = page * rows;
        sql = sql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
        Connection conn = null;
        IRowSet rowset = null;
        List<?> cols = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, start, rows);
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            cols = process.formatResultData(ctx, rowset, type);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rowset, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rowset, null, (Connection)conn);
        if (totalCount % rows == 0) {
            resultMap.put("total", totalCount / rows);
        } else {
            resultMap.put("total", totalCount / rows + 1);
        }
        resultMap.put("page", page);
        resultMap.put("records", totalCount);
        resultMap.put("rows", cols);
        return resultMap;
    }

    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException((Throwable)e);
        }
        return totalCount;
    }
}

