/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSQLUtil {
    private static Logger logger = LoggerFactory.getLogger(CommonSQLUtil.class);
    public static final String RECORD_TOTALCOUNT = "totalCount";
    public static final String AFTERPAINGSQL = "afterPagingSql";
    public static final String SOURCESQL = "sourcesql";
    private static final int MAX_DATA_ROW = 8000;

    public static String convertListToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append(list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static void executeBatch(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                SQLUtils.cleanup(ps, (Connection)conn);
                logger.error("", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws WfBizException, SHRPerfWebBizException {
        IRowSet rowSet;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            if (e.getMessage().contains("fetched too much rows")) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException.TOOMANYRECORDSQUERYERR);
            }
            throw new WfBizException(e.getMessage(), (Throwable)e);
        }
        return rowSet;
    }

    public static Connection getConnection(Context ctx) throws WfBizException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new WfBizException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getTotalCount(IRowSet rowSet) throws WfBizException {
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                try {
                    totalCount = rowSet.getInt(1);
                }
                catch (SQLException e) {
                    throw new WfBizException(e.getMessage(), (Throwable)e);
                    return totalCount;
                }
            }
        }
        catch (SQLException e) {
            throw new WfBizException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object> processGridDataPaging(Context ctx, String sourceSql, int rows, int page, String sidx, String sord) throws EASBizException, WfBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String afterPagingSql = "";
        Connection cn = null;
        int totalCount = 0;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            PagingHelper pageHelper = new PagingHelper();
            int length = rows;
            String countSql = "select count(1) from (" + sourceSql + ") AS B";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            String sorterItems = null;
            if (!StringUtils.isEmpty((String)sidx)) {
                sorterItems = sidx + " " + sord;
            }
            if (!StringUtils.isEmpty(sorterItems)) {
                sourceSql = sourceSql + " order by " + sorterItems;
            }
            map.put(SOURCESQL, sourceSql);
            sourceSql = sourceSql.replaceFirst("select", "SELECT TOP " + String.valueOf((page - 1) * rows + length));
            afterPagingSql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)cn), sourceSql.toString(), (page - 1) * rows, length);
        }
        catch (SQLException e) {
            throw new WfBizException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfBizException((Throwable)e);
        }
        map.put(RECORD_TOTALCOUNT, totalCount);
        map.put(AFTERPAINGSQL, afterPagingSql);
        return map;
    }
}

