/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileCollection;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileFactory;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataRlueInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataRuleAuditPersonCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataRuleAuditPersonInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivenmentDataRulePersonCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivenmentDataRulePersonInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObjMatrixWorkFlowInst;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObjectMatrixWorkFlow;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetImportSupportInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeParentInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IIndicatorExtendHelper;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeCollection;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeFactory;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorCollection;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorFactory;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationshipCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationshipFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationshipInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonValidDataUtils {
    private static Logger logger = LoggerFactory.getLogger(CommonValidDataUtils.class);
    private static final BigDecimal TOTALWEIGHT = new BigDecimal("100");
    private static Pattern PATTERN_NUMER = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");

    public static String checkIndecatorCode(PerfIndecatorInfo perfIndecator, Context ctx) throws BOSException {
        String incecadorCode = perfIndecator.getNumber();
        String errorString = "";
        if (StringUtils.isEmpty((CharSequence)incecadorCode)) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNUMBERREQUIRED, ctx);
        }
        if (incecadorCode.length() > 100) {
            errorString = errorString + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNUMBERTOOLONG, ctx);
        }
        String oql = "";
        oql = perfIndecator.getId() == null ? "where number = '" + incecadorCode.replace("'", "''") + "'" : "where number = '" + incecadorCode.replace("'", "''") + "' and id <> '" + perfIndecator.getId().toString() + "'";
        PerfIndecatorCollection perfIndeColl = PerfIndecatorFactory.getLocalInstance((Context)ctx).getPerfIndecatorCollection(oql);
        if (perfIndeColl.size() != 0) {
            errorString = errorString + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNUMBERALREADYEXISTED, ctx, new Object[]{incecadorCode});
        }
        return errorString;
    }

    public static String checkIndecatorName(PerfIndecatorInfo perfIndecator, Context ctx) {
        String incecadorName = perfIndecator.getName();
        String errorString = "";
        if (StringUtils.isEmpty((CharSequence)incecadorName)) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNAMEREQUIRED, ctx);
        }
        if (incecadorName.length() > 1000) {
            errorString = errorString + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNAMETOOLONG, ctx);
        }
        return errorString;
    }

    public static String checkIndecatorTypeCode(PerfIndecatorInfo perfIndecator, Context ctx) {
        String incecadorCode = perfIndecator.getIndecatorType().getNumber().toString();
        String errorString = "";
        if (StringUtils.isEmpty((CharSequence)incecadorCode)) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPENUMBERREQUIRED, ctx);
        }
        if (incecadorCode.length() > 100) {
            errorString = errorString + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPENUMBERTOOLONG, ctx);
        }
        return errorString;
    }

    public static String checkIndecatorTypeUsable(PerfIndecatorInfo perfIndecator, Context ctx) throws EASBizException, BOSException {
        String incecadorTypeCode = perfIndecator.getIndecatorType().getNumber();
        String errorString = "";
        String oql = "where number = '" + incecadorTypeCode.replace("'", "''") + "'";
        IndecatorTypeInfo info = IndecatorTypeFactory.getLocalInstance((Context)ctx).getIndecatorTypeInfo(oql);
        if (info.getState().getValue() != 1) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPEUNENABLED, ctx);
        }
        return errorString;
    }

    public static String checkIndecatorTypeCodeExits(Map<String, Object> currRowMap, Context ctx) throws BOSException {
        String incecadorTypeCode = (String)currRowMap.get("indecatorType.number".toString());
        String indecatorTypeName = (String)currRowMap.get("indecatorType.name".toString());
        if (StringUtils.isEmpty((CharSequence)indecatorTypeName)) {
            String errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPENAMEREQUIRED, ctx);
            return errorString;
        }
        String oql = "where number = '" + incecadorTypeCode.replace("'", "''") + "'";
        IndecatorTypeCollection coll = IndecatorTypeFactory.getLocalInstance((Context)ctx).getIndecatorTypeCollection(oql);
        if (coll.size() == 0) {
            String errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNUMBERNOTEXIST, ctx);
            return errorString;
        }
        IndecatorTypeInfo indecatorInfo = coll.get(0);
        if (!indecatorTypeName.equals(indecatorInfo.getName())) {
            String errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPENUMBERDONTMATCHTONAME, ctx);
            return errorString;
        }
        return "";
    }

    public static String checkIndecatorLeafNode(PerfIndecatorInfo perfIndecator, Context ctx) throws BOSException, EASBizException {
        String incecadorTypeCode = perfIndecator.getIndecatorType().getNumber();
        String oql = "where number = '" + incecadorTypeCode + "'";
        IndecatorTypeInfo info = IndecatorTypeFactory.getLocalInstance((Context)ctx).getIndecatorTypeInfo(oql);
        if (!info.isIsLeaf()) {
            String errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CREATINGERRASINDICATORTYPEHASSUBTYE, ctx);
            return errorString;
        }
        return "";
    }

    public static String getPerfIndecatorPK(String incecadorCode, Context ctx) throws BOSException {
        String oql = "where number = '" + incecadorCode.replace("'", "''") + "'";
        PerfIndecatorCollection coll = null;
        coll = PerfIndecatorFactory.getLocalInstance((Context)ctx).getPerfIndecatorCollection(oql);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        return coll.get(0).getId().toString();
    }

    public static boolean checkIsLeafNode(Map<String, Object> currRowMap, Context ctx) throws BOSException, EASBizException {
        IndecatorTypeInfo info = (IndecatorTypeInfo)currRowMap.get("indecatorType");
        String oql = "where id = '" + info.getId().toString() + "'";
        info = IndecatorTypeFactory.getLocalInstance((Context)ctx).getIndecatorTypeInfo(oql);
        return info.isIsLeaf();
    }

    public static String checkPerfFile(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errorString = "";
        PerfFileInfo perfFile = CommonValidDataUtils.getPerfFileInfoByPosition(perfEvaObjectInfo, ctx);
        if (perfFile == null) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFFILEREQUIREDFORTHISPERSON, ctx);
        }
        return errorString;
    }

    public static PerfFileInfo getPerfFileInfoByPosition(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        PerfFileInfo info = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        String personName = perfEvaObjectInfo.getName();
        String personNumber = perfEvaObjectInfo.getNumber();
        filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)personName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)personNumber, CompareType.EQUALS));
        if (perfEvaObjectInfo.getPerfFile().getPosition() != null && !StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            filter.getFilterItems().add(new FilterItemInfo("position.name", (Object)perfEvaObjectInfo.getPerfFile().getPosition().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfEvaObjectInfo.getHrUnitOrg().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by CREATETIME DESC");
        }
        catch (ParserException e1) {
            logger.error("", (Throwable)e1);
        }
        viewInfo.setSorter(sorterItemCollection);
        PerfFileCollection coll = null;
        try {
            coll = PerfFileFactory.getLocalInstance((Context)ctx).getPerfFileCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException:", (Throwable)e);
        }
        if ((coll == null || coll.size() == 0) && StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            FilterInfo filter1 = new FilterInfo();
            EntityViewInfo viewInfo1 = new EntityViewInfo();
            SelectorItemCollection sic1 = viewInfo.getSelector();
            sic1.add(new SelectorItemInfo("*"));
            filter1.getFilterItems().add(new FilterItemInfo("person.name", (Object)perfEvaObjectInfo.getName(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("person.number", (Object)perfEvaObjectInfo.getNumber(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfEvaObjectInfo.getHrUnitOrg().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            viewInfo1.setSelector(sic1);
            viewInfo1.setFilter(filter1);
            try {
                coll = PerfFileFactory.getLocalInstance((Context)ctx).getPerfFileCollection(viewInfo1);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getState().getValue() == 1 && perfEvaObjectInfo.getPerfFile().getAssignType().getValue() == coll.get(0).getAssignType().getValue()) {
                    info = coll.get(i);
                    break;
                }
                if (coll.get(i).getState().getValue() != 1) continue;
                info = coll.get(i);
            }
        }
        return info == null ? null : info;
    }

    public static PerfFileInfo getPerfFileInfoByPosition(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        PerfFileInfo info = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        String personName = perfEvaObjectInfo.getName();
        String personNumber = perfEvaObjectInfo.getNumber();
        filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)personName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)personNumber, CompareType.EQUALS));
        if (perfEvaObjectInfo.getPerfFile().getPosition() != null && !StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            filter.getFilterItems().add(new FilterItemInfo("position.name", (Object)perfEvaObjectInfo.getPerfFile().getPosition().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfEvaObjectInfo.getHrUnitOrg().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by CREATETIME DESC");
        }
        catch (ParserException e1) {
            logger.error("", (Throwable)e1);
        }
        viewInfo.setSorter(sorterItemCollection);
        PerfFileCollection coll = null;
        try {
            coll = PerfFileFactory.getLocalInstance((Context)ctx).getPerfFileCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        if ((coll == null || coll.size() == 0) && StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            FilterInfo filter1 = new FilterInfo();
            EntityViewInfo viewInfo1 = new EntityViewInfo();
            SelectorItemCollection sic1 = viewInfo.getSelector();
            sic1.add(new SelectorItemInfo("*"));
            filter1.getFilterItems().add(new FilterItemInfo("person.name", (Object)perfEvaObjectInfo.getName(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("person.number", (Object)perfEvaObjectInfo.getNumber(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)perfEvaObjectInfo.getHrUnitOrg().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            viewInfo1.setSelector(sic1);
            viewInfo1.setFilter(filter1);
            try {
                coll = PerfFileFactory.getLocalInstance((Context)ctx).getPerfFileCollection(viewInfo1);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getState().getValue() == 1 && perfEvaObjectInfo.getPerfFile().getAssignType().getValue() == coll.get(0).getAssignType().getValue()) {
                    info = coll.get(i);
                    break;
                }
                if (coll.get(i).getState().getValue() != 1) continue;
                info = coll.get(i);
            }
        }
        return info == null ? null : info;
    }

    public static HROrgUnitCollection getUserHrRangeColl(Context ctx, String permItemId) {
        HROrgUnitCollection hROrgUnitCollection = null;
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        try {
            hROrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("where id in (" + userHROrgRangeSQL + ") and isSealUp=0");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return hROrgUnitCollection;
    }

    public static AdminOrgUnitCollection getUserAdminRangeColl(Context ctx, String permItemId) {
        AdminOrgUnitCollection adminOrgUnitCollection = null;
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String userAdminOrgRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        try {
            adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id in (" + userAdminOrgRangeSQL + ") and isSealUp=0");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return adminOrgUnitCollection;
    }

    public static Set<String> getAdminOrgUnitSet(Context ctx, String permItemId) {
        HashSet<String> adminOrgUnitSet = new HashSet<String>();
        AdminOrgUnitCollection adminOrgUnit = CommonValidDataUtils.getUserAdminRangeColl(ctx, permItemId);
        if (null == adminOrgUnit) {
            return adminOrgUnitSet;
        }
        int size = adminOrgUnit.size();
        for (int i = 0; i < size; ++i) {
            adminOrgUnit.get(i);
            adminOrgUnitSet.add(adminOrgUnit.get(i).getId().toString());
        }
        return adminOrgUnitSet;
    }

    public static String checkPerfIndecator(PerfIndecatorInfo perfIndecator, Context ctx) throws BOSException, EASBizException {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(CommonValidDataUtils.checkIndecatorName(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorCode(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorTypeCode(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorTypeUsable(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorLeafNode(perfIndecator, ctx));
        return errMsg.toString();
    }

    public static String checkPerfIndecatorWithoutCode(PerfIndecatorInfo perfIndecator, Context ctx) throws BOSException, EASBizException {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(CommonValidDataUtils.checkIndecatorName(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorTypeCode(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorTypeUsable(perfIndecator, ctx)).append(CommonValidDataUtils.checkIndecatorLeafNode(perfIndecator, ctx));
        return errMsg.toString();
    }

    public static String checkPerfEvaObjectInfo(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(CommonValidDataUtils.checkPositionIsEmpty(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkPerfFile(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkPeriod(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkPerfGoalsGiver(perfEvaObjectInfo, ctx));
        return errMsg.toString();
    }

    public static String checkPerfGoalsGiver(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errMsg = "";
        PerfGoalsObjectCollection coll = perfEvaObjectInfo.getPerfGoalsObject();
        try {
            for (int i = 0; i < coll.size(); ++i) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                viewInfo.setSelector(sic);
                PerfGoalsObjectInfo info = coll.get(i);
                if (info.get("personNumber") != null) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.get("personNumber").toString(), CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPersonName().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
                if (personColl.size() > 1) {
                    errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIIDENTICALPERSONEXISTFORIMPORTWITHPREFIX, ctx, new Object[]{errMsg, info.getPersonName()});
                    continue;
                }
                if (personColl.size() == 0) {
                    errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONNOTFOUNDWITHPREFIX2, ctx, new Object[]{errMsg, info.getPersonName()});
                    continue;
                }
                info.setPerson(personColl.get(0).getId().toString());
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMERR, ctx);
        }
        perfEvaObjectInfo.put("perfGoalsObject", (Object)coll);
        return errMsg;
    }

    public static String checkPositionIsEmpty(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errMsg = "";
        if (perfEvaObjectInfo.getPerfFile().getAssignType() != null && perfEvaObjectInfo.getPerfFile().getAssignType().getValue() == 0 && StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONREQUIREDASPARTTIMEJOBTYPEASSIGNED, ctx);
        }
        return errMsg;
    }

    private static String checkPosition(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errMsg = "";
        if (perfEvaObjectInfo.getPerfFile().getAssignType() != null && perfEvaObjectInfo.getPerfFile().getAssignType().getValue() == 0 && StringUtils.isEmpty((CharSequence)perfEvaObjectInfo.getPerfFile().getPosition().getName())) {
            errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONREQUIREDASPARTTIMEJOBTYPEASSIGNED, ctx);
        }
        return errMsg;
    }

    public static PerfPlanInfo getPerfPlanByPeriod(String period, Context ctx) throws EASBizException, BOSException {
        PerfPlanInfo info = null;
        PerfPeriodInfo periofInfo = null;
        periofInfo = PerfPeriodFactory.getLocalInstance((Context)ctx).getPerfPeriodInfo((IObjectPK)new ObjectUuidPK(period));
        info = PerfPlanFactory.getLocalInstance((Context)ctx).getPerfPlanInfo((IObjectPK)new ObjectUuidPK(periofInfo.getPerfPlan().getId().toString()));
        return info;
    }

    public static String checkPerfPlan(String planId, Context ctx) throws BOSException, EASBizException {
        PerfPlanInfo planInfo = null;
        try {
            planInfo = PerfPlanFactory.getLocalInstance((Context)ctx).getPerfPlanInfo((IObjectPK)new ObjectUuidPK(planId));
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLANNOTEXIST, ctx);
        }
        if (planInfo.getPStatus().getValue() == 2) {
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFPLANDISABLED, ctx);
        }
        return "";
    }

    public static String checkPerfEvaObjectInfo(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(CommonValidDataUtils.checkPosition(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkPerfFile(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkRelation(perfEvaObjectInfo, ctx)).append(CommonValidDataUtils.checkMultiPeriod(perfEvaObjectInfo, ctx));
        return errMsg.toString();
    }

    public static String checkExist(MultiPerfEvaObjectInfo info, Context ctx) {
        String errorString = "";
        HashSet<String> paperStatusSet = new HashSet<String>();
        paperStatusSet.add("200");
        paperStatusSet.add("100");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paperStatus", paperStatusSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("multiPeriod.number", (Object)info.getMultiPeriod().getNumber()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("multiPeriod.multiPerfplan.name"));
        sic.add(new SelectorItemInfo("multiPeriod.name"));
        viewInfo.setSelector(sic);
        try {
            MultiPerfEvaObjectCollection multiPerfEvaObjectCollection = MultiPerfEvaObjectFactory.getLocalInstance((Context)ctx).getMultiPerfEvaObjectCollection(viewInfo);
            if (multiPerfEvaObjectCollection != null && multiPerfEvaObjectCollection.size() > 0) {
                MultiPerfEvaObjectInfo exist = multiPerfEvaObjectCollection.get(0);
                errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVAOBJEXISTERR, ctx, new Object[]{exist.getMultiPeriod().getMultiPerfplan().getName(), exist.getMultiPeriod().getName()});
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHECKEVAOBJEXISTERR, ctx);
        }
        return errorString;
    }

    public static String checkPerfFile(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errorString = "";
        PerfFileInfo perfFile = CommonValidDataUtils.getPerfFileInfoByPosition(perfEvaObjectInfo, ctx);
        if (perfFile == null) {
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFFILEREQUIREDFORTHISPERSON, ctx);
        }
        return errorString;
    }

    public static String checkRelation(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errorString = "";
        if (perfEvaObjectInfo.getMultiPerfRelationship() != null) {
            String relationId = perfEvaObjectInfo.getMultiPerfRelationship().getId().toString();
            try {
                MultiPerfRelationshipCollection coll = MultiPerfRelationshipFactory.getLocalInstance((Context)ctx).getMultiPerfRelationshipCollection("where id = '" + relationId + "'");
                if (coll != null && coll.size() > 0) {
                    MultiPerfRelationshipInfo info = coll.get(0);
                    if (!perfEvaObjectInfo.getMultiPeriod().getId().toString().equals(info.getMultiPeriod().getId().toString())) {
                        errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATIONSHIPNOTFOUNDINTHISPERIOD, ctx);
                    }
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
                errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVALUATERELATIONNOTFOUND, ctx);
            }
        }
        return errorString;
    }

    public static String checkMultiPeriod(MultiPerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errorString = "";
        MultiPerfPeriodInfo multiPeriod = perfEvaObjectInfo.getMultiPeriod();
        try {
            if (multiPeriod != null && multiPeriod.getEvaPeriodStatus().getValue() == 100) {
                errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNOTALLOWEDASEVALUENDED, ctx);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETPERIODERR, ctx);
        }
        return errorString;
    }

    public static String checkPeriod(PerfEvaObjectInfo perfEvaObjectInfo, Context ctx) {
        String errorString = "";
        String period = (String)perfEvaObjectInfo.get("period");
        try {
            PerfPeriodInfo info = PerfPeriodFactory.getLocalInstance((Context)ctx).getPerfPeriodInfo("where id = '" + period + "'");
            if (info.getEvaPeriodStatus().getValue() == 100) {
                errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTNOTALLOWEDASEVALUENDED, ctx);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            errorString = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETPERIODERR, ctx);
        }
        return errorString;
    }

    public static String checkTargetNodeParentInfo(TargetNodeParentInfo info, Context ctx, String workFlowId, boolean isTargetNodeWeight) {
        StringBuffer errMsg = new StringBuffer(48);
        errMsg.append(CommonValidDataUtils.checkEvaObject(info, ctx)).append(CommonValidDataUtils.checkPerson(info, ctx)).append(CommonValidDataUtils.checkTarget(info, ctx, workFlowId, isTargetNodeWeight));
        return errMsg.toString();
    }

    private static String checkTarget(TargetNodeParentInfo info, Context ctx, String workFlowId, boolean isTargetNodeWeight) {
        String targetName = (String)info.get("targetName");
        String targetNumber = (String)info.get("targetNumber");
        String areaTypeName = (String)info.get("areaType");
        if (StringUtils.isBlank((CharSequence)targetName) && StringUtils.isBlank((CharSequence)targetNumber)) {
            return "";
        }
        String period = (String)info.get("period");
        String evaObj = (String)info.get("evaObj");
        TargetNodeCollection targetNode = info.getTargetNode();
        try {
            BigDecimal weight;
            String wfId;
            TargetNodeInfo nodeInfo;
            int i;
            IndicatorTargetCollection college;
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            IIndicatorTarget iIndecatorTarget = IndicatorTargetFactory.getLocalInstance((Context)ctx);
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance((Context)ctx);
            PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("performanceRule", (Object)periodInfo.getPerfRule().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)areaTypeName, CompareType.EQUALS));
            EvaluFormAreaBaseCollection coll = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx).getEvaluFormAreaBaseCollection("where " + filter.toSql());
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("workFlow.id", (Object)workFlowId, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("areaBase.name", (Object)areaTypeName, CompareType.EQUALS));
            if ("200".equals(coll.get(0).getAreaType().getValue())) {
                if (StringUtils.isEmpty((CharSequence)targetNumber)) {
                    filter1.getFilterItems().add(new FilterItemInfo("name", (Object)targetName, CompareType.EQUALS));
                } else {
                    filter1.getFilterItems().add(new FilterItemInfo("number", (Object)targetNumber, CompareType.EQUALS));
                    filter1.getFilterItems().add(new FilterItemInfo("name", (Object)targetName, CompareType.EQUALS));
                }
                college = iIndecatorTarget.getIndicatorTargetCollection("where " + filter1.toSql());
                if (college.size() == 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATEDINDICATORNOTFOUND, ctx);
                }
                for (i = 0; i < targetNode.size(); ++i) {
                    nodeInfo = targetNode.get(i);
                    wfId = nodeInfo.getWfNode().getId().toString();
                    nodeInfo.setIndicatorId(college.get(0).getId().toString());
                    nodeInfo.setIndicatorType(0);
                    if (isTargetNodeWeight) continue;
                    if (map.get(nodeInfo.getIndicatorId() + "_" + wfId) == null) {
                        weight = new BigDecimal(nodeInfo.getWeight());
                        map.put(nodeInfo.getIndicatorId() + "_" + wfId, weight);
                        continue;
                    }
                    weight = new BigDecimal(nodeInfo.getWeight());
                    weight = weight.add((BigDecimal)map.get(nodeInfo.getIndicatorId() + "_" + wfId));
                    map.put(nodeInfo.getIndicatorId() + "_" + wfId, weight);
                }
                info.put("target", (Object)college.get(0).getId().toString());
            } else {
                if (StringUtils.isEmpty((CharSequence)targetNumber)) {
                    filter1.getFilterItems().add(new FilterItemInfo("keyItem", (Object)targetName, CompareType.EQUALS));
                } else {
                    filter1.getFilterItems().add(new FilterItemInfo("keyCode", (Object)targetNumber, CompareType.EQUALS));
                    filter1.getFilterItems().add(new FilterItemInfo("keyItem", (Object)targetName, CompareType.EQUALS));
                }
                college = irecordTarget.getRecordTargetCollection("where " + filter1.toSql());
                if (college.size() == 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATEDINDICATORNOTFOUND, ctx);
                }
                for (i = 0; i < targetNode.size(); ++i) {
                    nodeInfo = targetNode.get(i);
                    wfId = nodeInfo.getWfNode().getId().toString();
                    nodeInfo.setIndicatorId(college.get(0).getId().toString());
                    nodeInfo.setIndicatorType(1);
                    if (isTargetNodeWeight) continue;
                    if (map.get(nodeInfo.getIndicatorId() + "_" + wfId) == null) {
                        weight = new BigDecimal(nodeInfo.getWeight());
                        map.put(nodeInfo.getIndicatorId() + "_" + wfId, weight);
                        continue;
                    }
                    weight = new BigDecimal(nodeInfo.getWeight());
                    weight = weight.add((BigDecimal)map.get(nodeInfo.getIndicatorId() + "_" + wfId));
                    map.put(nodeInfo.getIndicatorId() + "_" + wfId, weight);
                }
                info.put("target", (Object)college.get(0).getId().toString());
            }
            if (!isTargetNodeWeight) {
                for (String key : map.keySet()) {
                    if (TOTALWEIGHT.compareTo((BigDecimal)map.get(key)) == 0) continue;
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NODEHANDLERWEIGHTMUSTBE100, ctx);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETPERFPLANERR, ctx);
        }
        return "";
    }

    private static String checkPerson(TargetNodeParentInfo info, Context ctx) {
        int size = info.getTargetNode().size();
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection posiMemberColl = null;
            IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < size; ++i) {
                TargetNodeInfo nodeInfo = info.getTargetNode().get(i);
                String personName = nodeInfo.getPersonName();
                String personNumber = nodeInfo.getPersonNumber();
                FilterInfo filter = new FilterInfo();
                if (StringUtils.isEmpty((CharSequence)personNumber)) {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)personName));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)personName, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)personNumber, CompareType.EQUALS));
                }
                PersonCollection coll = iPerson.getPersonCollection("where " + filter.toSql());
                if (coll.size() > 1) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIIDENTICALPERSONEXISTWITHPREFIX, ctx, new Object[]{personName});
                }
                if (coll.size() == 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONNOTFOUNDWITHPREFIX, ctx, new Object[]{personName});
                }
                posiMemberColl = iPosiMember.getPositionMemberCollection(CommonValidDataUtils.getPMEntityViewInfo(ctx, BOSUuid.read((String)coll.get(0).getId().toString())));
                nodeInfo.setPersonPosition(posiMemberColl.get(0).getPosition());
                nodeInfo.setPersonNumber(coll.get(0).getNumber());
                nodeInfo.setPerson(coll.get(0).getId().toString());
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEVALUATORERR, ctx);
        }
        return "";
    }

    public static String checkEvaObject(TargetNodeParentInfo info, Context ctx) {
        String name = (String)info.get("name");
        String number = (String)info.get("number");
        String position = (String)info.get("position");
        String period = (String)info.get("period");
        String isOrgVal = (String)info.get("isOrg");
        boolean isOrg = false;
        if (StringUtils.isNotEmpty((CharSequence)isOrgVal)) {
            isOrg = "1".equals(isOrgVal);
        }
        String evaObjKey = "person";
        if (isOrg) {
            evaObjKey = "adminHis";
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        if (StringUtils.isEmpty((CharSequence)number)) {
            filter.getFilterItems().add(new FilterItemInfo(evaObjKey + ".name", (Object)name, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(evaObjKey + ".name", (Object)name, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo(evaObjKey + ".number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)position)) {
            filter.getFilterItems().add(new FilterItemInfo("perffile.position.name", (Object)position, CompareType.EQUALS));
        }
        try {
            PerfEvaObjectCollection perfEvaObjectColl = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectCollection("where " + filter.toSql());
            if (perfEvaObjectColl.size() > 1) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIEVAOBJWITHSAMENAMEEXIST, ctx);
            }
            if (perfEvaObjectColl.size() == 0) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATEDEVAOBJNOTFOUND, ctx);
            }
            if (perfEvaObjectColl.get(0).getWorkFlowStatus().getValue() != 0) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTERRASWORKFLOWSTARTED, ctx);
            }
            for (int i = 0; i < info.getTargetNode().size(); ++i) {
                info.getTargetNode().get(i).setEvaObj(perfEvaObjectColl.get(0));
            }
            info.put("evaObj", (Object)perfEvaObjectColl.get(0).getId().toString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEVAOBJERR, ctx);
        }
        return "";
    }

    public static String checkTargetImportNodeInfo(TargetImportSupportInfo info, Context ctx) {
        StringBuffer errMsg = new StringBuffer(48);
        errMsg.append(CommonValidDataUtils.checkEvaObject(info, ctx)).append(CommonValidDataUtils.checkPerson(info, ctx)).append(CommonValidDataUtils.checkTarget(info, ctx));
        return errMsg.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String checkTarget(TargetImportSupportInfo info, Context ctx) {
        String targetName = (String)info.get("targetName");
        String targetNumber = (String)info.get("targetNumber");
        String areaTypeName = (String)info.get("areaName");
        String period = (String)info.get("period");
        String evaObj = (String)info.get("evaObj");
        String desc = (String)info.get("desc");
        String remark = (String)info.get("remark");
        String importType = String.valueOf(info.get("importType"));
        TargetNodeCollection targetNode = info.getTargetNode();
        HashMap map = new HashMap();
        PerfPlanInfo planInfo = null;
        PerfPeriodInfo periodInfo = null;
        try {
            planInfo = CommonValidDataUtils.getPerfPlanByPeriod(period, ctx);
            periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
            String periodRuleId = periodInfo.getPerfRule().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("performanceRule", (Object)periodRuleId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)areaTypeName, CompareType.EQUALS));
            EvaluFormAreaBaseCollection coll = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx).getEvaluFormAreaBaseCollection("where " + filter.toSql());
            if (coll.size() < 1) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EVALUAREANOTFOUND, ctx, new Object[]{areaTypeName});
            }
            String areaBaseId = coll.get(0).getId().toString();
            PWorkFlowDefInfo workFlow = null;
            IPerfEvaObjMatrixWorkFlowInst iPerfEvaObjMatrixWorkFlowInst = PerfEvaObjMatrixWorkFlowInstFactory.getLocalInstance((Context)ctx);
            PerfEvaObjMatrixWorkFlowInstCollection perfEvaObjMatrixWorkFlowInstColl = iPerfEvaObjMatrixWorkFlowInst.getPerfEvaObjMatrixWorkFlowInstCollection("where evaObj='" + evaObj + "' and areaBase = '" + areaBaseId + "'");
            if (perfEvaObjMatrixWorkFlowInstColl.size() > 0) {
                workFlow = perfEvaObjMatrixWorkFlowInstColl.get(0).getWorkflow();
            } else {
                IPerfEvaObjectMatrixWorkFlow imatrixWorkFlow = PerfEvaObjectMatrixWorkFlowFactory.getLocalInstance((Context)ctx);
                PerfEvaObjectMatrixWorkFlowCollection perfEvaObjMatrixWorkFlowColl = imatrixWorkFlow.getPerfEvaObjectMatrixWorkFlowCollection("where perfplan = '" + planInfo.getId().toString() + "' and areaBase = '" + areaBaseId + "' and perfRule = '" + periodRuleId + "'");
                if (perfEvaObjMatrixWorkFlowColl.isEmpty() && 1 == periodInfo.getIsHistoryUpdate().getValue()) {
                    perfEvaObjMatrixWorkFlowColl = imatrixWorkFlow.getPerfEvaObjectMatrixWorkFlowCollection("where perfplan = '" + planInfo.getId().toString() + "' and areaBase = '" + areaBaseId + "' and perfRule is null");
                }
                if (perfEvaObjMatrixWorkFlowColl.size() > 0) {
                    workFlow = perfEvaObjMatrixWorkFlowColl.get(0).getWorkflow();
                }
            }
            if ("200".equals(coll.get(0).getAreaType().getValue())) {
                info.put("recordTagetget", null);
                IndicatorTargetCollection indicoll = new IndicatorTargetCollection();
                IndicatorTargetInfo inditTarget = (IndicatorTargetInfo)info.get("indicatorTarget");
                String scoreFomula = inditTarget.getScoringFormula();
                String indiType = inditTarget.getIndecatorType();
                if (!StringUtils.isEmpty((CharSequence)scoreFomula) && inditTarget.getQualiOrRation().getValue() == 1) {
                    ScoringFormulaCollection fomulacoll = ScoringFormulaFactory.getLocalInstance((Context)ctx).getScoringFormulaCollection("where name = '" + scoreFomula + "'");
                    if (fomulacoll.size() <= 0) return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMULANOTFOUND, ctx);
                    inditTarget.setScoringFormula(fomulacoll.get(0).getId().toString());
                } else {
                    inditTarget.setScoringFormula(null);
                }
                if (!StringUtils.isEmpty((CharSequence)indiType)) {
                    FilterInfo typeFilter = new FilterInfo();
                    typeFilter.getFilterItems().add(new FilterItemInfo("name", (Object)indiType, CompareType.EQUALS));
                    IndecatorTypeCollection indiTypecoll = IndecatorTypeFactory.getLocalInstance((Context)ctx).getIndecatorTypeCollection("where " + typeFilter.toSql());
                    if (indiTypecoll.size() <= 0) return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORTYPENOTFOUND, ctx);
                    inditTarget.setIndecatorType(indiTypecoll.get(0).getId().toString());
                }
                if (!"10".equals(importType)) {
                    FilterInfo targetFilter = new FilterInfo();
                    targetFilter.getFilterItems().add(new FilterItemInfo("name", (Object)targetName, CompareType.EQUALS));
                    targetFilter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(targetFilter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    evi.setSelector(sic);
                    IndicatorTargetCollection targetColl = IndicatorTargetFactory.getLocalInstance((Context)ctx).getIndicatorTargetCollection(evi);
                    if (targetColl.size() > 0) {
                        inditTarget.setId(targetColl.get(0).getId());
                    } else {
                        inditTarget.setId(BOSUuid.create((String)"594BDE85"));
                    }
                } else {
                    inditTarget.setId(BOSUuid.create((String)"594BDE85"));
                }
                inditTarget.setName(targetName);
                inditTarget.setNumber(targetNumber);
                inditTarget.put("evaObj", (Object)evaObj);
                inditTarget.setWeight((String)info.get("weight"));
                inditTarget.setRemark((String)info.get("remark"));
                inditTarget.setWorkFlow(workFlow);
                if (!StringUtils.isEmpty((CharSequence)inditTarget.getTargetValue()) && !CommonValidDataUtils.isNumericzidai(inditTarget.getTargetValue())) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TARGETVALUEMUSTBEDIGITAL, ctx);
                }
                inditTarget.setIndecatorDesc(desc);
                inditTarget.put("perfPeriod", (Object)period);
                inditTarget.setPerfRule(periodInfo.getPerfRule());
                inditTarget.setEvaPlan(planInfo);
                inditTarget.setAreaBase(coll.get(0));
                info.put("target", (Object)inditTarget.getId().toString());
                IndicatorExtendHelperInfo extend = inditTarget.getExtend();
                if (null == extend) {
                    extend = new IndicatorExtendHelperInfo();
                }
                extend.setId(null);
                extend.put("evaObj", (Object)evaObj);
                IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getLocalInstance((Context)ctx);
                IObjectPK extendNew = iIndicatorExtendHelper.addnew(extend);
                inditTarget.put("extend", (Object)extendNew.toString());
                indicoll.add(inditTarget);
                info.put("indiTargetget", (Object)indicoll);
            } else {
                info.put("indiTargetget", null);
                RecordTargetCollection recordColl = new RecordTargetCollection();
                RecordTargetInfo record = (RecordTargetInfo)info.get("recordTarget");
                String time = record.getCompleteTime();
                if (!StringUtils.isEmpty((CharSequence)time) && !CommonValidDataUtils.isValidDate(time)) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.COMPLETETIMEFORMATINVALID, ctx);
                }
                record.setKeyItem(targetName);
                record.setKeyCode(targetNumber);
                record.put("evaObj", (Object)evaObj);
                record.setWorkFlow(workFlow);
                if (!"10".equals(importType)) {
                    FilterInfo targetFilter = new FilterInfo();
                    targetFilter.getFilterItems().add(new FilterItemInfo("keyItem", (Object)targetName, CompareType.EQUALS));
                    targetFilter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
                    RecordTargetCollection targetColl = RecordTargetFactory.getLocalInstance((Context)ctx).getRecordTargetCollection("where " + targetFilter.toSql());
                    if (targetColl.size() > 0) {
                        record.setId(targetColl.get(0).getId());
                    } else {
                        record.setId(BOSUuid.create((String)"594BDE85"));
                    }
                } else {
                    record.setId(BOSUuid.create((String)"594BDE85"));
                }
                record.setWeight((String)info.get("weight"));
                record.setRema((String)info.get("remark"));
                record.setId(BOSUuid.create((String)"C17A855D"));
                record.put("perfPeriod", (Object)period);
                record.setPerfRule(periodInfo.getPerfRule());
                record.setEvaPlan(planInfo);
                record.setAreaBase(coll.get(0));
                IndicatorExtendHelperInfo extend = record.getExtend();
                if (null == extend) {
                    extend = new IndicatorExtendHelperInfo();
                }
                extend.setId(null);
                extend.put("evaObj", (Object)evaObj);
                IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getLocalInstance((Context)ctx);
                IObjectPK extendNew = iIndicatorExtendHelper.addnew(extend);
                record.put("extend", (Object)extendNew.toString());
                info.put("target", (Object)record.getId().toString());
                recordColl.add(record);
                info.put("recordTargetget", (Object)recordColl);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.DATAINVALID, ctx);
        }
        for (String key : map.keySet()) {
            if (TOTALWEIGHT.compareTo((BigDecimal)map.get(key)) == 0) continue;
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NODEHANDLERWEIGHTMUSTBE100, ctx);
        }
        return "";
    }

    private static String checkPerson(TargetImportSupportInfo info, Context ctx) {
        int size = info.getTargetNode().size();
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection posiMemberColl = null;
            IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < size; ++i) {
                TargetNodeInfo nodeInfo = info.getTargetNode().get(i);
                String personName = nodeInfo.getPersonName();
                String personNumber = nodeInfo.getPersonNumber();
                FilterInfo filter = new FilterInfo();
                if (StringUtils.isEmpty((CharSequence)personNumber)) {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)personName));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)personName, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)personNumber, CompareType.EQUALS));
                }
                PersonCollection coll = iPerson.getPersonCollection("where " + filter.toSql());
                if (coll.size() > 1) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIIDENTICALPERSONEXISTWITHPREFIX, ctx, new Object[]{personName});
                }
                if (coll.size() == 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONNOTFOUNDWITHPREFIX, ctx, new Object[]{personName});
                }
                posiMemberColl = iPosiMember.getPositionMemberCollection(CommonValidDataUtils.getPMEntityViewInfo(ctx, BOSUuid.read((String)coll.get(0).getId().toString())));
                nodeInfo.setPersonPosition(posiMemberColl.get(0).getPosition());
                nodeInfo.setPersonNumber(coll.get(0).getNumber());
                nodeInfo.setPerson(coll.get(0).getId().toString());
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEVALUATORERR, ctx);
        }
        return "";
    }

    private static EntityViewInfo getPMEntityViewInfo(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        FilterItemInfo filterItemPosi = new FilterItemInfo("person.id", (Object)personId.toString().trim());
        filter.getFilterItems().add(filterItemPosi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPrimary"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        return viewInfo;
    }

    private static String checkEvaObject(TargetImportSupportInfo info, Context ctx) {
        String name = (String)info.get("name");
        String number = (String)info.get("number");
        String position = (String)info.get("position");
        String period = (String)info.get("period");
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((CharSequence)number)) {
            filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)name, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)name, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)position)) {
            filter.getFilterItems().add(new FilterItemInfo("perffile.position.name", (Object)position, CompareType.EQUALS));
        }
        try {
            PerfEvaObjectCollection perfEvaObjectColl = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectCollection("where " + filter.toSql());
            if (perfEvaObjectColl.size() > 1) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIEVAOBJWITHSAMENAMEEXIST, ctx);
            }
            if (perfEvaObjectColl.size() == 0) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RELATEDEVAOBJNOTFOUND, ctx);
            }
            if (perfEvaObjectColl.get(0).getCanAdjustEvaluer().getValue() == 0 && info.getTargetNode().size() > 0) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTHANDLERNOTALLOWEDFORMATRIXEVALU, ctx);
            }
            if (perfEvaObjectColl.get(0).getWorkFlowStatus().getValue() != 0) {
                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTERRASWORKFLOWSTARTED, ctx);
            }
            info.put("evaObj", (Object)perfEvaObjectColl.get(0).getId().toString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETEVAOBJERR, ctx);
        }
        return "";
    }

    public static boolean isNumericzidai(String str) {
        Matcher isNum = PATTERN_NUMER.matcher(str);
        return isNum.matches();
    }

    private static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static String checkAchivementDataRule(AchivementDataRlueInfo info, Context ctx) throws BOSException, EASBizException {
        AchivenmentDataRulePersonInfo entriorPersonInfo;
        PositionCollection positioncoll;
        PersonCollection personcoll;
        String[] person;
        AchivementDataRuleAuditPersonInfo auditorPersonInfo;
        FilterInfo filter;
        int i;
        AchivementDataRuleAuditPersonCollection coll;
        String[] persons;
        String errMsg = "";
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        String name = info.getName();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfPeriod", (Object)info.get("perfPeriod").toString(), CompareType.EQUALS));
        if (!IndicatorTargetFactory.getLocalInstance((Context)ctx).exists(filterInfo)) {
            errMsg = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDICATORNAMENOTFOUND, ctx);
        }
        if ("0".equals(info.getAudiType().getValue()) || "1".equals(info.getAudiType().getValue())) {
            info.put("auditPerson", null);
        } else if ("3".equals(info.getAudiType().getValue())) {
            if (StringUtils.isEmpty((CharSequence)((String)info.get("auditorName")))) {
                errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.AUDITORCANNOTBENULL, ctx);
            } else {
                persons = ((String)info.get("auditorName")).split(",|\uff0c| |;|\uff1b");
                coll = new AchivementDataRuleAuditPersonCollection();
                for (i = 0; i < persons.length; ++i) {
                    filter = new FilterInfo();
                    auditorPersonInfo = new AchivementDataRuleAuditPersonInfo();
                    person = persons[i].split("##");
                    if (person.length > 1) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)person[0], CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[1], CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[0], CompareType.EQUALS));
                    }
                    personcoll = iPerson.getPersonCollection("where " + filter.toSql());
                    if (personcoll.size() <= 0) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONNOTFOUNDINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    if (personcoll.size() > 1) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONISMULTIPLEINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    auditorPersonInfo.put("person", (Object)personcoll.get(0));
                    auditorPersonInfo.setAchivementDataRule(info);
                    coll.add(auditorPersonInfo);
                }
                info.put("auditPerson", (Object)coll);
            }
        } else if ("2".equals(info.getAudiType().getValue())) {
            if (StringUtils.isEmpty((CharSequence)((String)info.get("auditorName")))) {
                errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONCANNOTNULL, ctx);
            } else {
                persons = ((String)info.get("auditorName")).split(",|\uff0c| |;|\uff1b");
                coll = new AchivementDataRuleAuditPersonCollection();
                for (i = 0; i < persons.length; ++i) {
                    filter = new FilterInfo();
                    auditorPersonInfo = new AchivementDataRuleAuditPersonInfo();
                    person = persons[i].split("##");
                    if (person.length > 1) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)person[0], CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[1], CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[0], CompareType.EQUALS));
                    }
                    positioncoll = iPosition.getPositionCollection("where " + filter.toSql());
                    if (positioncoll.size() <= 0) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONNOTFOUNDINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    if (positioncoll.size() > 1) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONISMULTIPLEINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    auditorPersonInfo.put("position", (Object)positioncoll.get(0));
                    auditorPersonInfo.setAchivementDataRule(info);
                    coll.add(auditorPersonInfo);
                }
                info.put("auditPerson", (Object)coll);
            }
        }
        if ("0".equals(info.getInputType().getValue()) || "1".equals(info.getInputType().getValue())) {
            info.put("inputPerson", null);
        } else if ("3".equals(info.getInputType().getValue())) {
            if (StringUtils.isEmpty((CharSequence)((String)info.get("entriorName")))) {
                errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRIORPERSONCANNOTNULL, ctx);
            } else {
                persons = ((String)info.get("entriorName")).split(",|\uff0c| |;|\uff1b");
                coll = new AchivenmentDataRulePersonCollection();
                for (i = 0; i < persons.length; ++i) {
                    filter = new FilterInfo();
                    entriorPersonInfo = new AchivenmentDataRulePersonInfo();
                    person = persons[i].split("##");
                    if (person.length > 1) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)person[0], CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[1], CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[0], CompareType.EQUALS));
                    }
                    personcoll = iPerson.getPersonCollection("where " + filter.toSql());
                    if (personcoll.size() <= 0) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONNOTFOUNDINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    if (personcoll.size() > 1) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERSONISMULTIPLEINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    entriorPersonInfo.put("person", (Object)personcoll.get(0));
                    entriorPersonInfo.setAchimentDataRule(info);
                    coll.add(entriorPersonInfo);
                }
                info.put("inputPerson", (Object)coll);
            }
        } else if ("2".equals(info.getInputType().getValue())) {
            if (StringUtils.isEmpty((CharSequence)((String)info.get("entriorName")))) {
                errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ENTRIORPOSITIONCANNOTNULL, ctx);
            } else {
                persons = ((String)info.get("entriorName")).split(",|\uff0c| |;|\uff1b");
                coll = new AchivenmentDataRulePersonCollection();
                for (i = 0; i < persons.length; ++i) {
                    filter = new FilterInfo();
                    entriorPersonInfo = new AchivenmentDataRulePersonInfo();
                    person = persons[i].split("##");
                    if (person.length > 1) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)person[0], CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[1], CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("name", (Object)person[0], CompareType.EQUALS));
                    }
                    positioncoll = iPosition.getPositionCollection("where " + filter.toSql());
                    if (positioncoll.size() <= 0) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONNOTFOUNDINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    if (positioncoll.size() > 1) {
                        errMsg = errMsg + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POSITIONISMULTIPLEINSYSTEM, ctx, new Object[]{person[i]});
                        continue;
                    }
                    entriorPersonInfo.put("position", (Object)positioncoll.get(0));
                    entriorPersonInfo.setAchimentDataRule(info);
                    coll.add(entriorPersonInfo);
                }
                info.put("inputPerson", (Object)coll);
            }
        }
        return errMsg;
    }
}

