/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractPerformanceBillBaseControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.PerformanceBillBaseInfo;
import com.kingdee.shr.perfweb.util.TheThirdMessageUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceBillBaseControllerBean
extends AbstractPerformanceBillBaseControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.PerformanceBillBaseControllerBean");
    private IHRBillBizBean bizBean = null;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("billState", (Object)HRBillStateEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
        this._sendAssignedMsgToXT(ctx, billId);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITEND);
        this._sendAssignedMsgToXT(ctx, billId);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRBillStateEnum.AUDITING);
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        PerformanceBillBaseInfo info = (PerformanceBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(HRBillStateEnum.SAVED);
        info.setApplyDate(new Date());
        info.put("approveDate", sdf.format(new Date()));
        info.put("autoFilter", true);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("approveDate"));
        selectors.add(new SelectorItemInfo("autoFilter"));
        selectors.add(new SelectorItemInfo("flowState"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        PerformanceBillBaseInfo info = (PerformanceBillBaseInfo)this._getValue(ctx, "select id, billState , approveDate  where id = '" + pk.toString() + "'");
        info.setBillState(state);
        info.setApplyDate(new Date());
        info.put("approveDate", sdf.format(new Date()));
        info.put("autoFilter", true);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billState"));
        selectors.add(new SelectorItemInfo("approveDate"));
        selectors.add(new SelectorItemInfo("autoFilter"));
        this.updatePartial(ctx, info, selectors);
    }

    @Override
    protected void _batchPassAudit(Context ctx, String[] billIds) throws BOSException, EASBizException {
    }

    @Override
    protected void _setEffectDate(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
    }

    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PerformanceBillBaseInfo bill = (PerformanceBillBaseInfo)model;
        bill.setApproveType(ApproveTypeEnum.DIRECT);
        bill.setBillState(HRBillStateEnum.AUDITED);
        IObjectPK objectPK = super.save(ctx, model);
        this.setAudited(ctx, BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID != null) {
            HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
            if (this.bizBean != null) {
                this.bizBean._personPlanChek(ctx, (IObjectValue)model);
            }
            this.initBizBean(ctx);
            this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
            if (this.bizBean != null) {
                this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
            }
            if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
                this.saveMultiApproveInfo(ctx, billID);
            }
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
        }
        if (this.bizBean != null) {
            BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
            PlugInBeanProxy plugIn = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(this.getBOSType());
            if (entity != null) {
                String fullName = entity.getFullName();
                try {
                    plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                }
                catch (Exception var9) {
                    throw new BOSException("PlugInBean Get Error:" + var9.getMessage(), var9.getCause());
                }
            }
            IReflectMethod[] decorators = null;
            if (plugIn != null && billExtend != null) {
                decorators = new IReflectMethod[]{plugIn, billExtend};
            } else if (billExtend != null) {
                decorators = new IReflectMethod[]{billExtend};
            } else if (plugIn != null) {
                decorators = new IReflectMethod[]{plugIn};
            }
            if (decorators != null) {
                try {
                    this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                }
                catch (Throwable var8) {
                    throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, var8);
                }
            }
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (!(HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState))) {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
            iHRBillBase.setSaved(BOSUuid.read((String)billId));
            this.abortWorkFlow(ctx, billId);
        }
    }

    protected void abortWorkFlow(Context ctx, String billId) throws BOSException {
        TheThirdMessageUtil.recycleWFAssign(ctx, billId);
    }

    @Override
    protected void _setNoPassStateStop(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PerformanceBillBaseInfo info = (PerformanceBillBaseInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PerformanceBillBaseInfo info = (PerformanceBillBaseInfo)model;
        if (info.getHrOrgUnit() == null) {
            PerformanceBillBaseInfo billBaseInfo = this.getPerformanceBillBaseInfo(ctx, pk);
            info.setHrOrgUnit(billBaseInfo.getHrOrgUnit());
        }
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            logger.error("billInfo without hrOrgUnit, default value has been set. pk is :" + pk.toString());
        }
        super._update(ctx, pk, model);
    }
}

