/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractScoreFormulaCalculateFacadeControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.EndWayEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IsNeedScoreEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.formulaplatform.IPlatformCalFormula;
import com.kingdee.shr.perfweb.app.base.formulaplatform.PlatformCalFormulaFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.AbstractScoringFormulaDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException2;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.app.workflow.IPerfWorkFlowFacade;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.bean.PerfScoreBatchSaveBean;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.ServerResponseConst;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFExecutor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.parquet.Strings;

public class ScoreFormulaCalculateFacadeControllerBean
extends AbstractScoreFormulaCalculateFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.ScoreFormulaCalculateFacadeControllerBean");
    private static final String EVATASK_TITLE = "PERFWEB -Calculate achiveData score";
    private static final String ACHIVEMENTDATARULEBEAN = "com.kingdee.shr.perfweb.app.base.evalplan.ScoreFormulaCalculateFacadeControllerBean";
    private static final String EVATASK_METHODNAME = "cacularSumResult";

    @Override
    protected String _scoreFormularCalcaulate(Context ctx, String scoreFormularID, String rate, String perfScoreID, String maxScoreOrTarScore) throws BOSException, EASBizException {
        BigDecimal scoreRate = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scoringFormula", (Object)scoreFormularID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoringMin", (Object)rate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoringMax", (Object)rate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoringMin", (Object)rate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoringMax", (Object)rate, CompareType.GREATER));
        filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4)) ");
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("scoringFormula.*"));
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        ScoringFormulaDefineCollection coll = ScoringFormulaDefineFactory.getLocalInstance(ctx).getScoringFormulaDefineCollection(evi);
        BigDecimal result = new BigDecimal("0");
        if (coll == null || coll.size() < 1) {
            return new DecimalFormat("#.##").format(result);
        }
        AbstractScoringFormulaDefineInfo formulaDef = null;
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                ScoringFormulaDefineInfo info = coll.get(i);
                if (info.getScoringMax().equals(info.getScoringMin())) {
                    formulaDef = info;
                    break;
                }
                formulaDef = info;
            }
        }
        if (formulaDef == null) {
            if (logger.isDebugEnabled()) {
                logger.error("[PERFWEB] it is failed to get get formulaDef");
            }
            return new DecimalFormat("#.##").format(result);
        }
        BigDecimal rate1 = new BigDecimal(rate);
        BigDecimal scoringMax = formulaDef.getScoringMax();
        BigDecimal scoringMin = formulaDef.getScoringMin();
        BigDecimal scoringRateMax = formulaDef.getScoringRateMax();
        BigDecimal scoringRateMin = formulaDef.getScoringRateMin();
        BigDecimal maxScoreOrTarScoreBig = new BigDecimal(maxScoreOrTarScore);
        if (scoringMax == null && scoringMin != null) {
            scoreRate = scoringRateMin.multiply(maxScoreOrTarScoreBig);
        } else if (scoringMax != null && scoringMin == null) {
            scoreRate = scoringRateMax.multiply(maxScoreOrTarScoreBig);
        } else if (scoringRateMax.compareTo(scoringRateMin) == 0 || scoringMax != null && scoringMax.compareTo(scoringMin) == 0) {
            scoreRate = scoringRateMax.multiply(maxScoreOrTarScoreBig);
        } else if (scoringMax != null) {
            scoreRate = rate1.subtract(scoringMin).multiply(scoringRateMax.subtract(scoringRateMin)).multiply(new BigDecimal(100)).multiply(maxScoreOrTarScoreBig).divide(scoringMax.subtract(scoringMin), 4, 0).divide(new BigDecimal(100)).add(scoringRateMin.multiply(maxScoreOrTarScoreBig));
        }
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(scoreRate);
    }

    @Override
    protected void _calcalateNodeScore(Context ctx, Map targetAchieve) throws BOSException, EASBizException {
        Set targetIds = targetAchieve.keySet();
        StringBuffer sb = new StringBuffer(48);
        for (String id : targetIds) {
            sb.append(id).append(",");
        }
        this._cacularSumResult(ctx, sb.substring(0, sb.length() - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _cacularSumResult(Context ctx, String targetId) throws BOSException, EASBizException {
        logger.error("\u3010perfweb\u3011targetId", (Object)targetId);
        HashSet<String> targetIds = new HashSet<String>();
        String[] targets = targetId.split(",");
        targetIds.addAll(Arrays.asList(targets));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", targetIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("scoringFormula IS NOT NULL"));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaObj.period.perfRule"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        IndicatorTargetCollection targetColl = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(evi);
        logger.error("\u3010perfweb\u3011targetColl", (Object)targetColl.size());
        BigDecimal maxScore = null;
        int size = targetColl.size();
        BigDecimal achieveData = null;
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        IPlatformCalFormula iPlatformCalFormula = PlatformCalFormulaFactory.getLocalInstance(ctx);
        for (int i = 0; i < size; ++i) {
            boolean isPlatformula;
            IndicatorTargetInfo targetInfo = targetColl.get(i);
            if (StringUtils.isEmpty((CharSequence)targetInfo.getScoringFormula())) continue;
            String perfRuleid = targetInfo.getEvaObj().getPeriod().getPerfRule().getId().toString();
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add(new SelectorItemInfo("scoreRate.perfScoreInfo.id"));
            sic1.add(new SelectorItemInfo("scoreRate.perfScoreInfo.max"));
            sic1.add(new SelectorItemInfo("pariMutual.id"));
            sic1.add(new SelectorItemInfo("pariMutual.max"));
            sic1.add(new SelectorItemInfo("scoringWay"));
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", (Object)perfRuleid, CompareType.EQUALS));
            EntityViewInfo evi1 = new EntityViewInfo();
            evi1.setSelector(sic1);
            evi1.setFilter(filter1);
            PerformanceRuleCollection perfRuleColl = PerformanceRuleFactory.getLocalInstance(ctx).getPerformanceRuleCollection(evi1);
            if (perfRuleColl.isEmpty()) {
                throw new SHRPerfWebBizException(SHRPerfWebBizException2.CANNOTFINDPERFRUL);
            }
            PerformanceRuleInfo perfRule = perfRuleColl.get(0);
            String perfRuleId = null;
            if (perfRule.getPariMutual() == null) {
                perfRuleId = perfRule.getScoreRate().getPerfScoreInfo().getId().toString();
                maxScore = perfRule.getScoreRate().getPerfScoreInfo().getMax();
            } else {
                perfRuleId = perfRule.getPariMutual().getId().toString();
                maxScore = perfRule.getPariMutual().getMax();
            }
            logger.error("\u3010perfweb\u3011ScoringFormula", (Object)targetInfo.getScoringFormula());
            ScoringFormulaInfo info = ScoringFormulaFactory.getLocalInstance(ctx).getScoringFormulaInfo((IObjectPK)new ObjectUuidPK(targetInfo.getScoringFormula()));
            int formulaType = info.getFormulaType().getValue();
            boolean bl = isPlatformula = formulaType == 4 || formulaType == 0;
            if (StringUtils.isNotEmpty((CharSequence)targetInfo.getActualCompleValue())) {
                achieveData = new BigDecimal(targetInfo.getActualCompleValue());
            } else if (!isPlatformula) continue;
            String rate = null;
            if (formulaType == 1) {
                if (achieveData == null) {
                    throw new SHRPerfWebBizException(SHRPerfWebBizException.TARGETVALUEREQUIERD);
                }
                if (info.getScorBasis().getValue() == 1) {
                    if (targetInfo.getTargetValue() == null) throw new SHRPerfWebBizException(SHRPerfWebBizException.TARGETVALUEREQUIERD);
                    BigDecimal targetData = new BigDecimal(targetInfo.getTargetValue());
                    rate = achieveData.divide(targetData, 4, 4).multiply(new BigDecimal("100")).toString();
                } else {
                    rate = achieveData.toString();
                }
                String maxScoreOrTarScore = "";
                if (perfRule.getScoringWay().getValue() == 0) {
                    maxScoreOrTarScore = maxScore.toString();
                } else {
                    maxScoreOrTarScore = targetInfo.getTarScore();
                    if (StringUtils.isEmpty((CharSequence)maxScoreOrTarScore)) {
                        throw new EASBizException(SHRPerfWebBizException2.TARGETVALCANNOTNULL);
                    }
                }
                String calresult = this.scoreFormularCalcaulate(ctx, targetInfo.getScoringFormula(), rate, perfRuleId, maxScoreOrTarScore);
                BigDecimal scoreRate = new BigDecimal(calresult);
                BigDecimal result = scoreRate.divide(new BigDecimal("100"));
                DecimalFormat df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.HALF_UP);
                targetInfo.setScore(df.format(result));
                coreBaseCollection.add((CoreBaseInfo)targetInfo);
                continue;
            }
            if (formulaType == 0) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("number", targetInfo.getNumber());
                param.put("name", targetInfo.getName());
                param.put("period", targetInfo.getPerfPeriod().getId().toString());
                param.put("evaObj", targetInfo.getEvaObj().getId().toString());
                param.put("achieveData", achieveData);
                param.put("targetData", targetInfo.getTargetValue());
                HashMap osfmap = (HashMap)OSFExecutor.executeOSF((Context)ctx, param, (String)info.getFormulaAPI());
                BigDecimal result = null;
                result = osfmap.get("result") != null ? new BigDecimal(osfmap.get("result").toString()) : new BigDecimal("0");
                DecimalFormat df = new DecimalFormat("#.##");
                df.setRoundingMode(RoundingMode.HALF_UP);
                targetInfo.setScore(df.format(result));
                coreBaseCollection.add((CoreBaseInfo)targetInfo);
                continue;
            }
            if (!isPlatformula) continue;
            try {
                String formulaId = info.getId().toString();
                HashMap<String, String> param = new HashMap<String, String>();
                String evaObj = targetInfo.getEvaObj().getId().toString();
                param.put("formulaId", formulaId);
                param.put("evaObj", evaObj);
                param.put("execIndicator", targetInfo.getId().toString());
                OSFAppUtil.callService((Context)ctx, (String)"platformCalculateService", param);
                continue;
            }
            catch (SecurityException e) {
                logger.error("SecurityException: ", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error("IllegalArgumentException: ", (Throwable)e);
            }
        }
        IndicatorTargetFactory.getLocalInstance(ctx).save(coreBaseCollection);
        this.realCacularSumResult(ctx, targetIds);
    }

    public void reviseRationScore(Context ctx, String indicatorId, String score) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("update T_EVA_IndicatorTarget set FScore = '" + score + "' where FID = '" + indicatorId + "'"));
        DbUtil.execute((Context)ctx, (String)("update T_EVA_GradeTargetInst set FTargetScore = '" + score + "' where FTarget = '" + indicatorId + "'"));
    }

    public void realCacularSumResult(Context ctx, Set targetids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sictor = new SelectorItemCollection();
        sictor.add(new SelectorItemInfo("*"));
        FilterInfo targetfilterInfo = new FilterInfo();
        targetfilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)targetids, CompareType.INCLUDE));
        view.setSelector(sictor);
        view.setFilter(targetfilterInfo);
        HashMap<String, String> map = new HashMap<String, String>();
        IndicatorTargetCollection coll = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(view);
        HashSet<String> hasScoreFormulas = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            IndicatorTargetInfo targetInfo = coll.get(i);
            String id = targetInfo.getId().toString();
            map.put(id, targetInfo.getScore());
            if (StringUtils.isEmpty((CharSequence)targetInfo.getScoringFormula())) continue;
            hasScoreFormulas.add(id);
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        sic.clear();
        sic.add(new SelectorItemInfo("gradeTaskNode.*"));
        sic.add(new SelectorItemInfo("gradeTaskNode.wfNode.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaObj.*"));
        filterInfo.getFilterItems().add(new FilterItemInfo("target", (Object)targetids, CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filterInfo);
        GradeTargetInstCollection gradeTaskInstCollection = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection(evi);
        GradeTaskNodeInstCollection gradeTaskNodeInstCollection = new GradeTaskNodeInstCollection();
        CoreBaseCollection coreBase = new CoreBaseCollection();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < gradeTaskInstCollection.size(); ++i) {
            GradeTargetInstInfo gradeTargetInstInfo = gradeTaskInstCollection.get(i);
            if (map.get(gradeTargetInstInfo.getTarget()) == null) {
                if (hasScoreFormulas.contains(gradeTargetInstInfo.getTarget())) {
                    gradeTargetInstInfo.put("targetScore", null);
                }
            } else {
                gradeTargetInstInfo.setTargetScore(Float.valueOf((String)map.get(gradeTargetInstInfo.getTarget())).floatValue());
            }
            gradeTaskNodeInstCollection.add(gradeTargetInstInfo.getGradeTaskNode());
            coreBase.add((CoreBaseInfo)gradeTargetInstInfo);
            set.add(gradeTargetInstInfo.getEvaObj().getId().toString());
        }
        GradeTargetInstFactory.getLocalInstance(ctx).save(coreBase);
        try {
            this.calcuAndSaveSumScore(ctx, gradeTaskNodeInstCollection);
            IPerfWorkFlowFacade facade = PerfWorkFlowFacadeFactory.getLocalInstance(ctx);
            for (String evaObj : set) {
                facade.calcEvaSumScore(evaObj, "", EndWayEnum.NOMALWAY, true);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new BOSException("calculate areaSumScore failed...");
        }
    }

    protected void reCalcuGrade(Context ctx, String evaObj) throws NumberFormatException, BOSException, EASBizException {
        PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        String perfPeriod = perfEvaObjectInfo.getPeriod().getId().toString();
        PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, perfPeriod);
        EvaResultSummaryInfo evaResultInfo = GetEntityInfoUtils.getEvaResultSummaryInfoByEvaObj(ctx, evaObj);
        if (evaResultInfo != null) {
            if (perfEvaObjectInfo.getWorkFlowStatus().getValue() == 4 || perfEvaObjectInfo.getWorkFlowStatus().getValue() == 5) {
                evaResultInfo.put("sumScore", null);
                evaResultInfo.setGradeLevel(null);
            } else {
                String ruleId = periodInfo.getPerfRule().getId().toString();
                if (evaResultInfo.get("sumscore") == null) {
                    evaResultInfo.setGradeLevel(null);
                } else {
                    String nodeGrade = PerfWorkFlowUtils.getLevelByPerfScore(ctx, ruleId, Float.valueOf(String.valueOf(evaResultInfo.getSumScore())).floatValue(), "1");
                    evaResultInfo.setGradeLevel(nodeGrade);
                    PerfWorkFlowUtils.setPerfscoreLevelForEvaresult(ctx, evaObj, evaResultInfo);
                }
            }
            EvaResultSummaryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(evaResultInfo.getId()), evaResultInfo);
        }
    }

    private boolean judgeNeedGradeLeve(Context ctx, String evaObj) throws NumberFormatException, BOSException, EASBizException {
        IGradeTaskNodeInst gradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("*");
        selector.add("wfNode.*");
        viewInfo.setFilter(filter);
        GradeTaskNodeInstCollection gradeTaskNodeInstCollection = gradeTaskNodeInst.getGradeTaskNodeInstCollection(viewInfo);
        if (gradeTaskNodeInstCollection == null || gradeTaskNodeInstCollection.size() == 0) {
            return false;
        }
        for (int i = 0; i < gradeTaskNodeInstCollection.size(); ++i) {
            String value = gradeTaskNodeInstCollection.get(i).getWfNode().getPerfGradeEvaluate().getValue();
            if (value == null || !"1".equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void calcuAndSaveSumScore(Context ctx, GradeTaskNodeInstCollection gradeTaskNodeColl) throws Exception {
        GradeTaskNodeInstInfo info;
        PerfEvaObjectInfo evaObj;
        CoreBaseCollection coreBase = new CoreBaseCollection();
        ArrayList<GradeTaskNodeInstInfo> sumSoreBase = new ArrayList<GradeTaskNodeInstInfo>();
        PerfWorkFlowFacadeControllerBean bean = new PerfWorkFlowFacadeControllerBean();
        int gtnSize = gradeTaskNodeColl.size();
        HashSet<String> gtnIdSet = new HashSet<String>(16);
        for (int m = 0; m < gtnSize; ++m) {
            gtnIdSet.add(gradeTaskNodeColl.get(m).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNodeInst", gtnIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNodeInst.wfNode.needScore", (Object)"3", CompareType.NOTEQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("*");
        selector.add("gradeTaskNodeInst.id");
        selector.add("gradeTaskNodeInst.wfNode.needScore");
        viewInfo.setFilter(filter);
        WholeCommentCollection wholeCommentColl = WholeCommentFactory.getLocalInstance(ctx).getWholeCommentCollection(viewInfo);
        HashMap<String, String> nodeScoreMap = new HashMap<String, String>(16);
        HashMap<String, String> nodeGradeMap = new HashMap<String, String>(16);
        String number = "Perf001";
        if (gradeTaskNodeColl != null && gradeTaskNodeColl.size() > 0 && (evaObj = (info = gradeTaskNodeColl.get(0)).getEvaObj()) != null && evaObj.getIsOrg() != null && YesOrNoEnum.YES.equals((Object)evaObj.getIsOrg())) {
            number = "Perf501";
        }
        String isManualJudgeGrade = PerfConfigUtils.getConfigByNumber(ctx, number);
        for (int i = 0; i < gtnSize; ++i) {
            GradeTaskNodeInstInfo info2 = gradeTaskNodeColl.get(i);
            IsNeedScoreEnum needScore = info2.getWfNode().getNeedScore();
            if (IsNeedScoreEnum.EVALUSUMSCORE.equals((Object)needScore)) {
                sumSoreBase.add(info2);
                continue;
            }
            HashMap<String, String> reult = bean.reCalcNodeSumScore(ctx, info2.getId().toString(), info2.getEvaObj().getId().toString());
            if (!StringUtils.isEmpty((CharSequence)reult.get("sumScore"))) {
                info2.setNodeSumScore(Float.valueOf(reult.get("sumScore")).floatValue());
            } else if (!IsNeedScoreEnum.CANNOT.equals((Object)needScore)) {
                info2.put("nodeSumScore", null);
                info2.put("nodeGrade", null);
            }
            coreBase.add((CoreBaseInfo)info2);
            nodeScoreMap.put(info2.getId().toString(), reult.get("sumScore"));
            if (!"0".equals(isManualJudgeGrade) && !"2".equals(isManualJudgeGrade)) continue;
            if (!StringUtils.isEmpty((CharSequence)reult.get("sumScore"))) {
                String nodeGrade = EvaFormUtil.getNodeGradeByScore(ctx, info2.getId().toString(), reult.get("sumScore"));
                if (!StringUtils.isNotEmpty((CharSequence)nodeGrade)) continue;
                nodeGradeMap.put(info2.getId().toString(), nodeGrade);
                info2.setNodeGrade(nodeGrade);
                continue;
            }
            if (IsNeedScoreEnum.CANNOT.equals((Object)needScore)) continue;
            nodeGradeMap.put(info2.getId().toString(), null);
            info2.put("nodeSumScore", null);
            info2.put("nodeGrade", null);
        }
        GradeTaskNodeInstFactory.getLocalInstance(ctx).save(coreBase);
        int wholeCommentSize = wholeCommentColl.size();
        CoreBaseCollection wholeCommentBaseColl = new CoreBaseCollection();
        for (int j = 0; j < wholeCommentSize; ++j) {
            WholeCommentInfo wholeCommentInfo = wholeCommentColl.get(j);
            GradeTaskNodeInstInfo info3 = wholeCommentInfo.getGradeTaskNodeInst();
            IsNeedScoreEnum needScore = info3.getWfNode().getNeedScore();
            wholeCommentInfo.put("score", nodeScoreMap.get(wholeCommentInfo.getGradeTaskNodeInst().getId().toString()));
            if (("0".equals(isManualJudgeGrade) || "2".equals(isManualJudgeGrade)) && !IsNeedScoreEnum.CANNOT.equals((Object)needScore)) {
                wholeCommentInfo.put("grade", nodeGradeMap.get(wholeCommentInfo.getGradeTaskNodeInst().getId().toString()));
            }
            wholeCommentBaseColl.add((CoreBaseInfo)wholeCommentInfo);
        }
        WholeCommentFactory.getLocalInstance(ctx).updateBatchData(wholeCommentBaseColl);
        if (sumSoreBase.size() > 0) {
            HashSet<String> ids = new HashSet<String>();
            ArrayList<PerfScoreBatchSaveBean> scoreList = new ArrayList<PerfScoreBatchSaveBean>();
            for (GradeTaskNodeInstInfo info4 : sumSoreBase) {
                String id = info4.getString("id");
                ids.add(id);
            }
            String inSql = " ('" + Strings.join((String[])ids.toArray(new String[ids.size()]), (String)"','") + "') ";
            WholeCommentCollection tmpWholeCommentCollection = WholeCommentFactory.getLocalInstance(ctx).getWholeCommentCollection(" select *,gradeTaskNodeInst.* where gradeTaskNodeInst.id in " + inSql);
            for (int ii = 0; ii < tmpWholeCommentCollection.size(); ++ii) {
                WholeCommentInfo wholeCommentInfo = tmpWholeCommentCollection.get(ii);
                GradeTaskNodeInstInfo gradeTaskNodeInst = wholeCommentInfo.getGradeTaskNodeInst();
                String id = gradeTaskNodeInst.getId().toString();
                String sumScore = gradeTaskNodeInst.getNodeSumScore() + "";
                String grade = gradeTaskNodeInst.getNodeGrade();
                String wholeComment = wholeCommentInfo.getString("comment");
                PerfScoreBatchSaveBean batchSaveBean = new PerfScoreBatchSaveBean();
                batchSaveBean.setNodeSumScore(sumScore);
                batchSaveBean.setNodeGrade(grade);
                batchSaveBean.setWholeComment(wholeComment);
                batchSaveBean.setGradeTaskNodeInstID(id);
                batchSaveBean.setIgnoreStatus(true);
                scoreList.add(batchSaveBean);
            }
            if (scoreList.size() > 0) {
                Set set;
                Object o4;
                Set set2;
                Object o3_;
                Set set3;
                Object o3;
                Set set4;
                Object o2;
                Set set5;
                IPerfWorkFlowFacade iPerfWorkFlowFacade = PerfWorkFlowFacadeFactory.getLocalInstance(ctx);
                Map saveResult = iPerfWorkFlowFacade.saveNodeSumScoreAndGrade(scoreList);
                Object o1 = saveResult.get(ServerResponseConst.FAILED);
                if (o1 != null && (set5 = (Set)o1).size() > 0) {
                    logger.error(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ALLHASSCOREFORMULAR, ctx));
                }
                if ((o2 = saveResult.get("400")) != null && (set4 = (Set)o2).size() > 0) {
                    logger.error(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERSUMRANGE, ctx));
                }
                if ((o3 = saveResult.get("999")) != null && (set3 = (Set)o3).size() > 0) {
                    logger.error(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LESSTHANQUANTITYS, ctx));
                }
                if ((o3_ = saveResult.get("LESSLOWLIMIT")) != null && (set2 = (Set)o3_).size() > 0) {
                    logger.error(new SHRPerfWebBizException(SHRPerfWebBizException.SCOREOVERMIN2).getMessage());
                }
                if ((o4 = saveResult.get(ServerResponseConst.INVALID)) != null && (set = (Set)o4).size() > 0) {
                    logger.error(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHANGEHANDLER, ctx));
                }
            }
        }
    }
}

