/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.comprehensive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.comprehensive.AbstractPerfScoreConvertFacadeControllerBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfScoreConvertFacadeControllerBean
extends AbstractPerfScoreConvertFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.comprehensive.PerfScoreConvertFacadeControllerBean");

    @Override
    protected double _convertScore(Context ctx, double beforeScore, BigDecimal beforeMin, BigDecimal beforeMax, BigDecimal afterMin, BigDecimal afterMax) throws BOSException, EASBizException {
        if (beforeMin == null || beforeMax == null || afterMin == null || afterMax == null) {
            if (logger.isDebugEnabled()) {
                logger.error("current perfScoreInfo is null");
            }
            throw new BOSException("convertScore error! current perfScoreInfo is null");
        }
        if (beforeMax.compareTo(afterMax) == 0) {
            return beforeScore;
        }
        BigDecimal score = new BigDecimal(String.valueOf(beforeScore));
        BigDecimal sourceRangeMax = beforeMax.subtract(beforeMin);
        BigDecimal zeroToMax = afterMax.subtract(afterMin);
        score = score.subtract(beforeMin.subtract(BigDecimal.ZERO));
        BigDecimal tempScore = score.multiply(zeroToMax.divide(sourceRangeMax, 2, RoundingMode.HALF_UP));
        return tempScore.add(afterMin.subtract(BigDecimal.ZERO)).doubleValue();
    }
}

