/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.comprehensive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.StatusEnum;
import com.kingdee.shr.perfweb.app.comprehensive.AbstractPerfSummaryRuleControllerBean;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndItemMidInfo;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndScoreFormulaMidCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndScoreFormulaMidFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleAndScoreFormulaMidInfo;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleCollection;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfSummaryRuleUtils;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.BusinessRelationConfigCollection;
import com.kingdee.shr.validaterule.BusinessRelationConfigFactory;
import com.kingdee.shr.validaterule.BusinessRelationConfigInfo;
import com.kingdee.util.LocaleUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class PerfSummaryRuleControllerBean
extends AbstractPerfSummaryRuleControllerBean {
    private final Logger logger = Logger.getLogger((String)"com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryRuleControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        String dataStatus = PerfSummaryRuleUtils.checkSingleDataStatus(ctx, id, "1");
        Set<String> noScoreFormulaIds = PerfSummaryRuleUtils.checkIsHaveScoreFormula(ctx, new HashSet<String>(Collections.singletonList(id)));
        if (!"200".equals(dataStatus)) {
            throw new BOSException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEENABLEERRASENABLED, ctx));
        }
        if (!CollectionUtils.isEmpty(noScoreFormulaIds)) {
            throw new BOSException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NOSCOREFORMULA, ctx));
        }
        PerfSummaryRuleCollection perfSummaryRuleCollection = this.getPerfSummaryRuleCollection(ctx, "where id = '" + id + "'");
        if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
            PerfSummaryRuleInfo perfSummaryRuleInfo = perfSummaryRuleCollection.get(0);
            perfSummaryRuleInfo.setStatus(StatusEnum.ENABLED);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(perfSummaryRuleInfo.getId()), perfSummaryRuleInfo);
        }
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        String checkResult = PerfSummaryRuleUtils.checkSingleDataStatus(ctx, id, "2");
        if ("200".equals(checkResult)) {
            PerfSummaryRuleCollection perfSummaryRuleCollection = this.getPerfSummaryRuleCollection(ctx, "where id = '" + id + "'");
            if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
                PerfSummaryRuleInfo perfSummaryRuleInfo = perfSummaryRuleCollection.get(0);
                perfSummaryRuleInfo.setStatus(StatusEnum.FORBID);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(perfSummaryRuleInfo.getId()), perfSummaryRuleInfo);
            }
        } else {
            if ("forbided".equals(checkResult)) {
                throw new BOSException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEDISABLEERRASDISABLED, ctx));
            }
            if ("disabled".equals(checkResult)) {
                throw new BOSException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFRULEDISABLEERRASUNENABLE, ctx));
            }
        }
    }

    @Override
    protected void _copySummaryRule(Context ctx, String summaryRuleId) throws BOSException {
        try {
            BusinessRelationConfigCollection businessRelationConfigCollection;
            PerfSummaryRuleAndScoreFormulaMidCollection oldScoreFormulaMidCollection;
            PerfSummaryRuleInfo perfSummaryRuleInfo = this.getPerfSummaryRuleInfo(ctx, "where id = '" + summaryRuleId + "'");
            String copyNumber = perfSummaryRuleInfo.getNumber() + "_copy";
            String copyNameL1 = perfSummaryRuleInfo.getName(LocaleUtils.locale_L1) + "_copy";
            String copyNameL2 = perfSummaryRuleInfo.getName(LocaleUtils.locale_L2) + "_copy";
            String copyNameL3 = perfSummaryRuleInfo.getName(LocaleUtils.locale_L3) + "_copy";
            PerfSummaryRuleCollection perfSummaryRuleCollection = this.getPerfSummaryRuleCollection(ctx, "where number like '" + copyNumber + "%' order by number");
            if (perfSummaryRuleCollection != null && perfSummaryRuleCollection.size() > 0) {
                PerfSummaryRuleInfo summaryRuleInfo;
                for (int i = 0; i < perfSummaryRuleCollection.size() && (summaryRuleInfo = perfSummaryRuleCollection.get(i)).getNumber().equals(copyNumber); ++i) {
                    copyNumber = copyNumber + "(1)";
                    copyNameL1 = copyNameL1 + "(1)";
                    copyNameL2 = copyNameL2 + "(1)";
                    copyNameL3 = copyNameL3 + "(1)";
                }
            }
            perfSummaryRuleInfo.setId(BOSUuid.create((String)"570B3130"));
            perfSummaryRuleInfo.setName(copyNameL1, LocaleUtils.locale_L1);
            perfSummaryRuleInfo.setName(copyNameL2, LocaleUtils.locale_L2);
            perfSummaryRuleInfo.setName(copyNameL3, LocaleUtils.locale_L3);
            perfSummaryRuleInfo.setNumber(copyNumber);
            perfSummaryRuleInfo.setStatus(StatusEnum.DISABLED);
            PerfSummaryRuleAndItemMidCollection itemMidCollection = PerfSummaryRuleAndItemMidFactory.getLocalInstance(ctx).getPerfSummaryRuleAndItemMidCollection("where summaryRule = '" + summaryRuleId + "'");
            if (itemMidCollection != null && itemMidCollection.size() > 0) {
                for (int i = 0; i < itemMidCollection.size(); ++i) {
                    PerfSummaryRuleAndItemMidInfo itemMidInfo = itemMidCollection.get(i);
                    itemMidInfo.setId(null);
                    itemMidInfo.setSummaryRule(perfSummaryRuleInfo);
                }
                perfSummaryRuleInfo.put("summaryItemMidTab", (Object)itemMidCollection);
            }
            if ((oldScoreFormulaMidCollection = PerfSummaryRuleAndScoreFormulaMidFactory.getLocalInstance(ctx).getPerfSummaryRuleAndScoreFormulaMidCollection("select *, scoreFormula.* where summaryRule = '" + summaryRuleId + "'")) != null && oldScoreFormulaMidCollection.size() > 0 && (businessRelationConfigCollection = BusinessRelationConfigFactory.getLocalInstance((Context)ctx).getBusinessRelationConfigCollection("where businessId = '" + summaryRuleId + "'")) != null && businessRelationConfigCollection.size() > 0) {
                BusinessRelationConfigInfo businessRelationConfigInfo = businessRelationConfigCollection.get(0);
                businessRelationConfigInfo.setBusinessId(perfSummaryRuleInfo.getId());
                BOSUuid businessRelationConfigId = BOSUuid.create((String)"D08A6560");
                businessRelationConfigInfo.setId(businessRelationConfigId);
                CoreBaseCollection scoreFormulaCollection = new CoreBaseCollection();
                CoreBaseCollection newScoreFormulaMidCollection = new CoreBaseCollection();
                for (int i = 0; i < oldScoreFormulaMidCollection.size(); ++i) {
                    PerfSummaryRuleAndScoreFormulaMidInfo scoreFormulaMidInfo = oldScoreFormulaMidCollection.get(i);
                    BaseFormulaInfo scoreFormula = scoreFormulaMidInfo.getScoreFormula();
                    BOSUuid scoreId = BOSUuid.create((String)"19803973");
                    scoreFormula.setId(scoreId);
                    scoreFormula.put("businessRelationConfig", (Object)businessRelationConfigId);
                    scoreFormula.setCreateTime(null);
                    scoreFormula.setCreator(null);
                    scoreFormula.setLastUpdateTime(null);
                    scoreFormula.setLastUpdateUser(null);
                    scoreFormulaCollection.add((CoreBaseInfo)scoreFormula);
                    scoreFormulaMidInfo.put("scoreFormula", scoreId);
                    scoreFormulaMidInfo.setId(null);
                    scoreFormulaMidInfo.setSummaryRule(perfSummaryRuleInfo);
                    scoreFormulaMidInfo.setCreateTime(null);
                    scoreFormulaMidInfo.setCreator(null);
                    scoreFormulaMidInfo.setLastUpdateTime(null);
                    scoreFormulaMidInfo.setLastUpdateUser(null);
                    newScoreFormulaMidCollection.add((CoreBaseInfo)scoreFormulaMidInfo);
                }
                if (scoreFormulaCollection.size() > 0) {
                    businessRelationConfigInfo.put("formulas", (Object)scoreFormulaCollection);
                    BusinessRelationConfigFactory.getLocalInstance((Context)ctx).addnew(businessRelationConfigInfo);
                    BaseFormulaFactory.getLocalInstance((Context)ctx).addnew(scoreFormulaCollection);
                    PerfSummaryRuleAndScoreFormulaMidFactory.getLocalInstance(ctx).addnew(newScoreFormulaMidCollection);
                }
                perfSummaryRuleInfo.put("scoreFormulaMidTab", null);
            }
            perfSummaryRuleInfo.setCreator(null);
            perfSummaryRuleInfo.setCreateTime(null);
            perfSummaryRuleInfo.setLastUpdateUser(null);
            perfSummaryRuleInfo.setLastUpdateTime(null);
            this.addnew(ctx, perfSummaryRuleInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)"PerfSummaryRuleControllerBean._copySummaryRule error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _batchEnable(Context ctx, Set summaryRuleIds) throws BOSException, EASBizException {
        if (!CollectionUtils.isEmpty((Collection)summaryRuleIds)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo updFilter = new FilterInfo();
            updFilter.getFilterItems().add(new FilterItemInfo("id", (Object)summaryRuleIds, CompareType.INCLUDE));
            viewInfo.setFilter(updFilter);
            PerfSummaryRuleCollection summaryRuleCollection = this.getPerfSummaryRuleCollection(ctx, viewInfo);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < summaryRuleCollection.size(); ++i) {
                PerfSummaryRuleInfo perfSummaryRuleInfo = summaryRuleCollection.get(i);
                perfSummaryRuleInfo.setStatus(StatusEnum.ENABLED);
                coreBaseCollection.add((CoreBaseInfo)perfSummaryRuleInfo);
            }
            this.update(ctx, coreBaseCollection);
        }
    }

    @Override
    protected void _batchDisable(Context ctx, Set summaryRuleIds) throws BOSException, EASBizException {
        if (!CollectionUtils.isEmpty((Collection)summaryRuleIds)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo updFilter = new FilterInfo();
            updFilter.getFilterItems().add(new FilterItemInfo("id", (Object)summaryRuleIds, CompareType.INCLUDE));
            viewInfo.setFilter(updFilter);
            PerfSummaryRuleCollection summaryRuleCollection = this.getPerfSummaryRuleCollection(ctx, viewInfo);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < summaryRuleCollection.size(); ++i) {
                PerfSummaryRuleInfo perfSummaryRuleInfo = summaryRuleCollection.get(i);
                perfSummaryRuleInfo.setStatus(StatusEnum.FORBID);
                coreBaseCollection.add((CoreBaseInfo)perfSummaryRuleInfo);
            }
            this.update(ctx, coreBaseCollection);
        }
    }
}

