/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.data;

import com.kingdee.shr.perfweb.formulaplatform.data.ColumnAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class DataColumn
implements Serializable {
    private static final long serialVersionUID = -8161070861896390136L;
    public ArrayList columns = null;

    protected ColumnAttributes newColumn(String name, int type, Object defaultvalue) {
        ColumnAttributes column = new ColumnAttributes();
        column.setName(name);
        column.setType(type);
        column.setDefaultValue(defaultvalue);
        return column;
    }

    protected void addColumn(ColumnAttributes column) {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        this.columns.add(column);
    }

    protected void deleteColumn(String name) {
        int index = this.getColumnsIndex(name);
        this.deleteColumn(index);
    }

    protected void deleteColumn(int index) {
        if (!this.testArray(this.columns, index)) {
            throw new RuntimeException("index out of range");
        }
        this.columns.remove(index);
    }

    protected boolean testArray(ArrayList list, int index) {
        if (list == null) {
            return false;
        }
        return index >= 0 && index < list.size();
    }

    public int columnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    public ColumnAttributes getColumns(int index) {
        if (!this.testArray(this.columns, index)) {
            throw new RuntimeException("index out of range");
        }
        return (ColumnAttributes)this.columns.get(index);
    }

    public ColumnAttributes getColumns(String name) {
        return (ColumnAttributes)this.columns.get(this.getColumnsIndex(name));
    }

    public int getColumnsIndex(String name) {
        if (this.columns == null) {
            throw new RuntimeException("No matching columns");
        }
        int index = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            String temName = ((ColumnAttributes)this.columns.get(i)).getName().toUpperCase(Locale.ENGLISH);
            if (name.length() > 200) {
                name = name.substring(0, 200);
            }
            if (temName.length() > 200) {
                temName = temName.substring(0, 200);
            }
            if (!temName.equalsIgnoreCase(name) && !("SUM(" + name.toUpperCase(Locale.ENGLISH) + ")").contains(temName)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new RuntimeException("No matching columns");
        }
        return index;
    }

    public boolean containColumn(String name) {
        if (this.columns == null) {
            throw new RuntimeException("No matching columns");
        }
        int index = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!((ColumnAttributes)this.columns.get(i)).getName().equalsIgnoreCase(name)) continue;
            index = i;
            break;
        }
        return index != -1;
    }

    public int colIndexOf(String name) {
        int index = -1;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (!((ColumnAttributes)this.columns.get(i)).getName().toUpperCase(Locale.ENGLISH).equals(name.toUpperCase(Locale.ENGLISH))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public ColumnAttributes[] getAllColumns() {
        if (this.columns == null) {
            return null;
        }
        ColumnAttributes[] attr = new ColumnAttributes[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            attr[i] = (ColumnAttributes)this.columns.get(i);
        }
        return attr;
    }
}

