/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.shr.base.syssetting.json.adapter.BOSUuidTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.DateTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.EnumTypeAdapter;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractIndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaFormFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IRecordFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.enums.Enum;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEvaTargetService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetEvaTargetService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String evaObjId = (String)param.get("evaObjId");
        ArrayList result = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)evaObjId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resultFlag", "failure");
            map.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PARAMREQUIRED, ctx));
            return result.add(map);
        }
        List<Map<String, Object>> list = this.getEvaluTargetList(ctx, evaObjId);
        return list;
    }

    private List<Map<String, Object>> getEvaluTargetList(Context ctx, String evaObjId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("areaBase.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj.id", (Object)evaObjId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("areaBase.seq"));
        sorter.add(new SorterItemInfo("createTime"));
        IndicatorTargetCollection indeColl = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(viewInfo);
        RecordTargetCollection recordColl = RecordTargetFactory.getLocalInstance(ctx).getRecordTargetCollection(viewInfo);
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (indeColl.size() == 0 && recordColl.size() == 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resultFlag", "failure");
            map.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TARGETNOTFOUND, ctx));
            result.add(map);
            return result;
        }
        HashSet<String> scoringFormulaIds = new HashSet<String>();
        for (int i = 0; i < indeColl.size(); ++i) {
            IndicatorTargetInfo info = indeColl.get(i);
            scoringFormulaIds.add(info.getScoringFormula());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", scoringFormulaIds, CompareType.INCLUDE));
        SelectorItemCollection selectorItemColls = new SelectorItemCollection();
        selectorItemColls.add(new SelectorItemInfo("id"));
        selectorItemColls.add(new SelectorItemInfo("name"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemColls);
        ScoringFormulaCollection scoringFormulaColls = ScoringFormulaFactory.getLocalInstance(ctx).getScoringFormulaCollection(evi);
        if (!scoringFormulaColls.isEmpty()) {
            Serializable info;
            int i;
            HashMap<String, String> scoringFormulaMap = new HashMap<String, String>();
            for (i = 0; i < scoringFormulaColls.size(); ++i) {
                info = scoringFormulaColls.get(i);
                scoringFormulaMap.put(info.getId().toString(), info.getName());
            }
            for (i = 0; i < indeColl.size(); ++i) {
                info = indeColl.get(i);
                ((AbstractIndicatorTargetInfo)info).setScoringFormula((String)scoringFormulaMap.get(((AbstractIndicatorTargetInfo)info).getScoringFormula()));
            }
        }
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObjId);
        result = this.sort(ctx, indeColl, recordColl, ruleInfo);
        return result;
    }

    private List<Map<String, Object>> sort(Context ctx, IndicatorTargetCollection indeColl, RecordTargetCollection recordColl, PerformanceRuleInfo ruleInfo) {
        HashMap<String, Object> infoValue;
        int k;
        EvaAreaListBean evaBean;
        int m;
        ArrayList<EvaAreaListBean> evaList;
        PersonalEvaBaseBean bean;
        Map<String, Object> indecatorsMap;
        IndicatorExtendHelperInfo extendHelperInfo;
        String ereaBase;
        ObjectBaseInfo info;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, ArrayList<AreaFieldBean>> fieldMap = new HashMap<String, ArrayList<AreaFieldBean>>();
        ArrayList<ObjectBaseInfo> list = new ArrayList<ObjectBaseInfo>();
        HashMap map = new HashMap();
        int scoreWay = ruleInfo.getScoringWay().getValue();
        for (int i = 0; i < indeColl.size(); ++i) {
            List<ObjectBaseInfo> indeList;
            info = indeColl.get(i);
            ereaBase = info.getAreaBase().getId().toString();
            if (null != info.getExtend() && null != info.getExtend().getId()) {
                try {
                    extendHelperInfo = IndicatorExtendHelperFactory.getLocalInstance(ctx).getIndicatorExtendHelperInfo("where id='" + info.getExtend().getId().toString() + "'");
                    info.setExtend(extendHelperInfo);
                }
                catch (Exception e) {
                    logger.error("\u3010PERFWEB\u3011-GetEvaTargetService\uff0cset indicatorTarget extendHelperInfo error...", (Throwable)e);
                }
            }
            try {
                indecatorsMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, info.getEvaObj().getId().toString(), null, "0", null, null, null);
                bean = (PersonalEvaBaseBean)indecatorsMap.get("rows");
                evaList = bean.getEvaAreaList();
                for (m = 0; m < evaList.size(); ++m) {
                    evaBean = (EvaAreaListBean)evaList.get(m);
                    if (!evaBean.getAreaId().equals(ereaBase)) continue;
                    fieldMap.put(ereaBase, evaBean.getFieldList());
                    for (k = 0; k < evaBean.getEvaIndicatorList().size(); ++k) {
                        infoValue = evaBean.getEvaIndicatorList().get(k);
                        if (!infoValue.get("FID").toString().equals(info.getId().toString())) continue;
                        info.put("dataValue", infoValue);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            if (map.get(ereaBase) == null) {
                indeList = new ArrayList<ObjectBaseInfo>();
                indeList.add(info);
                map.put(ereaBase, indeList);
            } else {
                indeList = (List)map.get(ereaBase);
                indeList.add(info);
            }
            list.add(indeColl.get(i));
        }
        for (int j = 0; j < recordColl.size(); ++j) {
            List<ObjectBaseInfo> recordList;
            info = recordColl.get(j);
            ereaBase = info.getAreaBase().getId().toString();
            try {
                extendHelperInfo = IndicatorExtendHelperFactory.getLocalInstance(ctx).getIndicatorExtendHelperInfo("where id='" + info.getExtend().getId().toString() + "'");
                info.setExtend(extendHelperInfo);
            }
            catch (Exception e) {
                logger.error("\u3010PERFWEB\u3011-GetEvaTargetService\uff0cset recordTarget extendHelperInfo error...", (Throwable)e);
            }
            try {
                indecatorsMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, info.getEvaObj().getId().toString(), null, "0", null, null, null);
                bean = (PersonalEvaBaseBean)indecatorsMap.get("rows");
                evaList = bean.getEvaAreaList();
                for (m = 0; m < evaList.size(); ++m) {
                    evaBean = (EvaAreaListBean)evaList.get(m);
                    if (!evaBean.getAreaId().equals(ereaBase)) continue;
                    fieldMap.put(ereaBase, evaBean.getFieldList());
                    for (k = 0; k < evaBean.getEvaRecordList().size(); ++k) {
                        infoValue = evaBean.getEvaRecordList().get(k);
                        if (!infoValue.get("FID").toString().equals(info.getId().toString())) continue;
                        info.put("dataValue", infoValue);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            if (map.get(ereaBase) == null) {
                recordList = new ArrayList<ObjectBaseInfo>();
                recordList.add(info);
                map.put(ereaBase, recordList);
            } else {
                recordList = (List)map.get(ereaBase);
                recordList.add(info);
            }
            list.add(recordColl.get(j));
        }
        Collections.sort(list, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IndicatorTargetInfo) {
                    o1 = (IndicatorTargetInfo)o1;
                    if (o2 instanceof IndicatorTargetInfo) {
                        o2 = (IndicatorTargetInfo)o2;
                        return ((IndicatorTargetInfo)o1).getAreaBase().getSeq() - ((IndicatorTargetInfo)o2).getAreaBase().getSeq();
                    }
                    o2 = (RecordTargetInfo)o2;
                    return ((IndicatorTargetInfo)o1).getAreaBase().getSeq() - ((RecordTargetInfo)o2).getAreaBase().getSeq();
                }
                o1 = (RecordTargetInfo)o1;
                if (o2 instanceof IndicatorTargetInfo) {
                    o2 = (IndicatorTargetInfo)o2;
                    return ((RecordTargetInfo)o1).getAreaBase().getSeq() - ((IndicatorTargetInfo)o2).getAreaBase().getSeq();
                }
                o2 = (RecordTargetInfo)o2;
                return ((RecordTargetInfo)o1).getAreaBase().getSeq() - ((RecordTargetInfo)o2).getAreaBase().getSeq();
            }
        });
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            String AreaName;
            HashMap<String, Object> map1;
            String areaBaseId;
            Object info2 = list.get(i);
            if (info2 instanceof IndicatorTargetInfo) {
                IndicatorTargetInfo indeInfo = (IndicatorTargetInfo)info2;
                areaBaseId = indeInfo.getAreaBase().getId().toString();
                if (set.contains(areaBaseId)) continue;
                set.add(areaBaseId);
                map1 = new HashMap<String, Object>();
                AreaName = indeInfo.getAreaBase().getName();
                map1.put("Area", AreaName);
                map1.put("scoreWay", scoreWay);
                map1.put("EvaFormFieldConf", this.setEvaFormFieldConfMap(ctx, areaBaseId));
                map1.put("fieldList", fieldMap.get(indeInfo.getAreaBase().getId().toString()));
                map1.put("data", map.get(areaBaseId));
                map1.put("weightControl", indeInfo.getAreaBase().getWeightControl().getValue());
                map1.put("areaControlWeight", indeInfo.getAreaBase().getAreaWeight());
                map1.put("sumScoreRule", indeInfo.getAreaBase().getSumScoreRule().getValue());
                result.add(map1);
                continue;
            }
            RecordTargetInfo recordInfo = (RecordTargetInfo)info2;
            areaBaseId = recordInfo.getAreaBase().getId().toString();
            if (set.contains(areaBaseId)) continue;
            set.add(areaBaseId);
            map1 = new HashMap();
            AreaName = recordInfo.getAreaBase().getName();
            map1.put("Area", AreaName);
            map1.put("scoreWay", scoreWay);
            map1.put("fieldList", fieldMap.get(recordInfo.getAreaBase().getId().toString()));
            map1.put("EvaFormFieldConf", this.setRecordFieldConfMap(ctx, areaBaseId));
            map1.put("data", map.get(recordInfo.getAreaBase().getId().toString()));
            map1.put("weightControl", recordInfo.getAreaBase().getWeightControl().getValue());
            map1.put("areaControlWeight", recordInfo.getAreaBase().getAreaWeight());
            map1.put("sumScoreRule", recordInfo.getAreaBase().getSumScoreRule().getValue());
            result.add(map1);
        }
        return result;
    }

    protected Map<String, String> setEvaFormFieldConfMap(Context ctx, String areaBaseId) {
        IEvaFormFieldConf iEvaFormFieldConf = null;
        HashMap<String, String> evaFieldConfMap = new HashMap<String, String>();
        try {
            iEvaFormFieldConf = EvaFormFieldConfFactory.getLocalInstance(ctx);
            EvaFormFieldConfCollection evaFormFieldConfColl = iEvaFormFieldConf.getEvaFormFieldConfCollection(" where areaBase='" + areaBaseId + "'");
            if (null != evaFormFieldConfColl && evaFormFieldConfColl.size() > 0) {
                int fieldConfSize = evaFormFieldConfColl.size();
                for (int j = 0; j < fieldConfSize; ++j) {
                    EvaFormFieldConfInfo fieldInfo = evaFormFieldConfColl.get(j);
                    evaFieldConfMap.put(fieldInfo.getColName().toLowerCase().replaceFirst("f", ""), fieldInfo.getShowName());
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return evaFieldConfMap;
    }

    protected Map<String, String> setRecordFieldConfMap(Context ctx, String areaBaseId) {
        IRecordFieldConf iRecordFieldConf = null;
        HashMap<String, String> evaFieldConfMap = new HashMap<String, String>();
        try {
            iRecordFieldConf = RecordFieldConfFactory.getLocalInstance(ctx);
            RecordFieldConfCollection recordFieldConfColl = iRecordFieldConf.getRecordFieldConfCollection(" where areaBase='" + areaBaseId + "'");
            if (null != recordFieldConfColl && recordFieldConfColl.size() > 0) {
                int fieldConfSize = recordFieldConfColl.size();
                for (int j = 0; j < fieldConfSize; ++j) {
                    RecordFieldConfInfo fieldInfo = recordFieldConfColl.get(j);
                    evaFieldConfMap.put(fieldInfo.getColName().toLowerCase().replaceFirst("f", ""), fieldInfo.getShowName());
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return evaFieldConfMap;
    }

    private static List<Map<String, Object>> formatData(Context ctx, Object indictor) {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new MyExclusionStrategy());
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumTypeAdapter());
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter());
        Gson gson = builder.create();
        List lists = (List)gson.fromJson(gson.toJson(indictor), Object.class);
        for (Map items : lists) {
            Map values = (Map)items.get("values");
            items.clear();
            items.putAll(values);
        }
        return lists;
    }

    static class MyExclusionStrategy
    implements ExclusionStrategy {
        MyExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz.getName().contains("PerfGoalsObject") | clazz.getName().contains("PerfEvaTargetBackReason") | clazz.getName().contains("OrgRange");
        }
    }
}

