/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetConfirmBackReasonCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetConfirmBackReasonFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetConfirmBackReasonInfo;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GetGoalsTransmitListService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetGoalsTransmitListService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        int page = 0;
        int rows = 0;
        if (param.get("page") != null) {
            page = Integer.valueOf((String)param.get("page"));
        }
        if (param.get("rows") != null) {
            rows = Integer.valueOf((String)param.get("rows"));
        }
        IObjectPK userId = ctx.getCaller();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
        String oql = "where receiver = '" + user.getPerson().getId().toString() + "'and HandleStatus='" + "1" + "' and MsgType='" + "0" + "' and IsSelf=" + 0;
        GoalsMessageReceiverCollection coll = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection(oql);
        HashSet<String> receiverSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getEvaObj() == null) continue;
            receiverSet.add(coll.get(i).getEvaObj().getId().toString());
        }
        Map perfColl = this.getEvaObjectList(ctx, receiverSet, page, rows, param);
        return perfColl;
    }

    private Map getEvaObjectList(Context ctx, Set receiverSet, int page, int rows, Map param) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        param.put("isOrg", "0");
        EntityViewInfo viewInfo = this.getEntityView(ctx, receiverSet, param);
        IPerfEvaObject bizInterface = PerfEvaObjectFactory.getLocalInstance(ctx);
        int totalCount = bizInterface.getCount(viewInfo);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List perfColl = bizInterface.getPagingList(viewInfo, (page - 1) * rows, length);
        HashSet<String> evaObjIds = new HashSet<String>();
        for (int i = 0; i < perfColl.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            PerfEvaObjectInfo info = (PerfEvaObjectInfo)perfColl.get(i);
            String positionName = info.getPerfFile().getPosition().getName();
            String personId = info.getPerson().getId().toString();
            map.put("name", info.getName());
            map.put("number", info.getNumber());
            map.put("position", positionName);
            map.put("person", personId);
            evaObjIds.add(info.getId().toString());
            map.put("id", info.getId().toString());
            map.put("date", info.getPeriod().getName());
            map.put("period", info.getPeriod().getId().toString());
            map.put("personalGoalStatus", info.getPersonalGoalStatus().getValue());
            map.put("personalGoalStatusAlias", info.getPersonalGoalStatus().getAlias());
            map.put("perfPlan", info.getPeriod().getPerfPlan().getName());
            map.put("photo", null);
            result.add(map);
        }
        if (!CollectionUtils.isEmpty(evaObjIds)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjIds, CompareType.INCLUDE));
            TargetConfirmBackReasonCollection backReasonCollection = TargetConfirmBackReasonFactory.getLocalInstance(ctx).getTargetConfirmBackReasonCollection("select *, evaObj.id, creator.name where " + filter.toSql() + " order by evaObj.id, createTime desc");
            if (backReasonCollection != null && backReasonCollection.size() > 0) {
                for (int i = 0; i < backReasonCollection.size(); ++i) {
                    TargetConfirmBackReasonInfo backReasonInfo = backReasonCollection.get(i);
                    for (Map map : result) {
                        if (!backReasonInfo.getEvaObj().getId().toString().equals(map.get("id"))) continue;
                        ArrayList backReasonList = (ArrayList)map.get("backReasonList");
                        if (backReasonList == null) {
                            backReasonList = new ArrayList();
                        }
                        HashMap<String, Object> backReasonMap = new HashMap<String, Object>();
                        backReasonMap.put("backReason", backReasonInfo.getBackReason());
                        backReasonMap.put("backPerson", backReasonInfo.getCreator().getName());
                        backReasonMap.put("backTime", backReasonInfo.getCreateTime());
                        backReasonList.add(backReasonMap);
                        map.put("backReasonList", backReasonList);
                    }
                }
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("data", result);
        map.put("total", Integer.valueOf(totalCount));
        return map;
    }

    private EntityViewInfo getEntityView(Context ctx, Set receiverSet, Map param) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String positionName = (String)param.get("positionName");
        String name = (String)param.get("name");
        String belongOrgId = (String)param.get("belongOrgId");
        String perfPlanId = (String)param.get("perfPlanId");
        String periodId = (String)param.get("periodId");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)receiverSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)3, CompareType.NOTEQUALS));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("perfFile.position.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("period.perfplan.id"));
        sic.add(new SelectorItemInfo("period.perfplan.name"));
        sic.add(new SelectorItemInfo("personalGoalStatus"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        if (param.get("isOrg") != null && NumberUtils.isNumber((String)param.get("isOrg").toString())) {
            filter.getFilterItems().add(new FilterItemInfo("isOrg", (Object)Integer.valueOf(param.get("isOrg").toString()), CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            ArrayList<String> orgList = PermitUtil.getInterSectionOrg(PermitUtil.getCurrentUserOwnOrg(ctx), PermitUtil.getCurAndSubOrg(ctx, belongOrgId));
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.addAll(orgList);
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit", orgSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.perfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("unitAfterFiller", (Object)1, CompareType.EQUALS));
        if (!StringUtils.isEmpty((CharSequence)name) || !StringUtils.isEmpty((CharSequence)positionName)) {
            FilterInfo filter1 = new FilterInfo();
            FilterInfo filter2 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("perfFile.position.name", (Object)("%" + positionName + "%"), CompareType.LIKE));
            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
            try {
                filter1.mergeFilter(filter2, "OR");
                filter.mergeFilter(filter1, "and");
            }
            catch (BOSException e) {
                logger.error("merge filter bos err: ", (Throwable)e);
            }
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("period.id"));
        sorter.add(new SorterItemInfo("id"));
        return viewInfo;
    }
}

