/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetGradingListService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger(GetGradingListService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        int page = 0;
        int rows = 0;
        if (param.get("page") != null) {
            page = Integer.valueOf((String)param.get("page"));
        }
        if (param.get("rows") != null) {
            rows = Integer.valueOf((String)param.get("rows"));
        }
        IObjectPK userId = ctx.getCaller();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
        String personId = user.getPerson().getId().toString();
        Map map = this.buidServiceData(ctx, page, rows, personId, param);
        boolean batchScore = PermissionUtils.hasFunctionPermission(ctx, "batchScore");
        map.put("batchScore", batchScore);
        return map;
    }

    private Map buidServiceData(Context ctx, int page, int rows, String personId, Map param) throws BOSException {
        ArrayList result = new ArrayList();
        EntityViewInfo evi = this.getEntityView(ctx, personId, param);
        IGradeTaskNodeInst bizInterface = GradeTaskNodeInstFactory.getLocalInstance(ctx);
        int totalCount = bizInterface.getCount(evi);
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List list = bizInterface.getPagingList(evi, (page - 1) * rows, length);
        HashSet<String> evaObjIds = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            GradeTaskNodeInstInfo info = (GradeTaskNodeInstInfo)list.get(i);
            evaObjIds.add(info.getEvaObj().getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("scoringFormula", null, CompareType.ISNOT));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", evaObjIds, CompareType.INCLUDE));
        IndicatorTargetCollection targets = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection("select evaObj where " + filterInfo.toSql());
        HashSet<String> unvalids = new HashSet<String>();
        if (!targets.isEmpty()) {
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                IndicatorTargetInfo info = (IndicatorTargetInfo)iterator.next();
                unvalids.add(info.getEvaObj().getId().toString());
            }
        }
        String toBeAssigned = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TOBEASSIGNED, ctx);
        String toBeScored = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.TOBESCORED, ctx);
        HashSet<String> nodeTakSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            GradeTaskNodeInstInfo info = (GradeTaskNodeInstInfo)list.get(i);
            nodeTakSet.add(info.getId().toString());
        }
        Map<String, String> areaNameMap = this.getAreaBaseNameByNodeTaskInst(ctx, nodeTakSet);
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            GradeTaskNodeInstInfo info = (GradeTaskNodeInstInfo)list.get(i);
            String positionName = info.getEvaObj().getPerfFile().getPosition().getName();
            String person = info.getEvaObj().getPerson().getId().toString();
            String evaObjId = info.getEvaObj().getId().toString();
            map.put("name", info.getEvaObj().getName());
            map.put("number", info.getEvaObj().getNumber());
            map.put("areaName", areaNameMap.get(info.getId().toString()));
            map.put("canAdjustEvaluer", String.valueOf(info.getEvaObj().getCanAdjustEvaluer().getValue()));
            map.put("person", person);
            map.put("position", positionName);
            map.put("evaObj", evaObjId);
            map.put("seq", String.valueOf(info.getWfLevel()));
            map.put("nodeTaskId", info.getId().toString());
            map.put("date", info.getPeriod().getName());
            map.put("period", info.getPeriod().getId().toString());
            map.put("perfGradeEvaluate", info.getWfNode().getPerfGradeEvaluate().getValue());
            map.put("backInfo", info.getRema());
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add(new SelectorItemInfo("id"));
            sic1.add(new SelectorItemInfo("name"));
            sic1.add(new SelectorItemInfo("perfRule.id"));
            PerfPlanInfo perfInfo = info.getPeriod().getPerfPlan();
            map.put("perfPlan", perfInfo.getName());
            map.put("perfRule", perfInfo.getPerfRule().getId().toString());
            map.put("wfNode", info.getWfNode().getId().toString());
            map.put("needScore", info.getWfNode().getNeedScore().getValue());
            if (StringUtils.isEmpty((CharSequence)info.getNodeGrade()) && "0".equals(info.getTaskStatus().getValue())) {
                map.put("grade", toBeAssigned);
            } else {
                map.put("grade", info.getNodeGrade());
            }
            Float sc = Float.valueOf(info.getNodeSumScore());
            if ((sc == null || (double)sc.floatValue() == 0.0) && "0".equals(info.getTaskStatus().getValue())) {
                map.put("score", toBeScored);
            } else {
                DecimalFormat df = new DecimalFormat("#.##");
                HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, info.getId().toString(), evaObjId);
                if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
                    if (!StringUtils.isEmpty((CharSequence)((String)targrtMap.get("sumScore")))) {
                        BigDecimal score = new BigDecimal(String.valueOf(sc)).subtract(new BigDecimal((String)targrtMap.get("sumScore")));
                        if (score.compareTo(BigDecimal.ZERO) > 0) {
                            map.put("score", df.format(score));
                        } else {
                            map.put("score", "0");
                        }
                    } else {
                        map.put("score", df.format(info.getNodeSumScore()));
                    }
                } else {
                    map.put("score", df.format(info.getNodeSumScore()));
                }
            }
            map.put("photo", null);
            if (unvalids.contains(evaObjId)) {
                map.put("canBatchDeal", "0");
            } else {
                map.put("canBatchDeal", "1");
            }
            result.add(map);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("data", result);
        map.put("total", Integer.valueOf(totalCount));
        return map;
    }

    private EntityViewInfo getEntityView(Context ctx, String personId, Map param) {
        String positionName = (String)param.get("positionName");
        String name = (String)param.get("name");
        String belongOrgId = (String)param.get("belongOrgId");
        String perfPlanId = (String)param.get("perfPlanId");
        String periodId = (String)param.get("periodId");
        String isSelf = (String)param.get("isSelf");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("period.perfplan.id"));
        sic.add(new SelectorItemInfo("period.perfplan.name"));
        sic.add(new SelectorItemInfo("period.perfplan.perfRule.id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("evaObj.person.*"));
        sic.add(new SelectorItemInfo("evaObj.name"));
        sic.add(new SelectorItemInfo("evaObj.canAdjustEvaluer"));
        sic.add(new SelectorItemInfo("evaObj.number"));
        sic.add(new SelectorItemInfo("evaObj.perfFile.position.name"));
        sic.add(new SelectorItemInfo("nodeSumScore"));
        sic.add(new SelectorItemInfo("nodeGrade"));
        sic.add(new SelectorItemInfo("wfLevel"));
        sic.add(new SelectorItemInfo("wfNode.id"));
        sic.add(new SelectorItemInfo("scoreStatus"));
        sic.add(new SelectorItemInfo("taskStatus"));
        sic.add(new SelectorItemInfo("wfNode.*"));
        sic.add(new SelectorItemInfo("rema"));
        evi.setSelector(sic);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("period.pStartDate");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItemInfo);
        evi.setSorter(sorterItemCollection);
        HashSet<String> scoreStatusSet = new HashSet<String>();
        scoreStatusSet.add("2");
        scoreStatusSet.add("3");
        scoreStatusSet.add("4");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("nodeHandler", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoreStatus", scoreStatusSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("evaObj.isOrg", (Object)"0", CompareType.EQUALS));
        if (StringUtils.isNotEmpty((CharSequence)isSelf) && ("1".equals(isSelf) || "0".equals(isSelf))) {
            filter.getFilterItems().add(new FilterItemInfo("isSelf", (Object)Integer.valueOf(isSelf), CompareType.EQUALS));
        }
        if (param.get("onlyTotalScore") != null && "1".equals(param.get("onlyTotalScore").toString())) {
            filter.getFilterItems().add(new FilterItemInfo("wfNode.needScore", (Object)"3", CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)periodId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)belongOrgId)) {
            ArrayList<String> orgList = PermitUtil.getInterSectionOrg(PermitUtil.getCurrentUserOwnOrg(ctx), PermitUtil.getCurAndSubOrg(ctx, belongOrgId));
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.addAll(orgList);
            filter.getFilterItems().add(new FilterItemInfo("evaObj.adminOrgUnit", orgSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((CharSequence)perfPlanId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.perfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((CharSequence)name) || !StringUtils.isEmpty((CharSequence)positionName)) {
            FilterInfo filter1 = new FilterInfo();
            FilterInfo filter2 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("evaObj.perfFile.position.Name ", (Object)("%" + positionName + "%"), CompareType.LIKE));
            filter2.getFilterItems().add(new FilterItemInfo("evaObj.name", (Object)("%" + name + "%"), CompareType.LIKE));
            try {
                filter1.mergeFilter(filter2, "OR");
                filter.mergeFilter(filter1, "and");
            }
            catch (BOSException e) {
                logger.error("merge filter bos err: ", (Throwable)e);
            }
        }
        evi.setFilter(filter);
        return evi;
    }

    private Map<String, String> getAreaBaseNameByNodeTaskInst(Context ctx, Set nodeTakSet) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        GradeTargetInstCollection coll = GetEntityInfoUtils.getGradeTargetInstCollectionByNodeInst(ctx, nodeTakSet);
        HashSet<String> exist = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            if (map.get(coll.get(i).getGradeTaskNode().getId().toString()) != null) {
                if (exist.contains(coll.get(i).getAreaBase().getId().toString()) || coll.get(i).getEvaObj().getCanAdjustEvaluer().getValue() == 0) continue;
                String areaName = (String)map.get(coll.get(i).getGradeTaskNode().getId().toString());
                areaName = areaName + "," + coll.get(i).getAreaBase().getName();
                map.put(coll.get(i).getGradeTaskNode().getId().toString(), areaName);
                continue;
            }
            if (coll.get(i).getEvaObj().getCanAdjustEvaluer().getValue() == 0) {
                map.put(coll.get(i).getGradeTaskNode().getId().toString(), "");
                continue;
            }
            map.put(coll.get(i).getGradeTaskNode().getId().toString(), coll.get(i).getAreaBase().getName());
            exist.add(coll.get(i).getAreaBase().getId().toString());
        }
        return map;
    }
}

