/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaPeriodStatusEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonPageHelper;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMyGoalsScheduleService
implements IHRMsfService,
ICustomDataProcessor {
    private static Logger logger = LoggerFactory.getLogger(GetMyGoalsScheduleService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Map<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String baseSQL = GetMyGoalsScheduleService.getBaseSQL(ctx, personId, map);
        String baseOrder = "TT.FEVAPERIODSTATUS DESC, TT.FPEndDate desc, TT.FPStartDate desc,T.FCREATETIME DESC, T.FID";
        int rows = (Integer)map.get("rows");
        int page = (Integer)map.get("page");
        try {
            result = CommonPageHelper.getPageCallbackData(ctx, baseSQL, rows, page, baseOrder, this, null);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rs, String type) throws WfBizException {
        ArrayList list = new ArrayList();
        try {
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("id", rs.getString("FID"));
                    item.put("planName", rs.getString("FNAME"));
                    item.put("evaluModeName", rs.getString("MODELNAME"));
                    item.put("belongOrgName", rs.getString("FBELONGORGNAME"));
                    item.put("positionName", rs.getString("FPOSITIONNAME"));
                    item.put("periodStatus", GetMyGoalsScheduleService.getEvaPeriodStatuDesc(rs.getInt("FEVAPERIODSTATUS")));
                    item.put("periodDate", rs.getString("PERIODNAME"));
                    item.put("evaObj", rs.getString("EVAOBJID"));
                    item.put("periodId", rs.getString("PERIODID"));
                    item.put("personId", rs.getString("FPERSON"));
                    item.put("perfPlanId", rs.getString("FPERFPLAN"));
                    item.put("belongOrgId", rs.getString("FBELONGORGID"));
                    list.add(item);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return list;
    }

    public static String getBaseSQL(Context ctx, String person, Map map) {
        String positionName = (String)map.get("positionName");
        String belongOrgName = (String)map.get("belongOrgName");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        String baseSQL = "SELECT T.FID,TT.FID AS PERIODID,TT.FNAME" + mlFlag + " AS PERIODNAME,OBJECT.FID AS EVAOBJID,POSITION.FNAME" + mlFlag + " AS FPOSITIONNAME,PERFFILE.FPERSONID AS FPERSON,OBJECT.FNUMBER AS PERSONNUM,T.FPERIODFREQUENCY,T.FNAME" + mlFlag + " AS FNAME,T.FNUMBER,T.FBELONGORGID,T.FBELONGORGNAME,T.FPERFMODELID,MODEL.FNAME AS MODELNAME,T.FPerfRuleName,TT.FEVAPERIODSTATUS,TT.FREFSTATUS,TT.FYEAR,TT.FTIMEPERIOD,TT.FCycleType,replace(tochar(TT.FPStartDate,'yyyy-mm-dd'),'-','.') FPStartDate,replace(tochar(TT.FPEndDate,'yyyy-mm-dd'),'-','.') FPEndDate, TT.FPERFPLAN FROM T_EVA_PERFPLAN T LEFT OUTER JOIN T_EVA_PERFPERIOD TT ON T.FID = TT.FPERFPLAN LEFT OUTER JOIN T_PEF_PERFMODEL MODEL ON T.FPERFMODELID = MODEL.FID LEFT OUTER JOIN T_EVA_PERFEVAOBJECT OBJECT   ON OBJECT.FPERIODID = TT.FID LEFT OUTER JOIN T_EVA_PERFFILE PERFFILE   ON OBJECT.FPERFFILEID = PERFFILE.FID LEFT OUTER JOIN T_ORG_Position POSITION   ON PERFFILE.FPOSITIONID = POSITION.FID WHERE PERFFILE.FPERSONID = '" + person + "'  AND OBJECT.FUNITGOALSSTATUS = " + 1 + " AND OBJECT.FPERSONALGOALSTATUS = " + 3 + " ";
        if (!StringUtils.isEmpty((String)positionName) && positionName.equals(belongOrgName)) {
            baseSQL = baseSQL + "AND (POSITION.FNAME" + mlFlag + " like '%" + positionName + "%' OR T.FBELONGORGNAME like '%" + positionName + "%') ";
        } else {
            if (!StringUtils.isEmpty((String)positionName)) {
                baseSQL = baseSQL + "AND POSITION.FNAME" + mlFlag + " like '%" + positionName + "%' ";
            }
            if (!StringUtils.isEmpty((String)belongOrgName)) {
                baseSQL = baseSQL + "AND T.FBELONGORGNAME like '%" + belongOrgName + "%' ";
            }
        }
        if (!StringUtils.isEmpty((String)belongOrgId)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" T.FBELONGORGID in (SELECT RANGE.FORGID  FROM T_PM_ORGRANGE RANGE").append(" LEFT OUTER JOIN T_ORG_ADMIN a").append(" ON RANGE.FORGID = a.FID  WHERE  RANGE.FTYPE = 20 ").append("AND a.FISSTARTSHR = 1 ").append(" AND RANGE.FUSERID = '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "') ");
            try {
                AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where id='" + belongOrgId + "'");
                if (adminOrgColl != null && adminOrgColl.size() > 0) {
                    String longNumber = adminOrgColl.get(0).getLongNumber();
                    sb.append(" and T.FBELONGORGID  in (select fid from T_ORG_Admin where FLongNumber like '" + longNumber + "!%')");
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
            baseSQL = baseSQL + "AND " + sb.toString();
        }
        if (!StringUtils.isEmpty((String)perfPlanId)) {
            baseSQL = baseSQL + "AND TT.FPERFPLAN = '" + perfPlanId + "' ";
        }
        if (!StringUtils.isEmpty((String)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("OBJECT.FPERIODID", periods, CompareType.INCLUDE));
            baseSQL = baseSQL + "AND " + filterInfo.toSql();
        }
        return baseSQL;
    }

    public static String getEvaPeriodStatuDesc(int status) {
        if (100 == status) {
            return EvaPeriodStatusEnum.EVALUATED.getAlias();
        }
        if (200 == status) {
            return EvaPeriodStatusEnum.EVALUATING.getAlias();
        }
        return EvaPeriodStatusEnum.UNEVALUATE.getAlias();
    }
}

