/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMyGoalsService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetMyGoalsService.class.getName());

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        Boolean isOrg = "1".equals((String)map.get("isOrg"));
        EntityViewInfo evi = this.getEntityView(ctx, map);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        int totalCount = iPerfEvaObject.getCount(evi);
        int rows = (Integer)map.get("rows");
        int page = (Integer)map.get("page");
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List list = iPerfEvaObject.getPagingList(evi, (page - 1) * rows, length);
        HashSet<String> perfPlanIds = new HashSet<String>();
        ArrayList data = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            PerfEvaObjectInfo info = (PerfEvaObjectInfo)list.get(i);
            String id = info.getId().toString();
            resultMap.put("id", id);
            resultMap.put("name", info.getName());
            resultMap.put("number", info.getNumber());
            resultMap.put("", info.getNumber());
            if (isOrg.booleanValue()) {
                PerfEvaluAdminResponsorCollection responsors = info.getResponsor();
                String responsorName = "";
                for (int j = 0; j < responsors.size(); ++j) {
                    responsorName = responsorName + responsors.get(j).getPerson().getName() + ",";
                }
                resultMap.put("positionName", responsorName.substring(0, responsorName.length() - 1));
            } else if (info.getPerfFile() != null && info.getPerfFile().getPosition() != null) {
                resultMap.put("positionName", info.getPerfFile().getPosition().getName());
            }
            if (info.getAdminOrgUnit() != null) {
                resultMap.put("belongOrgId", info.getAdminOrgUnit().getId());
                resultMap.put("belongOrgName", info.getAdminOrgUnit().getName());
            }
            if (info.getPeriod() != null) {
                resultMap.put("periodId", info.getPeriod().getId().toString());
                resultMap.put("evaPeriodStatus", info.getPeriod().getEvaPeriodStatus().getName());
                Date pStartDate = info.getPeriod().getPStartDate();
                Date pEndDate = info.getPeriod().getPEndDate();
                String periodDate = DateUtil.dateToStr((Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((Date)pEndDate, (String)"yyyy-MM-dd");
                resultMap.put("periodDate", periodDate);
                if (!StringUtils.isEmpty((String)info.getPeriod().getPerfPlan().getId().toString())) {
                    resultMap.put("perfPlanId", info.getPeriod().getPerfPlan());
                    perfPlanIds.add(info.getPeriod().getPerfPlan().getId().toString());
                }
            }
            if (info.getPerson() != null) {
                resultMap.put("personId", info.getPerson().getId().toString());
            }
            resultMap.put("progressUpdate", PerfEvaObjectPersonalGoalStatusEnum.ASSIGNED.equals((Object)info.getPersonalGoalStatus()));
            resultMap.put("photo", null);
            data.add(resultMap);
        }
        if (perfPlanIds.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", perfPlanIds, CompareType.INCLUDE));
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("name"));
            selectorItemCollection.add(new SelectorItemInfo("perfModel.name"));
            evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSelector(selectorItemCollection);
            PerfPlanCollection perfPlanCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection(evi);
            HashMap<String, String> perfPlanMap = new HashMap<String, String>();
            HashMap<String, String> perfModelMap = new HashMap<String, String>();
            if (perfPlanCollection != null && perfPlanCollection.size() > 0) {
                int i;
                for (i = 0; i < perfPlanCollection.size(); ++i) {
                    PerfPlanInfo perfPlanInfo = perfPlanCollection.get(i);
                    perfPlanMap.put(perfPlanInfo.getId().toString(), perfPlanInfo.getName());
                    perfModelMap.put(perfPlanInfo.getId().toString(), perfPlanInfo.getPerfModel().getName());
                }
                for (i = 0; i < list.size(); ++i) {
                    PerfEvaObjectInfo info = (PerfEvaObjectInfo)list.get(i);
                    Map resultMap = (Map)data.get(i);
                    if (info.getPeriod() == null || StringUtils.isEmpty((String)info.getPeriod().getPerfPlan().getId().toString())) continue;
                    String perfPlanName = (String)perfPlanMap.get(info.getPeriod().getPerfPlan().getId().toString());
                    String perfModelName = (String)perfModelMap.get(info.getPeriod().getPerfPlan().getId().toString());
                    resultMap.put("planName", perfPlanName);
                    resultMap.put("evaluModeName", perfModelName);
                }
            }
        }
        int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
        result.put("pages", pages);
        result.put("records", totalCount);
        result.put("rows", data);
        if (isOrg.booleanValue()) {
            boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetOrgDecompose");
            result.put("targetDecompose", perfSumInterview);
            boolean progressUpdate = PermissionUtils.hasFunctionPermission(ctx, "progressOrgUpdate");
            result.put("progressUpdate", progressUpdate);
            boolean targetRevise = PermissionUtils.hasFunctionPermission(ctx, "orgTargetRevise");
            result.put("targetRevise", targetRevise);
            boolean targetHis = PermissionUtils.hasFunctionPermission(ctx, "orgTargetHis");
            result.put("targetHis", targetHis);
        } else {
            boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetDecompose");
            result.put("targetDecompose", perfSumInterview);
            boolean progressUpdate = PermissionUtils.hasFunctionPermission(ctx, "progressUpdate");
            result.put("progressUpdate", progressUpdate);
            boolean targetRevise = PermissionUtils.hasFunctionPermission(ctx, "targetRevise");
            result.put("targetRevise", targetRevise);
            boolean targetHis = PermissionUtils.hasFunctionPermission(ctx, "targetHis");
            result.put("targetHis", targetHis);
        }
        return result;
    }

    private EntityViewInfo getEntityView(Context ctx, Map map) throws BOSException, EASBizException {
        AdminOrgUnitCollection adminOrgUnitCollection;
        String permItemId;
        String positionName = (String)map.get("positionName");
        String belongOrgName = (String)map.get("belongOrgName");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        Boolean isOrg = "1".equals((String)map.get("isOrg"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        if (isOrg.booleanValue()) {
            String oql = "SELECT FEVAOBJID FROM T_EVA_PERFEVALUADMINRESPONSOR WHERE FPERSONID = '" + HRFilterUtils.getCurrentPersonId((Context)ctx) + "'";
            filterInfo.getFilterItems().add(new FilterItemInfo("isorg", (Object)1, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)oql, CompareType.INNER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)HRFilterUtils.getCurrentPersonId((Context)ctx), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isorg", (Object)0, CompareType.EQUALS));
        }
        String string = permItemId = map.get("permItemId") != null ? (String)map.get("permItemId") : "";
        if (!StringUtils.isEmpty((String)permItemId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)permItemId), CompareType.INNER));
        }
        if (!StringUtils.isEmpty((String)positionName) && !StringUtils.isEmpty((String)belongOrgName)) {
            FilterInfo fastFilter = new FilterInfo();
            if (!isOrg.booleanValue()) {
                fastFilter.getFilterItems().add(new FilterItemInfo("perfFile.position.name", (Object)("%" + positionName + "%"), CompareType.LIKE));
                fastFilter.getFilterItems().add(new FilterItemInfo("period.perfplan.name", (Object)("%" + belongOrgName + "%"), CompareType.LIKE));
                fastFilter.setMaskString("#0 OR #1");
                filterInfo.mergeFilter(fastFilter, "AND");
            } else {
                fastFilter.getFilterItems().add(new FilterItemInfo("period.perfplan.name", (Object)("%" + belongOrgName + "%"), CompareType.LIKE));
                fastFilter.getFilterItems().add(new FilterItemInfo("adminhis.name", (Object)("%" + belongOrgName + "%"), CompareType.LIKE));
                fastFilter.setMaskString("#0 OR #1");
                filterInfo.mergeFilter(fastFilter, "AND");
            }
        }
        if (!StringUtils.isEmpty((String)belongOrgId) && (adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id='" + belongOrgId + "'")) != null && adminOrgUnitCollection.size() > 0) {
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            if (isOrg.booleanValue()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("adminhis.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
            }
        }
        if (!StringUtils.isEmpty((String)perfPlanId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period.perfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", periods, CompareType.INCLUDE));
        }
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by period.evaPeriodStatus desc, period.pEndDate desc, period.pStartDate desc, createTime desc, id");
        }
        catch (ParserException e) {
            logger.error("my goals list sortItems error", (Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isOrg"));
        sic.add(new SelectorItemInfo("perfFile.position.name"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("period.perfplan.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.evaPeriodStatus"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("adminHis.responPosition"));
        sic.add(new SelectorItemInfo("adminHis.id"));
        sic.add(new SelectorItemInfo("adminHis.ResponPosition.name"));
        sic.add(new SelectorItemInfo("responsor.person.id"));
        sic.add(new SelectorItemInfo("responsor.person.name"));
        sic.add(new SelectorItemInfo("personalGoalStatus"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        return evi;
    }
}

