/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.tool.function.Strings;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.osf.model.FieldInfo;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.XmlUtil;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CoreConverter {
    private static Logger logger = LoggerFactory.getLogger(CoreConverter.class);
    private static final String[] FIELDPROPERTIES = new String[]{"colName", "showName", "hidden", "required", "defaultDisplay"};
    private static final String[] REQUIREDFIELDS = new String[]{"indecatorType", "name", "number", "tarScore", "weight", "keyItem"};
    private static Map<String, FieldType> customerFieldTypeMap = new HashMap<String, FieldType>();
    private static Map<String, String> f7DataSourceMap;
    private boolean isApplyCustomerFieldType;

    public CoreConverter() {
        this.isApplyCustomerFieldType = true;
    }

    public CoreConverter(boolean isApplyCustomerFieldType) {
        this.isApplyCustomerFieldType = isApplyCustomerFieldType;
    }

    public List<SimpleFieldInfo> buildSimpleFieldsByUipk(Context ctx, String uipk, Map map, List<String> onlyShowFields) throws EASBizException, BOSException, SQLException {
        List<SimpleFieldInfo> simpleFieldInfos = this.buildSimpleFieldsByUipk(ctx, uipk, map);
        ArrayList<SimpleFieldInfo> result = new ArrayList<SimpleFieldInfo>();
        for (String fn : onlyShowFields) {
            for (SimpleFieldInfo info : simpleFieldInfos) {
                if (!fn.equals(info.getFieldName())) continue;
                result.add(info);
            }
        }
        return result;
    }

    public List<SimpleFieldInfo> buildSimpleFieldsByUipk(Context ctx, String uipk, Map map) throws EASBizException, BOSException, SQLException {
        Map<String, String> stringStringMap = this.parseUIView(ctx, uipk);
        String content = stringStringMap.get("content");
        String model = stringStringMap.get("model");
        String type = stringStringMap.get("type");
        Document doc = XmlUtil.parseXML(content);
        Element root = doc.getRootElement();
        List<FieldInfo> fields = this.getFields(ctx, root, model, type, uipk);
        this.toMultiLangAlias(ctx, fields, uipk);
        return this.transToSimpleFields(ctx, fields, map);
    }

    public List<SimpleFieldInfo> buildSimpleFieldsByModel(Context ctx, String model, Map map) throws EASBizException, BOSException, SQLException {
        HashSet<String> fieldSet = new HashSet<String>();
        List<Map<String, Object>> list = this.assembleColumnModel(map, fieldSet);
        List<FieldInfo> fields = this.getFields(model, fieldSet, ctx);
        return this.transToSimpleFields(ctx, fields, list);
    }

    public List<SimpleFieldInfo> buildSimpleFieldsByQuery(Context ctx, String queryPK, Map map) throws EASBizException, BOSException, SQLException {
        HashSet<String> fieldSet = new HashSet<String>();
        List<Map<String, Object>> list = this.assembleColumnModel(map, fieldSet);
        List<FieldInfo> fields = this.getFields(ctx, queryPK, fieldSet);
        return this.transToSimpleFields(ctx, fields, list);
    }

    public List<FieldInfo> getFields(Context ctx, String queryPK, Set<String> fieldSet) {
        QuerySelect select = new QuerySelect(queryPK);
        SimpleQuery query = null;
        try {
            select.selectHeaderSelectorFields().propertyUnitSelect().select(fieldSet.toArray(new String[fieldSet.size()]), new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"}, ctx.getOriginLocale()).extendPropertySelect().select("*");
            query = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (String propertName : fieldSet) {
            SimplePropertyUnit property;
            if (query == null || (property = query.propertyUnit(propertName)) == null) continue;
            fields.add(this.propertToField(property, propertName));
        }
        return fields;
    }

    public static SimplePropertyUnitCollection getSimplePropertyUnitCollection0(Context ctx, String queryPK, String queryFieldName) {
        QuerySelect select = new QuerySelect(queryPK);
        SimpleQuery query = null;
        try {
            select.selectHeaderSelectorFields().propertyUnitSelect().select(new String[]{queryFieldName}, new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"}, ctx.getOriginLocale()).extendPropertySelect().select("*");
            query = MetaDataAccessFactory.getRemoteInstance().select(select);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null == query ? null : query.propertyUnits();
    }

    public List<SimpleFieldInfo> buildFieldOption(List<SimpleFieldInfo> simpleFieldInfoList, String fieldName, FieldType fieldType, Option ... options) {
        for (SimpleFieldInfo simpleFieldInfo : simpleFieldInfoList) {
            if (!fieldName.equals(simpleFieldInfo.getFieldName())) continue;
            simpleFieldInfo.setFieldType(fieldType);
            simpleFieldInfo.setOptions(Arrays.asList(options));
        }
        return simpleFieldInfoList;
    }

    public List<SimpleFieldInfo> buildFieldOption(List<SimpleFieldInfo> simpleFieldInfoList, String fieldName, FieldType fieldType, List<Option> options) {
        for (SimpleFieldInfo simpleFieldInfo : simpleFieldInfoList) {
            if (!fieldName.equals(simpleFieldInfo.getFieldName())) continue;
            simpleFieldInfo.setFieldType(fieldType);
            simpleFieldInfo.setOptions(options);
        }
        return simpleFieldInfoList;
    }

    public List<String> buildFieldNames(Context ctx, String uipk) throws EASBizException, BOSException, SQLException {
        Map<String, String> stringStringMap = this.parseUIView(ctx, uipk);
        String content = stringStringMap.get("content");
        Document doc = XmlUtil.parseXML(content);
        Element root = doc.getRootElement();
        return this.getFieldNames(root);
    }

    public Map<String, String> parseUIView(Context ctx, String uipk) throws BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)(" SELECT  uiv.FName" + mlFlag + " AS FName , uiv.FModel , uiv.FType , uiv.FUipk ,   uiv.FContent AS FContent ,uivext.FContent AS FExtend   FROM S_BS_UIView uiv    LEFT JOIN S_BS_UIViewEXT uivext ON  uivext.FParentId=uiv.Fid   WHERE uiv.FUipk ='" + uipk + "' "));
        while (rowset.next()) {
            String fName = rowset.getString("FName");
            String fModel = rowset.getString("FModel");
            String fType = rowset.getString("FType");
            String fUipk = rowset.getString("FUipk");
            String fContent = rowset.getString("FContent");
            String fExtend = rowset.getString("FExtend");
            result.put("content", fContent);
            result.put("isExt", "0");
            if (!StringUtils.isEmpty((String)fExtend)) {
                result.put("content", fExtend);
                result.put("isExt", "1");
            }
            result.put("model", fModel);
            result.put("type", fType);
        }
        return result;
    }

    protected List<SimpleFieldInfo> transToSimpleFields(Context ctx, List<FieldInfo> fields, Map map) throws EASBizException {
        List<Map<String, Object>> list = this.assembleColumnModel(map);
        return this.transToSimpleFields(ctx, fields, list);
    }

    protected List<SimpleFieldInfo> transToSimpleFields(Context ctx, List<FieldInfo> fields, List<Map<String, Object>> list) throws EASBizException {
        ArrayList<SimpleFieldInfo> simpleFieldInfoList = new ArrayList<SimpleFieldInfo>();
        HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
        for (FieldInfo info : fields) {
            fieldInfoMap.put(info.getName(), info);
        }
        if (!CollectionUtil.isEmpty(list)) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                SimpleFieldInfo simpleFieldInfo = new SimpleFieldInfo();
                Map<String, Object> fieldMap = list.get(i);
                String fieldName = (String)fieldMap.get("colName");
                simpleFieldInfo.setFieldName(fieldName);
                simpleFieldInfo.setShowName((String)fieldMap.get("showName"));
                FieldInfo tmpInfo = (FieldInfo)fieldInfoMap.get(fieldName);
                if (tmpInfo != null) {
                    simpleFieldInfo.setShowName(tmpInfo.getAlias());
                }
                simpleFieldInfo.setHidden(Boolean.parseBoolean((String)fieldMap.get("hidden")));
                simpleFieldInfo.setRequired(Boolean.parseBoolean((String)fieldMap.get("required")));
                if ("id".equalsIgnoreCase(fieldName)) {
                    simpleFieldInfo.setDefaultDisplay(false);
                } else {
                    simpleFieldInfo.setDefaultDisplay(Boolean.parseBoolean((String)fieldMap.get("defaultDisplay")));
                }
                for (FieldInfo fieldInfo : fields) {
                    if (!fieldName.equals(fieldInfo.getName())) continue;
                    PropertyInfo property = fieldInfo.getProperty();
                    if (property == null) break;
                    Object dataType = property.get("dataType");
                    if (dataType != null && simpleFieldInfo.getDataType() == null) {
                        simpleFieldInfo.setDataType(DataType.getEnum((String)dataType.toString()));
                    }
                    if (this.isApplyCustomerFieldType && customerFieldTypeMap.containsKey(fieldName)) {
                        simpleFieldInfo.setFieldType(customerFieldTypeMap.get(fieldName));
                    } else if (!StringUtils.isEmpty((String)fieldName) && fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                        simpleFieldInfo.setFieldType(FieldType.Text);
                    }
                    if (property instanceof OwnPropertyInfo) {
                        OwnPropertyInfo ownProp = (OwnPropertyInfo)property;
                        if (DataType.ENUM.equals((Object)ownProp.getDataType())) {
                            BizEnumValueCollection enumColl = ownProp.getEnumType().getEnumValue();
                            int size1 = enumColl.size();
                            ArrayList<Option> optionList = new ArrayList<Option>();
                            for (int i1 = 0; i1 < size1; ++i1) {
                                Option option = new Option();
                                option.setKey((String)enumColl.get(i1).getValue());
                                option.setValue(enumColl.get(i1).getAlias());
                                if (StringUtils.isEmpty((String)option.getValue())) {
                                    option.setValue(enumColl.get(i1).getName());
                                }
                                optionList.add(option);
                            }
                            simpleFieldInfo.setOptions(optionList);
                        }
                    } else if (property instanceof LinkPropertyInfo) {
                        // empty if block
                    }
                    if (f7DataSourceMap.containsKey(fieldName.toUpperCase())) {
                        simpleFieldInfo.setDataSource(f7DataSourceMap.get(fieldName.toUpperCase()));
                    }
                    if (!"ISVISIBLE".equalsIgnoreCase(fieldName.toUpperCase())) break;
                    Option option1 = new Option("0", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEUNPUBLIC, ctx));
                    Option option2 = new Option("1", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEPUBLIC, ctx));
                    simpleFieldInfo.setOptions(Arrays.asList(option1, option2));
                    break;
                }
                simpleFieldInfoList.add(simpleFieldInfo);
            }
        } else {
            for (FieldInfo fieldInfo : fields) {
                String fieldName = fieldInfo.getName();
                SimpleFieldInfo simpleFieldInfo = new SimpleFieldInfo();
                simpleFieldInfo.setFieldName(fieldName);
                simpleFieldInfo.setShowName(fieldInfo.getAlias());
                simpleFieldInfo.setHidden("hidden".equalsIgnoreCase(fieldInfo.getType()));
                simpleFieldInfo.setMaxLength(fieldInfo.getMaxLength());
                PropertyInfo property = fieldInfo.getProperty();
                if (property != null) {
                    Object dataType = property.get("dataType");
                    if (dataType != null && simpleFieldInfo.getDataType() == null) {
                        simpleFieldInfo.setDataType(DataType.getEnum((String)dataType.toString()));
                    }
                    if (this.isApplyCustomerFieldType && customerFieldTypeMap.containsKey(fieldName)) {
                        simpleFieldInfo.setFieldType(customerFieldTypeMap.get(fieldName));
                    } else if (!StringUtils.isEmpty((String)fieldName) && fieldName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                        simpleFieldInfo.setFieldType(FieldType.Text);
                    }
                    simpleFieldInfo.setRequired(Arrays.binarySearch(REQUIREDFIELDS, fieldName) > -1);
                    if (property instanceof OwnPropertyInfo) {
                        OwnPropertyInfo ownProp = (OwnPropertyInfo)property;
                        if (DataType.ENUM.equals((Object)ownProp.getDataType())) {
                            BizEnumValueCollection enumColl = ownProp.getEnumType().getEnumValue();
                            int size1 = enumColl.size();
                            ArrayList<Option> optionList = new ArrayList<Option>();
                            for (int i1 = 0; i1 < size1; ++i1) {
                                Option option = new Option();
                                option.setKey((String)enumColl.get(i1).getValue());
                                option.setValue(enumColl.get(i1).getAlias());
                                if (StringUtils.isEmpty((String)option.getValue())) {
                                    option.setValue(enumColl.get(i1).getName());
                                }
                                optionList.add(option);
                            }
                            simpleFieldInfo.setOptions(optionList);
                        }
                    } else if (property instanceof LinkPropertyInfo) {
                        // empty if block
                    }
                }
                simpleFieldInfoList.add(simpleFieldInfo);
            }
        }
        return simpleFieldInfoList;
    }

    public List<FieldInfo> getFields(Context ctx, Element root, String entityName, String entityType, String uipk) {
        if (root != null && root.getChildren() != null) {
            List children = root.getChildren();
            Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(ctx, entityName);
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            Element element = null;
            String elementName = null;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                elementName = element.getName();
                if (("list".equalsIgnoreCase(elementName) || "grid".equalsIgnoreCase(elementName)) && "form".equals(entityType)) continue;
                if (!"field".equalsIgnoreCase(elementName) && !"fieldValue".equalsIgnoreCase(elementName)) {
                    if ("editGrid".equalsIgnoreCase(elementName)) {
                        fields.addAll(this.assembleEditGridFields(ctx, element, entityName, properties));
                        continue;
                    }
                    if (element.getChildren() == null) continue;
                    fields.addAll(this.getFields(ctx, element, entityName, entityType, uipk));
                    continue;
                }
                fields.add(this.assembleFieldInfo(element, entityName, properties));
            }
            return fields;
        }
        return null;
    }

    protected void toMultiLangAlias(Context ctx, List<FieldInfo> fields, String uipk) {
        String language = "zh_CN";
        if (ctx.getOriginLocale() != null && !StringUtils.isEmpty((String)ctx.getOriginLocale().toString())) {
            language = ctx.getOriginLocale().toString();
        }
        if (("en_US".equals(language) || "zh_TW".equals(language)) && !CollectionUtils.isEmpty(fields)) {
            String alias;
            HashSet<String> aliasSet = new HashSet<String>();
            HashMap<String, String> resDis = new HashMap<String, String>();
            for (FieldInfo fieldInfo : fields) {
                alias = fieldInfo.getAlias();
                if (StringUtils.isEmpty((String)alias) || alias.contains("'") || alias.contains("=") || alias.contains("\"") || alias.contains("<") || alias.contains(">") || alias.contains("-") || alias.contains("and") || alias.contains("AND") || alias.contains("in") || alias.contains("IN") || alias.contains("not") || alias.contains("NOT") || alias.contains("or") || alias.contains("OR") || alias.contains("union") || alias.contains("UNION")) continue;
                aliasSet.add(alias);
            }
            if (!CollectionUtils.isEmpty(aliasSet)) {
                String inSql = " ('" + Strings.join((String[])aliasSet.toArray(new String[aliasSet.size()]), (String)"','") + "') ";
                String sql = " select resource.FRES as res,  multiLan.FMLRES as dis  from T_RES_UIResource resource \n LEFT JOIN T_RES_UIMultiLan multiLan \n ON resource.FID = multiLan.FResID \n where resource.FFILENAME = '" + uipk + "' \n and resource.FRES in " + inSql + "  and multiLan.FLANGUAGE = '" + language + "' ";
                IRowSet dataSet = null;
                try {
                    dataSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (dataSet.next()) {
                        String res = dataSet.getString("res");
                        String dis = dataSet.getString("dis");
                        if (StringUtils.isEmpty((String)res) || StringUtils.isEmpty((String)dis)) continue;
                        resDis.put(res, dis);
                    }
                }
                catch (Exception e) {
                    logger.error("toMultiLangAlias", (Throwable)e);
                }
            }
            for (FieldInfo fieldInfo : fields) {
                alias = fieldInfo.getAlias();
                if (StringUtils.isEmpty((String)((String)resDis.get(alias)))) continue;
                fieldInfo.setAlias((String)resDis.get(alias));
            }
        }
    }

    public List<FieldInfo> getFields(String entityName, Set<String> fieldSet, Context ctx) {
        Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(ctx, entityName);
        ArrayList<FieldInfo> fields = new ArrayList();
        if (CollectionUtils.isEmpty(fieldSet)) {
            fields = this.getFields(ctx, entityName);
        }
        for (String propertName : fieldSet) {
            PropertyInfo propertyInfo = !propertName.contains(".") ? properties.get(propertName) : MetaDataUtil.getPropertyInfo(entityName, propertName.split("\\."));
            if (propertyInfo == null) continue;
            fields.add(this.propertToField(propertyInfo, propertName));
        }
        return fields;
    }

    public List<FieldInfo> getFields(Context ctx, String entityName) {
        Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(ctx, entityName);
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (Map.Entry<String, PropertyInfo> entry : properties.entrySet()) {
            String propertName = entry.getKey();
            PropertyInfo propertyInfo = !entry.getKey().contains(".") ? properties.get(propertName) : MetaDataUtil.getPropertyInfo(entityName, propertName.split("\\."));
            if (propertyInfo == null) continue;
            fields.add(this.propertToField(propertyInfo, propertName));
        }
        return fields;
    }

    public FieldInfo propertToField(PropertyInfo propertyInfo) {
        FieldInfo field = new FieldInfo();
        field.setAlias(propertyInfo.getAlias());
        field.setName(propertyInfo.getName());
        field.setProperty(propertyInfo);
        return field;
    }

    public FieldInfo propertToField(PropertyInfo propertyInfo, String originalName) {
        FieldInfo field = new FieldInfo();
        field.setAlias(propertyInfo.getAlias());
        field.setName(originalName);
        field.setProperty(propertyInfo);
        return field;
    }

    public FieldInfo propertToField(SimplePropertyUnit propertyInfo, String originalName) {
        FieldInfo field = new FieldInfo();
        field.setAlias(propertyInfo.getDisplayName());
        field.setName(originalName);
        OwnPropertyInfo propertyInfo1 = new OwnPropertyInfo();
        propertyInfo1.setDataType(DataType.getEnum((String)propertyInfo.getReturnType().getName()));
        field.setProperty((PropertyInfo)propertyInfo1);
        return field;
    }

    public List<String> getFieldNames(Element root) {
        if (root != null && root.getChildren() != null) {
            List children = root.getChildren();
            ArrayList<String> fields = new ArrayList<String>();
            Element element = null;
            String elementName = null;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                elementName = element.getName();
                if (!"field".equalsIgnoreCase(elementName) && !"fieldValue".equalsIgnoreCase(elementName)) {
                    fields.addAll(this.getFieldNames(element));
                    continue;
                }
                fields.add(element.getAttributeValue("name"));
            }
            return fields;
        }
        return null;
    }

    private List<FieldInfo> assembleEditGridFieldsByQuery(Element element) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        List columns = element.getChildren("column");
        Element column = null;
        FieldInfo fieldInfo = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (Element)columns.get(i);
            fieldInfo = this.assembleFieldInfo(column, null, null);
            fields.add(fieldInfo);
        }
        return fields;
    }

    private List<FieldInfo> assembleEditGridFields(Context ctx, Element element, String entityName, Map<String, PropertyInfo> properties) {
        if (element.getAttribute("query") != null) {
            return this.assembleEditGridFieldsByQuery(element);
        }
        String entryName = element.getAttributeValue("name");
        PropertyInfo propertyInfo = null;
        if (!StringUtils.isEmpty((String)entityName)) {
            if (entryName.indexOf(".") != -1) {
                propertyInfo = MetaDataUtil.getPropertyInfo(entityName, entryName);
            } else if (properties != null) {
                propertyInfo = properties.get(entryName);
            }
        }
        String entryEntityName = null;
        LinkPropertyInfo linkPropertyInfo = null;
        if (propertyInfo instanceof LinkPropertyInfo && RelationshipType.COMPOSITION.equals((Object)(linkPropertyInfo = (LinkPropertyInfo)propertyInfo).getRelationship().getType())) {
            entryEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        }
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        FieldInfo editGridfieldInfo = this.assembleFieldInfo(element, entityName, properties);
        fields.add(editGridfieldInfo);
        Map<String, PropertyInfo> entryProperties = MetaDataUtil.getProperties(ctx, entryEntityName);
        List columns = element.getChildren("column");
        Element column = null;
        FieldInfo fieldInfo = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (Element)columns.get(i);
            fieldInfo = this.assembleFieldInfo(column, entryEntityName, entryProperties);
            fieldInfo.setName(entryName + "." + fieldInfo.getName());
            fields.add(fieldInfo);
        }
        return fields;
    }

    protected FieldInfo assembleFieldInfo(Element element, String entityName, Map<String, PropertyInfo> properties) {
        String maxlength;
        String _sortable_;
        String defaultValueExpression;
        String requireAudit;
        String type;
        String caption;
        Element parent;
        List children;
        String name = element.getAttributeValue("name");
        PropertyInfo propertyInfo = null;
        if (!StringUtils.isEmpty((String)entityName)) {
            if (name.contains(".")) {
                propertyInfo = MetaDataUtil.getPropertyInfo(entityName, name);
            } else if (properties != null && null == (propertyInfo = properties.get(name))) {
                propertyInfo = this.getPropertyInfo(properties, name);
            }
        }
        FieldInfo fieldInfo = this.newFieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setProperty(propertyInfo);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((String)label) && (children = (parent = element.getParentElement()).getChildren()).size() == 1 && !StringUtils.isEmpty((String)(caption = parent.getAttributeValue("caption")))) {
            label = caption;
        }
        if (StringUtils.isEmpty((String)label) && propertyInfo != null) {
            label = propertyInfo.getAlias(Locale.CHINA);
        }
        if (StringUtils.isEmpty((String)label)) {
            label = name;
        }
        fieldInfo.setAlias(label);
        String formatter = element.getAttributeValue("formatter");
        if (StringUtils.isEmpty((String)formatter)) {
            formatter = "";
        }
        fieldInfo.setFormatter(formatter);
        String formatoptions = element.getAttributeValue("formatoptions");
        if (StringUtils.isEmpty((String)formatoptions)) {
            formatoptions = "";
        }
        fieldInfo.setFormatoptions(formatoptions);
        String schemeField = element.getAttributeValue("schemeField");
        if (StringUtils.isEmpty((String)schemeField)) {
            formatter = "";
        }
        fieldInfo.setSchemeField(schemeField);
        String dataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)dataType)) {
            fieldInfo.setDataType(dataType);
        }
        if (!StringUtils.isEmpty((String)(type = element.getAttributeValue("type")))) {
            fieldInfo.setType(type);
        }
        if (!StringUtils.isEmpty((String)(requireAudit = element.getAttributeValue("requireAudit")))) {
            fieldInfo.setRequireAudit(Boolean.parseBoolean(requireAudit));
        }
        fieldInfo.setEntryField(this.isEntryField(name, properties));
        String defaultValue = element.getAttributeValue("defaultValue");
        if (!StringUtils.isEmpty((String)defaultValue)) {
            fieldInfo.setDefaultValue(defaultValue);
        }
        if (!StringUtils.isEmpty((String)(defaultValueExpression = element.getAttributeValue("defaultValueExpression")))) {
            fieldInfo.setDefaultValueExpression(defaultValueExpression);
        }
        if ("false".equals(_sortable_ = element.getAttributeValue("sortable"))) {
            fieldInfo.setSortable(false);
        }
        if (!StringUtils.isEmpty((String)(maxlength = element.getAttributeValue("maxlength"))) && NumberUtils.isNumber((String)maxlength)) {
            fieldInfo.setMaxLength(Integer.valueOf(maxlength));
        }
        this.initFieldAttribute(element, fieldInfo);
        return fieldInfo;
    }

    protected void initFieldAttribute(Element element, FieldInfo fieldInfo) {
        List attrs = element.getAttributes();
        if (null != attrs && attrs.size() > 0) {
            HashMap<String, String> attributes = new HashMap<String, String>(attrs.size());
            for (Attribute attr : attrs) {
                attributes.put(attr.getName(), attr.getValue());
            }
            fieldInfo.setAttributes(attributes);
        }
    }

    protected boolean isEntryField(String fieldName, Map<String, PropertyInfo> properties) {
        RelationshipType relationshipType;
        String firstName;
        PropertyInfo propertyInfo;
        return fieldName.contains(".") && properties != null && (propertyInfo = properties.get(firstName = fieldName.split("\\.")[0])) instanceof LinkPropertyInfo && RelationshipType.COMPOSITION.equals((Object)(relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType()));
    }

    protected FieldInfo newFieldInfo() {
        return new FieldInfo();
    }

    protected PropertyInfo getPropertyInfo(Map<String, PropertyInfo> properties, String name) {
        Map.Entry<String, PropertyInfo> e;
        Iterator<Map.Entry<String, PropertyInfo>> i$ = properties.entrySet().iterator();
        do {
            if (i$.hasNext()) continue;
            return null;
        } while (!name.equalsIgnoreCase((e = i$.next()).getKey()));
        return e.getValue();
    }

    private List<Map<String, Object>> assembleColumnModel(Map param) throws EASBizException {
        return this.assembleColumnModel(param, new HashSet<String>());
    }

    private List<Map<String, Object>> assembleColumnModel(Map param, Set<String> fieldSet) throws EASBizException {
        ArrayList<Map<String, Object>> list = null;
        try {
            String queryModel = MapUtils.getParam(param, "fieldList");
            if (StringUtils.isEmpty((String)queryModel)) {
                return null;
            }
            queryModel = org.apache.commons.lang.StringUtils.deleteWhitespace((String)queryModel);
            SelectorItemCollection sc = new SelectorItemCollection();
            list = new ArrayList<Map<String, Object>>();
            HashMap<String, String> map = null;
            String[] queryMode = queryModel.split(";");
            String[] properties = null;
            String columnName = null;
            for (int i = 0; i < queryMode.length; ++i) {
                properties = queryMode[i].split(",|\uff0c");
                columnName = properties[0];
                if (fieldSet.contains(columnName)) continue;
                fieldSet.add(columnName);
                sc.add(new SelectorItemInfo(columnName));
                map = new HashMap<String, String>();
                properties = queryMode[i].split(",");
                for (int j = 0; j < properties.length; ++j) {
                    map.put(FIELDPROPERTIES[j], properties[j]);
                }
                sc.add(new SelectorItemInfo(columnName));
                list.add(map);
            }
            param.put("SelectorItemCollection", sc);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARSEFIELDOFOSF);
        }
        return list;
    }

    static {
        customerFieldTypeMap.put("weight", FieldType.Number);
        customerFieldTypeMap.put("tarScore", FieldType.Number);
        customerFieldTypeMap.put("score", FieldType.Number);
        customerFieldTypeMap.put("indecatorType", FieldType.F7);
        customerFieldTypeMap.put("indecatorDesc", FieldType.LongText);
        customerFieldTypeMap.put("comment", FieldType.LongText);
        customerFieldTypeMap.put("updateDate", FieldType.Date);
        customerFieldTypeMap.put("planedDate", FieldType.Date);
        customerFieldTypeMap.put("actualCompleValue", FieldType.Number);
        customerFieldTypeMap.put("targetValue", FieldType.Number);
        customerFieldTypeMap.put("actualCompleteDesc", FieldType.LongText);
        customerFieldTypeMap.put("scoringFormula", FieldType.F7);
        customerFieldTypeMap.put("evalStandard", FieldType.LongText);
        customerFieldTypeMap.put("actualComplete", FieldType.LongText);
        customerFieldTypeMap.put("rejection", FieldType.Boolean);
        customerFieldTypeMap.put("isVisible", FieldType.Select);
        customerFieldTypeMap.put("compleProgress", FieldType.Number);
        customerFieldTypeMap.put("remark", FieldType.LongText);
        customerFieldTypeMap.put("rema", FieldType.LongText);
        customerFieldTypeMap.put("measureStandard", FieldType.LongText);
        customerFieldTypeMap.put("actualCompleteTime", FieldType.Date);
        customerFieldTypeMap.put("completeTime", FieldType.Date);
        f7DataSourceMap = new HashMap<String, String>();
        String indecatorTypeOSF = "getIndicatorTypeListService";
        f7DataSourceMap.put("INDECATORTYPE", indecatorTypeOSF);
        f7DataSourceMap.put("FINDECATORTYPE", indecatorTypeOSF);
        String scoringFormulaOSF = "getFormulaListService";
        f7DataSourceMap.put("SCORINGFORMULA", scoringFormulaOSF);
        f7DataSourceMap.put("FSCORINGFORMULA", scoringFormulaOSF);
    }
}

