/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.FieldInfo;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.util.XmlUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class InterviewConverter
extends CoreConverter {
    @Override
    public List<SimpleFieldInfo> buildSimpleFieldsByUipk(Context ctx, String uipk, Map map) throws EASBizException, BOSException, SQLException {
        Map<String, String> stringStringMap = this.parseUIView(ctx, uipk);
        String content = stringStringMap.get("content");
        String model = stringStringMap.get("model");
        String type = stringStringMap.get("type");
        Document doc = XmlUtil.parseXML(content);
        Element root = doc.getRootElement();
        List<FieldInfo> fields = this.getFields(ctx, root, model, type, uipk);
        this.toMultiLangAlias(ctx, fields, uipk);
        List<SimpleFieldInfo> simpleFieldInfos = this.transToSimpleFields(ctx, fields, map);
        this.detailHiddenAttr(simpleFieldInfos, root);
        return simpleFieldInfos;
    }

    private void detailHiddenAttr(List<SimpleFieldInfo> simpleFieldInfos, Element root) {
        if (root != null && root.getChildren() != null) {
            List children = root.getChildren();
            Element element = null;
            String elementName = null;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                elementName = element.getName();
                if ("span".equalsIgnoreCase(elementName) && "show_span".equals(element.getAttributeValue("class"))) {
                    String[] s;
                    String forName = element.getAttributeValue("for");
                    String id = element.getAttributeValue("id");
                    if (StringUtils.isEmpty((String)id) || (s = id.split("_")).length != 2) continue;
                    String v = s[1];
                    for (SimpleFieldInfo info : simpleFieldInfos) {
                        if (!info.getFieldName().equalsIgnoreCase(v)) continue;
                        info.setHidden("false".equalsIgnoreCase(element.getText()));
                        info.setFieldType(FieldType.LongText);
                    }
                    continue;
                }
                this.detailHiddenAttr(simpleFieldInfos, element);
            }
        }
    }

    @Override
    protected FieldInfo assembleFieldInfo(Element element, String entityName, Map<String, PropertyInfo> properties) {
        String maxlength;
        String _sortable_;
        String defaultValueExpression;
        String requireAudit;
        String type;
        String formatter;
        Element parent;
        List<String> valueList = Arrays.asList("value1", "value2", "value3", "value4", "value5", "value6", "value7");
        String name = element.getAttributeValue("name");
        PropertyInfo propertyInfo = null;
        if (!StringUtils.isEmpty((String)entityName)) {
            if (name.contains(".")) {
                propertyInfo = MetaDataUtil.getPropertyInfo(entityName, name);
            } else if (properties != null && null == (propertyInfo = properties.get(name))) {
                propertyInfo = this.getPropertyInfo(properties, name);
            }
        }
        FieldInfo fieldInfo = this.newFieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setProperty(propertyInfo);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((String)label) && propertyInfo != null) {
            label = propertyInfo.getAlias(Locale.CHINA);
        }
        if (StringUtils.isEmpty((String)label)) {
            label = name;
        }
        fieldInfo.setAlias(label);
        if (valueList.contains(name) && (parent = element.getParentElement()) != null) {
            String caption = parent.getAttributeValue("caption");
            fieldInfo.setAlias(caption);
        }
        if (StringUtils.isEmpty((String)(formatter = element.getAttributeValue("formatter")))) {
            formatter = "";
        }
        fieldInfo.setFormatter(formatter);
        String formatoptions = element.getAttributeValue("formatoptions");
        if (StringUtils.isEmpty((String)formatoptions)) {
            formatoptions = "";
        }
        fieldInfo.setFormatoptions(formatoptions);
        String schemeField = element.getAttributeValue("schemeField");
        if (StringUtils.isEmpty((String)schemeField)) {
            formatter = "";
        }
        fieldInfo.setSchemeField(schemeField);
        String dataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)dataType)) {
            fieldInfo.setDataType(dataType);
        }
        if (!StringUtils.isEmpty((String)(type = element.getAttributeValue("type")))) {
            fieldInfo.setType(type);
        }
        if (!StringUtils.isEmpty((String)(requireAudit = element.getAttributeValue("requireAudit")))) {
            fieldInfo.setRequireAudit(Boolean.parseBoolean(requireAudit));
        }
        fieldInfo.setEntryField(super.isEntryField(name, properties));
        String defaultValue = element.getAttributeValue("defaultValue");
        if (!StringUtils.isEmpty((String)defaultValue)) {
            fieldInfo.setDefaultValue(defaultValue);
        }
        if (!StringUtils.isEmpty((String)(defaultValueExpression = element.getAttributeValue("defaultValueExpression")))) {
            fieldInfo.setDefaultValueExpression(defaultValueExpression);
        }
        if ("false".equals(_sortable_ = element.getAttributeValue("sortable"))) {
            fieldInfo.setSortable(false);
        }
        if (!StringUtils.isEmpty((String)(maxlength = element.getAttributeValue("maxlength"))) && NumberUtils.isNumber((String)maxlength)) {
            fieldInfo.setMaxLength(Integer.valueOf(maxlength));
        }
        super.initFieldAttribute(element, fieldInfo);
        return fieldInfo;
    }
}

