/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.util.XmlUtil;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.springframework.util.CollectionUtils;

public class UIViewArgumentParser {
    public static Map<String, Map<String, String>> parseViewArguments(Context ctx, Map<String, Set<String>> confKeysMap) throws BOSException, SQLException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        CoreConverter coreConverter = new CoreConverter();
        Set<String> uipks = confKeysMap.keySet();
        if (uipks == null) {
            return result;
        }
        for (String uipk : uipks) {
            Map<String, String> parseUIViewMap = coreConverter.parseUIView(ctx, uipk);
            if (CollectionUtils.isEmpty(parseUIViewMap)) continue;
            String content = parseUIViewMap.get("content");
            String isExt = parseUIViewMap.get("isExt");
            if (!StringUtils.isNotBlank((CharSequence)content) || !"1".equalsIgnoreCase(isExt)) continue;
            Document doc = XmlUtil.parseXML(content);
            Element root = doc.getRootElement();
            Set<String> confKeys = confKeysMap.get(uipk);
            if (CollectionUtils.isEmpty(confKeys)) continue;
            UIViewArgumentParser.doParseViewArguments(uipk, confKeys, root, result);
        }
        return result;
    }

    private static void doParseViewArguments(String uipk, Set<String> confKeys, Element root, Map<String, Map<String, String>> result) {
        UIViewArgumentParser.getDivIdConfAttr(root, uipk, confKeys, result);
    }

    private static void getDivIdConfAttr(Element root, String uipk, Set<String> confKeys, Map<String, Map<String, String>> result) {
        if (root != null && root.getChildren() != null) {
            List children = root.getChildren();
            Element element = null;
            String elementName = null;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                elementName = element.getName();
                List subEle = element.getChildren();
                if ("div".equalsIgnoreCase(elementName)) {
                    String id = element.getAttributeValue("id");
                    if (StringUtils.isNotBlank((CharSequence)id) && confKeys.contains(id)) {
                        Map<String, String> kvMap = result.get(uipk);
                        if (kvMap == null) {
                            kvMap = new HashMap<String, String>();
                        }
                        if (element.getContent() != null && element.getContent().size() > 0) {
                            if (element.getContent().get(0) instanceof Text) {
                                kvMap.put(id, ((Text)element.getContent().get(0)).getTextTrim());
                            }
                        } else {
                            kvMap.put(id, null);
                        }
                        result.put(uipk, kvMap);
                    }
                    if (CollectionUtils.isEmpty((Collection)subEle)) continue;
                    UIViewArgumentParser.getDivIdConfAttr(element, uipk, confKeys, result);
                    continue;
                }
                UIViewArgumentParser.getDivIdConfAttr(element, uipk, confKeys, result);
            }
        }
    }
}

