/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.teamPersonalTarget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.QualiOrRation;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.serviceImpl.TargetFillService;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.ExceptionUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.MapUtils;
import com.kingdee.shr.perfweb.utils.PermissionUtils;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CompositeEvaObjectDataService
implements IHRMsfService {
    TargetFillService targetFillService = new TargetFillService();
    private static Logger logger = LoggerFactory.getLogger(CompositeEvaObjectDataService.class);
    public static final String[] HIDDENFIELDS = new String[]{"ACTUALCOMPLETEDESC", "ACTUALCOMPLETE", "ACTUALCOMPLEVALUE", "ACTUALCOMPLETETIME", "COMMENT"};

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Map<String, Object> reMap;
        try {
            HashMap<String, String> indParamMap = new HashMap<String, String>();
            indParamMap.put("fieldList", MapUtils.getParam(map, "indFieldList"));
            HashMap<String, String> recParamMap = new HashMap<String, String>();
            recParamMap.put("fieldList", MapUtils.getParam(map, "recFieldList"));
            Map<String, SimpleFieldInfo> indFieMap = this.listToMap(new CoreConverter().buildSimpleFieldsByModel(ctx, "com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTarget", indParamMap));
            Map<String, SimpleFieldInfo> recFieMap = this.listToMap(new CoreConverter().buildSimpleFieldsByModel(ctx, "com.kingdee.shr.perfweb.app.base.evalplan.RecordTarget", recParamMap));
            map.put("getTargetType", "0");
            reMap = PerfGoasFillService.getInstance().compositeEvaObjectDataAction(ctx, map);
            String evaObj = (String)map.get("evaObj");
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            String isOrg = "0";
            if (perfEvaObjectInfo != null) {
                isOrg = String.valueOf(perfEvaObjectInfo.getIsOrg().getValue());
            }
            PersonalEvaBaseBean row = (PersonalEvaBaseBean)reMap.get("rows");
            for (EvaAreaListBean areaBean : row.getEvaAreaList()) {
                Option option2;
                Option option1;
                SimpleFieldInfo fieldInfo;
                String fieldName;
                if (areaBean.getAreaType().equals("200")) {
                    for (AreaFieldBean fieldBean : areaBean.getFieldList()) {
                        fieldName = fieldBean.getColName().substring(1);
                        if (StringUtils.isEmpty((String)fieldName)) continue;
                        fieldInfo = indFieMap.get(fieldName);
                        if (fieldInfo != null) {
                            fieldBean.setFieldType(fieldInfo.getFieldType());
                            fieldBean.setOptions(fieldInfo.getOptions());
                            fieldBean.setHidden(fieldInfo.isHidden());
                        }
                        if ("INDECATORTYPE".equalsIgnoreCase(fieldName)) {
                            fieldBean.setDataSource("getIndicatorTypeListService");
                            fieldBean.setFieldType(FieldType.F7);
                        }
                        if ("SCORINGFORMULA".equalsIgnoreCase(fieldName)) {
                            fieldBean.setDataSource("getFormulaListService");
                            fieldBean.setFieldType(FieldType.F7);
                        }
                        if ("ISVISIBLE".equalsIgnoreCase(fieldName)) {
                            option1 = new Option("0", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEUNPUBLIC, ctx));
                            option2 = new Option("1", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEPUBLIC, ctx));
                            fieldBean.setFieldType(FieldType.Select);
                            fieldBean.setOptions(Arrays.asList(option1, option2));
                        }
                        if ("QUALIORRATION".equalsIgnoreCase(fieldName)) {
                            option1 = new Option("0", QualiOrRation.Quali.getAlias());
                            option2 = new Option("1", QualiOrRation.Ration.getAlias());
                            fieldBean.setFieldType(FieldType.Select);
                            fieldBean.setOptions(Arrays.asList(option1, option2));
                        }
                        if (!ArrayUtils.contains((Object[])HIDDENFIELDS, (Object)fieldName.toUpperCase())) continue;
                        fieldBean.setHidden(true);
                    }
                }
                if (!areaBean.getAreaType().equals("300")) continue;
                for (AreaFieldBean fieldBean : areaBean.getFieldList()) {
                    fieldName = fieldBean.getColName().substring(1);
                    fieldInfo = recFieMap.get(fieldName);
                    if (fieldInfo != null) {
                        fieldBean.setFieldType(fieldInfo.getFieldType());
                        fieldBean.setOptions(fieldInfo.getOptions());
                        fieldBean.setHidden(fieldInfo.isHidden());
                    }
                    if ("INDECATORTYPE".equalsIgnoreCase(fieldName)) {
                        fieldBean.setDataSource("getIndicatorTypeListService");
                        fieldBean.setFieldType(FieldType.F7);
                    }
                    if ("SCORINGFORMULA".equalsIgnoreCase(fieldName)) {
                        fieldBean.setDataSource("getFormulaListService");
                        fieldBean.setFieldType(FieldType.F7);
                    }
                    if ("ISVISIBLE".equalsIgnoreCase(fieldName)) {
                        option1 = new Option("0", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEUNPUBLIC, ctx));
                        option2 = new Option("1", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VISIBLEPUBLIC, ctx));
                        fieldBean.setFieldType(FieldType.Select);
                        fieldBean.setOptions(Arrays.asList(option1, option2));
                    }
                    if ("QUALIORRATION".equalsIgnoreCase(fieldName)) {
                        option1 = new Option("0", QualiOrRation.Quali.getAlias());
                        option2 = new Option("1", QualiOrRation.Ration.getAlias());
                        fieldBean.setFieldType(FieldType.Select);
                        fieldBean.setOptions(Arrays.asList(option1, option2));
                    }
                    if (!ArrayUtils.contains((Object[])HIDDENFIELDS, (Object)fieldName.toUpperCase())) continue;
                    fieldBean.setHidden(true);
                }
            }
            if ("0".equals(isOrg)) {
                boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetDecompose");
                reMap.put("targetDecompose", perfSumInterview);
                boolean refTarget = PermissionUtils.hasFunctionPermission(ctx, "refTarget");
                reMap.put("refTarget", refTarget);
                boolean addTarget = PermissionUtils.hasFunctionPermission(ctx, "addTarget");
                reMap.put("addTarget", addTarget);
                boolean setTargetWorkflow = PermissionUtils.hasFunctionPermission(ctx, "setTargetWorkflow");
                reMap.put("setTargetWorkflow", setTargetWorkflow);
                boolean progressUpdate = PermissionUtils.hasFunctionPermission(ctx, "progressUpdate");
                reMap.put("progressUpdate", progressUpdate);
            } else {
                boolean perfSumInterview = PermissionUtils.hasFunctionPermission(ctx, "targetOrgDecompose");
                reMap.put("targetDecompose", perfSumInterview);
                boolean refTarget = PermissionUtils.hasFunctionPermission(ctx, "refTargetOrg");
                reMap.put("refTarget", refTarget);
                boolean addTarget = PermissionUtils.hasFunctionPermission(ctx, "addTargetOrg");
                reMap.put("addTarget", addTarget);
                boolean setTargetWorkflow = PermissionUtils.hasFunctionPermission(ctx, "setTargetWorkflowOrg");
                reMap.put("setTargetWorkflow", setTargetWorkflow);
                boolean progressUpdate = PermissionUtils.hasFunctionPermission(ctx, "progressOrgUpdate");
                reMap.put("progressUpdate", progressUpdate);
            }
        }
        catch (Exception e) {
            logger.error("[perfweb]it is failed to process", (Throwable)e);
            throw ExceptionUtil.EASBizException(e.getMessage());
        }
        return reMap;
    }

    public Map<String, SimpleFieldInfo> listToMap(List<SimpleFieldInfo> list) {
        TreeMap<String, SimpleFieldInfo> map = new TreeMap<String, SimpleFieldInfo>(String.CASE_INSENSITIVE_ORDER);
        if (!CollectionUtils.isEmpty(list)) {
            for (SimpleFieldInfo info : list) {
                map.put(info.getFieldName(), info);
            }
        }
        return map;
    }
}

