/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.teamPersonalTarget;

import cn.org.rapid_framework.util.ObjectUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.serviceImpl.TargetFillService;
import com.kingdee.shr.perfweb.osf.converter.CoreConverter;
import com.kingdee.shr.perfweb.osf.model.SimpleFieldInfo;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.AdminRangeUtils;
import com.kingdee.shr.perfweb.utils.CustomPageHelper;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPerfIndicatorListService
implements IHRMsfService {
    TargetFillService targetFillService = new TargetFillService();
    private static Logger logger = LoggerFactory.getLogger(GetPerfIndicatorListService.class);

    public Object process(Context context, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            if (map.get("searchText") != null && !StringUtils.isEmpty((String)((String)map.get("searchText")))) {
                String searchText = String.valueOf(map.get("searchText"));
                map.put("fastFilterItems", "((name like '%" + searchText + "%') or (number like '%" + searchText + "%') or (typeName like '%" + searchText + "%'))");
            }
            Map<String, Object> indicatorMap = GetPerfIndicatorListService.getIndicatorList(context, map);
            resultMap.put("data", indicatorMap.get("rows"));
            resultMap.put("total", indicatorMap.get("records"));
            resultMap.put("rows", ObjectUtils.isEmpty(map.get("rows")) ? "10" : map.get("rows"));
            List<SimpleFieldInfo> simpleFieldInfos = new CoreConverter().buildSimpleFieldsByModel(context, "com.kingdee.shr.perfweb.app.base.indecator.PerfIndecator", map);
            resultMap.put("fieldList", simpleFieldInfos);
            resultMap.put("selectId", "id");
            resultMap.put("selectName", "name");
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GEINDECATORLIBERR);
        }
        return resultMap;
    }

    public static Map<String, Object> getIndicatorList(Context ctx, Map<String, Object> requestMap) throws EASBizException, WfBizException {
        HashMap<String, Object> resultMap = new HashMap();
        try {
            String indicatorTypeIdStr;
            Object page;
            Object rows;
            PerfEvaObjectInfo perfEvaObjectInfo;
            String evaOrg;
            String evaid;
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            StringBuilder getListSQLBuilder = new StringBuilder();
            ArrayList<String> conditionParams = new ArrayList<String>();
            getListSQLBuilder.append("SELECT baseInfo.FID, baseInfo.FNumber, baseInfo.FName").append(mlFlag).append(" AS FName,baseInfo.FIndecatorDesc").append(mlFlag).append(" AS FIndecatorDesc, baseInfo.FEvalStandard").append(mlFlag).append(" AS FEvalStandard,");
            for (String field : IndicatorUtils.multiTBFields4Indicator) {
                getListSQLBuilder.append("baseInfo.").append(field).append(" AS ").append(field).append(",");
            }
            getListSQLBuilder.append("baseInfo.FUseStates, baseInfo.FRefStates,");
            getListSQLBuilder.append("baseInfo.FIndecatorTypeID, baseInfo.FEFFDT, ");
            getListSQLBuilder.append("baseInfo.FQualiOrRation,baseInfo.FUnit,baseInfo.FScoringFormulaID,baseInfo.FRejection ");
            getListSQLBuilder.append(" FROM T_PEF_PerfIndecator baseInfo");
            getListSQLBuilder.append(" LEFT JOIN T_PEF_PerfIndecatorRelation indecatorRelation");
            getListSQLBuilder.append(" ON baseInfo.FID =  indecatorRelation.FBaseInfoId");
            getListSQLBuilder.append(" LEFT JOIN T_PEF_IndecatorType indicatorType");
            getListSQLBuilder.append(" ON indicatorType.FID =  baseInfo.FIndecatorTypeID");
            getListSQLBuilder.append(" WHERE baseInfo.FState=1 ");
            getListSQLBuilder.append(" AND indecatorRelation.FState=100 ");
            Set userAdminSet = AdminRangeUtils.getRangeSet(ctx, SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)"fffffff0-ffff-efff-be21-000003c649fbPERMITEM"));
            if (userAdminSet.size() > 0) {
                StringBuilder temp = new StringBuilder("(' '");
                for (String s : userAdminSet) {
                    temp.append(",'").append(s).append("'");
                }
                temp.append(")");
                getListSQLBuilder.append(" and baseInfo.fid in  ").append((CharSequence)temp);
            }
            String hrOrgUnit = requestMap.get("hrOrgUnit") == null ? "" : requestMap.get("hrOrgUnit").toString();
            String string = evaid = requestMap.get("selectedIds") == null ? "" : requestMap.get("selectedIds").toString();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaid) && !StringUtils.isEmpty((String)(evaOrg = (perfEvaObjectInfo = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectInfo("select period.perfPlan.* where id = '" + evaid + "'")).getPeriod().getPerfPlan().getHrUnitOrg().getId().toString()))) {
                hrOrgUnit = evaOrg;
            }
            if (requestMap.get("hrOrgUnit") != null && !"".equals(requestMap.get("hrOrgUnit"))) {
                getListSQLBuilder.append(" AND indecatorRelation.fhrOrgUseId = ? ");
                conditionParams.add(hrOrgUnit);
            }
            if (!ObjectUtils.isEmpty((Object)(rows = requestMap.get("rowsNum")))) {
                requestMap.put("rows", rows);
            }
            if (!ObjectUtils.isEmpty((Object)(page = requestMap.get("pageNum")))) {
                requestMap.put("page", page);
            }
            if (requestMap.get("searchText") != null && !StringUtils.isEmpty((String)((String)requestMap.get("searchText")))) {
                String searchText = String.valueOf(requestMap.get("searchText"));
                getListSQLBuilder.append(" AND ((baseInfo.FName").append(mlFlag).append(" like ?) or (baseInfo.FNumber like ?) or (indicatorType.FName").append(mlFlag).append(" like ?)) ");
                conditionParams.add("%" + searchText + "%");
                conditionParams.add("%" + searchText + "%");
                conditionParams.add("%" + searchText + "%");
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(indicatorTypeIdStr = (String)requestMap.get("filterIds")))) {
                String[] indicatorTypeIdArr = indicatorTypeIdStr.split(",");
                getListSQLBuilder.append(" and baseInfo.FIndecatorTypeID in (");
                for (int i = 0; i < indicatorTypeIdArr.length; ++i) {
                    if (i == indicatorTypeIdArr.length - 1) {
                        getListSQLBuilder.append("?");
                    } else {
                        getListSQLBuilder.append("?,");
                    }
                    conditionParams.add(indicatorTypeIdArr[i]);
                }
                getListSQLBuilder.append(") ");
            }
            resultMap = CustomPageHelper.getPageCallbackData(ctx, requestMap, getListSQLBuilder.toString(), "baseInfo.FNumber asc", new IndicatorUtils(), "001", conditionParams.toArray());
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETLISTDATAERR, ctx));
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return resultMap;
    }
}

