/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetDecomposeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetDecomposeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonalGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaFormFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IScoringFormula;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.base.bean.SelectFieldTypeConfigBean;
import com.kingdee.shr.perfweb.osf.converter.FieldTypeConverter;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractAreaTypeBaseService;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.MetaDataUtil;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.PerfPlanUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTargetService
extends AbstractAreaTypeBaseService {
    public static Logger logger = LoggerFactory.getLogger(IndicatorTargetService.class);
    private static final String TARGET_TABLE_NAME = "T_EVA_IndicatorTarget";

    @Override
    public String getTargetTableName() {
        return TARGET_TABLE_NAME;
    }

    @Override
    public void packageFiledListWithEvaAreaBeans(Context ctx, ArrayList<EvaAreaListBean> evaAreaBeanList) {
        try {
            Set<String> areaBaseIds = evaAreaBeanList.stream().map(EvaAreaListBean::getAreaId).collect(Collectors.toSet());
            EvaFormFieldConfCollection evaFormFieldColl = this.getEvaFormFieldCollByAreaBaseIds(ctx, areaBaseIds);
            if (evaFormFieldColl != null && evaFormFieldColl.size() > 0) {
                evaAreaBeanList.forEach(evaAreaListBean -> {
                    ArrayList<AreaFieldBean> fieldList = new ArrayList<AreaFieldBean>();
                    for (int j = 0; j < evaFormFieldColl.size(); ++j) {
                        PropertyInfo propertyInfo;
                        SelectFieldTypeConfigBean selectFieldTypeConfigBean;
                        String fieldTypeConfig;
                        EvaFormFieldConfInfo evaFormFieldInfo = evaFormFieldColl.get(j);
                        if (!evaAreaListBean.getAreaId().equals(evaFormFieldInfo.getAreaBase())) continue;
                        AreaFieldBean areaFieldBean = new AreaFieldBean();
                        areaFieldBean.setId(evaFormFieldInfo.getId().toString());
                        areaFieldBean.setColName(evaFormFieldInfo.getColName());
                        areaFieldBean.setShowName(evaFormFieldInfo.getShowName());
                        areaFieldBean.setRequired(evaFormFieldInfo.getIsRequired() != null && "1".equals(evaFormFieldInfo.getIsRequired().getValue()));
                        areaFieldBean.setSeqNo(evaFormFieldInfo.getSeqNo());
                        areaFieldBean.setTemplateId(evaFormFieldInfo.getFieldTemplate());
                        if (evaFormFieldInfo.getFieldShowLocation() != null) {
                            areaFieldBean.setFieldShowLocation(evaFormFieldInfo.getFieldShowLocation().getValue());
                        }
                        if (evaFormFieldInfo.getFieldMaintenanceStage() != null) {
                            areaFieldBean.setFieldMaintenanceStage(evaFormFieldInfo.getFieldMaintenanceStage().getValue());
                        }
                        areaFieldBean.setFillOverwrite(evaFormFieldInfo.getFillOverwrite());
                        if ("FINDECATORTYPE".equalsIgnoreCase(evaFormFieldInfo.getColName())) {
                            areaFieldBean.setFieldType(FieldType.F7);
                        } else {
                            areaFieldBean.setFieldType(FieldTypeConverter.toFieldType(evaFormFieldInfo.getFieldType()));
                        }
                        if (FieldType.Select.equals((Object)areaFieldBean.getFieldType()) && StringUtils.isNotBlank((CharSequence)(fieldTypeConfig = evaFormFieldInfo.getFieldTypeConfig())) && (selectFieldTypeConfigBean = (SelectFieldTypeConfigBean)JSON.parseObject((String)fieldTypeConfig, SelectFieldTypeConfigBean.class)) != null) {
                            List<Option> options = selectFieldTypeConfigBean.getOptions();
                            areaFieldBean.setOptions(options);
                        }
                        if ((propertyInfo = MetaDataUtil.getPropertyInfo(IndicatorTarget.class.getCanonicalName(), evaFormFieldInfo.getColName().substring(1))) == null) {
                            areaFieldBean.setMultiLang(false);
                        } else {
                            areaFieldBean.setMultiLang(propertyInfo.getMappingField().isMultilingual());
                        }
                        fieldList.add(areaFieldBean);
                    }
                    AreaFieldBean areaFieldBean = new AreaFieldBean();
                    areaFieldBean.setColName("FISUNITED");
                    areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                    fieldList.add(areaFieldBean);
                    evaAreaListBean.setFieldList(fieldList);
                });
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-LOADEVALUAREADATAERR...", (Throwable)e);
        }
    }

    private EvaFormFieldConfCollection getEvaFormFieldCollByAreaBaseIds(Context ctx, Set<String> areaBaseIds) throws BOSException {
        IEvaFormFieldConf ievaFormFieldConf = EvaFormFieldConfFactory.getLocalInstance(ctx);
        String areaBaseIdStr = areaBaseIds.stream().map(areaBaseId -> "'" + areaBaseId + "'").collect(Collectors.joining(","));
        EvaFormFieldConfCollection evaFormFieldColl = ievaFormFieldConf.getEvaFormFieldConfCollection(" where areaBase in (" + areaBaseIdStr + ") order by seqNo ASC");
        return evaFormFieldColl;
    }

    @Override
    public void packageTargetDetailInfo(Context ctx, IRowSet rs, EvaAreaListBean evaAreaBean, String gradeTaskNode, String personId, PerfEvaObjectInfo evaObjectInfo, String getTargetType) throws SQLException, BOSException, EASBizException {
        HashSet<String> tarIdSet = new HashSet<String>(16);
        HashSet<String> targetIdSet = new HashSet<String>(16);
        while (rs.next()) {
            targetIdSet.add(rs.getString("FID"));
        }
        HashMap<String, String> targetParentMap = new HashMap<String, String>(8);
        HashMap<String, IndicatorTargetInfo> parentIndicatorMap = new HashMap<String, IndicatorTargetInfo>(16);
        HashMap<String, IndicatorTargetInfo> indicatorMap = new HashMap<String, IndicatorTargetInfo>(16);
        HashMap<String, GradeTargetInstInfo> gtInstMap = new HashMap<String, GradeTargetInstInfo>(16);
        HashSet<String> parentSet = new HashSet<String>(8);
        this.getIndicatorTargetDataMap(ctx, targetParentMap, parentIndicatorMap, indicatorMap, parentSet, targetIdSet, evaObjectInfo, gradeTaskNode, gtInstMap, getTargetType, personId);
        BigDecimal areaWeight = BigDecimal.ZERO;
        BigDecimal areaTarScore = BigDecimal.ZERO;
        DecimalFormat df = new DecimalFormat("0.00");
        ArrayList<HashMap<String, Object>> evaIndicatorList = new ArrayList<HashMap<String, Object>>();
        rs.beforeFirst();
        Map<String, Map<String, Object>> targetExtendInfoMap = EvaFormUtil.putExtendInfos(ctx, targetIdSet);
        while (rs.next()) {
            String nodeTask;
            Object fscore;
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            String targetId = rs.getString("FID");
            IndicatorTargetInfo info = (IndicatorTargetInfo)indicatorMap.get(targetId);
            fieldValueMap.put("FGOALSSTATUS", (Object)(info.getGoalsStatus() == null ? PersonalGoalsStatusEnum.SAVE : info.getGoalsStatus()));
            fieldValueMap.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
            fieldValueMap.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
            fieldValueMap.put("FID", targetId);
            fieldValueMap.put("FREFTARGET", info.getRefTarget());
            fieldValueMap.put("FSEQ", info.getSeq());
            if ("1".equals(fieldValueMap.get("isQualityIndicator")) && !getTargetType.equals("1") && null != (fscore = fieldValueMap.get("FSCORE")) && !"".equals(fscore)) {
                BigDecimal score = new BigDecimal(String.valueOf(fscore));
                GradeTargetInstInfo gradeTargetInstInfo = (GradeTargetInstInfo)gtInstMap.get(targetId);
                if (gradeTargetInstInfo != null) {
                    GradeTaskNodeInstInfo gradeNodeInstInfo = GetEntityInfoUtils.getGradeTaskNodeInstInfoById(ctx, gradeTargetInstInfo.getGradeTaskNode().getId().toString());
                    float nodeTargetWeight = gradeNodeInstInfo.getNodeWeight();
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal nTargetWeight = new BigDecimal(String.valueOf(nodeTargetWeight));
                    score = score.multiply(nTargetWeight.divide(hundred));
                }
                fieldValueMap.put("FSCORE", Float.valueOf(PerfPortalUtils.roudUpRemainGiveDecimal(2, score.floatValue())));
            }
            String weightStr = "0";
            String tarScoreStr = "0";
            IndicatorTargetInfo parentinfo = (IndicatorTargetInfo)parentIndicatorMap.get(targetParentMap.get(targetId));
            if (parentinfo != null) {
                fieldValueMap.put("FSOURCE", parentinfo.getName());
                fieldValueMap.put("FRESPONSERNAME", parentinfo.getEvaObj().getName());
                fieldValueMap.put("FRESPONSER", parentinfo.getEvaObj().getPerson().getId().toString());
            }
            fieldValueMap.put("FEXTENDID", rs.getString("FEXTENDID"));
            if (null != gtInstMap.get(targetId)) {
                Object targetScore;
                String gradRank = "";
                GradeTargetInstInfo gtInstInfo = (GradeTargetInstInfo)gtInstMap.get(targetId);
                if (!StringUtils.isEmpty((CharSequence)gtInstInfo.getGradeRank())) {
                    gradRank = gtInstInfo.getGradeRank();
                }
                fieldValueMap.put("targetScore", (targetScore = gtInstInfo.get("targetScore")) == null ? "" : targetScore);
                fieldValueMap.put("gradeRank", gradRank);
                fieldValueMap.put("nodeTask", gtInstInfo.getGradeTaskNode().getId().toString());
                fieldValueMap.put("FCOMMENT", gtInstInfo.getComment());
                fieldValueMap.put("isRejection", (Object)gtInstInfo.getIsRejection());
            } else {
                if (evaAreaBean.getScoreOrRate().equals("0")) {
                    fieldValueMap.put("targetScore", "");
                }
                fieldValueMap.put("gradeRank", "");
                fieldValueMap.put("isRejection", (Object)YesOrNoEnum.NO);
            }
            WFNodeDefInfo wfNode = null;
            if ((getTargetType.equals("1") || getTargetType.equals("2")) && StringUtils.isNotEmpty((CharSequence)(nodeTask = (String)fieldValueMap.get("nodeTask")))) {
                GradeTaskNodeInstInfo gradeTaskNodeInstInfo = GetEntityInfoUtils.getGradeTaskNodeAndNodeDefInfoById(ctx, nodeTask);
                wfNode = gradeTaskNodeInstInfo.getWfNode();
            }
            Map<String, Object> putExtendInfo = targetExtendInfoMap.get(targetId);
            for (int m = 0; m < evaAreaBean.getFieldList().size(); ++m) {
                AreaFieldBean areaFieldBean = evaAreaBean.getFieldList().get(m);
                String colName = areaFieldBean.getColName();
                String colVal = rs.getString(colName);
                colVal = colVal == null ? "" : colVal;
                FieldType fieldType = areaFieldBean.getFieldType();
                colVal = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colVal, colName, fieldValueMap);
                if (colName.equalsIgnoreCase("FINDECATORTYPE")) {
                    IndecatorTypeInfo indecatorTypeInfo = new IndecatorTypeInfo();
                    if (!StringUtils.isEmpty((CharSequence)colVal)) {
                        indecatorTypeInfo = IndicatorUtils.getIndecatorType(ctx, colVal);
                    }
                    fieldValueMap.put(colName, indecatorTypeInfo);
                    continue;
                }
                if (colName.equalsIgnoreCase("FSCORINGFORMULA")) {
                    IScoringFormula instance;
                    ScoringFormulaInfo scoringFormulaInfo;
                    String scoringFormulaId = rs.getString(colName);
                    if (Strings.isNullOrEmpty((String)scoringFormulaId) || (scoringFormulaInfo = (instance = ScoringFormulaFactory.getLocalInstance(ctx)).getScoringFormulaInfo(" where id='" + scoringFormulaId + "'")) == null) continue;
                    HashMap<String, String> scoringFormulaMap = new HashMap<String, String>();
                    scoringFormulaMap.put("id", scoringFormulaInfo.getId().toString());
                    scoringFormulaMap.put("name", scoringFormulaInfo.getName());
                    fieldValueMap.put(colName, scoringFormulaMap);
                    fieldValueMap.put("isQualityIndicator", "1");
                    continue;
                }
                if (colName.equalsIgnoreCase("FTARSCORE") && StringUtils.isBlank((CharSequence)colVal)) {
                    colVal = "0";
                    fieldValueMap.put(colName, colVal);
                    continue;
                }
                if (colName.equalsIgnoreCase("FWEIGHT") && !StringUtils.isBlank((CharSequence)colVal)) {
                    fieldValueMap.put(colName, df.format(Double.valueOf(colVal)));
                    continue;
                }
                if (colName.startsWith("FEXTEND")) {
                    if ("0".equals(areaFieldBean.getFillOverwrite()) && !"100".equals(areaFieldBean.getFieldMaintenanceStage())) {
                        if (putExtendInfo == null || putExtendInfo.get(colName) == null) {
                            fieldValueMap.put(colName, "");
                        } else {
                            fieldValueMap.put(colName, putExtendInfo.get(colName));
                        }
                    } else {
                        fieldValueMap.put(colName, colVal);
                    }
                    String fieldMaintenanceShow = EvaFormUtil.judgeIndicatorCanEdit(evaAreaBean.getAreaId(), colName, getTargetType, wfNode);
                    if ("1".equals(getTargetType) && "100".equals(areaFieldBean.getFieldMaintenanceStage())) {
                        fieldMaintenanceShow = "2";
                    }
                    areaFieldBean.setFieldMaintenanceShow(fieldMaintenanceShow);
                    continue;
                }
                if (IndicatorUtils.multiTBField4Indicator.contains(colName.toUpperCase(Locale.ENGLISH))) {
                    fieldValueMap.put(colName + "_L1", rs.getString(colName + "_L1"));
                    fieldValueMap.put(colName + "_L2", rs.getString(colName + "_L2"));
                    fieldValueMap.put(colName + "_L3", rs.getString(colName + "_L3"));
                }
                fieldValueMap.put(colName, colVal);
            }
            if (tarIdSet.contains(rs.getString("FID"))) continue;
            int value = evaAreaBean.getCanRate();
            if (1 == value) {
                if (evaAreaBean.getScoringWay() == 1) {
                    tarScoreStr = "0".equalsIgnoreCase(evaAreaBean.getSubAreaType()) ? rs.getString("FTARSCORE") : "0";
                } else {
                    weightStr = "0".equalsIgnoreCase(evaAreaBean.getSubAreaType()) ? rs.getString("FWEIGHT") : "0";
                }
            } else {
                tarScoreStr = "0";
                weightStr = "0";
            }
            if (StringUtils.isEmpty((CharSequence)weightStr)) {
                weightStr = "0";
            }
            if (StringUtils.isEmpty((CharSequence)tarScoreStr)) {
                tarScoreStr = "0";
            }
            areaWeight = areaWeight.add(new BigDecimal(weightStr));
            areaTarScore = areaTarScore.add(new BigDecimal(tarScoreStr));
            tarIdSet.add(rs.getString("FID"));
            evaIndicatorList.add(fieldValueMap);
            Map<String, Boolean> map = PerfPlanUtils.checkCanEditActValue(ctx, targetId);
            fieldValueMap.put("isCanEditActValue", map.get(targetId));
        }
        evaAreaBean.setAreaWeight(df.format(areaWeight));
        if (evaAreaBean.getScoringWay() == 1) {
            evaAreaBean.setAreaWeight(df.format(areaTarScore));
        }
        evaAreaBean.setEvaIndicatorList(evaIndicatorList);
    }

    private void getIndicatorTargetDataMap(Context ctx, Map<String, String> targetParentMap, Map<String, IndicatorTargetInfo> parentIndicatorMap, Map<String, IndicatorTargetInfo> indicatorMap, HashSet<String> parentSet, HashSet<String> targetIdSet, PerfEvaObjectInfo perfEvaObjectInfo, String gradeTaskNode, Map<String, GradeTargetInstInfo> gradeTargetInfoMap, String getTargetType, String personId) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("decomposeTarget", targetIdSet, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add("parent");
            selector.add("targetId");
            viewInfo.setFilter(filter);
            IndicatorTargetDecomposeCollection decomposeCollection = IndicatorTargetDecomposeFactory.getLocalInstance(ctx).getIndicatorTargetDecomposeCollection(viewInfo);
            if (null != decomposeCollection && decomposeCollection.size() > 0) {
                for (int h = 0; h < decomposeCollection.size(); ++h) {
                    targetParentMap.put(decomposeCollection.get(h).getDecomposeTarget(), decomposeCollection.get(h).getParent());
                    parentSet.add(decomposeCollection.get(h).getParent());
                }
            }
            IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(ctx);
            FilterInfo parentFilter = new FilterInfo();
            parentFilter.getFilterItems().add(new FilterItemInfo("id", parentSet, CompareType.INCLUDE));
            EntityViewInfo parentViewInfo = new EntityViewInfo();
            parentViewInfo.setFilter(parentFilter);
            IndicatorTargetCollection parentColl = iIndicatorTarget.getIndicatorTargetCollection(parentViewInfo);
            if (null != parentColl && parentColl.size() > 0) {
                for (int p = 0; p < parentColl.size(); ++p) {
                    parentIndicatorMap.put(parentColl.get(p).getId().toString(), parentColl.get(p));
                }
            }
            FilterInfo indicatorFilter = new FilterInfo();
            indicatorFilter.getFilterItems().add(new FilterItemInfo("id", targetIdSet, CompareType.INCLUDE));
            EntityViewInfo indicatorViewInfo = new EntityViewInfo();
            SelectorItemCollection indicatorSic = indicatorViewInfo.getSelector();
            indicatorSic.add("id");
            indicatorSic.add("refTarget");
            indicatorSic.add("goalsStatus");
            indicatorSic.add("perfPeriod.pStartDate");
            indicatorSic.add("perfPeriod.pEndDate");
            indicatorViewInfo.setFilter(indicatorFilter);
            IndicatorTargetCollection indicatorTargetColl = iIndicatorTarget.getIndicatorTargetCollection(indicatorViewInfo);
            if (null != indicatorTargetColl && indicatorTargetColl.size() > 0) {
                for (int q = 0; q < indicatorTargetColl.size(); ++q) {
                    indicatorMap.put(indicatorTargetColl.get(q).getId().toString(), indicatorTargetColl.get(q));
                }
            }
            this.getGradeTargetInfoMap(ctx, perfEvaObjectInfo, gradeTaskNode, gradeTargetInfoMap, personId, getTargetType);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }
}

