/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTargetHIS;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTargetHIS;
import com.kingdee.shr.perfweb.app.base.evalplan.ITargetNode;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetHISCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetHISFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetHISInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonalGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetHISCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetHISFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetHISInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.IIndicatorExtendHelper;
import com.kingdee.shr.perfweb.app.base.evalrule.IndicatorExtendHelperFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.indecator.IndecatorTypeInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IScoringFormula;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.ScoringFormulaInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.ITargetReviseBill;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillFactory;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.base.bean.SelectFieldTypeConfigBean;
import com.kingdee.shr.perfweb.exception.SHRPerfWebException;
import com.kingdee.shr.perfweb.osf.converter.FieldTypeConverter;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.bean.PersonalEvaBaseBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.EvaFormUtil;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.PersonBaseUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfGoalsHisService
extends PerfGoasFillService {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService");

    public static PerfGoalsHisService getInstance() {
        return PerfGoalsHisServiceInst.instance;
    }

    public boolean deleteIndicatorTarget(Context ctx, String todeleteId, String evaObj, String billId) {
        boolean flag = true;
        String filter = todeleteId.startsWith("(") && todeleteId.endsWith(")") ? todeleteId : "('" + todeleteId + "')";
        try {
            IIndicatorTargetHIS iIndicatorTarget = IndicatorTargetHISFactory.getLocalInstance(ctx);
            IRecordTargetHIS iRecordTarget = RecordTargetHISFactory.getLocalInstance(ctx);
            ITargetNode iTargetNode = TargetNodeFactory.getLocalInstance(ctx);
            IIndicatorExtendHelper iIndicatorExtendHelper = IndicatorExtendHelperFactory.getLocalInstance(ctx);
            ArrayList<String> extendIds = new ArrayList<String>();
            if (!filter.equals("('')")) {
                String oql = "select *,extend where historyRelateId in " + filter + " and targetReviseBill = '" + billId + "'";
                IndicatorTargetHISCollection indicatorColl = iIndicatorTarget.getIndicatorTargetHISCollection(oql);
                if (!indicatorColl.isEmpty()) {
                    Iterator iterator = indicatorColl.iterator();
                    while (iterator.hasNext()) {
                        String extend;
                        IndicatorTargetHISInfo next = (IndicatorTargetHISInfo)iterator.next();
                        if ("1".equals(next.getIsUnited().getValue())) {
                            return false;
                        }
                        if (null == next.getExtend() || StringUtils.isEmpty((CharSequence)(extend = next.getExtend().getId().toString()))) continue;
                        extendIds.add(extend);
                    }
                } else {
                    oql = "select *,extend where historyRelateId in " + filter + " and targetReviseBillID = '" + billId + "'";
                    RecordTargetHISCollection recordColl = iRecordTarget.getRecordTargetHISCollection(oql);
                    if (!recordColl.isEmpty()) {
                        Iterator iterator = recordColl.iterator();
                        while (iterator.hasNext()) {
                            String extend;
                            RecordTargetHISInfo next = (RecordTargetHISInfo)iterator.next();
                            if ("1".equals(next.getIsUnited().getValue())) {
                                return false;
                            }
                            if (null == next.getExtend() || StringUtils.isEmpty((CharSequence)(extend = next.getExtend().getId().toString()))) continue;
                            extendIds.add(extend);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(extendIds)) {
                    iIndicatorExtendHelper.delete(" where id in ('" + StringUtils.join(extendIds, (String)",").replace(",", "','") + "')");
                }
            }
            iIndicatorTarget.delete(" where id in " + filter + " OR (targetReviseBill = '" + billId + "' AND historyRelateId IN " + filter + ")");
            iRecordTarget.delete(" where id in " + filter + " OR (targetReviseBillID = '" + billId + "' AND historyRelateId IN " + filter + ")");
        }
        catch (Exception e) {
            flag = false;
            logger.error("Delete instance indicators or record error, detailed information:" + e.getMessage());
        }
        return flag;
    }

    public Map<String, Object> compositeEvaObjectDataAction(Context ctx, HttpServletRequest request) throws SHRPerfWebBizException {
        String evaObj = request.getParameter("evaObj");
        String billId = request.getParameter("billId");
        try {
            PerfEvaObjectInfo evaObjInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
            Map<String, Object> map = this.compositeEvaObjectDataAction(ctx, evaObj, billId);
            return map;
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-get perfObject fail!", (Throwable)e);
            throw new SHRPerfWebBizException(SHRPerfWebBizException.GETBILLFAIL, new Object[]{e});
        }
    }

    public Map<String, Object> compositeEvaObjectDataAction(Context ctx, String evaObj, String billId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<EvaluFormAreaBaseInfo> areaBaseList = new ArrayList<EvaluFormAreaBaseInfo>();
        try {
            UserInfo userInfo = this.getUserInfo(ctx);
            PerfEvaObjectInfo evaObjInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
            if (StringUtils.isEmpty((CharSequence)billId)) {
                ITargetReviseBill instance = TargetReviseBillFactory.getLocalInstance(ctx);
                TargetReviseBillCollection coll = instance.getTargetReviseBillCollection("where evaObj='" + evaObj + "' and billState in (0,1,2)");
                billId = coll.get(0).getId().toString();
            }
            if (evaObjInfo == null) {
                logger.error("\u3010PERFWEB\u3011-perfObject not exsit! perfObjectId:" + StringUtils.defaultString((String)evaObj));
                throw new SHRPerfWebBizException(SHRPerfWebBizException.EVALUINVALID);
            }
            PerfPeriodInfo periodInfo = PersonBaseUtils.getPerfPeriodInfo(ctx, evaObjInfo.getPeriod().getId().toString());
            if (periodInfo == null) {
                logger.error("\u3010PERFWEB\u3011-perfObject period not exsit!periodId:" + evaObjInfo.getPeriod().getId().toString());
                throw new SHRPerfWebBizException(SHRPerfWebBizException.PERIODNOTEXIST);
            }
            PerfPlanInfo planInfo = PersonBaseUtils.getPerfPlanInfo(ctx, periodInfo.getPerfPlan().getId().toString());
            int targetCanEdit = planInfo.isTargetCanEdit() ? 1 : 0;
            map.put("targetCanEdit", targetCanEdit);
            String planName = planInfo.getName();
            String perfRuleName = planInfo.getPerfRule().getName();
            String perfModelName = planInfo.getPerfModel().getName();
            String perfRuleId = periodInfo.getPerfRule().getId().toString();
            String hrOrgUnit = planInfo.getHrUnitOrg().getId().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            String pStartDate = sdf.format(periodInfo.getPStartDate());
            String pEndDate = sdf.format(periodInfo.getPEndDate());
            PersonalEvaBaseBean personEvaBaseBean = new PersonalEvaBaseBean();
            personEvaBaseBean.setPeriodId(periodInfo.getId().toString());
            personEvaBaseBean.setPlanName(planName);
            personEvaBaseBean.setRuleName(perfRuleName);
            personEvaBaseBean.setPerfModelName(perfModelName);
            personEvaBaseBean.setpStartDate(pStartDate);
            personEvaBaseBean.setPersonalGoalStatus(String.valueOf(evaObjInfo.getPersonalGoalStatus().getValue()));
            personEvaBaseBean.setPersonalGoalStatusAlias(evaObjInfo.getPersonalGoalStatus().getAlias());
            personEvaBaseBean.setHrOrgUnit(hrOrgUnit);
            personEvaBaseBean.setpEndDate(pEndDate);
            personEvaBaseBean.setPeriodName(periodInfo.getName());
            PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, perfRuleId);
            map.put("scoringWay", ruleInfo.getScoringWay().getValue());
            IEvaluFormAreaBase iEvaFABase = EvaluFormAreaBaseFactory.getLocalInstance(ctx);
            StringBuffer areaBaseIdCondition = new StringBuffer("(''");
            StringBuffer evaFormABSb = new StringBuffer(" where id in ");
            EvaluFormAreaBaseCollection evaFormABColl = null;
            evaFormABSb = new StringBuffer("where performanceRule='").append(perfRuleId).append("' order by Seq ASC");
            evaFormABColl = iEvaFABase.getEvaluFormAreaBaseCollection(evaFormABSb.toString());
            ArrayList<EvaAreaListBean> evaAreaList = new ArrayList<EvaAreaListBean>();
            if (evaFormABColl != null && evaFormABColl.size() > 0) {
                for (int i = 0; i < evaFormABColl.size(); ++i) {
                    areaBaseList.add(evaFormABColl.get(i));
                    EvaAreaListBean evaAreaBean = new EvaAreaListBean();
                    EvaluFormAreaBaseInfo evaFABaseInfo = evaFormABColl.get(i);
                    String areaBaseId = evaFABaseInfo.getId().toString();
                    String areaType = evaFABaseInfo.getAreaType().getValue();
                    evaAreaBean.setAreaType(areaType);
                    evaAreaBean.setWeightControl(String.valueOf(evaFABaseInfo.getWeightControl().getValue()));
                    evaAreaBean.setCanRate(evaFABaseInfo.getCanRate().getValue());
                    evaAreaBean.setAreaControlWeight(evaFABaseInfo.getAreaWeight());
                    ArrayList<AreaFieldBean> fieldList = new ArrayList<AreaFieldBean>();
                    if (map.get("scoringWay") != null && StringUtils.isNotBlank((CharSequence)map.get("scoringWay").toString())) {
                        evaAreaBean.setScoringWay(Integer.valueOf(map.get("scoringWay").toString()));
                    } else {
                        evaAreaBean.setScoringWay(0);
                    }
                    if (areaType.equals("200")) {
                        this.assembleEvaluFormData(ctx, evaAreaBean, areaBaseId, evaFABaseInfo, fieldList, evaObj, evaAreaList, billId);
                        continue;
                    }
                    if (!areaType.equals("300")) continue;
                    this.assembleEvaluRecordData(ctx, evaAreaBean, areaBaseId, evaFABaseInfo, fieldList, evaObj, evaAreaList, billId);
                }
            }
            personEvaBaseBean.setEvaAreaList(evaAreaList);
            map.put("rows", personEvaBaseBean);
            map.put("areaBaseList", areaBaseList);
        }
        catch (EASBizException e) {
            map.put("result", e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-loading area and indicator error!", (Throwable)e);
            map.put("result", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LOADEVALUAREAANDINDICATORERR, ctx));
        }
        return map;
    }

    protected void assembleEvaluFormData(Context ctx, EvaAreaListBean evaAreaBean, String areaBaseId, EvaluFormAreaBaseInfo evaFABaseInfo, ArrayList<AreaFieldBean> fieldList, String evaObj, ArrayList<EvaAreaListBean> evaAreaList, String billId) {
        try {
            String subAreaType = "0";
            if (evaFABaseInfo.getSubAreaType() != null) {
                subAreaType = evaFABaseInfo.getSubAreaType().getValue();
            }
            evaAreaBean.setAreaId(areaBaseId);
            evaAreaBean.setAreaName(evaFABaseInfo.getName());
            evaAreaBean.setSumScoreRule(evaFABaseInfo.getSumScoreRule().getValue());
            evaAreaBean.setSubAreaType(evaFABaseInfo.getSubAreaType() == null ? "0" : evaFABaseInfo.getSubAreaType().getValue());
            EvaFormFieldConfCollection evaFormFieldColl = PersonBaseUtils.getEvaFormFieldColl(ctx, areaBaseId);
            UserInfo userInfo = this.getUserInfo(ctx);
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            String planId = perfEvaObjectInfo.getPeriod().getPerfPlan().getId().toString();
            PerfPlanInfo planInfo = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanInfo("where id = '" + planId + "'");
            if (evaFormFieldColl != null && evaFormFieldColl.size() > 0) {
                for (int j = 0; j < evaFormFieldColl.size(); ++j) {
                    String jsonString;
                    SelectFieldTypeConfigBean selectFieldTypeConfigBean;
                    String fieldTypeConfig;
                    EvaFormFieldConfInfo evaFormFieldInfo = evaFormFieldColl.get(j);
                    AreaFieldBean areaFieldBean = new AreaFieldBean();
                    areaFieldBean.setId(evaFormFieldInfo.getId().toString());
                    areaFieldBean.setColName(evaFormFieldInfo.getColName());
                    areaFieldBean.setShowName(evaFormFieldInfo.getShowName());
                    areaFieldBean.setRequired(evaFormFieldInfo.getIsRequired() != null && "1".equals(evaFormFieldInfo.getIsRequired().getValue()));
                    areaFieldBean.setSeqNo(evaFormFieldInfo.getSeqNo());
                    areaFieldBean.setTemplateId(evaFormFieldInfo.getFieldTemplate());
                    if (evaFormFieldInfo.getFieldShowLocation() != null) {
                        areaFieldBean.setFieldShowLocation(evaFormFieldInfo.getFieldShowLocation().getValue());
                    }
                    if (evaFormFieldInfo.getFieldMaintenanceStage() != null) {
                        areaFieldBean.setFieldMaintenanceStage(evaFormFieldInfo.getFieldMaintenanceStage().getValue());
                    }
                    if ("FINDECATORTYPE".equalsIgnoreCase(evaFormFieldInfo.getColName())) {
                        areaFieldBean.setFieldType(FieldType.F7);
                    } else {
                        areaFieldBean.setFieldType(FieldTypeConverter.toFieldType(evaFormFieldInfo.getFieldType()));
                    }
                    if (FieldType.Select.equals((Object)areaFieldBean.getFieldType()) && StringUtils.isNotBlank((CharSequence)(fieldTypeConfig = evaFormFieldInfo.getFieldTypeConfig())) && (selectFieldTypeConfigBean = (SelectFieldTypeConfigBean)JSON.parseObject((String)(jsonString = fieldTypeConfig), SelectFieldTypeConfigBean.class)) != null) {
                        List<Option> options = selectFieldTypeConfigBean.getOptions();
                        areaFieldBean.setOptions(options);
                    }
                    fieldList.add(areaFieldBean);
                }
                AreaFieldBean areaFieldBean = new AreaFieldBean();
                areaFieldBean.setColName("FISUNITED");
                areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                fieldList.add(areaFieldBean);
                evaAreaBean.setFieldList(fieldList);
            }
            String selectSQL = "";
            StringBuffer sqlBuffer = new StringBuffer("select indicator.FID AS FID,indicator.FEXTENDID AS FEXTENDID,indicator.FWEIGHT AS FWEIGHT,indicator.FTARSCORE AS FTARSCORE, indicator.fhistoryRelateId as fhistoryRelateId ");
            for (int k = 0; k < fieldList.size(); ++k) {
                String colName = fieldList.get(k).getColName();
                if (colName.equalsIgnoreCase("FWEIGHT") || colName.equalsIgnoreCase("FTARSCORE")) continue;
                if (colName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                    sqlBuffer.append(",helper.").append(colName).append(" AS ").append(colName);
                    continue;
                }
                if (IndicatorUtils.multiTBField4Indicator.contains(colName.toUpperCase())) {
                    sqlBuffer.append(",indicator.").append(colName + SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" AS ").append(colName);
                    continue;
                }
                sqlBuffer.append(",indicator.").append(colName).append(" AS ").append(colName);
            }
            for (String multiField : IndicatorUtils.multiTBFields4Indicator) {
                sqlBuffer.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            IRowSet rs = null;
            sqlBuffer.append(" from T_EVA_IndicatorTargetHIS indicator left join T_EVA_IndicatorExtendHelper helper on indicator.FExtendId = helper.FID where indicator.FEvaObjID=? and indicator.FAreaBaseID=? and indicator.FTargetReviseBillID=?  order by indicator.FSeq asc,  to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc,indicator.FNumber asc ,indicator.FName" + SHRPerfWebResourceUtil.getMlFlag(ctx) + " asc ");
            selectSQL = sqlBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{evaObj, areaBaseId, billId});
            ArrayList<HashMap<String, Object>> evaIndicatorList = new ArrayList<HashMap<String, Object>>();
            BigDecimal areaWeight = BigDecimal.ZERO;
            BigDecimal areaTarScore = BigDecimal.ZERO;
            DecimalFormat df = new DecimalFormat("0.00");
            if (rs != null) {
                while (rs.next()) {
                    HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
                    for (int m = 0; m < fieldList.size(); ++m) {
                        String colName = fieldList.get(m).getColName();
                        String colVal = rs.getString(colName);
                        colVal = colVal == null ? "" : colVal;
                        FieldType fieldType = fieldList.get(m).getFieldType();
                        colVal = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colVal, colName, fieldValueMap);
                        if (colName.equalsIgnoreCase("FINDECATORTYPE")) {
                            IndecatorTypeInfo indecatorTypeInfo = new IndecatorTypeInfo();
                            if (!StringUtils.isEmpty((CharSequence)colVal)) {
                                indecatorTypeInfo = IndicatorUtils.getIndecatorType(ctx, colVal);
                            }
                            fieldValueMap.put(colName, indecatorTypeInfo);
                            continue;
                        }
                        if (colName.equalsIgnoreCase("FSCORINGFORMULA")) {
                            ScoringFormulaInfo scoringFormulaInfo;
                            IScoringFormula instance = ScoringFormulaFactory.getLocalInstance(ctx);
                            String scoringFormulaId = rs.getString(colName);
                            if (Strings.isNullOrEmpty((String)scoringFormulaId) || (scoringFormulaInfo = instance.getScoringFormulaInfo(" where id='" + scoringFormulaId + "'")) == null) continue;
                            HashMap<String, String> scoringFormulaMap = new HashMap<String, String>();
                            scoringFormulaMap.put("id", scoringFormulaInfo.getId().toString());
                            scoringFormulaMap.put("name", scoringFormulaInfo.getName());
                            fieldValueMap.put(colName, scoringFormulaMap);
                            fieldValueMap.put("isQualityIndicator", "1");
                            continue;
                        }
                        if (colName.equalsIgnoreCase("FTARSCORE") && StringUtils.isBlank((CharSequence)colVal)) {
                            colVal = "0";
                            fieldValueMap.put(colName, colVal);
                            continue;
                        }
                        if (colName.equalsIgnoreCase("FWEIGHT") && !StringUtils.isBlank((CharSequence)colVal)) {
                            fieldValueMap.put(colName, df.format(Double.valueOf(colVal)));
                            continue;
                        }
                        if (IndicatorUtils.multiTBField4Indicator.contains(colName.toUpperCase())) {
                            fieldValueMap.put(colName + "_L1", rs.getString(colName + "_L1"));
                            fieldValueMap.put(colName + "_L2", rs.getString(colName + "_L2"));
                            fieldValueMap.put(colName + "_L3", rs.getString(colName + "_L3"));
                        }
                        fieldValueMap.put(colName, colVal);
                    }
                    String weightStr = "0";
                    String tarScoreStr = "0";
                    int value = evaFABaseInfo.getCanRate().getValue();
                    if (1 == value) {
                        if (evaAreaBean.getScoringWay() == 1) {
                            tarScoreStr = "0".equalsIgnoreCase(subAreaType) ? rs.getString("FTARSCORE") : "0";
                        } else {
                            weightStr = "0".equalsIgnoreCase(subAreaType) ? rs.getString("FWEIGHT") : "0";
                        }
                    } else {
                        tarScoreStr = "0";
                        weightStr = "0";
                    }
                    if (StringUtils.isEmpty((CharSequence)weightStr)) {
                        weightStr = "0";
                    }
                    if (StringUtils.isEmpty((CharSequence)tarScoreStr)) {
                        tarScoreStr = "0";
                    }
                    areaWeight = areaWeight.add(new BigDecimal(weightStr));
                    areaTarScore = areaTarScore.add(new BigDecimal(tarScoreStr));
                    String targetId = rs.getString("fhistoryRelateId");
                    if (StringUtils.isEmpty((CharSequence)targetId)) {
                        fieldValueMap.put("FID", rs.getString("FID"));
                    } else {
                        fieldValueMap.put("FID", targetId);
                    }
                    IndicatorTargetHISInfo info = IndicatorTargetHISFactory.getLocalInstance(ctx).getIndicatorTargetHISInfo("select *,perfperiod.* where id ='" + rs.getString("FID") + "'");
                    fieldValueMap.put("FGOALSSTATUS", (Object)(info.getGoalsStatus() == null ? PersonalGoalsStatusEnum.SAVE : info.getGoalsStatus()));
                    fieldValueMap.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
                    fieldValueMap.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
                    fieldValueMap.put("FEXTENDID", rs.getString("FEXTENDID"));
                    fieldValueMap.put("FREFTARGET", info.getRefTarget());
                    evaIndicatorList.add(fieldValueMap);
                }
            }
            evaAreaBean.setAreaWeight(df.format(areaWeight));
            if (evaAreaBean.getScoringWay() == 1) {
                evaAreaBean.setAreaWeight(df.format(areaTarScore));
            }
            evaAreaBean.setEvaIndicatorList(evaIndicatorList);
            evaAreaList.add(evaAreaBean);
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-loading evaluarea data error...", (Throwable)e);
        }
    }

    protected void assembleEvaluRecordData(Context ctx, EvaAreaListBean evaAreaBean, String areaBaseId, EvaluFormAreaBaseInfo evaFABaseInfo, ArrayList<AreaFieldBean> fieldList, String evaObj, ArrayList<EvaAreaListBean> evaAreaList, String billId) {
        try {
            evaAreaBean.setAreaId(areaBaseId);
            evaAreaBean.setAreaName(evaFABaseInfo.getName());
            evaAreaBean.setSumScoreRule(evaFABaseInfo.getSumScoreRule().getValue());
            RecordFieldConfCollection recordFieldColl = PersonBaseUtils.getRecordFieldColl(ctx, areaBaseId);
            UserInfo userInfo = this.getUserInfo(ctx);
            PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            if (recordFieldColl != null && recordFieldColl.size() > 0) {
                for (int j = 0; j < recordFieldColl.size(); ++j) {
                    String jsonString;
                    SelectFieldTypeConfigBean selectFieldTypeConfigBean;
                    String fieldTypeConfig;
                    RecordFieldConfInfo recordFieldInfo = recordFieldColl.get(j);
                    AreaFieldBean areaFieldBean = new AreaFieldBean();
                    areaFieldBean.setId(recordFieldInfo.getId().toString());
                    areaFieldBean.setColName(recordFieldInfo.getColName());
                    areaFieldBean.setShowName(recordFieldInfo.getShowName());
                    areaFieldBean.setRequired(recordFieldInfo.getIsRequired() != null && "1".equals(recordFieldInfo.getIsRequired().getValue()));
                    areaFieldBean.setSeqNo(recordFieldInfo.getSeqNo());
                    areaFieldBean.setTemplateId(recordFieldInfo.getFieldTemplate());
                    if (recordFieldInfo.getFieldShowLocation() != null) {
                        areaFieldBean.setFieldShowLocation(recordFieldInfo.getFieldShowLocation().getValue());
                    }
                    if (recordFieldInfo.getFieldMaintenanceStage() != null) {
                        areaFieldBean.setFieldMaintenanceStage(recordFieldInfo.getFieldMaintenanceStage().getValue());
                    }
                    if ("FINDECATORTYPE".equalsIgnoreCase(recordFieldInfo.getColName())) {
                        areaFieldBean.setFieldType(FieldType.F7);
                    } else {
                        areaFieldBean.setFieldType(FieldTypeConverter.toFieldType(recordFieldInfo.getFieldType()));
                    }
                    if (FieldType.Select.equals((Object)areaFieldBean.getFieldType()) && StringUtils.isNotBlank((CharSequence)(fieldTypeConfig = recordFieldInfo.getFieldTypeConfig())) && (selectFieldTypeConfigBean = (SelectFieldTypeConfigBean)JSON.parseObject((String)(jsonString = fieldTypeConfig), SelectFieldTypeConfigBean.class)) != null) {
                        List<Option> options = selectFieldTypeConfigBean.getOptions();
                        areaFieldBean.setOptions(options);
                    }
                    fieldList.add(areaFieldBean);
                }
                AreaFieldBean areaFieldBean = new AreaFieldBean();
                areaFieldBean.setColName("FISUNITED");
                areaFieldBean.setShowName(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.UNIFIEDTRANSMITORNOT, ctx));
                fieldList.add(areaFieldBean);
                evaAreaBean.setFieldList(fieldList);
            }
            String selectSQL = "";
            StringBuffer sqlBuffer = new StringBuffer("select indicator.FID AS FID,indicator.FEXTENDID AS FEXTENDID, indicator.fhistoryRelateId as fhistoryRelateId , indicator.FWEIGHT AS FWEIGHT,indicator.FTARSCORE AS FTARSCORE");
            for (int k = 0; k < fieldList.size(); ++k) {
                String colName = fieldList.get(k).getColName();
                if (colName.equalsIgnoreCase("FWEIGHT")) continue;
                if (colName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                    sqlBuffer.append(",helper.").append(colName).append(" AS ").append(colName);
                    continue;
                }
                if (IndicatorUtils.multiTBField4Record.contains(colName.toUpperCase())) {
                    sqlBuffer.append(",indicator.").append(colName + SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" AS ").append(colName);
                    continue;
                }
                sqlBuffer.append(",indicator.").append(colName).append(" AS ").append(colName);
            }
            for (String multiField : IndicatorUtils.multiTBFields4Record) {
                sqlBuffer.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            IRowSet rs = null;
            sqlBuffer.append(" from T_EVA_RecordTargetHIS indicator left join T_EVA_IndicatorExtendHelper helper on indicator.FExtendId = helper.FID where indicator.FEvaObjID=? and indicator.FAreaBaseID=? and indicator.FTargetReviseBillIDid=?  order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc,indicator.FKeyCode asc,indicator.FKeyItem" + SHRPerfWebResourceUtil.getMlFlag(ctx) + " asc ");
            selectSQL = sqlBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL, (Object[])new Object[]{evaObj, areaBaseId, billId});
            BigDecimal areaWeight = BigDecimal.ZERO;
            BigDecimal areaTarScore = BigDecimal.ZERO;
            DecimalFormat df = new DecimalFormat("0.00");
            ArrayList<HashMap<String, Object>> evaRecordList = new ArrayList<HashMap<String, Object>>();
            if (rs != null) {
                while (rs.next()) {
                    HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
                    for (int m = 0; m < fieldList.size(); ++m) {
                        String colName = fieldList.get(m).getColName();
                        String colValue = rs.getString(colName);
                        colValue = colValue == null ? "" : colValue;
                        FieldType fieldType = fieldList.get(m).getFieldType();
                        colValue = EvaFormUtil.setBooleanMulitLan(ctx, fieldType, colValue, colName, fieldValueMap);
                        if (colName.equalsIgnoreCase("FTARSCORE") && StringUtils.isBlank((CharSequence)colValue)) {
                            colValue = "0";
                            continue;
                        }
                        if (colName.equalsIgnoreCase("FWEIGHT") && !StringUtils.isBlank((CharSequence)colValue)) {
                            fieldValueMap.put(colName, df.format(Double.valueOf(colValue)));
                            continue;
                        }
                        if (IndicatorUtils.multiTBField4Record.contains(colName.toUpperCase())) {
                            fieldValueMap.put(colName + "_L1", rs.getString(colName + "_L1"));
                            fieldValueMap.put(colName + "_L2", rs.getString(colName + "_L2"));
                            fieldValueMap.put(colName + "_L3", rs.getString(colName + "_L3"));
                        }
                        fieldValueMap.put(colName, colValue);
                    }
                    String weightStr = "0";
                    String tarScoreStr = "0";
                    int value = evaFABaseInfo.getCanRate().getValue();
                    if (1 == value) {
                        if (evaAreaBean.getScoringWay() == 1) {
                            tarScoreStr = rs.getString("FTARSCORE");
                        } else {
                            weightStr = rs.getString("FWEIGHT");
                        }
                    } else {
                        tarScoreStr = "0";
                        weightStr = "0";
                    }
                    if (StringUtils.isEmpty((CharSequence)weightStr)) {
                        weightStr = "0";
                    }
                    if (StringUtils.isEmpty((CharSequence)tarScoreStr)) {
                        tarScoreStr = "0";
                    }
                    areaWeight = areaWeight.add(new BigDecimal(weightStr));
                    areaTarScore = areaTarScore.add(new BigDecimal(tarScoreStr));
                    String targetId = rs.getString("fhistoryRelateId");
                    if (StringUtils.isEmpty((CharSequence)targetId)) {
                        fieldValueMap.put("FID", rs.getString("FID"));
                    } else {
                        fieldValueMap.put("FID", targetId);
                    }
                    RecordTargetHISInfo info = RecordTargetHISFactory.getLocalInstance(ctx).getRecordTargetHISInfo("select *,perfperiod.* where id ='" + rs.getString("FID") + "'");
                    fieldValueMap.put("FGOALSSTATUS", (Object)(info.getGoalsStatus() == null ? PersonalGoalsStatusEnum.SAVE : info.getGoalsStatus()));
                    fieldValueMap.put("FPSTARTDATE", info.getPerfPeriod().getPStartDate());
                    fieldValueMap.put("FPENDDATE", info.getPerfPeriod().getPEndDate());
                    fieldValueMap.put("FEXTENDID", rs.getString("FEXTENDID"));
                    fieldValueMap.put("FREFTARGET", info.getRefTarget());
                    evaRecordList.add(fieldValueMap);
                }
            }
            evaAreaBean.setAreaWeight(df.format(areaWeight));
            if (evaAreaBean.getScoringWay() == 1) {
                evaAreaBean.setAreaWeight(df.format(areaTarScore));
            }
            evaAreaBean.setEvaRecordList(evaRecordList);
            evaAreaList.add(evaAreaBean);
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-loading recordarea data error...", (Throwable)e);
        }
    }

    public Map<String, Object> addIndicatorHISForArea(Context ctx, HttpServletRequest request) throws SHRPerfWebException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LinkedList<String> successIdList = IndicatorUtils.addIndicatorHISForArea(ctx, request);
            map.put("result", successIdList);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return map;
    }

    public String judgeIsRefTarget(Context ctx, String indicatorId, String isUnited) throws BOSException, SQLException {
        if (StringUtils.isEmpty((CharSequence)isUnited)) {
            isUnited = "0";
        }
        String isRefTarget = "0";
        if (!StringUtils.isEmpty((CharSequence)indicatorId)) {
            if ("0".equals(isUnited)) {
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select frefTarget from T_EVA_IndicatorTargetHIS where fid = ? union select frefTarget from T_EVA_RecordTargethis where fid = ?", (Object[])new Object[]{indicatorId, indicatorId});
                if (iRowSet != null && iRowSet.next() && !StringUtils.isEmpty((CharSequence)iRowSet.getString("frefTarget"))) {
                    isRefTarget = "1";
                }
            } else {
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select frefTarget from T_EVA_UniteIndicator where fid = ? union select frefTarget from T_EVA_UniteRecord where fid = ?", (Object[])new Object[]{indicatorId, indicatorId});
                if (iRowSet != null && iRowSet.next() && !StringUtils.isEmpty((CharSequence)iRowSet.getString("frefTarget"))) {
                    isRefTarget = "1";
                }
            }
        }
        return isRefTarget;
    }

    public static class PerfGoalsHisServiceInst {
        private static final PerfGoalsHisService instance = new PerfGoalsHisService();
    }
}

