/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjFactory;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBill4OrgInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultAppealBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryAuditBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultAppealBill;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultAppealBill4Org;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummaryAuditBill;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummaryAuditBill;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryAuditBillInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDef;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.ITargetReviseBill;
import com.kingdee.shr.perfweb.app.base.targetprocess.ITargetTransmitBill;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetReviseBillInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.IGradeTargetInst;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfWorkFlowUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.PerfWorkFlowUtils");

    public static synchronized String createWFNumber() {
        String number = "WF" + new SimpleDateFormat("yyyyMMdd").format(new Date());
        int maxNumber = 0;
        try {
            IPWorkFlowDef iPworkFlow = PWorkFlowDefFactory.getRemoteInstance();
            PWorkFlowDefCollection workFlowColl = iPworkFlow.getPWorkFlowDefCollection("where number like '" + number + "%' order by number desc");
            if (workFlowColl != null && !workFlowColl.isEmpty()) {
                Iterator archIter = workFlowColl.iterator();
                PWorkFlowDefInfo workFlowInfo = null;
                while (archIter.hasNext()) {
                    workFlowInfo = (PWorkFlowDefInfo)archIter.next();
                    int workFlowNumber = Integer.parseInt(workFlowInfo.getNumber().substring(10));
                    if (workFlowNumber <= maxNumber) continue;
                    maxNumber = workFlowNumber;
                }
            }
        }
        catch (BOSException e) {
            logger.error("generating process coding error, detailed information:" + e.getMessage());
        }
        number = ++maxNumber < 10 ? number + "0" + maxNumber : number + maxNumber;
        return number;
    }

    public static Map<String, Object> judgeWorkflowIsCanEdit(Context ctx, String wfid) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        boolean isExistsWfInstance = false;
        String message = null;
        try {
            PerfEvaObjectCollection evaObjColl;
            int i;
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
            StringBuffer oqlSb = null;
            FilterInfo filter = new FilterInfo();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)wfid)) {
                filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", (Object)wfid, CompareType.EQUALS));
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
            if (iGradeTaskNodeInst.exists(filter)) {
                isExistsWfInstance = true;
                HashSet<String> evaObjIdSet = new HashSet<String>();
                GradeTaskNodeInstCollection gradeTasknodeInstColl = iGradeTaskNodeInst.getGradeTaskNodeInstCollection(" select evaObj.id where wfNode.workFlow='" + wfid + "'");
                if (null != gradeTasknodeInstColl) {
                    int size = gradeTasknodeInstColl.size();
                    for (i = 0; i < size; ++i) {
                        if (null == gradeTasknodeInstColl.get(i).getEvaObj() || null == gradeTasknodeInstColl.get(i).getEvaObj().toString()) continue;
                        evaObjIdSet.add(gradeTasknodeInstColl.get(i).getEvaObj().getId().toString());
                    }
                    if (evaObjIdSet.size() > 0) {
                        StringBuffer idConditionSb = new StringBuffer("(").append(PerfwebStrUtils.convertListToString(new ArrayList<String>(evaObjIdSet))).append(")");
                        oqlSb = new StringBuffer("select period.id  where id in").append(idConditionSb).append(" group by period");
                    }
                }
            }
            if (oqlSb != null && isExistsWfInstance && null != (evaObjColl = iPerfEvaObject.getPerfEvaObjectCollection(oqlSb.toString())) && evaObjColl.size() > 0) {
                int collSize = evaObjColl.size();
                StringBuffer conditionSb = new StringBuffer("(''");
                for (i = 0; i < collSize; ++i) {
                    conditionSb.append(",'").append(evaObjColl.get(i).getPeriod().getId().toString()).append("'");
                }
                conditionSb.append(")");
                String l = LocaleUtils.getShortCode((Context)ctx);
                StringBuffer selectSQLSb = new StringBuffer("select e.FNAME_" + l + " as periodName,p.FNAME as planName from T_EVA_PerfPeriod p left join T_EVA_PERFPLAN e on p.FPERFPLAN =e.fid ");
                selectSQLSb.append("where p.fid in ").append(conditionSb.toString());
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQLSb.toString());
                StringBuffer messageSb = new StringBuffer(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PWFUMESSAGE1, ctx));
                while (rs.next()) {
                    messageSb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PWFUMESSAGE2, ctx, new Object[]{rs.getString("planName"), rs.getString("periodName")}));
                }
                message = messageSb.toString();
            }
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        res.put("canEdit", !isExistsWfInstance);
        res.put("message", message);
        return res;
    }

    public static Map<String, Object> judgeWFIsCanEdit(Context ctx, String wfid) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        boolean isExistsWfInstance = false;
        String message = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SYSTEMERR, ctx);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)wfid)) {
            try {
                IPerfEvaObject iPerfEvaObject;
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", (Object)wfid, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isRetain", (Object)0, CompareType.EQUALS));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                IGradeTaskNodeInst iGradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
                if (iGradeTaskNodeInst.exists(filter)) {
                    isExistsWfInstance = true;
                }
                if (!isExistsWfInstance && (iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx)).exists("where workFlow = '" + wfid + "' and (workflowStatus <> 0 or scoreTaskStatus <> '100')")) {
                    isExistsWfInstance = true;
                }
                if (isExistsWfInstance) {
                    message = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PWFUMESSAGE3, ctx);
                }
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        res.put("canEdit", !isExistsWfInstance);
        res.put("message", message);
        return res;
    }

    public static Map<String, Object> judgeEvaluRuleFormIsCanEdit(Context ctx, String ruleId) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        boolean isExistsTarget = false;
        String message = null;
        HashSet<String> periodSet = new HashSet<String>();
        try {
            IEvaluFormAreaBase iEvaluFormAreaBase;
            EvaluFormAreaBaseCollection evaluFormAreaBaseColl;
            String l = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer existTargetSql = new StringBuffer("select distinct FPerfPeriod as period from T_EVA_UniteIndicator where FEvaPlan in (");
            existTargetSql.append("select fid from T_EVA_PerfPlan where FPerfRuleID=?)").append(" union ").append("select distinct FPerfPeriod as period from T_EVA_UniteRecord  where FEvaPlan in (").append("select fid from T_EVA_PerfPlan where FPerfRuleID=?)");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existTargetSql.toString(), (Object[])new Object[]{ruleId, ruleId});
            while (rs.next()) {
                periodSet.add(rs.getString("period"));
            }
            StringBuffer existUnitedTransEvaObjSql = new StringBuffer("select distinct FPeriodID from t_eva_perfevaobject where FPeriodID in (");
            existUnitedTransEvaObjSql.append("select fid from t_eva_perfperiod where FPerfPlan in(").append("select fid from T_EVA_PerfPlan where FPerfRuleID=?").append(" )) and FUnitGoalsStatus=1");
            StringBuffer existTransTargetSql = new StringBuffer("select distinct FPerfPeriodID  from T_EVA_IndicatorTarget where FPerfPeriodID in (");
            existTransTargetSql.append("select fid from t_eva_perfperiod where FPerfRuleID = ?)");
            IRowSet rs4 = DbUtil.executeQuery((Context)ctx, (String)existTransTargetSql.toString(), (Object[])new Object[]{ruleId});
            while (rs4.next()) {
                periodSet.add(rs4.getString("FPerfPeriodID"));
            }
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)existUnitedTransEvaObjSql.toString(), (Object[])new Object[]{ruleId});
            while (rs2.next()) {
                periodSet.add(rs2.getString("FPeriodID"));
            }
            if (periodSet.size() > 0) {
                isExistsTarget = true;
                StringBuffer conditionSb = new StringBuffer("(");
                conditionSb.append(PerfwebStrUtils.convertListToString(new ArrayList<String>(periodSet))).append(")");
                StringBuffer selectSQLSb = new StringBuffer("select e.FNAME_" + l + " as periodName,p.FNAME as planName from T_EVA_PerfPeriod p left join T_EVA_PERFPLAN e on p.FPERFPLAN =e.fid ");
                selectSQLSb.append("where p.fid in ").append(conditionSb.toString());
                IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)selectSQLSb.toString());
                StringBuffer messageSb = new StringBuffer(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PWFUMESSAGE4, ctx));
                while (rs3.next()) {
                    messageSb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PWFUMESSAGE5, ctx, new Object[]{rs3.getString("planName"), rs3.getString("periodName")}));
                }
                message = messageSb.toString();
            }
            if (null != (evaluFormAreaBaseColl = (iEvaluFormAreaBase = EvaluFormAreaBaseFactory.getLocalInstance(ctx)).getEvaluFormAreaBaseCollection("select id where performanceRule='" + ruleId + "'"))) {
                res.put("evaluFormSize", evaluFormAreaBaseColl.size());
            } else {
                res.put("evaluFormSize", 0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        res.put("canEdit", !isExistsTarget);
        res.put("message", message);
        return res;
    }

    public static boolean judgeIsExistsTargetInst(Context ctx, String evaObj) {
        boolean flag = false;
        try {
            IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(ctx);
            IRecordTarget iRecordTarget = RecordTargetFactory.getLocalInstance(ctx);
            if (iIndicatorTarget.exists("where evaObj='" + evaObj + "'") || iRecordTarget.exists(" where evaObj='" + evaObj + "'")) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return flag;
    }

    public static boolean judgeIsExistsGradeTargetInst(Context ctx, String evaObj) {
        boolean flag = false;
        try {
            IGradeTargetInst iGradeTargetInst = GradeTargetInstFactory.getLocalInstance(ctx);
            if (iGradeTargetInst.exists("where evaObj='" + evaObj + "'")) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return flag;
    }

    public static Set<String> getWorkFlowByPeriod(Context ctx, String periodID, String type) {
        HashSet<String> procIdSet = new HashSet<String>();
        try {
            PerfEvaObjectCollection perfEvaObjectCollection = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection("where period = '" + periodID + "'");
            for (int i = 0; i < perfEvaObjectCollection.size(); ++i) {
                AbstractObjectCollection evaResultAppealBillCollection;
                HashSet<String> summarySet;
                EvaResultSummaryCollection summaryCollection;
                AbstractObjectCollection resultSummaryAuditBillCollection;
                PerfEvaObjectInfo perfEvaObjectInfo = perfEvaObjectCollection.get(i);
                AbstractObjectCollection approvalBillCollection = null;
                if (StringUtils.equals((String)"transmit", (String)type)) {
                    TargetTransmitBillCollection transmitBillCollection = TargetTransmitBillFactory.getLocalInstance(ctx).getTargetTransmitBillCollection(" where evaObj = '" + perfEvaObjectInfo.getId().toString() + "' ");
                    approvalBillCollection = transmitBillCollection;
                }
                if (StringUtils.equals((String)"revise", (String)type)) {
                    TargetReviseBillCollection reviseBillCollection = TargetReviseBillFactory.getLocalInstance(ctx).getTargetReviseBillCollection(" where evaObj = '" + perfEvaObjectInfo.getId().toString() + "' ");
                    approvalBillCollection = reviseBillCollection;
                }
                if (StringUtils.equals((String)"resultSummaryAuditBill", (String)type)) {
                    approvalBillCollection = resultSummaryAuditBillCollection = EvaResultSummaryAuditBillFactory.getLocalInstance(ctx).getEvaResultSummaryAuditBillCollection(" where period = '" + periodID + "' ");
                }
                if (StringUtils.equals((String)"resultAppealBill", (String)type) && (summaryCollection = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection("where period = '" + periodID + "'  ")).size() > 0) {
                    summarySet = new HashSet<String>();
                    for (int k = 0; k < summaryCollection.size(); ++k) {
                        summarySet.add(summaryCollection.get(k).getId().toString());
                    }
                    approvalBillCollection = evaResultAppealBillCollection = EvaResultAppealBillFactory.getLocalInstance(ctx).getEvaResultAppealBillCollection(" where " + new FilterItemInfo("evaResult", summarySet, CompareType.INCLUDE).toString() + " ");
                }
                if (StringUtils.equals((String)"OrgResultSummaryAuditBill", (String)type)) {
                    approvalBillCollection = resultSummaryAuditBillCollection = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx).getOrgEvaResultSummaryAuditBillCollection("where period = '" + periodID + "' ");
                }
                if (StringUtils.equals((String)"resultAppealBill4Org", (String)type) && (summaryCollection = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection("where period = '" + periodID + "'  ")).size() > 0) {
                    summarySet = new HashSet();
                    for (int k = 0; k < summaryCollection.size(); ++k) {
                        summarySet.add(summaryCollection.get(k).getId().toString());
                    }
                    approvalBillCollection = evaResultAppealBillCollection = EvaResultAppealBill4OrgFactory.getLocalInstance(ctx).getEvaResultAppealBill4OrgCollection(" where " + new FilterItemInfo("evaResult", summarySet, CompareType.INCLUDE).toString() + " ");
                }
                if (approvalBillCollection == null || approvalBillCollection.size() <= 0) continue;
                for (int j = 0; j < approvalBillCollection.size(); ++j) {
                    ProcInstBizObjCollection procInstBizObjCollection = ProcInstBizObjFactory.getLocalInstance((Context)ctx).getCollection(" select procInstID ,bizObjID where bizObjID = '" + approvalBillCollection.getObject(j).get("id").toString() + "'");
                    if (procInstBizObjCollection.size() <= 0) continue;
                    procIdSet.add(approvalBillCollection.getObject(j).get("id").toString());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("perfWeb:get period flow failed");
        }
        return procIdSet;
    }

    public static int getWorkFlowCountByPeriod(Context ctx, String periodID, String type) {
        HashSet procIdSet = new HashSet();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("billState", (Object)"1,2", CompareType.INCLUDE));
            if (StringUtils.equals((String)"transmit", (String)type)) {
                filterItems.add(new FilterItemInfo("evaObj.period", (Object)periodID));
                return TargetTransmitBillFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
            if (StringUtils.equals((String)"revise", (String)type)) {
                filterItems.add(new FilterItemInfo("evaObj.period", (Object)periodID));
                return TargetReviseBillFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
            if (StringUtils.equals((String)"resultSummaryAuditBill", (String)type)) {
                filterItems.add(new FilterItemInfo("period", (Object)periodID));
                return EvaResultSummaryAuditBillFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
            if (StringUtils.equals((String)"resultAppealBill", (String)type)) {
                filterItems.add(new FilterItemInfo("evaResult.period", (Object)periodID));
                filterItems.add(new FilterItemInfo("valid", (Object)1));
                return EvaResultAppealBillFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
            if (StringUtils.equals((String)"OrgResultSummaryAuditBill", (String)type)) {
                filterItems.add(new FilterItemInfo("period", (Object)periodID));
                return OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
            if (StringUtils.equals((String)"resultAppealBill4Org", (String)type)) {
                filterItems.add(new FilterItemInfo("evaResult.period", (Object)periodID));
                filterItems.add(new FilterItemInfo("valid", (Object)1));
                return EvaResultAppealBill4OrgFactory.getLocalInstance(ctx).getCount(viewInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("perfWeb:get period flow failed");
        }
        return 0;
    }

    public static void endWorkFlowByProcIds(Context ctx, String type, Set<String> bizIds) {
        if (bizIds.size() < 1) {
            return;
        }
        try {
            int i;
            CoreBaseCollection coreBaseCollection;
            Set<Object> bizIdSet = new HashSet();
            bizIdSet = bizIds;
            if (StringUtils.equals((String)"transmit", (String)type)) {
                ITargetTransmitBill transmitBill = TargetTransmitBillFactory.getLocalInstance(ctx);
                TargetTransmitBillCollection targetTransmitBillCollection = transmitBill.getTargetTransmitBillCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < targetTransmitBillCollection.size(); ++i) {
                    TargetTransmitBillInfo transmitBillInfo = targetTransmitBillCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)transmitBillInfo);
                }
                transmitBill.update(coreBaseCollection);
            }
            if (StringUtils.equals((String)"revise", (String)type)) {
                ITargetReviseBill iTargetReviseBill = TargetReviseBillFactory.getLocalInstance(ctx);
                TargetReviseBillCollection targetReviseBillCollection = iTargetReviseBill.getTargetReviseBillCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < targetReviseBillCollection.size(); ++i) {
                    TargetReviseBillInfo targetReviseBillInfo = targetReviseBillCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)targetReviseBillInfo);
                }
                iTargetReviseBill.update(coreBaseCollection);
            }
            if (StringUtils.equals((String)"resultSummaryAuditBill", (String)type)) {
                IEvaResultSummaryAuditBill iEvaResultSummaryAuditBill = EvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
                EvaResultSummaryAuditBillCollection evaResultSummaryAuditBillCollection = iEvaResultSummaryAuditBill.getEvaResultSummaryAuditBillCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < evaResultSummaryAuditBillCollection.size(); ++i) {
                    EvaResultSummaryAuditBillInfo resultSummaryAuditBillInfo = evaResultSummaryAuditBillCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)resultSummaryAuditBillInfo);
                }
                iEvaResultSummaryAuditBill.update(coreBaseCollection);
            }
            if (StringUtils.equals((String)"OrgResultSummaryAuditBill", (String)type)) {
                IEvaResultAppealBill iEvaResultAppealBill = EvaResultAppealBillFactory.getLocalInstance(ctx);
                EvaResultAppealBillCollection evaResultAppealBillCollection = iEvaResultAppealBill.getEvaResultAppealBillCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < evaResultAppealBillCollection.size(); ++i) {
                    EvaResultAppealBillInfo evaResultAppealBillInfo = evaResultAppealBillCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)evaResultAppealBillInfo);
                }
                iEvaResultAppealBill.update(coreBaseCollection);
            }
            if (StringUtils.equals((String)"OrgResultSummaryAuditBill", (String)type)) {
                IOrgEvaResultSummaryAuditBill iOrgEvaResultSummaryAuditBill = OrgEvaResultSummaryAuditBillFactory.getLocalInstance(ctx);
                OrgEvaResultSummaryAuditBillCollection orgEvaResultSummaryAuditBillCollection = iOrgEvaResultSummaryAuditBill.getOrgEvaResultSummaryAuditBillCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < orgEvaResultSummaryAuditBillCollection.size(); ++i) {
                    OrgEvaResultSummaryAuditBillInfo orgEvaResultSummaryAuditBillInfo = orgEvaResultSummaryAuditBillCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)orgEvaResultSummaryAuditBillInfo);
                }
                iOrgEvaResultSummaryAuditBill.update(coreBaseCollection);
            }
            if (StringUtils.equals((String)"resultAppealBill4Org", (String)type)) {
                IEvaResultAppealBill4Org iEvaResultAppealBill4Org = EvaResultAppealBill4OrgFactory.getLocalInstance(ctx);
                EvaResultAppealBill4OrgCollection evaResultAppealBill4OrgCollection = iEvaResultAppealBill4Org.getEvaResultAppealBill4OrgCollection(" where " + new FilterItemInfo("id", bizIdSet, CompareType.INCLUDE));
                coreBaseCollection = new CoreBaseCollection();
                for (i = 0; i < evaResultAppealBill4OrgCollection.size(); ++i) {
                    EvaResultAppealBill4OrgInfo evaResultAppealBill4OrgInfo = evaResultAppealBill4OrgCollection.get(i);
                    coreBaseCollection.add((CoreBaseInfo)evaResultAppealBill4OrgInfo);
                }
                iEvaResultAppealBill4Org.update(coreBaseCollection);
            }
            StringBuffer procIdsStrBu = new StringBuffer();
            Iterator<String> iterator = bizIds.iterator();
            while (iterator.hasNext()) {
                procIdsStrBu.append(iterator.next() + ",");
            }
            String procIdsStr = procIdsStrBu.substring(0, procIdsStrBu.length() - 1);
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            svc.abortProcessByHoldedObjectId(procIdsStr);
        }
        catch (BOSException e) {
            logger.error("perfWeb:stop period flow failed" + (Object)((Object)e));
        }
        catch (EASBizException e) {
            logger.error("perfWeb:stop period flow failed:" + (Object)((Object)e));
        }
    }
}

