/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.PerfEvaObjRejectionAreaCollection;
import com.kingdee.shr.perfweb.app.workflow.PerfEvaObjRejectionAreaFactory;
import com.kingdee.shr.perfweb.app.workflow.PerfEvaObjRejectionAreaInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfInvolveScoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(PerfInvolveScoreUtils.class);

    public static Map<String, Map<String, String>> getCalcNodeSumScore(Context ctx, Set<String> nodeToEvaSet) throws BOSException {
        HashSet<String> nodeIds = new HashSet<String>();
        HashSet<String> evaIds = new HashSet<String>();
        HashMap<String, String> nodeToEvaMap = new HashMap<String, String>(nodeToEvaSet.size());
        for (String nodeToEva : nodeToEvaSet) {
            String[] nodeToEvaArr = nodeToEva.split("##");
            nodeIds.add(nodeToEvaArr[0]);
            evaIds.add(nodeToEvaArr[1]);
            nodeToEvaMap.put(nodeToEvaArr[0], nodeToEvaArr[1]);
        }
        Map<String, PerfEvaObjectInfo> evaObjectInfoMap = PerfInvolveScoreUtils.getEvaObjectInfoMap(ctx, evaIds);
        HashMap<String, List<GradeTargetInstInfo>> nodeToTargetMap = new HashMap<String, List<GradeTargetInstInfo>>();
        HashMap<String, String> nodeNeedScoreMap = new HashMap<String, String>();
        HashSet<String> areaIds = new HashSet<String>();
        HashSet<String> targetIds = new HashSet<String>();
        PerfInvolveScoreUtils.getNodeToTargetMapAndNeedScoreMap(ctx, nodeIds, nodeToTargetMap, nodeNeedScoreMap, areaIds, targetIds);
        Map<String, List<PerfEvaObjRejectionAreaInfo>> evaAreaInfoMap = PerfInvolveScoreUtils.getEvaAreaInfoMap(ctx, evaIds, areaIds);
        Map<String, IndicatorTargetInfo> targetWeightMap = PerfInvolveScoreUtils.getTargetWeightMap(ctx, targetIds);
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        for (String gradeTaskNode : nodeToTargetMap.keySet()) {
            String isVetoZero;
            boolean hasRejection;
            String sumScore;
            HashMap<String, String> sumScoreMap;
            block15: {
                List gradeTargetInstInfos;
                sumScoreMap = new HashMap<String, String>(2);
                sumScore = null;
                hasRejection = false;
                isVetoZero = "0";
                PerfEvaObjectInfo evaObjectInfo = evaObjectInfoMap.get(nodeToEvaMap.get(gradeTaskNode));
                int scoringWay = evaObjectInfo.getPeriod().getPerfRule().getScoringWay().getValue();
                if ("0".equals(nodeNeedScoreMap.get(gradeTaskNode)) || CollectionUtils.isEmpty((Collection)(gradeTargetInstInfos = (List)nodeToTargetMap.get(gradeTaskNode)))) break block15;
                for (GradeTargetInstInfo gradeTargetInstInfo : gradeTargetInstInfos) {
                    IndicatorTargetInfo indicatorTargetInfo;
                    boolean sumScoreRuleFlag;
                    float nTargetWeight;
                    boolean isVetoToAreaZeroFlag;
                    block17: {
                        block16: {
                            String sumScoreRule;
                            isVetoToAreaZeroFlag = false;
                            String nodeTargetWeight = gradeTargetInstInfo.getNodeTargetWeight();
                            int isRejection = 0;
                            if (null != gradeTargetInstInfo.getIsRejection()) {
                                isRejection = gradeTargetInstInfo.getIsRejection().getValue();
                            }
                            nTargetWeight = 100.0f;
                            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeTargetWeight)) {
                                nTargetWeight = Float.parseFloat(nodeTargetWeight);
                            }
                            boolean bl = sumScoreRuleFlag = (sumScoreRule = gradeTargetInstInfo.getAreaBase().getSumScoreRule().getValue()).equals("300") || sumScoreRule.equals("400");
                            if (isRejection != 1 || null == gradeTargetInstInfo.getAreaBase().getRejection()) break block16;
                            hasRejection = true;
                            if (!gradeTargetInstInfo.getAreaBase().getRejection().getValue().equals("200")) break block17;
                            sumScoreRuleFlag = false;
                            break block17;
                        }
                        List<PerfEvaObjRejectionAreaInfo> rejectionAreaInfos = evaAreaInfoMap.get(gradeTargetInstInfo.getEvaObj().getId().toString() + "##" + gradeTargetInstInfo.getAreaBase().getId().toString());
                        if (!CollectionUtils.isEmpty(rejectionAreaInfos)) {
                            for (PerfEvaObjRejectionAreaInfo rejectionAreaInfo : rejectionAreaInfos) {
                                if (!rejectionAreaInfo.getRejection().getValue().equals("200")) continue;
                                sumScoreRuleFlag = false;
                                isVetoToAreaZeroFlag = true;
                                break;
                            }
                        }
                    }
                    if (null == gradeTargetInstInfo.get("targetScore")) continue;
                    float targetScore = gradeTargetInstInfo.getTargetScore();
                    String target = gradeTargetInstInfo.getTarget();
                    String targetType = gradeTargetInstInfo.getTargetType().getValue();
                    if (!targetType.equals("200") || (indicatorTargetInfo = targetWeightMap.get(target)) == null) continue;
                    String weight = indicatorTargetInfo.getWeight();
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)weight) && scoringWay == 0) {
                        weight = "0";
                    }
                    if (null != evaObjectInfo.getPeriod().getPerfPlan().getIsShowQuantity()) {
                        sumScoreMap.put("showTarget", String.valueOf(evaObjectInfo.getPeriod().getPerfPlan().getIsShowQuantity().getValue()));
                    }
                    if (sumScoreRuleFlag) {
                        BigDecimal hundred = new BigDecimal("100");
                        if (scoringWay == 0) {
                            BigDecimal weightData = new BigDecimal(String.valueOf(targetScore)).multiply(new BigDecimal(weight)).divide(hundred).multiply(new BigDecimal(String.valueOf(nTargetWeight))).divide(hundred);
                            sumScore = null != sumScore ? new BigDecimal(sumScore).add(weightData).toString() : weightData.toString();
                        }
                        if (scoringWay != 1) continue;
                        BigDecimal scoreData = new BigDecimal(String.valueOf(targetScore)).multiply(new BigDecimal(String.valueOf(nTargetWeight))).divide(hundred);
                        if (null != sumScore) {
                            sumScore = new BigDecimal(sumScore).add(scoreData).toString();
                            continue;
                        }
                        sumScore = scoreData.toString();
                        continue;
                    }
                    if (!isVetoToAreaZeroFlag || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sumScore)) continue;
                    sumScore = "0";
                }
            }
            if (hasRejection) {
                block4: for (String evaAndArea : evaAreaInfoMap.keySet()) {
                    List<PerfEvaObjRejectionAreaInfo> perfEvaObjRejectionAreaInfos;
                    if (!evaAndArea.split("##")[0].equals(nodeToEvaMap.get(gradeTaskNode)) || CollectionUtils.isEmpty(perfEvaObjRejectionAreaInfos = evaAreaInfoMap.get(evaAndArea))) continue;
                    for (PerfEvaObjRejectionAreaInfo objRejectionAreaInfo : perfEvaObjRejectionAreaInfos) {
                        if (!objRejectionAreaInfo.getRejection().getValue().equals("100")) continue;
                        sumScore = "0";
                        isVetoZero = "1";
                        continue block4;
                    }
                }
            }
            sumScoreMap.put("sumScore", sumScore);
            sumScoreMap.put("isVetoZero", isVetoZero);
            resultMap.put(gradeTaskNode, sumScoreMap);
        }
        return resultMap;
    }

    private static Map<String, IndicatorTargetInfo> getTargetWeightMap(Context ctx, Set<String> targetIds) throws BOSException {
        FilterInfo targetFilter = new FilterInfo();
        targetFilter.getFilterItems().add(new FilterItemInfo("id", targetIds, CompareType.INCLUDE));
        EntityViewInfo targetViewInfo = new EntityViewInfo();
        targetViewInfo.setFilter(targetFilter);
        SelectorItemCollection targetSelector = targetViewInfo.getSelector();
        targetSelector.add("id");
        targetSelector.add("weight");
        targetSelector.add("scoringFormula");
        IndicatorTargetCollection targetCollection = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(targetViewInfo);
        HashMap<String, IndicatorTargetInfo> targetMap = new HashMap<String, IndicatorTargetInfo>();
        if (targetCollection != null && targetCollection.size() > 0) {
            for (int i = 0; i < targetCollection.size(); ++i) {
                IndicatorTargetInfo indicatorTargetInfo = targetCollection.get(i);
                if (StringUtils.isEmpty((String)indicatorTargetInfo.getScoringFormula())) continue;
                targetMap.put(indicatorTargetInfo.getId().toString(), indicatorTargetInfo);
            }
        }
        return targetMap;
    }

    private static Map<String, List<PerfEvaObjRejectionAreaInfo>> getEvaAreaInfoMap(Context ctx, Set<String> evaIds, Set<String> areaIds) throws BOSException {
        FilterInfo objAreaFilter = new FilterInfo();
        objAreaFilter.getFilterItems().add(new FilterItemInfo("evaObj", evaIds, CompareType.INCLUDE));
        objAreaFilter.getFilterItems().add(new FilterItemInfo("areaBase", areaIds, CompareType.INCLUDE));
        EntityViewInfo objAreaInfo = new EntityViewInfo();
        objAreaInfo.setFilter(objAreaFilter);
        SelectorItemCollection objAreaSelector = objAreaInfo.getSelector();
        objAreaSelector.add("rejection");
        objAreaSelector.add("evaObj.id");
        objAreaSelector.add("areaBase.id");
        PerfEvaObjRejectionAreaCollection objRejectionAreaCollection = PerfEvaObjRejectionAreaFactory.getLocalInstance(ctx).getPerfEvaObjRejectionAreaCollection(objAreaInfo);
        HashMap<String, List<PerfEvaObjRejectionAreaInfo>> evaAreaInfoMap = new HashMap<String, List<PerfEvaObjRejectionAreaInfo>>();
        if (objRejectionAreaCollection != null && objRejectionAreaCollection.size() > 0) {
            for (int i = 0; i < objRejectionAreaCollection.size(); ++i) {
                PerfEvaObjRejectionAreaInfo objRejectionAreaInfo = objRejectionAreaCollection.get(i);
                String key = objRejectionAreaInfo.getEvaObj().getId().toString() + "##" + objRejectionAreaInfo.getAreaBase().getId().toString();
                ArrayList<PerfEvaObjRejectionAreaInfo> objRejectionAreaInfos = (ArrayList<PerfEvaObjRejectionAreaInfo>)evaAreaInfoMap.get(key);
                if (CollectionUtils.isEmpty((Collection)objRejectionAreaInfos)) {
                    objRejectionAreaInfos = new ArrayList<PerfEvaObjRejectionAreaInfo>();
                }
                objRejectionAreaInfos.add(objRejectionAreaInfo);
                evaAreaInfoMap.put(key, objRejectionAreaInfos);
            }
        }
        return evaAreaInfoMap;
    }

    private static void getNodeToTargetMapAndNeedScoreMap(Context ctx, Set<String> nodeIds, Map<String, List<GradeTargetInstInfo>> nodeToTargetMap, Map<String, String> nodeNeedScoreMap, Set<String> areaIds, Set<String> targetIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("gradeTaskNode", nodeIds, CompareType.INCLUDE));
        EntityViewInfo evInfo = new EntityViewInfo();
        evInfo.setFilter(filterInfo);
        SelectorItemCollection selector = evInfo.getSelector();
        selector.add("nodeTargetWeight");
        selector.add("isRejection");
        selector.add("targetScore");
        selector.add("target");
        selector.add("targetType");
        selector.add("gradeTaskNode.id");
        selector.add("gradeTaskNode.wfNode.needScore");
        selector.add("evaObj.id");
        selector.add("areaBase.id");
        selector.add("areaBase.sumScoreRule");
        selector.add("areaBase.rejection");
        GradeTargetInstCollection gradeTargetInstCollection = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection(evInfo);
        for (int i = 0; i < gradeTargetInstCollection.size(); ++i) {
            GradeTargetInstInfo gradeTargetInstInfo = gradeTargetInstCollection.get(i);
            String gradeTaskNode = gradeTargetInstInfo.getGradeTaskNode().getId().toString();
            nodeNeedScoreMap.put(gradeTaskNode, gradeTargetInstInfo.getGradeTaskNode().getWfNode().getNeedScore().getValue());
            areaIds.add(gradeTargetInstInfo.getAreaBase().getId().toString());
            targetIds.add(gradeTargetInstInfo.getTarget());
            List<GradeTargetInstInfo> gradeTargetInstInfos = nodeToTargetMap.get(gradeTaskNode);
            if (CollectionUtils.isEmpty(gradeTargetInstInfos)) {
                gradeTargetInstInfos = new ArrayList<GradeTargetInstInfo>();
            }
            gradeTargetInstInfos.add(gradeTargetInstInfo);
            nodeToTargetMap.put(gradeTaskNode, gradeTargetInstInfos);
        }
    }

    private static Map<String, PerfEvaObjectInfo> getEvaObjectInfoMap(Context ctx, Set<String> evaIds) throws BOSException {
        FilterInfo evaFilter = new FilterInfo();
        evaFilter.getFilterItems().add(new FilterItemInfo("id", evaIds, CompareType.INCLUDE));
        EntityViewInfo evaInfo = new EntityViewInfo();
        evaInfo.setFilter(evaFilter);
        SelectorItemCollection evaInfoSelector = evaInfo.getSelector();
        evaInfoSelector.add("period.perfPlan.isShowQuantity");
        evaInfoSelector.add("period.perfRule.scoringWay");
        PerfEvaObjectCollection perfEvaObjectCollection = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection(evaInfo);
        HashMap<String, PerfEvaObjectInfo> evaObjectInfoMap = new HashMap<String, PerfEvaObjectInfo>(perfEvaObjectCollection.size());
        for (int i = 0; i < perfEvaObjectCollection.size(); ++i) {
            PerfEvaObjectInfo perfEvaObjectInfo = perfEvaObjectCollection.get(i);
            evaObjectInfoMap.put(perfEvaObjectInfo.getId().toString(), perfEvaObjectInfo);
        }
        return evaObjectInfoMap;
    }
}

