/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfPeriodUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfPeriodUtils.class);

    public static void setPeriodNameByPlanName(Context ctx, String planName, String planName_l1, String planName_l2, String planName_l3, PerfPeriodInfo perfPeriodInfo) {
        String periodName = planName + "_" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERIODDESC, ctx);
        String periodName_l1 = planName_l1 + "_" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERIODDESC, LocaleUtils.locale_L1);
        String periodName_l2 = planName_l2 + "_" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERIODDESC, LocaleUtils.locale_L2);
        String periodName_l3 = planName_l3 + "_" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERIODDESC, LocaleUtils.locale_L3);
        String year = perfPeriodInfo.getYear();
        String timePeriod = perfPeriodInfo.getTimePeriod();
        switch (perfPeriodInfo.getCycleType().getValue()) {
            case 100: {
                periodName = periodName + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{year});
                periodName_l1 = periodName_l1 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, LocaleUtils.locale_L1, new Object[]{year});
                periodName_l2 = periodName_l2 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, LocaleUtils.locale_L2, new Object[]{year});
                periodName_l3 = periodName_l3 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, LocaleUtils.locale_L3, new Object[]{year});
                break;
            }
            case 200: {
                String timeStr = "1".equals(timePeriod) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{year}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{year});
                String timeStr_l1 = "1".equals(timePeriod) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, LocaleUtils.locale_L1, new Object[]{year}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, LocaleUtils.locale_L1, new Object[]{year});
                String timeStr_l2 = "1".equals(timePeriod) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, LocaleUtils.locale_L2, new Object[]{year}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, LocaleUtils.locale_L2, new Object[]{year});
                String timeStr_l3 = "1".equals(timePeriod) ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, LocaleUtils.locale_L3, new Object[]{year}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, LocaleUtils.locale_L3, new Object[]{year});
                periodName = periodName + timeStr;
                periodName_l1 = periodName_l1 + timeStr_l1;
                periodName_l2 = periodName_l2 + timeStr_l2;
                periodName_l3 = periodName_l3 + timeStr_l3;
                break;
            }
            case 300: {
                periodName = periodName + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, ctx, new Object[]{year, timePeriod});
                periodName_l1 = periodName_l1 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, LocaleUtils.locale_L1, new Object[]{year, timePeriod});
                periodName_l2 = periodName_l2 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, LocaleUtils.locale_L2, new Object[]{year, timePeriod});
                periodName_l3 = periodName_l3 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER, LocaleUtils.locale_L3, new Object[]{year, timePeriod});
                break;
            }
            case 400: {
                periodName = periodName + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDMONTH, ctx, new Object[]{year, timePeriod});
                periodName_l1 = periodName_l1 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDMONTH, LocaleUtils.locale_L1, new Object[]{year, timePeriod});
                periodName_l2 = periodName_l2 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDMONTH, LocaleUtils.locale_L2, new Object[]{year, timePeriod});
                periodName_l3 = periodName_l3 + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDMONTH, LocaleUtils.locale_L3, new Object[]{year, timePeriod});
                break;
            }
        }
        perfPeriodInfo.setName(periodName);
        perfPeriodInfo.setName(periodName_l1, LocaleUtils.locale_L1);
        perfPeriodInfo.setName(periodName_l2, LocaleUtils.locale_L2);
        perfPeriodInfo.setName(periodName_l3, LocaleUtils.locale_L3);
    }
}

