/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObjectMatrixWorkFlow;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsFillerObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectUnitGoalsStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsFillerObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsFillerObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsFillerObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonBatchFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetEvaluModeEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWFLevelDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWFLevelDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDefHIS;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWFLevelDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefHISFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefHISInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScorLevelDefine;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreLevelInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillCollection;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillFactory;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitBillInfo;
import com.kingdee.shr.perfweb.app.base.targetprocess.TargetTransmitWayEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PersonInchargeUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class PerfWorkFlowUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfWorkFlowUtils.class);

    public static PersonCollection getSupervisor(String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            person = iPersonFacade.getSupervisor(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getPrimarySubordinate(String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            person = iPersonFacade.getPrimarySubordinate(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getColleague(String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            person = iPersonFacade.getColleague(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getDirector(String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            person = iPersonFacade.getDirector(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static Map getSupervisor(Set personIdSet, boolean isPrimary) {
        Map supervisorMap = new HashMap();
        try {
            supervisorMap = PersonBatchFacadeFactory.getRemoteInstance().getSupervisor(personIdSet, "00000000-0000-0000-0000-000000000001396FCAD0", isPrimary);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return supervisorMap;
    }

    public static Map<String, String> getDirectSuperior(Context ctx, String position) {
        HashMap<String, String> superiorList = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)position)) {
            return superiorList;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date(System.currentTimeMillis());
            String dt2 = sdf.format(now);
            String superiorPosition = "";
            IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection posColl = iposition.getPositionCollection(" where id='" + position + "'");
            if (posColl != null && posColl.size() > 0 && posColl.get(0).getParent() != null) {
                superiorPosition = posColl.get(0).getParent().getId().toString();
            }
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            String selectSuperiorPerson = "select t.FPersonID,t3.fname" + mlFlag + " as name from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where t.FPositionID='" + superiorPosition + "' and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
            IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
            while (superiorRS.next()) {
                superiorList.put(superiorRS.getString("FPersonID"), superiorRS.getString("name"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return superiorList;
    }

    public static Map<String, Map<String, Set<String>>> getPersonByParentPersonId(Context ctx, Set<String> personIds) {
        HashMap<String, String> personToPositionMap = new HashMap<String, String>();
        HashMap<String, Map<String, Set<String>>> personToPersonsMap = new HashMap<String, Map<String, Set<String>>>();
        if (CollectionUtils.isEmpty(personIds)) {
            return personToPersonsMap;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            String dt2 = sdf.format(now);
            String selectPosition = "select t.FPersonID,t.fpositionId from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  where t.FPERSONID in (" + PerfwebStrUtils.convertListToString(personIds.toArray()) + ") and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
            IRowSet positionRs = DbUtil.executeQuery((Context)ctx, (String)selectPosition);
            while (positionRs.next()) {
                personToPositionMap.put(positionRs.getString("FPersonID"), positionRs.getString("fpositionId"));
            }
            if (!CollectionUtils.isEmpty(personToPositionMap)) {
                HashSet positionIds = new HashSet();
                for (Map.Entry entry : personToPositionMap.entrySet()) {
                    positionIds.add(entry.getValue());
                }
                IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
                PositionCollection posColl = iposition.getPositionCollection("select id, parent.id where parent in (" + PerfwebStrUtils.convertListToString(positionIds.toArray()) + ")");
                HashMap<String, HashSet<String>> positionToPosMap = new HashMap<String, HashSet<String>>(positionIds.size());
                if (posColl != null && posColl.size() > 0) {
                    HashSet<String> lowPositionIds = new HashSet<String>();
                    for (int i = 0; i < posColl.size(); ++i) {
                        PositionInfo positionInfo = posColl.get(i);
                        lowPositionIds.add(positionInfo.getId().toString());
                        String parentId = positionInfo.getParent().getId().toString();
                        HashSet<String> sonIds = (HashSet<String>)positionToPosMap.get(parentId);
                        if (CollectionUtils.isEmpty((Collection)sonIds)) {
                            sonIds = new HashSet<String>();
                        }
                        sonIds.add(positionInfo.getId().toString());
                        positionToPosMap.put(parentId, sonIds);
                    }
                    Map<String, Set<String>> positionToPersonIdsMap = PerfWorkFlowUtils.getPersonByPositionSet(ctx, lowPositionIds);
                    for (Map.Entry entry : personToPositionMap.entrySet()) {
                        String sourcePersonId = (String)entry.getKey();
                        Set sonPositionIds = (Set)positionToPosMap.get(entry.getValue());
                        if (CollectionUtils.isEmpty((Collection)sonPositionIds)) continue;
                        for (String sonPositionId : sonPositionIds) {
                            Set<String> sonPersonIds = positionToPersonIdsMap.get(sonPositionId);
                            if (CollectionUtils.isEmpty(sonPersonIds)) continue;
                            HashMap<String, Set<String>> positionToPerMap = (HashMap<String, Set<String>>)personToPersonsMap.get(sourcePersonId);
                            if (CollectionUtils.isEmpty((Map)positionToPerMap)) {
                                positionToPerMap = new HashMap<String, Set<String>>();
                            }
                            positionToPerMap.put(sonPositionId, sonPersonIds);
                            personToPersonsMap.put(sourcePersonId, positionToPerMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("getPersonByParentPersonId is error: ", (Throwable)e);
        }
        return personToPersonsMap;
    }

    public static Map<String, Set<String>> getPersonByPositionSet(Context ctx, Set<String> positionSet) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (CollectionUtils.isEmpty(positionSet)) {
            return result;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date(System.currentTimeMillis());
            String dt2 = sdf.format(now);
            String selectPerson = "select t.FPersonID, t.fpositionId from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where t.FPositionID in (" + PerfwebStrUtils.convertListToString(positionSet.toArray()) + ") and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}";
            IRowSet selectPersonRs = DbUtil.executeQuery((Context)ctx, (String)selectPerson);
            while (selectPersonRs.next()) {
                String positionId = selectPersonRs.getString("fpositionId");
                HashSet<String> personIds = (HashSet<String>)result.get(positionId);
                if (CollectionUtils.isEmpty((Collection)personIds)) {
                    personIds = new HashSet<String>();
                }
                personIds.add(selectPersonRs.getString("FPersonID"));
                result.put(positionId, personIds);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    public static Map<String, String> getPersonByPosition(Context ctx, String position) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)position)) {
            return result;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date(System.currentTimeMillis());
            String dt2 = sdf.format(now);
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            String selectSuperiorPerson = "select t.FPersonID,t3.fname" + mlFlag + " as name from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where t.FPositionID='" + position + "' and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
            IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
            while (superiorRS.next()) {
                result.put(superiorRS.getString("FPersonID"), superiorRS.getString("name"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    public static Map<String, List<PersonInfo>> getParentPosPersonByPosIdList(Context ctx, Set<Object> posIds) throws BOSException, SQLException {
        HashMap<String, List<PersonInfo>> parentPosPersonSet = new HashMap<String, List<PersonInfo>>();
        if (CollectionUtils.isEmpty(posIds)) {
            return parentPosPersonSet;
        }
        HashSet<String> parentPosSet = new HashSet<String>();
        HashMap<String, String> posAndParent = new HashMap<String, String>();
        HashMap<String, List> parentPerson = new HashMap<String, List>();
        EntityViewInfo positionViewInfo = new EntityViewInfo();
        SelectorItemCollection positionSelector = new SelectorItemCollection();
        FilterInfo positionFilter = new FilterInfo();
        positionSelector.add("parent.id");
        positionFilter.getFilterItems().add(new FilterItemInfo("id", posIds, CompareType.INCLUDE));
        positionViewInfo.setSelector(positionSelector);
        positionViewInfo.setFilter(positionFilter);
        IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
        PositionCollection posColl = iposition.getPositionCollection(positionViewInfo);
        if (posColl != null && posColl.size() > 0) {
            for (int i = 0; i < posColl.size(); ++i) {
                PositionInfo parent = posColl.get(i).getParent();
                if (parent == null) continue;
                parentPosSet.add(parent.getId().toString());
                posAndParent.put(posColl.get(i).getId().toString(), parent.getId().toString());
            }
        }
        if (CollectionUtils.isEmpty(parentPosSet)) {
            return parentPosPersonSet;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date(System.currentTimeMillis());
        String dt2 = sdf.format(now);
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        String selectSuperiorPerson = "select t.FPersonID,t3.fname" + mlFlag + " as name , t.FPositionID as parentID from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where 1=1  and  " + new FilterItemInfo("t.FPositionID ", parentPosSet, CompareType.INCLUDE).toString() + " and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
        IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
        while (superiorRS.next()) {
            List posPersonList = (List)parentPerson.get(superiorRS.getString("parentID"));
            if (CollectionUtils.isEmpty((Collection)posPersonList)) {
                ArrayList<PersonInfo> arrayList = new ArrayList<PersonInfo>();
                PersonInfo emp = new PersonInfo();
                emp.setId(BOSUuid.read((String)superiorRS.getString("FPersonID")));
                emp.setName(superiorRS.getString("name"));
                arrayList.add(emp);
                parentPerson.put(superiorRS.getString("parentID"), arrayList);
                continue;
            }
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)superiorRS.getString("FPersonID")));
            personInfo.setName(superiorRS.getString("name"));
            posPersonList.add(personInfo);
            parentPerson.put(superiorRS.getString("parentID"), posPersonList);
        }
        for (String string : posIds) {
            List posPersonList = (List)parentPerson.get(posAndParent.get(string));
            parentPosPersonSet.put(string, posPersonList);
        }
        return parentPosPersonSet;
    }

    /*
     * WARNING - void declaration
     */
    public static void setOrderAndFillerForEvaObjList(Context ctx, List<String> listData) {
        HashSet<Object> positionIdSet = new HashSet<Object>();
        Map<String, List<PersonInfo>> parentPosPersonSet = null;
        HashSet<String> perfEvaObjIdSet = new HashSet<String>();
        HashMap<String, ArrayList<String>> perfEvaObjAdmin = new HashMap<String, ArrayList<String>>();
        try {
            void var7_10;
            for (HashMap hashMap : listData) {
                String string = "";
                if (hashMap.get("position.id") != null) {
                    String string2 = hashMap.get("position.id").toString();
                    positionIdSet.add(string2);
                }
                perfEvaObjIdSet.add("'" + hashMap.get("id") + "'");
            }
            parentPosPersonSet = PerfWorkFlowUtils.getParentPosPersonByPosIdList(ctx, positionIdSet);
            PerfEvaluAdminResponsorCollection perColl = PerfEvaluAdminResponsorFactory.getRemoteInstance().getPerfEvaluAdminResponsorCollection("select person.name ,evaobj where evaobj in (" + org.apache.commons.lang3.StringUtils.join(perfEvaObjIdSet, (String)",") + ")");
            boolean bl = false;
            while (var7_10 < perColl.size()) {
                PerfEvaluAdminResponsorInfo perfEvaluAdminResponsorInfo = perColl.get((int)var7_10);
                ArrayList<String> responsorList = (ArrayList<String>)perfEvaObjAdmin.get(perfEvaluAdminResponsorInfo.getEvaObj().getId().toString());
                if (!CollectionUtils.isEmpty((Collection)responsorList)) {
                    responsorList.add(perfEvaluAdminResponsorInfo.getPerson().getName());
                } else {
                    responsorList = new ArrayList<String>();
                    responsorList.add(perfEvaluAdminResponsorInfo.getPerson().getName());
                }
                perfEvaObjAdmin.put(perfEvaluAdminResponsorInfo.getEvaObj().getId().toString(), responsorList);
                ++var7_10;
            }
            for (HashMap hashMap : listData) {
                Set<PersonInfo> personInfoSet;
                Map<String, Set<PersonInfo>> personMaps;
                Map<Object, Object> inchargeByids;
                HashSet<String> set;
                String inchargePosition;
                StringBuffer fillerSQL;
                IRowSet fillerRows;
                PersonInfo leader;
                List leaderList;
                StringBuffer odersName = new StringBuffer("");
                StringBuffer fillersName = new StringBuffer("");
                String position = "";
                String isOrg = "";
                String id = "";
                String isSelf = "0";
                String isSuperor = "0";
                String isSuperiorFiller = "0";
                String isSelfFiller = "0";
                if (hashMap.get("position.id") != null) {
                    position = hashMap.get("position.id").toString();
                }
                id = hashMap.get("id").toString();
                if (hashMap.get("isOrg") != null) {
                    isOrg = ((BizEnumValueDTO)hashMap.get("isOrg")).getValue().toString();
                }
                if (hashMap.get("isSuperior") != null) {
                    isSuperor = ((BizEnumValueDTO)hashMap.get("isSuperior")).getValue().toString();
                }
                if (hashMap.get("isSelf") != null) {
                    isSelf = ((BizEnumValueDTO)hashMap.get("isSelf")).getValue().toString();
                }
                if (hashMap.get("isSuperiorFiller") != null) {
                    isSuperiorFiller = ((BizEnumValueDTO)hashMap.get("isSuperiorFiller")).getValue().toString();
                }
                if (hashMap.get("isSelfFiller") != null) {
                    isSelfFiller = ((BizEnumValueDTO)hashMap.get("isSelfFiller")).getValue().toString();
                }
                if ("1".equals(isSuperor) && !CollectionUtils.isEmpty(leaderList = parentPosPersonSet.get(position))) {
                    Iterator<PersonInfo> it = leaderList.iterator();
                    if ("1".equals(isOrg)) {
                        while (it.hasNext()) {
                            leader = it.next();
                            odersName.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORORGWITHPREFIX, ctx, new Object[]{leader.getName()})).append(",");
                        }
                    } else {
                        while (it.hasNext()) {
                            leader = it.next();
                            odersName.append(leader.getName()).append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIOR, ctx) + "),");
                        }
                    }
                }
                if ("1".equals(isSelf)) {
                    if ("1".equals(isOrg)) {
                        leaderList = (List)perfEvaObjAdmin.get(id);
                        if (!CollectionUtils.isEmpty(leaderList)) {
                            for (int i = 0; i < leaderList.size(); ++i) {
                                odersName.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESPONSERWITHPREFIX, ctx, new Object[]{leaderList.get(i)})).append(",");
                            }
                        }
                    } else {
                        odersName.append(hashMap.get("person.name") + "(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELF, ctx) + "),");
                    }
                }
                if ("1".equals(isSuperiorFiller) && !CollectionUtils.isEmpty(leaderList = parentPosPersonSet.get(position))) {
                    Iterator<PersonInfo> it = leaderList.iterator();
                    if ("1".equals(isOrg)) {
                        while (it.hasNext()) {
                            leader = it.next();
                            fillersName.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORORGWITHPREFIX, ctx, new Object[]{leader.getName()})).append(",");
                        }
                    } else {
                        while (it.hasNext()) {
                            leader = it.next();
                            fillersName.append(leader.getName()).append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIOR, ctx) + "),");
                        }
                    }
                }
                if ("1".equals(isSelfFiller)) {
                    if ("1".equals(isOrg)) {
                        leaderList = (List)perfEvaObjAdmin.get(id);
                        if (!CollectionUtils.isEmpty((Collection)leaderList)) {
                            for (int i = 0; i < leaderList.size(); ++i) {
                                fillersName.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESPONSERWITHPREFIX, ctx, new Object[]{leaderList.get(i)})).append(",");
                            }
                        }
                    } else {
                        fillersName.append(hashMap.get("person.name") + "(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELF, ctx) + "),");
                    }
                }
                String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
                StringBuffer ordersSQL = new StringBuffer("select person.Fname" + mlFlag + " as personName from T_EVA_PerfGoalsObject lll inner join T_BD_Person person on lll.FPerson = person.fid where fperfEvaObjectId='" + id + "'");
                IRowSet orderRows = DbUtil.executeQuery((Context)ctx, (String)ordersSQL.toString());
                if (orderRows != null) {
                    while (orderRows.next()) {
                        odersName.append(orderRows.getString("personName")).append("(").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POINTPERSON, ctx)).append("),");
                    }
                }
                if ((fillerRows = DbUtil.executeQuery((Context)ctx, (String)(fillerSQL = new StringBuffer("select person.Fname" + mlFlag + " as personName from T_EVA_PerfGoalsFillerObject lll inner join T_BD_Person person on lll.FPerson = person.fid where fperfEvaObjectId='" + id + "'")).toString())) != null) {
                    while (fillerRows.next()) {
                        fillersName.append(fillerRows.getString("personName")).append("(").append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.POINTPERSON, ctx)).append("),");
                    }
                }
                int personalGoalStatus = 0;
                int unitGoalsStatus = 0;
                if (hashMap.get("personalGoalStatus") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)hashMap.get("personalGoalStatus").toString())) {
                    personalGoalStatus = ((BizEnumValueDTO)hashMap.get("personalGoalStatus")).getInt();
                }
                if (hashMap.get("unitGoalsStatus") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)hashMap.get("unitGoalsStatus").toString())) {
                    unitGoalsStatus = ((BizEnumValueDTO)hashMap.get("unitGoalsStatus")).getInt();
                }
                String string = inchargePosition = hashMap.get("personInchargePosition") == null ? "" : hashMap.get("personInchargePosition").toString();
                if (PersonInchargeUtils.isFill2PersonIncharge(inchargePosition)) {
                    set = new HashSet<String>();
                    set.add(id);
                    inchargeByids = new HashMap();
                    try {
                        if (unitGoalsStatus == 1 && (personalGoalStatus == 0 || personalGoalStatus == 1)) {
                            inchargeByids = PersonInchargeUtils.getPersonInchargeByids(ctx, set, true);
                        } else if (personalGoalStatus == 0 || personalGoalStatus == 1) {
                            inchargeByids = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, set);
                        } else {
                            try {
                                HashSet<String> receiverIds = new HashSet<String>();
                                GoalsMessageReceiverCollection goalsMessageReceiverCollection = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + id + "' and isSelf = 1  ");
                                Iterator iteratorFill = goalsMessageReceiverCollection.iterator();
                                while (iteratorFill.hasNext()) {
                                    GoalsMessageReceiverInfo next = (GoalsMessageReceiverInfo)iteratorFill.next();
                                    receiverIds.add(next.getReceiver());
                                }
                                inchargeByids.put(id, receiverIds);
                            }
                            catch (BOSException e) {
                                logger.error("getSuperiorFillerString", (Throwable)e);
                            }
                        }
                        personMaps = PersonInchargeUtils.transferInformation(ctx, inchargeByids);
                        personInfoSet = personMaps.get(id);
                        if (!CollectionUtils.isEmpty(personInfoSet) && personInfoSet.size() > 0) {
                            for (PersonInfo personInfo : personInfoSet) {
                                if (personInfo != null) {
                                    fillersName.append(personInfo.getName());
                                    if (personalGoalStatus == 0 || personalGoalStatus == 1) {
                                        fillersName.append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHARGER, ctx) + "),");
                                        continue;
                                    }
                                    fillersName.append(",");
                                    continue;
                                }
                                logger.error(personInfo.toString());
                            }
                        }
                    }
                    catch (BOSException e) {
                        logger.error("setOrderAndFillerForEvaObjList", (Throwable)e);
                    }
                }
                if (PersonInchargeUtils.isGoals2PersonIncharge(inchargePosition)) {
                    set = new HashSet();
                    set.add(id);
                    inchargeByids = null;
                    try {
                        inchargeByids = unitGoalsStatus == 0 ? PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, set) : PersonInchargeUtils.getPersonInchargeByids(ctx, set, true);
                        personMaps = PersonInchargeUtils.transferInformation(ctx, inchargeByids);
                        personInfoSet = personMaps.get(id);
                        if (personInfoSet != null) {
                            for (PersonInfo personInfo : personInfoSet) {
                                odersName.append(personInfo.getName()).append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHARGER, ctx) + "),");
                            }
                        }
                    }
                    catch (BOSException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (personalGoalStatus == 3) {
                    odersName.setLength(0);
                    try {
                        HashSet<String> receiverIds = new HashSet<String>();
                        GoalsMessageReceiverCollection goalsMessageReceiverCollection = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + id + "' and isSelf = 0  ");
                        Iterator iterator2 = goalsMessageReceiverCollection.iterator();
                        while (iterator2.hasNext()) {
                            GoalsMessageReceiverInfo next = (GoalsMessageReceiverInfo)iterator2.next();
                            receiverIds.add(next.getReceiver());
                        }
                        if (receiverIds.size() > 0) {
                            String inSql = "('" + Strings.join(receiverIds, (String)"','") + "')";
                            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id in " + inSql);
                            for (PersonInfo next : personCollection) {
                                odersName.append(next.getName()).append(",");
                            }
                        }
                    }
                    catch (BOSException e) {
                        logger.error("setOrderAndFillerForEvaObjList", (Throwable)e);
                    }
                }
                String odersNameStr = odersName.toString();
                String fillersNameStr = fillersName.toString();
                if (odersName.length() > 0) {
                    odersNameStr = odersName.substring(0, odersName.length() - 1);
                }
                if (fillersName.length() > 0) {
                    fillersNameStr = fillersName.substring(0, fillersName.length() - 1);
                }
                hashMap.put("goalsGiver", odersNameStr);
                hashMap.put("goalsFiller", fillersNameStr);
            }
        }
        catch (Exception e) {
            logger.error("perfweb:Obtain orders and fill in the person make a mistake", (Throwable)e);
        }
    }

    public static Map<String, String> getDirectSuperior(Context ctx, PerfEvaObjectInfo info) {
        HashMap<String, String> superiorList = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date(System.currentTimeMillis());
            String dt2 = sdf.format(now);
            String superiorPosition = "";
            IPosition iposition = PositionFactory.getRemoteInstance();
            String position = "";
            if (info.getAdminHis().getParent().getResponPosition() != null) {
                position = info.getAdminHis().getParent().getResponPosition().getId().toString();
            }
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            String selectSuperiorPerson = "select t.FPersonID,t3.fname" + mlFlag + " as name from T_HR_EmpOrgRelation t  left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid   left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid  inner join T_BD_Person t3     on t.FPersonID = t3.fid where t.FPositionID='" + position + "' and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
            IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
            while (superiorRS.next()) {
                superiorList.put(superiorRS.getString("FPersonID"), superiorRS.getString("name"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return superiorList;
    }

    public static Map<String, Set<String>> getDirectSuperiorByEvaObjs(Context ctx, Map<String, String> positionMap, boolean isReturnPersonName, boolean isOrg) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        HashSet<String> values = new HashSet<String>();
        values.addAll(positionMap.values());
        try {
            HashMap<String, String> posMap = new HashMap<String, String>();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", values, CompareType.INCLUDE));
            evi.setFilter(filter1);
            IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection posColl = iposition.getPositionCollection(evi);
            for (int i = 0; i < posColl.size(); ++i) {
                PositionInfo positionInfo = posColl.get(i);
                if (positionInfo.getParent() == null) continue;
                String superiorPosition = positionInfo.getParent().getId().toString();
                posMap.put(positionInfo.getId().toString(), superiorPosition);
            }
            HashSet superiorPositions = new HashSet();
            superiorPositions.addAll(posMap.values());
            if (superiorPositions != null && superiorPositions.size() > 0) {
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(new FilterItemInfo("t.FPositionID", superiorPositions, CompareType.INCLUDE));
                HashMap<String, HashSet<String>> superPosMap = new HashMap<String, HashSet<String>>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date now = new Date(System.currentTimeMillis());
                String dt2 = sdf.format(now);
                String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
                String selectSuperiorPerson = "select t.FPositionID, t.FPersonID, t3.FName" + mlFlag + " FPersonName from T_HR_EmpOrgRelation t   left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid    left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid    left outer join T_BD_PERSON t3     on t.FPersonID = t3.fid  where " + filter2.toSql() + " and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
                IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
                while (superiorRS.next()) {
                    String key = superiorRS.getString("FPositionID");
                    String personId = superiorRS.getString("FPersonID");
                    String personName = superiorRS.getString("FPersonName");
                    HashSet<String> superPos = (HashSet<String>)superPosMap.get(key);
                    if (superPos == null) {
                        superPos = new HashSet<String>();
                    }
                    if (isReturnPersonName) {
                        superPos.add(personName);
                    } else {
                        superPos.add(personId);
                    }
                    superPosMap.put(key, superPos);
                }
                for (Map.Entry<String, String> entry : positionMap.entrySet()) {
                    String superiorPosition = (String)posMap.get(entry.getValue());
                    if (StringUtils.isEmpty((String)superiorPosition)) continue;
                    Set persons = (Set)superPosMap.get(superiorPosition);
                    resultMap.put(entry.getKey(), persons);
                }
            }
        }
        catch (BOSException e) {
            logger.error("according to the evaluation object failed to get immediate superior!", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("according to the evaluation object failed to get immediate superior!", (Throwable)e);
        }
        return resultMap;
    }

    public static Map<String, List<String>> getDirectSuperiorByEvaObjs(Context ctx, Map<String, String> positionMap, boolean isOrg) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        HashSet<String> positions = new HashSet<String>();
        positions.addAll(positionMap.values());
        try {
            HashMap<String, String> posMap = new HashMap<String, String>();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", positions, CompareType.INCLUDE));
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("parent.id"));
            evi.setFilter(filter1);
            evi.setSelector(selectors);
            IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection posColl = iposition.getPositionCollection(evi);
            for (int i = 0; i < posColl.size(); ++i) {
                PositionInfo positionInfo = posColl.get(i);
                if (positionInfo.getParent() == null) continue;
                String superiorPosition = positionInfo.getParent().getId().toString();
                posMap.put(positionInfo.getId().toString(), superiorPosition);
            }
            HashSet superiorPositions = new HashSet();
            superiorPositions.addAll(posMap.values());
            if (superiorPositions != null && superiorPositions.size() > 0) {
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(new FilterItemInfo("t.FPositionID", superiorPositions, CompareType.INCLUDE));
                HashMap<String, HashMap<String, String>> superPosMap = new HashMap<String, HashMap<String, String>>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date now = new Date(System.currentTimeMillis());
                String dt2 = sdf.format(now);
                String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
                String selectSuperiorPerson = "select t.FPositionID, t.FPersonID, t3.FName" + mlFlag + " FPersonName from T_HR_EmpOrgRelation t   left outer join T_HR_EmpLaborRelation t1     on t.FlaborRelationID = t1.fid    left outer join T_HR_BDEmployeeType t2     on t1.FLaborRelationStateID = t2.fid    left outer join T_BD_PERSON t3     on t.FPersonID = t3.fid  where " + filter2.toSql() + " and t.FLEFFDT>={ts'" + dt2 + "'} and t.FEFFDT<={ts'" + dt2 + "'}   and (t2.FIsInCount  = 1  or t2.FIsOnTheStrength =1  )";
                IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
                while (superiorRS.next()) {
                    String key = superiorRS.getString("FPositionID");
                    String personId = superiorRS.getString("FPersonID");
                    String personName = superiorRS.getString("FPersonName");
                    HashMap<String, String> superPos = (HashMap<String, String>)superPosMap.get(key);
                    if (superPos == null) {
                        superPos = new HashMap<String, String>();
                    }
                    superPos.put(personId, personName);
                    superPosMap.put(key, superPos);
                }
                for (Map.Entry<String, String> entry : positionMap.entrySet()) {
                    String superiorPosition = (String)posMap.get(entry.getValue());
                    if (StringUtils.isEmpty((String)superiorPosition)) continue;
                    Map persons = (Map)superPosMap.get(superiorPosition);
                    ArrayList personNames = new ArrayList();
                    if (persons != null && persons.size() > 0) {
                        personNames.addAll(persons.values());
                    }
                    resultMap.put(entry.getKey(), personNames);
                }
            }
        }
        catch (BOSException e) {
            logger.error("according to the evaluation object failed to get immediate superior!", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("according to the evaluation object failed to get immediate superior!", (Throwable)e);
        }
        return resultMap;
    }

    public static Map<String, PersonCollection> getDirectSuperiorPeronsByEvaObjs(Context ctx, Map<String, String> positionMap) {
        HashMap<String, PersonCollection> resultMap = new HashMap<String, PersonCollection>();
        HashSet<String> positions = new HashSet<String>();
        positions.addAll(positionMap.values());
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", positions, CompareType.INCLUDE));
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("parent.id"));
            evi.setFilter(filter1);
            evi.setSelector(selectors);
            IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection posColl = iposition.getPositionCollection(evi);
            HashMap<String, String> posMap = new HashMap<String, String>();
            for (int i = 0; i < posColl.size(); ++i) {
                PositionInfo positionInfo = posColl.get(i);
                if (positionInfo.getParent() == null) continue;
                String superiorPosition = positionInfo.getParent().getId().toString();
                posMap.put(positionInfo.getId().toString(), superiorPosition);
            }
            HashSet superiorPositions = new HashSet();
            superiorPositions.addAll(posMap.values());
            if (superiorPositions != null && superiorPositions.size() > 0) {
                PersonCollection persons;
                HashMap<String, PersonCollection> superPosMap = new HashMap<String, PersonCollection>();
                String currentDate = PerfDateUtils.formatDate(new Date(), "yyyy-MM-dd");
                FilterInfo empOrgFilter = new FilterInfo();
                empOrgFilter.getFilterItems().add(new FilterItemInfo("position.id", superiorPositions, CompareType.INCLUDE));
                empOrgFilter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)currentDate, CompareType.GREATER_EQUALS));
                empOrgFilter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)currentDate, CompareType.LESS_EQUALS));
                empOrgFilter.getFilterItems().add(new FilterItemInfo("laborRelation.laborRelationState.inService", (Object)1));
                SelectorItemCollection empOrgSelectors = new SelectorItemCollection();
                empOrgSelectors.add(new SelectorItemInfo("position.id"));
                empOrgSelectors.add(new SelectorItemInfo("person.id"));
                empOrgSelectors.add(new SelectorItemInfo("person.number"));
                empOrgSelectors.add(new SelectorItemInfo("person.name"));
                EntityViewInfo empOrgEvi = new EntityViewInfo();
                empOrgEvi.setFilter(empOrgFilter);
                empOrgEvi.setSelector(empOrgSelectors);
                EmpPosOrgRelationCollection empOrgs = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(empOrgEvi);
                if (empOrgs != null && !empOrgs.isEmpty()) {
                    for (EmpPosOrgRelationInfo empPosInfo : empOrgs) {
                        String positionId = empPosInfo.getPosition().getId().toString();
                        persons = (PersonCollection)superPosMap.get(positionId);
                        if (persons == null) {
                            persons = new PersonCollection();
                        }
                        persons.add(empPosInfo.getPerson());
                        superPosMap.put(positionId, persons);
                    }
                }
                for (Map.Entry<String, String> entry : positionMap.entrySet()) {
                    String superiorPosition = (String)posMap.get(entry.getValue());
                    if (StringUtils.isEmpty((String)superiorPosition)) continue;
                    persons = (PersonCollection)superPosMap.get(superiorPosition);
                    resultMap.put(entry.getKey(), persons);
                }
            }
        }
        catch (BOSException e) {
            logger.error("", (Throwable)e);
            logger.error("according to the evaluation object failed to get immediate superior!", (Throwable)e);
        }
        return resultMap;
    }

    public static Map<String, Set<String>> getDirectSuperiorByEvaObjs(Context ctx, List<PerfEvaObjectInfo> infos) throws BOSException {
        return PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, infos, false);
    }

    public static Map<String, Set<String>> getDirectSuperiorByEvaObjs(Context ctx, List<PerfEvaObjectInfo> infos, boolean isReturnPersonName) throws BOSException {
        HashMap<String, String> positionMap = new HashMap<String, String>();
        boolean isOrg = false;
        if (infos != null && infos.size() > 0) {
            isOrg = OrgAssessmentUtils.isOrgAssessment(infos.get(0));
        }
        if (infos == null || infos.size() < 1) {
            if (logger.isDebugEnabled()) {
                logger.error("[PERFWEB]it is failed to get infos");
            }
            return new HashMap<String, Set<String>>();
        }
        if (isOrg) {
            for (int i = 0; i < infos.size(); ++i) {
                PerfEvaObjectInfo info = infos.get(i);
                String orgAdminId = OrgAssessmentUtils.getOrgAdminResPositionIDByEvaObj(ctx, info, true);
                if (StringUtils.isEmpty((String)orgAdminId)) continue;
                positionMap.put(info.getId().toString(), orgAdminId);
            }
        } else {
            for (int i = 0; i < infos.size(); ++i) {
                PerfEvaObjectInfo info = infos.get(i);
                PositionInfo positionInfo = info.getPerfFile().getPosition();
                if (positionInfo == null) continue;
                positionMap.put(info.getId().toString(), positionInfo.getId().toString());
            }
        }
        return PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, positionMap, isReturnPersonName, isOrg);
    }

    public static Map<String, PersonCollection> getGoalsChargerPersonsByEvaObjs(Context ctx, Set<String> goalsEvaObjs) throws BOSException {
        HashMap<String, PersonCollection> goalsMap = new HashMap<String, PersonCollection>();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", goalsEvaObjs, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        PerfEvaObjectCollection perfEvaObjectCollection = iPerfEvaObject.getPerfEvaObjectCollection(evi);
        for (int i = 0; i < perfEvaObjectCollection.size(); ++i) {
            String inchargePosition;
            String id = perfEvaObjectCollection.get(i).getId().toString();
            PersonCollection personCollections = new PersonCollection();
            PerfEvaObjectInfo evaObjectInfo = perfEvaObjectCollection.get(i);
            int personalGoalStatus = 0;
            int unitGoalsStatus = 0;
            if (evaObjectInfo.get("personalGoalStatus") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)evaObjectInfo.get("personalGoalStatus").toString())) {
                personalGoalStatus = Integer.parseInt(evaObjectInfo.get("personalGoalStatus").toString());
            }
            if (evaObjectInfo.get("unitGoalsStatus") != null && !org.apache.commons.lang.StringUtils.isEmpty((String)evaObjectInfo.get("unitGoalsStatus").toString())) {
                unitGoalsStatus = Integer.parseInt(evaObjectInfo.get("unitGoalsStatus").toString());
            }
            String string = inchargePosition = evaObjectInfo.get("personInchargePosition") == null ? "" : evaObjectInfo.get("personInchargePosition").toString();
            if (personalGoalStatus == 3) {
                try {
                    HashSet<String> receiverIds = new HashSet<String>();
                    GoalsMessageReceiverCollection goalsMessageReceiverCollection = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + id + "' and isSelf = 0  ");
                    Iterator iterator = goalsMessageReceiverCollection.iterator();
                    while (iterator.hasNext()) {
                        GoalsMessageReceiverInfo next = (GoalsMessageReceiverInfo)iterator.next();
                        receiverIds.add(next.getReceiver());
                    }
                    if (receiverIds.size() > 0) {
                        String inSql = "('" + Strings.join(receiverIds, (String)"','") + "')";
                        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id in " + inSql);
                        for (PersonInfo next : personCollection) {
                            personCollections.add(next);
                        }
                    }
                    goalsMap.put(id, personCollections);
                    continue;
                }
                catch (BOSException e) {
                    logger.error("getGoalsChargerPersonsByEvaObjs", (Throwable)e);
                }
            }
            if (!PersonInchargeUtils.isGoals2PersonIncharge(inchargePosition)) continue;
            HashSet<String> set = new HashSet<String>();
            set.add(id);
            Map<String, Set<String>> inchargeByids = null;
            try {
                inchargeByids = unitGoalsStatus == 0 ? PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, set) : PersonInchargeUtils.getPersonInchargeByids(ctx, set, true);
                Map<String, Set<PersonInfo>> personMaps = PersonInchargeUtils.transferInformation(ctx, inchargeByids);
                Set<PersonInfo> personInfoSet = personMaps.get(id);
                if (personInfoSet != null) {
                    for (PersonInfo personInfo : personInfoSet) {
                        personCollections.add(personInfo);
                    }
                }
                goalsMap.put(id, personCollections);
                continue;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return goalsMap;
    }

    public static Map<String, PersonCollection> getGoalsChargerPersonsByEvaObjsNew(Context ctx, Set<String> goalsEvaObjs) throws BOSException {
        HashMap<String, PersonCollection> goalsMap = new HashMap<String, PersonCollection>();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", goalsEvaObjs, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("unitGoalsStatus"));
        selectors.add(new SelectorItemInfo("personInchargePosition"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        long t1 = System.currentTimeMillis();
        PerfEvaObjectCollection perfEvaObjectCollection = iPerfEvaObject.getPerfEvaObjectCollection(evi);
        long t2 = System.currentTimeMillis();
        HashSet<String> setUnassign = new HashSet<String>();
        HashSet<String> setAssign = new HashSet<String>();
        for (int i = 0; i < perfEvaObjectCollection.size(); ++i) {
            String inchargePosition;
            String id = perfEvaObjectCollection.get(i).getId().toString();
            PerfEvaObjectInfo evaObjectInfo = perfEvaObjectCollection.get(i);
            int unitGoalsStatus = 0;
            if (!StringUtils.isEmpty((String)evaObjectInfo.get("unitGoalsStatus").toString())) {
                unitGoalsStatus = Integer.parseInt(evaObjectInfo.get("unitGoalsStatus").toString());
            }
            String string = inchargePosition = evaObjectInfo.get("personInchargePosition") == null ? "" : evaObjectInfo.get("personInchargePosition").toString();
            if (!PersonInchargeUtils.isGoals2PersonIncharge(inchargePosition)) continue;
            if (unitGoalsStatus == 0) {
                setUnassign.add(id);
                continue;
            }
            setAssign.add(id);
        }
        if (setUnassign.size() > 0) {
            Map<String, Set<String>> dynamicPersonInchargeByids = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, setUnassign);
            Map<String, Set<PersonInfo>> personMap = PersonInchargeUtils.transferInformation(ctx, dynamicPersonInchargeByids);
            for (String evaobjId : personMap.keySet()) {
                PersonCollection personCollections = new PersonCollection();
                Set<PersonInfo> personInfos = personMap.get(evaobjId);
                if (personInfos != null && personInfos.size() > 0) {
                    for (PersonInfo person : personInfos) {
                        personCollections.add(person);
                    }
                }
                goalsMap.put(evaobjId, personCollections);
            }
        }
        if (setAssign.size() > 0) {
            Map<String, Set<PersonInfo>> personIncharge = PersonInchargeUtils.getPersonIncharge(ctx, setAssign, true);
            for (String evaobjId : personIncharge.keySet()) {
                PersonCollection personCollections = new PersonCollection();
                Set<PersonInfo> personInfos = personIncharge.get(evaobjId);
                for (PersonInfo person : personInfos) {
                    personCollections.add(person);
                }
                goalsMap.put(evaobjId, personCollections);
            }
        }
        return goalsMap;
    }

    public static Map<String, PersonCollection> getAssignerPersonsByEvaObjs(Context ctx, Set<String> goalsEvaObjs) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", goalsEvaObjs, CompareType.INCLUDE));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        IPerfGoalsObject iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
        PerfGoalsObjectCollection goalsColls = iPerfGoalsObject.getPerfGoalsObjectCollection(evi);
        HashMap<String, PersonCollection> goalsMap = new HashMap<String, PersonCollection>();
        HashSet<String> personIds = new HashSet<String>();
        if (goalsColls != null && goalsColls.size() > 0) {
            Iterator git = goalsColls.iterator();
            while (git.hasNext()) {
                PerfGoalsObjectInfo perfGoalsObjectInfo = (PerfGoalsObjectInfo)git.next();
                personIds.add(perfGoalsObjectInfo.getPerson());
            }
            evi = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("id"));
            evi.setSelector(selectors);
            HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
            PersonCollection personColls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
            for (PersonInfo personInfo : personColls) {
                personMap.put(personInfo.getId().toString(), personInfo);
            }
            Iterator git2 = goalsColls.iterator();
            while (git2.hasNext()) {
                PerfGoalsObjectInfo perfGoalsObjectInfo = (PerfGoalsObjectInfo)git2.next();
                String evaObjId = perfGoalsObjectInfo.getPerfEvaObject().getId().toString();
                String personId = perfGoalsObjectInfo.getPerson();
                PersonCollection persons = (PersonCollection)goalsMap.get(evaObjId);
                if (persons == null) {
                    persons = new PersonCollection();
                }
                if (personMap.get(personId) != null) {
                    persons.add((PersonInfo)personMap.get(personId));
                }
                goalsMap.put(evaObjId, persons);
            }
        }
        return goalsMap;
    }

    public static Map<String, PersonCollection> getAssignerFillerPersonsByEvaObjs(Context ctx, Set<String> goalsEvaObjs) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", goalsEvaObjs, CompareType.INCLUDE));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        IPerfGoalsFillerObject iPerfGoalsObject = PerfGoalsFillerObjectFactory.getLocalInstance(ctx);
        PerfGoalsFillerObjectCollection goalsColls = iPerfGoalsObject.getPerfGoalsFillerObjectCollection(evi);
        HashMap<String, PersonCollection> goalsMap = new HashMap<String, PersonCollection>();
        HashSet<String> personIds = new HashSet<String>();
        if (goalsColls != null && goalsColls.size() > 0) {
            Iterator git = goalsColls.iterator();
            while (git.hasNext()) {
                PerfGoalsFillerObjectInfo perfGoalsObjectInfo = (PerfGoalsFillerObjectInfo)git.next();
                personIds.add(perfGoalsObjectInfo.getPerson());
            }
            evi = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("number"));
            selectors.add(new SelectorItemInfo("id"));
            evi.setSelector(selectors);
            HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
            PersonCollection personColls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
            for (PersonInfo personInfo : personColls) {
                personMap.put(personInfo.getId().toString(), personInfo);
            }
            Iterator git2 = goalsColls.iterator();
            while (git2.hasNext()) {
                PerfGoalsFillerObjectInfo perfGoalsObjectInfo = (PerfGoalsFillerObjectInfo)git2.next();
                String evaObjId = perfGoalsObjectInfo.getPerfEvaObject().getId().toString();
                String personId = perfGoalsObjectInfo.getPerson();
                PersonCollection persons = (PersonCollection)goalsMap.get(evaObjId);
                if (persons == null) {
                    persons = new PersonCollection();
                }
                persons.add((PersonInfo)personMap.get(personId));
                goalsMap.put(evaObjId, persons);
            }
        }
        return goalsMap;
    }

    public static Set<String> setEvaObjPositionMap(PerfEvaObjectCollection perfEvaObjectInfos, Map<String, String> evaPositionMap) {
        HashSet<String> goalsEvaObjs = new HashSet<String>();
        Iterator eit = perfEvaObjectInfos.iterator();
        while (eit.hasNext()) {
            PerfEvaObjectInfo perfEvaObjectInfo = (PerfEvaObjectInfo)eit.next();
            String evaObj = perfEvaObjectInfo.getId().toString();
            if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperior())) {
                String position = (String)perfEvaObjectInfo.get("position");
                if (!StringUtils.isEmpty((String)position)) {
                    evaPositionMap.put(evaObj, (String)perfEvaObjectInfo.get("position"));
                } else {
                    PositionInfo positionInfo = perfEvaObjectInfo.getPerfFile().getPosition();
                    if (positionInfo != null) {
                        evaPositionMap.put(evaObj, positionInfo.getId().toString());
                    }
                }
            }
            goalsEvaObjs.add(evaObj);
        }
        return goalsEvaObjs;
    }

    public static void setPerfGoalsObjects(Context ctx, PerfEvaObjectCollection perfEvaObjectInfos, Map<String, String> fillerNumberMap, Map<String, String> fillerNameMap, Map<String, String> goalsNumberMap, Map<String, String> goalsNameMap) throws BOSException {
        HashMap<String, String> evaPositionMap = new HashMap<String, String>();
        Set<String> goalsEvaObjs = PerfWorkFlowUtils.setEvaObjPositionMap(perfEvaObjectInfos, evaPositionMap);
        HashSet<String> fillerEvaObjs = new HashSet<String>();
        Iterator eit = perfEvaObjectInfos.iterator();
        while (eit.hasNext()) {
            PerfEvaObjectInfo perfEvaObjectInfo = (PerfEvaObjectInfo)eit.next();
            String evaObj = perfEvaObjectInfo.getId().toString();
            fillerEvaObjs.add(evaObj);
        }
        Map<String, PersonCollection> superiorMap = PerfWorkFlowUtils.getDirectSuperiorPeronsByEvaObjs(ctx, evaPositionMap);
        Map<String, PersonCollection> assignerMap = PerfWorkFlowUtils.getAssignerPersonsByEvaObjs(ctx, goalsEvaObjs);
        Map<String, PersonCollection> goalsChargerMap = PerfWorkFlowUtils.getGoalsChargerPersonsByEvaObjsNew(ctx, goalsEvaObjs);
        Map<String, PersonCollection> fillerAssignerMap = PerfWorkFlowUtils.getAssignerFillerPersonsByEvaObjs(ctx, fillerEvaObjs);
        Iterator eit2 = perfEvaObjectInfos.iterator();
        while (eit2.hasNext()) {
            PersonCollection fillerAssigners;
            PerfEvaObjectInfo perfEvaObjectInfo = (PerfEvaObjectInfo)eit2.next();
            String evaObj = perfEvaObjectInfo.getId().toString();
            PersonCollection superiors = superiorMap.get(evaObj);
            PersonCollection personColls = new PersonCollection();
            PersonCollection personFillerColls = new PersonCollection();
            if (TargetTransmitWayEnum.ASSIGNER.equals((Object)perfEvaObjectInfo.getTargetTransmitWay())) {
                if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelf())) {
                    personColls.add(perfEvaObjectInfo.getPerson());
                }
                PersonCollection assigners = assignerMap.get(evaObj);
                PersonCollection personChargerCollection = goalsChargerMap.get(evaObj);
                if (assigners != null) {
                    personColls.addCollection(assigners);
                }
                if (superiors != null && YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperior())) {
                    personColls.addCollection(superiors);
                }
                if (personChargerCollection != null && PersonInchargeUtils.isGoals2PersonIncharge(perfEvaObjectInfo.getPersonInchargePosition())) {
                    personColls.addCollection(personChargerCollection);
                }
                PerfWorkFlowUtils.combineEvaObjPersonMap(ctx, evaObj, personColls, goalsNumberMap, goalsNameMap);
            }
            if (superiors != null && YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperiorFiller())) {
                personFillerColls.addCollection(superiors);
            }
            if ((fillerAssigners = fillerAssignerMap.get(evaObj)) != null) {
                personFillerColls.addCollection(fillerAssigners);
            }
            if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelfFiller())) {
                personFillerColls.add(perfEvaObjectInfo.getPerson());
            }
            PerfWorkFlowUtils.combineEvaObjPersonMap(ctx, evaObj, personFillerColls, fillerNumberMap, fillerNameMap);
        }
    }

    private static void combineEvaObjPersonMap(Context ctx, String evaObj, PersonCollection personColls, Map<String, String> goalsNumberMap, Map<String, String> goalsNameMap) {
        StringBuffer numberSb = new StringBuffer();
        StringBuffer nameSb = new StringBuffer();
        Locale locale = ctx.getLocale();
        HashSet<String> personSet = new HashSet<String>();
        if (personColls != null && !personColls.isEmpty()) {
            for (PersonInfo personInfo : personColls) {
                if (personSet.contains(personInfo.getId().toString())) continue;
                personSet.add(personInfo.getId().toString());
                if (StringUtils.isEmpty((String)personInfo.getNumber())) {
                    logger.error("get target person number null, evaObj =" + evaObj);
                    continue;
                }
                if (StringUtils.isEmpty((String)personInfo.getName(locale))) {
                    logger.error("get target person name null, evaObj =" + evaObj);
                    continue;
                }
                numberSb.append(personInfo.getNumber()).append(",");
                nameSb.append(personInfo.getName(locale)).append(",");
            }
        }
        if (numberSb.length() > 1) {
            numberSb.setLength(numberSb.length() - 1);
        }
        if (nameSb.length() > 1) {
            nameSb.setLength(nameSb.length() - 1);
        }
        goalsNumberMap.put(evaObj, numberSb.toString());
        goalsNameMap.put(evaObj, nameSb.toString());
    }

    public static void setPerfTransmitObjects(Context ctx, Set<String> evaObjIds, Map<String, String> tNameMap) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjIds, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        TargetTransmitBillCollection targetTransmitBillCollection = TargetTransmitBillFactory.getLocalInstance(ctx).getTargetTransmitBillCollection(evi);
        Iterator iterator = targetTransmitBillCollection.iterator();
        ArrayList<Map<String, Object>> targetTransmitBillList = new ArrayList<Map<String, Object>>();
        while (iterator.hasNext()) {
            TargetTransmitBillInfo next = (TargetTransmitBillInfo)iterator.next();
            HashMap<String, String> map = new HashMap<String, String>();
            if (next.getEvaObj() != null) {
                map.put("evaObj", next.getEvaObj().getId().toString());
            }
            map.put("billID", next.getId().toString());
            targetTransmitBillList.add(map);
        }
        Map<Object, Object> assignMap = new HashMap();
        if (targetTransmitBillList != null && targetTransmitBillList.size() > 0) {
            assignMap = PerfWorkFlowUtils.setAssginApprovePersonMap(ctx, targetTransmitBillList, "billID");
        }
        for (Object e : targetTransmitBillList) {
            Map row = (Map)e;
            String billId = (String)row.get("billID");
            Object evaObj = row.get("evaObj");
            if (assignMap.get(billId) == null) continue;
            Set personNameSet = (Set)assignMap.get(billId);
            tNameMap.put(evaObj.toString(), org.apache.commons.lang3.StringUtils.join((Iterable)personNameSet, (String)","));
        }
    }

    public static Map<String, Set<String>> setAssginApprovePersonMap(Context ctx, List<Map<String, Object>> recordList, String billName) {
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> assginMap = new HashMap<String, Set<String>>();
        for (Map<String, Object> mapRecord : recordList) {
            String billId = (String)mapRecord.get(billName);
            ids.add(billId);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bizObjID"));
        sic.add(new SelectorItemInfo("performerUName"));
        sic.add(new SelectorItemInfo("personEmpName"));
        sic.add(new SelectorItemInfo("personEmpID"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjID", ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        try {
            AssignCollection assginCol = AssignFactory.getLocalInstance((Context)ctx).getCollection(entityViewInfo);
            if (!assginCol.isEmpty() && assginCol.size() > 0) {
                int assginSize = assginCol.size();
                Locale locale = ctx.getLocale();
                for (int i = 0; i < assginSize; ++i) {
                    Set<String> personNameSet;
                    AssignInfo assginInfo = assginCol.get(i);
                    String billId = assginInfo.getBizObjID();
                    String personName = assginInfo.getPersonEmpName(locale);
                    if (assginMap.get(billId) != null) {
                        personNameSet = (Set)assginMap.get(billId);
                        personNameSet.add(personName);
                        assginMap.put(billId, personNameSet);
                        continue;
                    }
                    personNameSet = new HashSet();
                    personNameSet.add(personName);
                    assginMap.put(billId, personNameSet);
                }
            }
        }
        catch (BOSException e) {
            logger.error("", (Throwable)e);
        }
        return assginMap;
    }

    public static Set<String> getEvaObjIdsByAssignGoalsObjs(Context ctx, Set<String> evaObjIds) throws BOSException {
        if (CollectionUtils.isEmpty(evaObjIds)) {
            return null;
        }
        HashSet<String> validEvaObjIds = new HashSet<String>();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", evaObjIds, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("perfEvaObject.id");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        PerfGoalsObjectCollection goalsObjects = PerfGoalsObjectFactory.getLocalInstance(ctx).getPerfGoalsObjectCollection(evi);
        if (goalsObjects != null && !goalsObjects.isEmpty()) {
            Iterator it = goalsObjects.iterator();
            while (it.hasNext()) {
                BOSUuid evaObjId;
                PerfGoalsObjectInfo goalsObjectInfo = (PerfGoalsObjectInfo)it.next();
                if (goalsObjectInfo.getPerfEvaObject() == null || (evaObjId = goalsObjectInfo.getPerfEvaObject().getId()) == null) continue;
                validEvaObjIds.add(evaObjId.toString());
            }
        }
        return validEvaObjIds;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Map<String, String> getPerfGoalsObjects(Context ctx, List<PerfEvaObjectInfo> perfEvaObjectInfos) throws BOSException {
        evaPositionMap = new HashMap<String, String>();
        goalsEvaObjs = new HashSet<String>();
        isOrg = false;
        if (perfEvaObjectInfos != null && perfEvaObjectInfos.size() > 0) {
            isOrg = OrgAssessmentUtils.isOrgAssessment(perfEvaObjectInfos.get(0));
        }
        hasPersonInchargeSet = new HashSet<String>();
        for (PerfEvaObjectInfo perfEvaObjectInfo : perfEvaObjectInfos) {
            evaObj = perfEvaObjectInfo.getId().toString();
            if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperior())) {
                if (isOrg) {
                    objectId = OrgAssessmentUtils.getOrgAdminResPositionIDByEvaObj(ctx, perfEvaObjectInfo, true);
                    if (!StringUtils.isEmpty((String)objectId)) {
                        evaPositionMap.put(evaObj, objectId);
                    }
                } else {
                    position = (String)perfEvaObjectInfo.get("position");
                    if (!StringUtils.isEmpty((String)position)) {
                        evaPositionMap.put(evaObj, (String)perfEvaObjectInfo.get("position"));
                    } else {
                        positionInfo = perfEvaObjectInfo.getPerfFile().getPosition();
                        if (positionInfo != null) {
                            evaPositionMap.put(evaObj, positionInfo.getId().toString());
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty((String)(personInchargePosition = perfEvaObjectInfo.getPersonInchargePosition())) && !isOrg && PersonInchargeUtils.isGoals2PersonIncharge((String)personInchargePosition)) {
                hasPersonInchargeSet.add(perfEvaObjectInfo.getId().toString());
            }
            goalsEvaObjs.add(evaObj);
        }
        superiorMap = new HashMap<String, ArrayList<E>>();
        if (!CollectionUtils.isEmpty(evaPositionMap)) {
            strings = evaPositionMap.keySet();
            directList = null;
            for (String evaobj : strings) {
                directList = new ArrayList<String>();
                position = (String)evaPositionMap.get(evaobj);
                map = PerfWorkFlowUtils.getDirectSuperior(ctx, position);
                for (String key : map.keySet()) {
                    directList.add(map.get(key));
                }
                superiorMap.put(evaobj, directList);
            }
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", goalsEvaObjs, CompareType.INCLUDE));
        sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
        perfGoalsObjectCollection = iPerfGoalsObject.getPerfGoalsObjectCollection(evi);
        goalsMap = new HashMap<String, ArrayList<String>>();
        if (perfGoalsObjectCollection != null && perfGoalsObjectCollection.size() > 0) {
            for (i = 0; i < perfGoalsObjectCollection.size(); ++i) {
                perfGoalsObjectInfo = perfGoalsObjectCollection.get(i);
                evaObj = perfGoalsObjectInfo.getPerfEvaObject().getId().toString();
                goals = (ArrayList<String>)goalsMap.get(evaObj);
                if (goals == null || goals.size() == 0) {
                    goals = new ArrayList<String>();
                }
                goals.add(perfGoalsObjectInfo.getPersonName());
                goalsMap.put(evaObj, goals);
            }
        }
        resultMap = new HashMap<String, String>();
        for (PerfEvaObjectInfo perfEvaObjectInfo : perfEvaObjectInfos) {
            evaObj = perfEvaObjectInfo.getId().toString();
            sb = new StringBuffer();
            if (PerfEvaObjectPersonalGoalStatusEnum.ASSIGNED.equals((Object)perfEvaObjectInfo.getPersonalGoalStatus())) {
                try {
                    receiverIds = new HashSet<String>();
                    goalsMessageReceiverCollection /* !! */  = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + evaObj + "' and isSelf = 0  ");
                    iterator2 = goalsMessageReceiverCollection /* !! */ .iterator();
                    while (iterator2.hasNext()) {
                        next = (GoalsMessageReceiverInfo)iterator2.next();
                        receiverIds.add(next.getReceiver());
                    }
                    if (receiverIds.size() <= 0) ** GOTO lbl140
                    inSql = "('" + Strings.join(receiverIds, (String)"','") + "')";
                    personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id in " + inSql);
                    for (PersonInfo next : personCollection) {
                        sb.append(next.getName()).append(",");
                    }
                }
                catch (BOSException e) {
                    PerfWorkFlowUtils.logger.error("setOrderAndFillerForEvaObjList", (Throwable)e);
                }
            } else {
                superiors = (List)superiorMap.get(evaObj);
                if (superiors != null && superiors.size() > 0) {
                    for (Iterator<E> superior : superiors) {
                        sb.append(isOrg != false ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORORGWITHPREFIX, ctx, new Object[]{superior}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORWITHPREFIX, ctx, new Object[]{superior})).append(",");
                    }
                }
                if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelf())) {
                    if (isOrg) {
                        responserName = OrgAssessmentUtils.getOrgResponserNameByEvaObject(ctx, evaObj);
                        if (responserName != null) {
                            superior = responserName.iterator();
                            while (superior.hasNext()) {
                                responser = (String)superior.next();
                                sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESPONSERWITHPREFIX, ctx, new Object[]{responser})).append(",");
                            }
                        }
                    } else {
                        sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELFWITHPREFIX, ctx, new Object[]{perfEvaObjectInfo.getName()})).append(",");
                    }
                }
                if ((goals = (List)goalsMap.get(evaObj)) != null && goals.size() > 0) {
                    superior = goals.iterator();
                    while (superior.hasNext()) {
                        goal = (String)superior.next();
                        sb.append(goal).append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ASSIGNERWITHPREFIX, ctx, new Object[0])).append(",");
                    }
                }
                inchargeByids /* !! */  = new HashMap<K, V>();
                personInchargePosition = perfEvaObjectInfo.getPersonInchargePosition();
                if (!StringUtils.isEmpty((String)personInchargePosition) && !isOrg && PersonInchargeUtils.isGoals2PersonIncharge(personInchargePosition)) {
                    hasPersonInchargeSet.add(perfEvaObjectInfo.getId().toString());
                }
                if (hasPersonInchargeSet.size() > 0) {
                    inchargeByids /* !! */  = PerfEvaObjectUnitGoalsStatusEnum.UNASSIGN.equals((Object)perfEvaObjectInfo.getUnitGoalsStatus()) != false ? PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, hasPersonInchargeSet) : PersonInchargeUtils.getPersonInchargeByids(ctx, hasPersonInchargeSet, true);
                }
                chargerInfomations = new HashMap<K, V>();
                if (hasPersonInchargeSet.size() > 0) {
                    chargerInfomations = PersonInchargeUtils.transferInformation(ctx, inchargeByids /* !! */ );
                }
                if (chargerInfomations.size() > 0 && chargerInfomations.get(perfEvaObjectInfo.getId().toString()) != null) {
                    personInfos = (Set)chargerInfomations.get(perfEvaObjectInfo.getId().toString());
                    for (PersonInfo personInfo : personInfos) {
                        sb.append(personInfo.getName()).append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHARGER, ctx) + "),");
                    }
                }
            }
lbl140:
            // 6 sources

            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
            resultMap.put(evaObj, sb.toString());
        }
        return resultMap;
    }

    public static Map<String, Set<String>> getPerfGoalsFillerIds(Context ctx, PerfEvaObjectCollection colls) throws BOSException {
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        PerfWorkFlowUtils.getPerfGoalsObjectAndFillerIds(ctx, colls, null, resultMap);
        return resultMap;
    }

    public static void getPerfGoalsObjectAndFillerIds(Context ctx, PerfEvaObjectCollection colls, Map<String, Set<String>> goalsObjects, Map<String, Set<String>> goalsFillers) throws BOSException {
        Set v2;
        Set<String> v1;
        CoreBaseCollection coreBases;
        EntityViewInfo evi;
        FilterInfo filterInfo;
        if (colls == null || colls.isEmpty()) {
            return;
        }
        HashSet<String> evaObjIds = new HashSet<String>();
        HashSet<String> goalsEvaObjIds = new HashSet<String>();
        ArrayList<PerfEvaObjectInfo> list = new ArrayList<PerfEvaObjectInfo>();
        HashSet<String> personInchargeFillList = new HashSet<String>();
        HashSet<String> personInchargeGoalsList = new HashSet<String>();
        boolean isOrg = false;
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            String personInchargePosition;
            PerfEvaObjectInfo evaObj = (PerfEvaObjectInfo)it.next();
            if (evaObj.getId() == null) continue;
            String evaObjId = evaObj.getId().toString();
            evaObjIds.add(evaObjId);
            if (YesOrNoEnum.YES.equals((Object)evaObj.getIsOrg())) {
                isOrg = true;
            }
            if (PersonInchargeUtils.isFill2PersonIncharge(personInchargePosition = evaObj.getPersonInchargePosition())) {
                personInchargeFillList.add(evaObjId);
            }
            if (PersonInchargeUtils.isGoals2PersonIncharge(personInchargePosition)) {
                personInchargeGoalsList.add(evaObjId);
            }
            if (goalsFillers != null) {
                Set<String> persons = goalsFillers.get(evaObjId);
                if (CollectionUtils.isEmpty(persons)) {
                    persons = new HashSet<String>();
                }
                if (YesOrNoEnum.YES.equals((Object)evaObj.getIsSelfFiller())) {
                    if (YesOrNoEnum.YES.equals((Object)evaObj.getIsOrg())) {
                        persons.addAll(OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObjId));
                    } else if (evaObj.getPerson() != null) {
                        persons.add(evaObj.getPerson().getId().toString());
                    }
                    goalsFillers.put(evaObjId, persons);
                }
                if (YesOrNoEnum.YES.equals((Object)evaObj.getIsSuperiorFiller())) {
                    list.add(evaObj);
                }
            }
            boolean onlyFillerReceiver = evaObj.getPeriod().getPerfPlan().isOnlyFillerReceiver();
            if (goalsObjects == null || TargetTransmitWayEnum.PROCESS.equals((Object)evaObj.getTargetTransmitWay())) continue;
            Set<String> persons2 = goalsObjects.get(evaObjId);
            if (CollectionUtils.isEmpty(persons2)) {
                persons2 = new HashSet<String>();
            }
            if (YesOrNoEnum.YES.equals((Object)evaObj.getIsSelf())) {
                if (YesOrNoEnum.YES.equals((Object)evaObj.getIsOrg())) {
                    persons2.addAll(OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObjId));
                } else if (evaObj.getPerson() != null) {
                    persons2.add(evaObj.getPerson().getId().toString());
                }
                goalsObjects.put(evaObjId, persons2);
            }
            if (YesOrNoEnum.YES.equals((Object)evaObj.getIsSuperior())) {
                list.add(evaObj);
            }
            goalsEvaObjIds.add(evaObjId);
        }
        Map<String, Set<String>> superiors = PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, list);
        if (!CollectionUtils.isEmpty(superiors)) {
            Iterator it2 = colls.iterator();
            while (it2.hasNext()) {
                Set<String> persons;
                PerfEvaObjectInfo evaObj = (PerfEvaObjectInfo)it2.next();
                String evaObjId = evaObj.getId().toString();
                Set<String> superiorPersons = superiors.get(evaObjId);
                if (CollectionUtils.isEmpty(superiorPersons)) continue;
                if (goalsFillers != null && YesOrNoEnum.YES.equals((Object)evaObj.getIsSuperiorFiller())) {
                    persons = goalsFillers.get(evaObjId);
                    if (persons == null) {
                        persons = new HashSet<String>();
                    }
                    persons.addAll(superiorPersons);
                    goalsFillers.put(evaObjId, persons);
                }
                if (goalsObjects == null || !YesOrNoEnum.YES.equals((Object)evaObj.getIsSuperior())) continue;
                persons = goalsObjects.get(evaObjId);
                if (persons == null) {
                    persons = new HashSet<String>();
                }
                persons.addAll(superiorPersons);
                goalsObjects.put(evaObjId, persons);
            }
        }
        if (goalsFillers != null) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", evaObjIds, CompareType.INCLUDE));
            evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            IPerfGoalsFillerObject iPerfGoalsFillerObject = PerfGoalsFillerObjectFactory.getLocalInstance(ctx);
            PerfGoalsFillerObjectCollection fillers = iPerfGoalsFillerObject.getPerfGoalsFillerObjectCollection(evi);
            coreBases = new CoreBaseCollection();
            coreBases.addObjectCollection((IObjectCollection)fillers);
            PerfWorkFlowUtils.setAssignerGoalsObjectOrFillers(coreBases, goalsFillers);
        }
        if (goalsObjects != null && !CollectionUtils.isEmpty(goalsEvaObjIds)) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", goalsEvaObjIds, CompareType.INCLUDE));
            evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            IPerfGoalsObject iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
            PerfGoalsObjectCollection goals = iPerfGoalsObject.getPerfGoalsObjectCollection(evi);
            coreBases = new CoreBaseCollection();
            coreBases.addObjectCollection((IObjectCollection)goals);
            PerfWorkFlowUtils.setAssignerGoalsObjectOrFillers(coreBases, goalsObjects);
        }
        Map<Object, Object> personInchargeFillMap = new HashMap();
        Map<Object, Object> personInchargeGoalsMap = new HashMap();
        if (!isOrg) {
            personInchargeFillMap = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, personInchargeFillList);
            personInchargeGoalsMap = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, personInchargeGoalsList);
        }
        Set fkeySet = personInchargeFillMap.keySet();
        Set gkeySet = personInchargeGoalsMap.keySet();
        if (goalsObjects == null) {
            goalsObjects = new HashMap<String, Set<String>>();
        }
        if (goalsFillers == null) {
            goalsFillers = new HashMap<String, Set<String>>();
        }
        for (String s : fkeySet) {
            v1 = goalsFillers.get(s);
            if (v1 == null) {
                v1 = new HashSet<String>();
            }
            if (CollectionUtils.isEmpty((Collection)(v2 = (Set)personInchargeFillMap.get(s)))) continue;
            v1.addAll(v2);
            goalsFillers.put(s, v1);
        }
        for (String s : gkeySet) {
            v1 = goalsObjects.get(s);
            if (v1 == null) {
                v1 = new HashSet<String>();
            }
            if (CollectionUtils.isEmpty((Collection)(v2 = (Set)personInchargeGoalsMap.get(s)))) continue;
            v1.addAll(v2);
            goalsObjects.put(s, v1);
        }
    }

    private static void setAssignerGoalsObjectOrFillers(CoreBaseCollection colls, Map<String, Set<String>> goalsObjects) {
        if (colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                CoreBaseInfo obj = colls.get(i);
                String personId = null;
                PerfEvaObjectInfo evaObjInfo = null;
                if (obj instanceof PerfGoalsFillerObjectInfo) {
                    PerfGoalsFillerObjectInfo fillerObj = (PerfGoalsFillerObjectInfo)obj;
                    personId = fillerObj.getPerson();
                    evaObjInfo = fillerObj.getPerfEvaObject();
                } else if (obj instanceof PerfGoalsObjectInfo) {
                    PerfGoalsObjectInfo goalsObj = (PerfGoalsObjectInfo)obj;
                    personId = goalsObj.getPerson();
                    evaObjInfo = goalsObj.getPerfEvaObject();
                }
                if (StringUtils.isEmpty(personId) || evaObjInfo == null || evaObjInfo.getId() == null) continue;
                String evaObjId = evaObjInfo.getId().toString();
                Set<String> persons = goalsObjects.get(evaObjId);
                if (CollectionUtils.isEmpty(persons)) {
                    persons = new HashSet<String>();
                }
                persons.add(personId);
                goalsObjects.put(evaObjId, persons);
            }
        }
    }

    public static Map<String, String> getPerfGoalsFillerObjects(Context ctx, List<PerfEvaObjectInfo> perfEvaObjectInfos) throws BOSException {
        HashMap<Object, String> evaPositionMap = new HashMap<Object, String>();
        HashSet<Object> goalsEvaObjs = new HashSet<Object>();
        boolean isOrg = false;
        if (perfEvaObjectInfos != null && perfEvaObjectInfos.size() > 0) {
            isOrg = OrgAssessmentUtils.isOrgAssessment(perfEvaObjectInfos.get(0));
        }
        HashSet<String> set = new HashSet<String>();
        HashMap<String, Set<PersonInfo>> chargerInfomations = new HashMap<String, Set<PersonInfo>>();
        for (PerfEvaObjectInfo perfEvaObjectInfo : perfEvaObjectInfos) {
            String evaObj = perfEvaObjectInfo.getId().toString();
            if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperiorFiller())) {
                if (isOrg) {
                    String objectId = OrgAssessmentUtils.getOrgAdminResPositionIDByEvaObj(ctx, perfEvaObjectInfo, true);
                    if (!StringUtils.isEmpty((String)objectId)) {
                        evaPositionMap.put(evaObj, objectId);
                    }
                } else {
                    String position = (String)perfEvaObjectInfo.get("position");
                    if (!StringUtils.isEmpty((String)position)) {
                        evaPositionMap.put(evaObj, (String)perfEvaObjectInfo.get("position"));
                    } else {
                        PositionInfo positionInfo = perfEvaObjectInfo.getPerfFile().getPosition();
                        if (positionInfo != null) {
                            evaPositionMap.put(evaObj, positionInfo.getId().toString());
                        }
                    }
                }
            }
            goalsEvaObjs.add(evaObj);
            String personInchargePosition = perfEvaObjectInfo.getPersonInchargePosition();
            if (StringUtils.isEmpty((String)personInchargePosition) || isOrg || !PersonInchargeUtils.isFill2PersonIncharge(personInchargePosition)) continue;
            set.add(perfEvaObjectInfo.getId().toString());
            HashSet<String> chargerSet = new HashSet<String>();
            chargerSet.add(perfEvaObjectInfo.getId().toString());
            int personalGoalStatus = 0;
            int unitGoalsStatus = 0;
            unitGoalsStatus = perfEvaObjectInfo.getUnitGoalsStatus().getValue();
            personalGoalStatus = perfEvaObjectInfo.getPersonalGoalStatus().getValue();
            HashMap<String, Set<String>> inchargeByids = new HashMap();
            if (unitGoalsStatus == 1 && (personalGoalStatus == 0 || personalGoalStatus == 1)) {
                inchargeByids = PersonInchargeUtils.getPersonInchargeByids(ctx, chargerSet, true);
            } else if (unitGoalsStatus == 0) {
                inchargeByids = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, chargerSet);
            } else {
                try {
                    HashSet<String> receiverIds = new HashSet<String>();
                    GoalsMessageReceiverCollection goalsMessageReceiverCollection = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + perfEvaObjectInfo.getId().toString() + "' and isSelf = 1  ");
                    Iterator iterator = goalsMessageReceiverCollection.iterator();
                    while (iterator.hasNext()) {
                        GoalsMessageReceiverInfo next = (GoalsMessageReceiverInfo)iterator.next();
                        receiverIds.add(next.getReceiver());
                    }
                    inchargeByids.put(perfEvaObjectInfo.getId().toString(), receiverIds);
                }
                catch (BOSException e) {
                    logger.error("getPerfGoalsFillerObjects", (Throwable)e);
                }
            }
            chargerInfomations.putAll(PersonInchargeUtils.transferInformation(ctx, inchargeByids));
            logger.info("**************chargerInfomations::" + ((Object)chargerInfomations).toString());
        }
        HashMap superiorMap = new HashMap();
        if (!CollectionUtils.isEmpty(evaPositionMap)) {
            Set strings = evaPositionMap.keySet();
            for (String evaobj : strings) {
                ArrayList<String> directList = new ArrayList<String>();
                String position = (String)evaPositionMap.get(evaobj);
                Map<String, String> map = PerfWorkFlowUtils.getDirectSuperior(ctx, position);
                for (String key : map.keySet()) {
                    directList.add(map.get(key));
                }
                superiorMap.put(evaobj, directList);
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", goalsEvaObjs, CompareType.INCLUDE));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        IPerfGoalsFillerObject iPerfGoalsFillerObject = PerfGoalsFillerObjectFactory.getLocalInstance(ctx);
        PerfGoalsFillerObjectCollection perfGoalsFillerObjectCollection = iPerfGoalsFillerObject.getPerfGoalsFillerObjectCollection(evi);
        HashMap<String, ArrayList<String>> goalsMap = new HashMap<String, ArrayList<String>>();
        if (perfGoalsFillerObjectCollection != null && perfGoalsFillerObjectCollection.size() > 0) {
            for (int i = 0; i < perfGoalsFillerObjectCollection.size(); ++i) {
                PerfGoalsFillerObjectInfo perfGoalsFillerObjectInfo = perfGoalsFillerObjectCollection.get(i);
                String evaObj = perfGoalsFillerObjectInfo.getPerfEvaObject().getId().toString();
                ArrayList<String> goals = (ArrayList<String>)goalsMap.get(evaObj);
                if (goals == null || goals.size() == 0) {
                    goals = new ArrayList<String>();
                }
                goals.add(perfGoalsFillerObjectInfo.getPersonName());
                goalsMap.put(evaObj, goals);
            }
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (PerfEvaObjectInfo perfEvaObjectInfo : perfEvaObjectInfos) {
            List goals;
            Iterator superior2;
            String evaObj = perfEvaObjectInfo.getId().toString();
            StringBuffer sb = new StringBuffer();
            List superiors = (List)superiorMap.get(evaObj);
            if (superiors != null && superiors.size() > 0) {
                for (Iterator superior2 : superiors) {
                    sb.append(isOrg ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORORGWITHPREFIX, ctx, new Object[]{superior2}) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIORWITHPREFIX, ctx, new Object[]{superior2})).append(",");
                }
            }
            if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelfFiller())) {
                if (isOrg) {
                    List<String> responserNameList = OrgAssessmentUtils.getOrgResponserNameByEvaObject(ctx, evaObj);
                    if (responserNameList != null) {
                        superior2 = responserNameList.iterator();
                        while (superior2.hasNext()) {
                            String responserName = (String)superior2.next();
                            sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.RESPONSERWITHPREFIX, ctx, new Object[]{responserName})).append(",");
                        }
                    }
                } else {
                    sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELFWITHPREFIX, ctx, new Object[]{perfEvaObjectInfo.getName()})).append(",");
                }
            }
            if ((goals = (List)goalsMap.get(evaObj)) != null && goals.size() > 0) {
                superior2 = goals.iterator();
                while (superior2.hasNext()) {
                    String goal = (String)superior2.next();
                    sb.append(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.ASSIGNERWITHPREFIX, ctx, new Object[]{goal})).append(",");
                }
            }
            if (chargerInfomations.size() > 0 && chargerInfomations.get(perfEvaObjectInfo.getId().toString()) != null) {
                Set personInfos = (Set)chargerInfomations.get(perfEvaObjectInfo.getId().toString());
                logger.info("***************personInfos" + personInfos.toString());
                if (personInfos != null && personInfos.size() > 0) {
                    for (PersonInfo personInfo : personInfos) {
                        if (personInfo == null) continue;
                        sb.append(personInfo.getName());
                        int personalGoalStatus = perfEvaObjectInfo.getPersonalGoalStatus().getValue();
                        if (personalGoalStatus == 0 || personalGoalStatus == 1) {
                            sb.append("(" + SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHARGER, ctx) + "),");
                            continue;
                        }
                        sb.append(",");
                    }
                }
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
            resultMap.put(evaObj, sb.toString());
        }
        return resultMap;
    }

    public static Set<String> getPerfGoalsObjects(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo) throws BOSException {
        Set superiors;
        HashMap<String, String> evaPositionMap = new HashMap<String, String>();
        String evaObj = perfEvaObjectInfo.getId().toString();
        HashSet<String> goalsPerson = new HashSet<String>();
        boolean isOrg = OrgAssessmentUtils.isOrgAssessment(perfEvaObjectInfo);
        if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperior())) {
            if (isOrg) {
                String objectId = OrgAssessmentUtils.getOrgAdminResPositionIDByEvaObj(ctx, perfEvaObjectInfo, true);
                if (!StringUtils.isEmpty((String)objectId)) {
                    evaPositionMap.put(evaObj, objectId);
                }
            } else {
                String position = (String)perfEvaObjectInfo.get("position");
                if (!StringUtils.isEmpty((String)position)) {
                    evaPositionMap.put(evaObj, (String)perfEvaObjectInfo.get("position"));
                } else {
                    PositionInfo positionInfo = perfEvaObjectInfo.getPerfFile().getPosition();
                    if (positionInfo != null) {
                        evaPositionMap.put(evaObj, positionInfo.getId().toString());
                    }
                }
            }
        }
        Map<Object, Object> superiorMap = new HashMap();
        if (!CollectionUtils.isEmpty(evaPositionMap)) {
            superiorMap = PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, evaPositionMap, false, isOrg);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", (Object)evaObj, CompareType.EQUALS));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        IPerfGoalsObject iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
        PerfGoalsObjectCollection perfGoalsObjectCollection = iPerfGoalsObject.getPerfGoalsObjectCollection(evi);
        if (perfGoalsObjectCollection != null && perfGoalsObjectCollection.size() > 0) {
            for (int i = 0; i < perfGoalsObjectCollection.size(); ++i) {
                PerfGoalsObjectInfo perfGoalsObjectInfo = perfGoalsObjectCollection.get(i);
                goalsPerson.add(perfGoalsObjectInfo.getPerson());
            }
        }
        if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelf())) {
            if (isOrg) {
                goalsPerson.addAll(OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObj));
            } else {
                goalsPerson.add(perfEvaObjectInfo.getPerson().getId().toString());
            }
        }
        if ((superiors = (Set)superiorMap.get(evaObj)) != null && superiors.size() > 0) {
            for (String superior : superiors) {
                goalsPerson.add(superior);
            }
        }
        HashSet<String> hasPersonInchargeSet = new HashSet<String>();
        Map<Object, Object> inchargeByids = new HashMap();
        String personInchargePosition = perfEvaObjectInfo.getPersonInchargePosition();
        if (!StringUtils.isEmpty((String)personInchargePosition) && !isOrg && PersonInchargeUtils.isGoals2PersonIncharge(personInchargePosition)) {
            hasPersonInchargeSet.add(perfEvaObjectInfo.getId().toString());
        }
        if (hasPersonInchargeSet.size() > 0) {
            inchargeByids = PerfEvaObjectUnitGoalsStatusEnum.UNASSIGN.equals((Object)perfEvaObjectInfo.getUnitGoalsStatus()) ? PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, hasPersonInchargeSet) : PersonInchargeUtils.getPersonInchargeByids(ctx, hasPersonInchargeSet, true);
        }
        if (inchargeByids.size() > 0 && inchargeByids.get(perfEvaObjectInfo.getId().toString()) != null) {
            Set personInfos = (Set)inchargeByids.get(perfEvaObjectInfo.getId().toString());
            for (String personInfoId : personInfos) {
                goalsPerson.add(personInfoId);
            }
        }
        return goalsPerson;
    }

    public static float getDefaultScoreByPerfRate(Context ctx, String ruleId, String grade, String type) throws BOSException {
        float score = 0.0f;
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, ruleId);
        if (ruleInfo != null) {
            String perfRateId = null;
            perfRateId = type.equals("0") ? ruleInfo.getScoreRate().getId().toString() : ruleInfo.getPerfRate().getId().toString();
            PerfScoreLevelInfo scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId);
            if (scoreLevelInfo != null) {
                String perfScoreLevel = scoreLevelInfo.getId().toString();
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
                PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' and perfLevelName='" + grade + "'");
                if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                    score = scoreLvDefColl.get(0).getDefaultScore().floatValue();
                }
            }
        }
        return score;
    }

    public static Map<String, Float> getDefaultScoreByPerfRate(Context ctx, String ruleId, Set<String> gradeSet, String type) throws BOSException {
        HashMap<String, Float> gradeScoreMap = new HashMap<String, Float>();
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, ruleId);
        if (ruleInfo != null) {
            String perfRateId = null;
            perfRateId = type.equals("0") ? ruleInfo.getScoreRate().getId().toString() : ruleInfo.getPerfRate().getId().toString();
            PerfScoreLevelInfo scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId);
            if (scoreLevelInfo != null) {
                String perfScoreLevel = scoreLevelInfo.getId().toString();
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
                PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' and perfLevelName in (" + PerfwebStrUtils.convertListToString(gradeSet.toArray()) + ")");
                if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                    for (int i = 0; i < scoreLvDefColl.size(); ++i) {
                        PerfScorLevelDefineInfo perfScorLevelDefineInfo = scoreLvDefColl.get(i);
                        gradeScoreMap.put(perfScorLevelDefineInfo.getPerfLevelName(), Float.valueOf(perfScorLevelDefineInfo.getDefaultScore().floatValue()));
                    }
                }
            }
        }
        return gradeScoreMap;
    }

    public static String getLevelByPerfScore(Context ctx, String ruleId, float score, String type) throws BOSException {
        PerfScorLevelDefineCollection perfScoreLevelDefineColl;
        String level = "";
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, ruleId);
        float scoreMin = 0.0f;
        if (null != ruleInfo.getPariMutual()) {
            scoreMin = ruleInfo.getPariMutual().getMin().floatValue();
        } else if (null != ruleInfo.getScoreRate() && null != (perfScoreLevelDefineColl = GetEntityInfoUtils.getPerfScorLevelDefineCollection(ctx, ruleInfo.getScoreRate().getId().toString())) && perfScoreLevelDefineColl.size() > 0) {
            int size = perfScoreLevelDefineColl.size();
            scoreMin = Float.valueOf(String.valueOf(perfScoreLevelDefineColl.get(size - 1).getScoreLowLimit())).floatValue();
        }
        if (ruleInfo != null) {
            String perfRateId = null;
            perfRateId = type.equals("0") ? ruleInfo.getScoreRate().getId().toString() : ruleInfo.getPerfRate().getId().toString();
            level = PerfWorkFlowUtils.getGradeLevelByScore(ctx, score, scoreMin, perfRateId);
        }
        return level;
    }

    public static String getGradeLevelByScore(Context ctx, float score, float scoreMin, String perfRateId) throws BOSException {
        String level = "";
        PerfScoreLevelInfo scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId);
        if (scoreLevelInfo != null) {
            String perfScoreLevel = scoreLevelInfo.getId().toString();
            IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
            PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' order by scoreUpLimit desc");
            if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                PerfScorLevelDefineInfo maxDefineInfo = scoreLvDefColl.get(0);
                for (int i = 0; i < scoreLvDefColl.size(); ++i) {
                    PerfScorLevelDefineInfo scoreLevelDefineInfo = scoreLvDefColl.get(i);
                    float scoreLowLimit = scoreLevelDefineInfo.getScoreLowLimit().floatValue();
                    float scoreUpLimit = scoreLevelDefineInfo.getScoreUpLimit().floatValue();
                    if (!(score == scoreMin && scoreLowLimit == score || score > scoreLowLimit && score <= scoreUpLimit) && maxDefineInfo.getScoreUpLimit().compareTo(BigDecimal.valueOf(score)) > 0) continue;
                    level = scoreLevelDefineInfo.getPerfLevelName();
                    break;
                }
            }
        }
        return level;
    }

    public static EvaResultSummaryInfo setPerfscoreLevelForEvaresult(Context ctx, String evaObj, EvaResultSummaryInfo evaResultSummaryInfo) throws BOSException {
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
        if (ruleInfo != null) {
            String perfRateId = ruleInfo.getPerfRate().getId().toString();
            PerfScoreLevelInfo scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId);
            evaResultSummaryInfo.setPerfScorLevel(scoreLevelInfo);
            if (scoreLevelInfo != null) {
                String perfScoreLevel = scoreLevelInfo.getId().toString();
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
                PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' and perfLevelName='" + evaResultSummaryInfo.getGradeLevel() + "'");
                if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                    PerfScorLevelDefineInfo scoreLevelDefineInfo = scoreLvDefColl.get(0);
                    evaResultSummaryInfo.put("perfScorLevelDefine", scoreLevelDefineInfo.getId().toString());
                }
            }
        }
        return evaResultSummaryInfo;
    }

    public static OrgEvaResultSummaryInfo setPerfscoreLevelForEvaresult(Context ctx, String evaObj, OrgEvaResultSummaryInfo evaResultSummaryInfo) throws BOSException {
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
        if (ruleInfo != null) {
            String perfRateId = ruleInfo.getPerfRate().getId().toString();
            PerfScoreLevelInfo scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId);
            evaResultSummaryInfo.setPerfScorLevel(scoreLevelInfo);
            if (scoreLevelInfo != null) {
                String perfScoreLevel = scoreLevelInfo.getId().toString();
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
                PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' and perfLevelName='" + evaResultSummaryInfo.getGradeLevel() + "'");
                if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                    PerfScorLevelDefineInfo scoreLevelDefineInfo = scoreLvDefColl.get(0);
                    evaResultSummaryInfo.put("perfScorLevelDefine", scoreLevelDefineInfo.getId().toString());
                }
            }
        }
        return evaResultSummaryInfo;
    }

    public static PerfScorLevelDefineInfo getPerfScoreLevelDefineInfo(Context ctx, String evaObj, String gradeLevel) throws BOSException {
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
        PerfScorLevelDefineInfo scoreLevelDefineInfo = null;
        scoreLevelDefineInfo = PerfWorkFlowUtils.getPerfScoreLevelDefineInfo(ctx, gradeLevel, ruleInfo, scoreLevelDefineInfo);
        return scoreLevelDefineInfo;
    }

    public static PerfScorLevelDefineInfo getMultiPerfScoreLevelDefineInfo(Context ctx, String evaObj, String gradeLevel) throws BOSException {
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getMultiPerformanceRuleInfoByEvaObj(ctx, evaObj);
        PerfScorLevelDefineInfo scoreLevelDefineInfo = null;
        scoreLevelDefineInfo = PerfWorkFlowUtils.getPerfScoreLevelDefineInfo(ctx, gradeLevel, ruleInfo, scoreLevelDefineInfo);
        return scoreLevelDefineInfo;
    }

    private static PerfScorLevelDefineInfo getPerfScoreLevelDefineInfo(Context ctx, String gradeLevel, PerformanceRuleInfo ruleInfo, PerfScorLevelDefineInfo scoreLevelDefineInfo) throws BOSException {
        String perfRateId;
        PerfScoreLevelInfo scoreLevelInfo;
        if (ruleInfo != null && (scoreLevelInfo = GetEntityInfoUtils.getPerfScoreLevelInfo(ctx, perfRateId = ruleInfo.getPerfRate().getId().toString())) != null) {
            String perfScoreLevel = scoreLevelInfo.getId().toString();
            IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance(ctx);
            PerfScorLevelDefineCollection scoreLvDefColl = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(" where perfScoreLevel='" + perfScoreLevel + "' and perfLevelName='" + gradeLevel + "'");
            if (scoreLvDefColl != null && scoreLvDefColl.size() > 0) {
                scoreLevelDefineInfo = scoreLvDefColl.get(0);
            }
        }
        return scoreLevelDefineInfo;
    }

    public static void addPerfWorkFlowHis(Context ctx, String wfid) throws BOSException, EASBizException {
        int i;
        IPWorkFlowDef ipWorkFlowDef = PWorkFlowDefFactory.getLocalInstance(ctx);
        IPWFLevelDef ipwfLevelDef = PWFLevelDefFactory.getLocalInstance(ctx);
        IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
        IPWorkFlowDefHIS ipWorkFlowDefHIS = PWorkFlowDefHISFactory.getLocalInstance(ctx);
        IPWFLevelDefHIS ipwfLevelDefHIS = PWFLevelDefHISFactory.getLocalInstance(ctx);
        IWFNodeDefHIS iwfNodeDefHIS = WFNodeDefHISFactory.getLocalInstance(ctx);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        PWorkFlowDefInfo pWorkFlowDefInfo = ipWorkFlowDef.getPWorkFlowDefInfo((IObjectPK)new ObjectUuidPK(wfid));
        PWFLevelDefCollection pwfLevelDefCollection = ipwfLevelDef.getPWFLevelDefCollection("where workflow='" + wfid + "'");
        WFNodeDefCollection wfNodeDefCollection = iwfNodeDef.getWFNodeDefCollection("where workflow='" + wfid + "'");
        IObjectPK pk = null;
        if (pWorkFlowDefInfo != null) {
            PWorkFlowDefHISInfo pWorkFlowDefHISInfo = new PWorkFlowDefHISInfo();
            BeanUtils.copyProperties((Object)pWorkFlowDefInfo, (Object)pWorkFlowDefHISInfo);
            pWorkFlowDefHISInfo.setEFFDT(nowDate);
            pWorkFlowDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
            pWorkFlowDefHISInfo.setCreateTime(nowTime);
            pWorkFlowDefHISInfo.setHistoryRelateId(pWorkFlowDefInfo.getId());
            pWorkFlowDefHISInfo.setId(null);
            pk = ipWorkFlowDefHIS.addnew(pWorkFlowDefHISInfo);
        }
        if (pk != null && pwfLevelDefCollection != null && pwfLevelDefCollection.size() > 0) {
            CoreBaseCollection pwfLevelDefBaseColl = new CoreBaseCollection();
            for (i = 0; i < pwfLevelDefCollection.size(); ++i) {
                PWFLevelDefInfo pwfLevelDefInfo = pwfLevelDefCollection.get(i);
                PWFLevelDefHISInfo pwfLevelDefHISInfo = new PWFLevelDefHISInfo();
                BeanUtils.copyProperties((Object)pwfLevelDefInfo, (Object)pwfLevelDefHISInfo);
                pwfLevelDefHISInfo.setEFFDT(nowDate);
                pwfLevelDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
                pwfLevelDefHISInfo.setCreateTime(nowTime);
                pwfLevelDefHISInfo.setHistoryRelateId(pwfLevelDefInfo.getId());
                pwfLevelDefHISInfo.setWorkflow(pk.toString());
                pwfLevelDefHISInfo.setId(null);
                pwfLevelDefBaseColl.add((CoreBaseInfo)pwfLevelDefHISInfo);
            }
            ipwfLevelDefHIS.addnewBatchData(pwfLevelDefBaseColl);
        }
        if (pk != null && wfNodeDefCollection != null && wfNodeDefCollection.size() > 0) {
            CoreBaseCollection wfNodeDefBaseColl = new CoreBaseCollection();
            for (i = 0; i < wfNodeDefCollection.size(); ++i) {
                WFNodeDefInfo wfNodeDefInfo = wfNodeDefCollection.get(i);
                WFNodeDefHISInfo wfNodeDefHISInfo = new WFNodeDefHISInfo();
                BeanUtils.copyProperties((Object)wfNodeDefInfo, (Object)wfNodeDefHISInfo);
                wfNodeDefHISInfo.setEFFDT(nowDate);
                wfNodeDefHISInfo.setLEFFDT(AtsDateUtils.stringToShortDate((String)"2099-12-31"));
                wfNodeDefHISInfo.setCreateTime(nowTime);
                wfNodeDefHISInfo.setHistoryRelateId(wfNodeDefInfo.getId());
                wfNodeDefHISInfo.setWorkflow(pk.toString());
                wfNodeDefHISInfo.setId(null);
                wfNodeDefBaseColl.add((CoreBaseInfo)wfNodeDefHISInfo);
            }
            iwfNodeDefHIS.addnewBatchData(wfNodeDefBaseColl);
        }
    }

    public static Set<String> getPerfGoalsFillerObjects(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo) throws BOSException {
        Set superiors;
        HashMap<String, String> evaPositionMap = new HashMap<String, String>();
        String evaObj = perfEvaObjectInfo.getId().toString();
        HashSet<String> goalsPerson = new HashSet<String>();
        boolean isOrg = OrgAssessmentUtils.isOrgAssessment(perfEvaObjectInfo);
        if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSuperiorFiller())) {
            if (isOrg) {
                String objectId = OrgAssessmentUtils.getOrgAdminResPositionIDByEvaObj(ctx, perfEvaObjectInfo, true);
                if (!StringUtils.isEmpty((String)objectId)) {
                    evaPositionMap.put(evaObj, objectId);
                }
            } else {
                String position = (String)perfEvaObjectInfo.get("position");
                if (!StringUtils.isEmpty((String)position)) {
                    evaPositionMap.put(evaObj, (String)perfEvaObjectInfo.get("position"));
                } else {
                    PositionInfo positionInfo = perfEvaObjectInfo.getPerfFile().getPosition();
                    if (positionInfo != null) {
                        evaPositionMap.put(evaObj, positionInfo.getId().toString());
                    }
                }
            }
        }
        Map<Object, Object> superiorMap = new HashMap();
        if (!CollectionUtils.isEmpty(evaPositionMap)) {
            superiorMap = PerfWorkFlowUtils.getDirectSuperiorByEvaObjs(ctx, evaPositionMap, false, isOrg);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", (Object)evaObj, CompareType.EQUALS));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemInfo.setPropertyName("perfEvaObject");
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(sorterItemInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSorter(sorterItemCollection);
        IPerfGoalsFillerObject iPerfGoalsFillerObject = PerfGoalsFillerObjectFactory.getLocalInstance(ctx);
        PerfGoalsFillerObjectCollection perfGoalsFillerObjectCollection = iPerfGoalsFillerObject.getPerfGoalsFillerObjectCollection(evi);
        if (perfGoalsFillerObjectCollection != null && perfGoalsFillerObjectCollection.size() > 0) {
            for (int i = 0; i < perfGoalsFillerObjectCollection.size(); ++i) {
                PerfGoalsFillerObjectInfo perfGoalsFillerObjectInfo = perfGoalsFillerObjectCollection.get(i);
                goalsPerson.add(perfGoalsFillerObjectInfo.getPerson());
            }
        }
        if (YesOrNoEnum.YES.equals((Object)perfEvaObjectInfo.getIsSelfFiller())) {
            if (isOrg) {
                goalsPerson.addAll(OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObj));
            } else {
                goalsPerson.add(perfEvaObjectInfo.getPerson().getId().toString());
            }
        }
        if ((superiors = (Set)superiorMap.get(evaObj)) != null && superiors.size() > 0) {
            for (String superior : superiors) {
                goalsPerson.add(superior);
            }
        }
        String inchargePosition = perfEvaObjectInfo.getPersonInchargePosition();
        int unitGoalsStatus = perfEvaObjectInfo.getUnitGoalsStatus().getValue();
        int personalGoalStatus = perfEvaObjectInfo.getPersonalGoalStatus().getValue();
        String id = perfEvaObjectInfo.getId().toString();
        if (PersonInchargeUtils.isFill2PersonIncharge(inchargePosition)) {
            HashSet<String> set = new HashSet<String>();
            set.add(id);
            Map<Object, Object> inchargeByids = new HashMap();
            try {
                if (unitGoalsStatus == 1 && (personalGoalStatus == 0 || personalGoalStatus == 1)) {
                    inchargeByids = PersonInchargeUtils.getPersonInchargeByids(ctx, set, true);
                } else if (personalGoalStatus == 0 || personalGoalStatus == 1) {
                    inchargeByids = PersonInchargeUtils.getDynamicPersonInchargeByids(ctx, set);
                } else {
                    try {
                        HashSet<String> receiverIds = new HashSet<String>();
                        GoalsMessageReceiverCollection goalsMessageReceiverCollection = GoalsMessageReceiverFactory.getLocalInstance(ctx).getGoalsMessageReceiverCollection("select receiver  where  evaObj.id ='" + id + "' and isSelf = 1  ");
                        Iterator iterator = goalsMessageReceiverCollection.iterator();
                        while (iterator.hasNext()) {
                            GoalsMessageReceiverInfo next = (GoalsMessageReceiverInfo)iterator.next();
                            receiverIds.add(next.getReceiver());
                        }
                        inchargeByids.put(id, receiverIds);
                    }
                    catch (BOSException e) {
                        logger.error("getSuperiorFillerString", (Throwable)e);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)((Collection)inchargeByids.get(id)))) {
                    goalsPerson.addAll((Collection)inchargeByids.get(id));
                }
            }
            catch (BOSException e) {
                logger.error("getSuperiorFillerString", (Throwable)e);
            }
        }
        return goalsPerson;
    }

    private static EntityViewInfo getOrgPRPEntityViewInfo(Set<String> positions) {
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo1.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("responPosition.id"));
        selector.add(new SelectorItemInfo("responPosition.parent.id"));
        selector.add(new SelectorItemInfo("parent.responPosition.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", positions, CompareType.INCLUDE));
        viewInfo1.setFilter(filterInfo);
        return viewInfo1;
    }

    private static EntityViewInfo getOrgRPDPEntityViewInfo(Set<String> positions) {
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo1.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("responPosition.id"));
        selector.add(new SelectorItemInfo("responPosition.parent.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", positions, CompareType.INCLUDE));
        viewInfo1.setFilter(filterInfo);
        return viewInfo1;
    }

    public static void setWorkFlowForTarget(Context ctx, IObjectCollection indicators) throws BOSException, EASBizException {
        if (indicators != null) {
            List<Object> list;
            String evaObjId;
            CoreBaseCollection coreColl = new CoreBaseCollection();
            HashSet<String> evaObjIds = new HashSet<String>();
            HashSet<String> areaBaseIds = new HashSet<String>();
            HashSet<String> perfPlanIds = new HashSet<String>();
            HashSet<String> perfRuleIds = new HashSet<String>();
            HashSet<String> allTargetIds = new HashSet<String>();
            HashSet<String> targetIds = new HashSet<String>();
            HashSet<String> mAreaBaseIds = new HashSet<String>();
            HashSet<String> mPerfPlanIds = new HashSet<String>();
            HashMap<String, ArrayList<CoreBaseInfo>> indicatorMap = new HashMap<String, ArrayList<CoreBaseInfo>>();
            HashMap<String, ArrayList<CoreBaseInfo>> defIndicatorMap = new HashMap<String, ArrayList<CoreBaseInfo>>();
            HashMap<String, ArrayList<CoreBaseInfo>> defHisIndicatorMap = new HashMap<String, ArrayList<CoreBaseInfo>>();
            HashSet<String> historyUpdates = new HashSet<String>();
            for (CoreBaseInfo coreBaseInfo : indicators) {
                PerfEvaObjectInfo evaObj = null;
                PerfPeriodInfo periodInfo = null;
                PerfPlanInfo perfPlanInfo = null;
                String areaBaseId = null;
                String perfRuleId = null;
                if (coreBaseInfo instanceof IndicatorTargetInfo) {
                    IndicatorTargetInfo indicator = (IndicatorTargetInfo)coreBaseInfo;
                    evaObj = indicator.getEvaObj();
                    areaBaseId = indicator.getAreaBase().getId().toString();
                    periodInfo = indicator.getPerfPeriod();
                    perfPlanInfo = indicator.getEvaPlan();
                    perfRuleId = indicator.getPerfRule().getId().toString();
                } else if (coreBaseInfo instanceof RecordTargetInfo) {
                    RecordTargetInfo record = (RecordTargetInfo)coreBaseInfo;
                    evaObj = record.getEvaObj();
                    areaBaseId = record.getAreaBase().getId().toString();
                    periodInfo = record.getPerfPeriod();
                    perfPlanInfo = record.getEvaPlan();
                    perfRuleId = record.getPerfRule().getId().toString();
                }
                if (evaObj == null || periodInfo == null || perfPlanInfo == null || StringUtils.isEmpty((String)areaBaseId) || StringUtils.isEmpty(perfRuleId)) {
                    logger.error("setWorkFlowForTarget err, this fields are required : [evaObj,  periodInfo, perfPlanInfo, areaBaseId, perfRuleId");
                    continue;
                }
                evaObjId = evaObj.getId().toString();
                evaObjIds.add(evaObjId);
                areaBaseIds.add(areaBaseId);
                String key = evaObjId + areaBaseId;
                list = (ArrayList<CoreBaseInfo>)indicatorMap.get(key);
                if (list == null) {
                    list = new ArrayList<CoreBaseInfo>();
                }
                list.add(coreBaseInfo);
                indicatorMap.put(key, (ArrayList<CoreBaseInfo>)list);
                if (TargetEvaluModeEnum.MATRIX.equals((Object)evaObj.getCanAdjustEvaluer())) {
                    String planId = perfPlanInfo.getId().toString();
                    perfPlanIds.add(planId);
                    perfRuleIds.add(perfRuleId);
                    String key2 = planId + areaBaseId + perfRuleId;
                    ArrayList<CoreBaseInfo> list2 = (ArrayList<CoreBaseInfo>)defIndicatorMap.get(key2);
                    if (list2 == null) {
                        list2 = new ArrayList<CoreBaseInfo>();
                    }
                    list2.add(coreBaseInfo);
                    defIndicatorMap.put(key2, list2);
                    if (YesOrNoEnum.YES.equals((Object)periodInfo.getIsHistoryUpdate())) {
                        historyUpdates.add(key2);
                        mAreaBaseIds.add(areaBaseId);
                        mPerfPlanIds.add(planId);
                        String key3 = planId + areaBaseId;
                        ArrayList<CoreBaseInfo> list3 = (ArrayList<CoreBaseInfo>)defHisIndicatorMap.get(key3);
                        if (list3 == null) {
                            list3 = new ArrayList<CoreBaseInfo>();
                        }
                        list3.add(coreBaseInfo);
                        defHisIndicatorMap.put(key3, list3);
                    }
                }
                allTargetIds.add(coreBaseInfo.get("id").toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("areaBase.id", areaBaseIds, CompareType.INCLUDE));
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("evaObj.id"));
            selectors.add(new SelectorItemInfo("areaBase.id"));
            selectors.add(new SelectorItemInfo("workflow.id"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSelector(selectors);
            PerfEvaObjMatrixWorkFlowInstCollection instColl = PerfEvaObjMatrixWorkFlowInstFactory.getLocalInstance(ctx).getPerfEvaObjMatrixWorkFlowInstCollection(evi);
            if (instColl != null && !instColl.isEmpty()) {
                Iterator it = instColl.iterator();
                while (it.hasNext()) {
                    PerfEvaObjMatrixWorkFlowInstInfo instInfo = (PerfEvaObjMatrixWorkFlowInstInfo)it.next();
                    PerfEvaObjectInfo evaObj = instInfo.getEvaObj();
                    evaObjId = evaObj.getId().toString();
                    String areaBaseId = instInfo.getAreaBase().getId().toString();
                    list = (List)indicatorMap.get(evaObjId + areaBaseId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    PerfWorkFlowUtils.setIndicatorWorkFlow(coreColl, targetIds, list, instInfo.getWorkflow().getId().toString());
                }
            }
            if (defIndicatorMap.size() > 0) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("perfPlan.id", perfPlanIds, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("areaBase.id", areaBaseIds, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("perfRule.id", perfRuleIds, CompareType.INCLUDE));
                selectors = new SelectorItemCollection();
                selectors.add("perfPlan.id");
                selectors.add("areaBase.id");
                selectors.add("perfRule.id");
                selectors.add("workflow.id");
                evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectors);
                IPerfEvaObjectMatrixWorkFlow iMatrixWorkFlow = PerfEvaObjectMatrixWorkFlowFactory.getLocalInstance(ctx);
                PerfEvaObjectMatrixWorkFlowCollection defMatrixs = iMatrixWorkFlow.getPerfEvaObjectMatrixWorkFlowCollection(evi);
                if (historyUpdates.size() > 0) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("perfPlan.id", mPerfPlanIds, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("areaBase.id", mAreaBaseIds, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("perfRule.id", null, CompareType.IS));
                    evi.setFilter(filterInfo);
                    PerfEvaObjectMatrixWorkFlowCollection defMatrixs2 = iMatrixWorkFlow.getPerfEvaObjectMatrixWorkFlowCollection(evi);
                    if (defMatrixs != null) {
                        defMatrixs.addCollection(defMatrixs2);
                    }
                }
                if (defMatrixs != null) {
                    Iterator it = defMatrixs.iterator();
                    while (it.hasNext()) {
                        List list2;
                        PerfEvaObjectMatrixWorkFlowInfo matrixWorkFlowInfo = (PerfEvaObjectMatrixWorkFlowInfo)it.next();
                        String perfPlanId = matrixWorkFlowInfo.getPerfPlan().getId().toString();
                        String areaBaseId = matrixWorkFlowInfo.getAreaBase().getId().toString();
                        PerformanceRuleInfo perfRuleInfo = matrixWorkFlowInfo.getPerfRule();
                        if (perfRuleInfo != null) {
                            String perfRuleId = perfRuleInfo.getId().toString();
                            list2 = (List)defIndicatorMap.get(perfPlanId + areaBaseId + perfRuleId);
                        } else {
                            list2 = (List)defHisIndicatorMap.get(perfPlanId + areaBaseId);
                        }
                        if (CollectionUtils.isEmpty((Collection)list2)) continue;
                        PerfWorkFlowUtils.setIndicatorWorkFlow(coreColl, targetIds, list2, matrixWorkFlowInfo.getWorkflow().getId().toString());
                    }
                }
            }
            allTargetIds.removeAll(targetIds);
            if (allTargetIds.size() > 0) {
                for (CoreBaseInfo targetInfo : indicators) {
                    PWorkFlowDefInfo workFlowDefInfo;
                    String targetId = targetInfo.getId().toString();
                    if (!allTargetIds.contains(targetId)) continue;
                    PerfEvaObjectInfo evaObjectInfo = null;
                    if (targetInfo instanceof IndicatorTargetInfo) {
                        IndicatorTargetInfo indicator = (IndicatorTargetInfo)targetInfo;
                        evaObjectInfo = indicator.getEvaObj();
                    } else if (targetInfo instanceof RecordTargetInfo) {
                        RecordTargetInfo record = (RecordTargetInfo)targetInfo;
                        evaObjectInfo = record.getEvaObj();
                    }
                    if (evaObjectInfo == null || (workFlowDefInfo = evaObjectInfo.getWorkFlow()) == null) continue;
                    targetInfo.put("workflow", (Object)workFlowDefInfo.getId().toString());
                    coreColl.add(targetInfo);
                }
            }
            if (coreColl.size() > 0) {
                CoreBaseInfo baseInfo = coreColl.get(0);
                if (baseInfo instanceof IndicatorTargetInfo) {
                    IndicatorTargetFactory.getLocalInstance(ctx).save(coreColl);
                } else if (baseInfo instanceof RecordTargetInfo) {
                    RecordTargetFactory.getLocalInstance(ctx).save(coreColl);
                }
            }
        }
    }

    private static void setIndicatorWorkFlow(CoreBaseCollection coreColl, Set<String> targetIds, List<CoreBaseInfo> list, String workFlowId) {
        for (CoreBaseInfo inTargetInfo : list) {
            String toSetTargetId = inTargetInfo.getId().toString();
            if (!CollectionUtils.isEmpty(targetIds) && targetIds.contains(toSetTargetId)) continue;
            inTargetInfo.put("workflow", (Object)workFlowId);
            targetIds.add(inTargetInfo.getId().toString());
            coreColl.add(inTargetInfo);
        }
    }

    public static boolean isFromWf(Context ctx, String billId, String msgId, String userId) {
        if (StringUtils.isEmpty((String)billId)) {
            return false;
        }
        if (StringUtils.isEmpty((String)userId)) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        if (PerfWorkFlowUtils.checkWFBillInProcessSecurity(ctx, billId, userId)) {
            return true;
        }
        if (PerfWorkFlowUtils.checkWFBillFinishedSecurity(ctx, billId, userId)) {
            return true;
        }
        if (PerfWorkFlowUtils.checkWFBillCirculationSecurity(ctx, msgId, userId)) {
            return true;
        }
        return true;
    }

    private static boolean checkWFBillInProcessSecurity(Context ctx, String billId, String userId) {
        String sql = "SELECT FASSIGNID FROM t_wfr_assign where FBIZOBJID = ? and FPERSONUSERID = ? ";
        return PerfWorkFlowUtils.isWfPermission(ctx, billId, userId, sql);
    }

    private static boolean checkWFBillFinishedSecurity(Context ctx, String billId, String userId) {
        String sql = "SELECT FASSIGNID FROM t_wfr_assigndetail where FBIZOBJID = ? and FPERSONUSERID = ? ";
        return PerfWorkFlowUtils.isWfPermission(ctx, billId, userId, sql);
    }

    private static boolean checkWFBillCirculationSecurity(Context ctx, String msgId, String userId) {
        if (logger.isDebugEnabled()) {
            logger.debug("checkWFBillCirculationSecurity begin");
        }
        if (StringUtils.isEmpty((String)msgId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkWFBillCirculationSecurity msgId is null");
            }
            return false;
        }
        try {
            String sql = "SELECT count(*) cc FROM T_BAS_Message where fid = ? and (FRECEIVER = ? or FSENDERID = ? ) ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{msgId, userId, userId});
            boolean var7 = false;
            while (null != rs && rs.next()) {
                int cc = rs.getInt("cc");
                if (cc < 1) continue;
                return true;
            }
            return false;
        }
        catch (BOSException var8) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkWFBillCirculationSecurity BOSException,e=", (Throwable)var8);
            }
            return false;
        }
        catch (SQLException var9) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkWFBillCirculationSecurity SQLException,e=", (Throwable)var9);
            }
            return false;
        }
    }

    private static boolean isWfPermission(Context ctx, String billId, String userId, String sql) {
        if (logger.isDebugEnabled()) {
            logger.debug("isWfPermission begin");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId, userId});
        }
        catch (BOSException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("isWfPermission error,e=", (Throwable)e);
            }
            return false;
        }
        return rs.size() > 0;
    }
}

