/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.common.IPerfSMSConfig;
import com.kingdee.shr.perfweb.app.common.PerfSMSConfigFactory;
import com.kingdee.shr.perfweb.app.common.PerfSMSConfigInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.utils.CommonSmsStrategy;
import com.kingdee.shr.perfweb.utils.JsonUtils;
import com.kingdee.shr.perfweb.utils.SmsEmpSha256Util;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import com.kingdee.shr.smsplatform.service.SMSSendEntry;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SmsUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.SmsUtils");

    public static void main(String apiUrl, String tenantId, String token, Map param) {
        if (StringUtils.isEmpty((String)apiUrl)) {
            apiUrl = "http://ssmc.kingdee.com/message/smssend/other/send";
        }
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = "EK_4414138";
        }
        if (StringUtils.isEmpty((String)token)) {
            token = "09074eb8ab6e48e282bab36610c2ecac64D8CA7395D9C2EAE12107C66132B20A";
        }
        if (CollectionUtils.isEmpty((Map)param)) {
            param = new HashMap<String, String>();
            param.put("phone", "15626131368");
            param.put("content", "Tina|2022|2023-04-10|Kindee\uff08Test Data\uff09");
            param.put("apiUrl", "http://ssmc.kingdee.com/message/smssend/other/send");
            param.put("tempNumber", "perf_evaluate_target10_all");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("tenantId", tenantId);
        header.put("token", token);
        String response = SmsUtils.doHttpPost("http://ssmc.kingdee.com/message/smssend/other/send", param, header, null);
        logger.error("[perfweb]response:" + response);
    }

    public static Map smsHttpPost(Context ctx, Map<String, String> paramMap) {
        logger.error("[perfweb]smsHttpPost\uff1a" + JsonUtils.getJsonStr(paramMap));
        String sendMode = paramMap.get("sendMode");
        String evaObjId = paramMap.get("evaObjId");
        if ("customizeTemplate".equals(sendMode) && !StringUtils.isEmpty((String)evaObjId)) {
            return SmsUtils.sendSmsByCustomizeTemplate(ctx, paramMap);
        }
        return SmsUtils.smsHttpPost(ctx, paramMap, null);
    }

    public static Map sendSmsByCustomizeTemplate(Context ctx, Map<String, String> params) {
        Map map = SmsUtils.verifyCustomizeSmsParams(ctx, params);
        if (map != null && !StringUtils.isEmpty((String)((String)map.get("errorcode")))) {
            return map;
        }
        HashMap<String, String> preParams = new HashMap<String, String>();
        String phone = (String)map.get("phone");
        String content = (String)map.get("content");
        String hrOrgUnitId = (String)map.get("hrOrgUnitId");
        String smsCode = (String)map.get("smsCode");
        String paramKeys = (String)map.get("paramKeys");
        String evaObjId = (String)map.get("evaObjId");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> cloudParams = new HashMap<String, String>();
        HashMap customParams = new HashMap();
        if (!StringUtils.isEmpty((String)paramKeys)) {
            String[] paramValArr = content.split("\\|");
            String[] paramKeyArr = paramKeys.split("\\|");
            for (int i = 0; i < paramKeyArr.length; ++i) {
                if ("shortUrl".equalsIgnoreCase(paramKeyArr[i])) {
                    cloudParams.put(paramKeyArr[i], paramValArr.length > i ? paramValArr[i] : "");
                    continue;
                }
                preParams.put(paramKeyArr[i], paramValArr.length > i ? paramValArr[i] : "");
            }
        }
        logger.error("[perfweb]sendSmsByCustomizeTemplate\uff1a" + JsonUtils.getJsonStr(params));
        if (!StringUtils.isEmpty((String)evaObjId)) {
            queryParams.put("id", evaObjId);
        }
        Object[] mapObjs = new Object[]{preParams, queryParams, cloudParams, customParams};
        Map result = SMSSendEntry.sendSMS((ISMSStrategy)new CommonSmsStrategy(smsCode, phone, hrOrgUnitId, mapObjs), (Context)ctx);
        logger.error("[perfweb]sendSmsByCustomizeTemplate send success:" + JsonUtils.getJsonStr(result));
        HashMap resultMap = new HashMap(2);
        resultMap.put("errorcode", result.get("code"));
        resultMap.put("errormsg", result.get("errMsg"));
        resultMap.put("data", result.get("data"));
        resultMap.put("HTTP_CLIENT_USER_RESULT", JsonUtils.getJsonStr(resultMap));
        return resultMap;
    }

    public static Map smsHttpPost(Context ctx, Map<String, String> paramMap, String charset) {
        Map map = SmsUtils.verifySmsParams(ctx, paramMap);
        if (map != null && !StringUtils.isEmpty((String)((String)map.get("errorcode")))) {
            return map;
        }
        String resp = SmsUtils.httpPost((String)map.get("apiUrl"), (Map)map.get("param"), (Map)map.get("smsCommonHeader"), charset);
        logger.error("[perfweb]sms smsHttpPost resp:" + resp);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
        String data = resultJsonObject.getString("data");
        if (data.contains("errorcode")) {
            resultMap.put("HTTP_CLIENT_USER_RESULT", data);
            logger.error("[perfweb]sms send success:" + data);
        } else {
            resultMap.put("errorMsg", "can not connect to tsp sms service!");
            resultMap.put("responseMsg", data);
            logger.error("[perfweb] can not connect to tsp sms service,responseMsg:" + data);
        }
        return resultMap;
    }

    private static Map verifyCustomizeSmsParams(Context ctx, Map<String, String> paramMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(paramMap)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "paramMap can't empty");
            return result;
        }
        StringBuilder errorMsg = new StringBuilder("");
        String phone = paramMap.get("phone");
        if (StringUtils.isEmpty((String)phone)) {
            errorMsg.append("phone can't empty");
        }
        String content = paramMap.get("content");
        String perfSmsCode = paramMap.get("perfSmsCode");
        if (StringUtils.isEmpty((String)perfSmsCode)) {
            errorMsg.append("perfSmsCode can't empty");
        }
        if (errorMsg.length() > 0) {
            result.put("errorcode", "-1");
            result.put("errormsg", errorMsg.toString());
            return result;
        }
        Map<String, String> smsCodeConfigMap = SmsUtils.getSmsConfigMap(ctx, perfSmsCode);
        String smsCode = smsCodeConfigMap.get("smsCode");
        String paramKeys = smsCodeConfigMap.get("paramKeys");
        if (StringUtils.isEmpty((String)smsCode)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "smsCode can't empty");
            return result;
        }
        String hrOrgUnitId = paramMap.get("hrOrgUnitId");
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            hrOrgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (StringUtils.isEmpty((String)content)) {
            content = "";
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("smsCode", smsCode);
        param.put("paramKeys", paramKeys);
        param.put("phone", phone);
        param.put("content", content);
        param.put("hrOrgUnitId", hrOrgUnitId);
        param.put("evaObjId", paramMap.get("evaObjId"));
        logger.error("[perfweb]sms verifyCustomizeSmsParams:" + JsonUtils.getJsonStr(param));
        return param;
    }

    private static Map verifySmsParams(Context ctx, Map<String, String> paramMap) {
        String apiUrl;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(paramMap)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "paramMap can't empty");
            return result;
        }
        StringBuilder errorMsg = new StringBuilder("");
        String phone = paramMap.get("phone");
        if (StringUtils.isEmpty((String)phone)) {
            errorMsg.append("phone can't empty");
        }
        String content = paramMap.get("content");
        String perfSmsCode = paramMap.get("perfSmsCode");
        if (StringUtils.isEmpty((String)perfSmsCode)) {
            errorMsg.append("perfSmsCode can't empty");
        }
        if (StringUtils.isEmpty((String)(apiUrl = paramMap.get("apiUrl")))) {
            errorMsg.append("apiUrl can't empty");
        }
        if (errorMsg.length() > 0) {
            result.put("errorcode", "-1");
            result.put("errormsg", errorMsg.toString());
            return result;
        }
        String smsCode = SmsUtils.getSmsCode(ctx, perfSmsCode);
        if (StringUtils.isEmpty((String)smsCode)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "smsCode can't empty");
            return result;
        }
        if (StringUtils.isEmpty((String)content)) {
            content = "";
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("phone", phone);
        param.put("tempNumber", smsCode);
        param.put("content", content);
        Map smsCommonHeader = SmsUtils.getSmsCommonHeader(ctx, phone, content);
        if (CollectionUtils.isEmpty((Map)smsCommonHeader)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "sms header can't empty");
            return result;
        }
        result.put("param", param);
        result.put("apiUrl", apiUrl);
        result.put("smsCommonHeader", smsCommonHeader);
        if (logger.isDebugEnabled()) {
            logger.error("[perfweb]sms verifySmsParams:" + JsonUtils.getJsonStr(result));
        }
        return result;
    }

    private static Map getSmsCommonHeader(Context ctx, String phone, String content) {
        return SmsEmpSha256Util.getHeader(ctx, phone, content);
    }

    protected static String getSmsCode(Context ctx, String perfSmsCode) {
        block5: {
            if (StringUtils.isEmpty((String)perfSmsCode)) {
                return "";
            }
            try {
                IPerfSMSConfig iInstance = PerfSMSConfigFactory.getLocalInstance(ctx);
                PerfSMSConfigInfo configInfo = iInstance.getPerfSMSConfigInfo("select smsCode where perfSmsCode='" + perfSmsCode + "'");
                return configInfo.getSmsCode();
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.error("[perfweb] it is failed to get sms config!", (Throwable)e);
                }
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.error("[perfweb] it is failed to get sms config!", (Throwable)e);
            }
        }
        return "";
    }

    protected static Map<String, String> getSmsConfigMap(Context ctx, String perfSmsCode) {
        HashMap<String, String> result;
        block5: {
            result = new HashMap<String, String>(2);
            if (StringUtils.isEmpty((String)perfSmsCode)) {
                return null;
            }
            try {
                IPerfSMSConfig iInstance = PerfSMSConfigFactory.getLocalInstance(ctx);
                PerfSMSConfigInfo configInfo = iInstance.getPerfSMSConfigInfo("select smsCode,paramKeys where perfSmsCode='" + perfSmsCode + "'");
                result.put("smsCode", configInfo.getSmsCode());
                result.put("paramKeys", configInfo.getParamKeys());
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.error("[perfweb] it is failed to get sms config!", (Throwable)e);
                }
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.error("[perfweb] it is failed to get sms config!", (Throwable)e);
            }
        }
        return result;
    }

    private static String httpPost(String url, Map paramMap, Map<String, String> headerMap) {
        return SmsUtils.httpPost(url, paramMap, headerMap, null);
    }

    private static String httpPost(String url, Map paramMap, Map<String, String> headerMap, String charSet) {
        return SmsUtils.doHttpPost(url, paramMap, headerMap, charSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doHttpPost(String url, Map<String, String> params, Map<String, String> header, String charSet) {
        if (logger.isDebugEnabled()) {
            logger.error("[perfweb]doHttpPost params:" + JsonUtils.getJsonStr(params));
        }
        if (logger.isDebugEnabled()) {
            logger.error("[perfweb]doHttpPost header:" + JsonUtils.getJsonStr(header));
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("accept", "*/*");
        httpPost.addHeader("content-Type", "application/json");
        if (StringUtils.isEmpty((String)charSet)) {
            charSet = "UTF-8";
        }
        if (!header.isEmpty()) {
            Set<Map.Entry<String, String>> headEntrys = header.entrySet();
            for (Map.Entry<String, String> entry : headEntrys) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!params.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            Set<Map.Entry<String, String>> paramEntrys = params.entrySet();
            for (Map.Entry<String, String> entry : paramEntrys) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String result = "";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
            JSONObject successObject = new JSONObject();
            successObject.put("code", (Object)response.getStatusLine().getStatusCode());
            successObject.put("data", (Object)string);
            result = successObject.toJSONString();
            if (logger.isDebugEnabled()) {
                logger.error("[perfweb] smsUtils#doHttpPost, result:" + result);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("[perfweb] it is failed to doHttpPost", (Throwable)e);
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"400");
            result = jSONObject.toJSONString();
        }
        finally {
            block21: {
                try {
                    client.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block21;
                    logger.error("[perfweb] it is failed to close doHttpPost", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static void assembleOtherParam(PerfEvaObjectInfo evaObjectInfo, Map params) {
        if (evaObjectInfo != null) {
            params.put("hrOrgUnitId", evaObjectInfo.getHrUnitOrg() != null ? evaObjectInfo.getHrUnitOrg().getId().toString() : "");
            params.put("evaObjId", evaObjectInfo.getId().toString());
        }
    }

    public static void assembleOtherParam4Multi(MultiPerfEvaObjectInfo evaObjectInfo, Map params) {
        if (evaObjectInfo != null) {
            params.put("hrOrgUnitId", evaObjectInfo.getHrUnitOrg() != null ? evaObjectInfo.getHrUnitOrg().getId().toString() : "");
            params.put("evaObjId", evaObjectInfo.getId().toString());
        }
    }
}

