/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeManageFacadeFactory;
import com.kingdee.eas.hr.emp.app.EmployeeManageUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.preentry.PEPersonRewardPunishCollection;
import com.kingdee.shr.preentry.PEPersonRewardPunishInfo;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.preentry.app.AbstractPEPersonRewardPunishControllerBean;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class PEPersonRewardPunishControllerBean
extends AbstractPEPersonRewardPunishControllerBean {
    @Override
    protected IObjectCollection _getRecordsByPerson(Context ctx, BOSUuid personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)personId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.getPEPersonRewardPunishCollection(ctx, evi);
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PEPersonRewardPunishInfo linkmanInfo = (PEPersonRewardPunishInfo)model;
        if (linkmanInfo.getTalent() != null && (linkmanInfo.getTalent().getName() == null || linkmanInfo.getTalent().getNumber() == null)) {
            ObjectUuidPK pk = new ObjectUuidPK(linkmanInfo.getTalent().getId());
            PreEntryPersonInfo talentInfo = PreEntryPersonFactory.getLocalInstance(ctx).getPreEntryPersonInfo((IObjectPK)pk);
            linkmanInfo.setTalent(talentInfo);
        }
        return super.addnew(ctx, linkmanInfo);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PEPersonRewardPunishCollection prpColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < prpColl.size(); ++i) {
            if (prpColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)prpColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(prpColl.get(i).getId()), (IObjectValue)prpColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection records, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PEPersonRewardPunishCollection)records);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PEPersonRewardPunishInfo info = (PEPersonRewardPunishInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        String prePersonID = info.getTalent().getId().toString();
        if (info.getRepealDate() != null) {
            info.setRepealDate(DateTimeUtils.truncateDate((Date)info.getRepealDate()));
        }
        if (info.getOccurDate() != null) {
            info.setOccurDate(DateTimeUtils.truncateDate((Date)info.getOccurDate()));
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this._setVIPItem(ctx, pk.toString(), prePersonID);
        return pk;
    }

    @Override
    protected void _setVIPItem(Context ctx, String id, String prePersonID) throws BOSException, EASBizException {
        String notVipOther = "UPDATE T_HR_PEPersonRewardPunish SET FVIP = 0 WHERE FID <> ? AND FTalentID = ?";
        String vip = "UPDATE T_HR_PEPersonRewardPunish SET FVIP = 1 WHERE FID = ? AND FTalentID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(notVipOther);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)prePersonID);
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(vip);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)prePersonID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PEPersonRewardPunishInfo info = (PEPersonRewardPunishInfo)model;
        if (info.getRepealDate() != null) {
            info.setRepealDate(DateTimeUtils.truncateDate((Date)info.getRepealDate()));
        }
        if (info.getOccurDate() != null) {
            info.setOccurDate(DateTimeUtils.truncateDate((Date)info.getOccurDate()));
        }
        super._update(ctx, pk, (IObjectValue)info);
        if (info.getTalent() != null) {
            EmployeeManageFacadeFactory.getLocalInstance((Context)ctx).updateEmpVipInfo("T_HR_PEPersonRewardPunish", "FVIP", "FTalentID", info.getTalent().getId().toString());
        }
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("talent.id"));
        PEPersonRewardPunishCollection col = this.getPEPersonRewardPunishCollection(ctx, viewInfo);
        IObjectPK[] pks = super._delete(ctx, filter);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PEPersonRewardPunishInfo info = col.get(i);
                if (info.getTalent() == null) continue;
                personSet.add(info.getTalent().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance((Context)ctx).batchUpdateEmpVipInfo("T_HR_PEPersonRewardPunish", "FVIP", "FTalentID", personSet, true);
        }
        return pks;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("talent.id"));
        PEPersonRewardPunishInfo info = (PEPersonRewardPunishInfo)this._getValue(ctx, pk, selector);
        super._delete(ctx, pk);
        if (info.getTalent() != null) {
            EmployeeManageFacadeFactory.getLocalInstance((Context)ctx).updateEmpVipInfo("T_HR_PEPersonRewardPunish", "FVIP", "FPersonID", info.getTalent().getId().toString());
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)EmployeeManageUtil.convertPKToSet((IObjectPK[])arrayPK), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("talent.id"));
        PEPersonRewardPunishCollection col = this.getPEPersonRewardPunishCollection(ctx, viewInfo);
        super._delete(ctx, arrayPK);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PEPersonRewardPunishInfo info = col.get(i);
                if (info.getTalent() == null) continue;
                personSet.add(info.getTalent().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance((Context)ctx).batchUpdateEmpVipInfo("T_HR_PEPersonRewardPunish", "FVIP", "FTalentID", personSet, true);
        }
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        PEPersonRewardPunishCollection col = this.getPEPersonRewardPunishCollection(ctx, oql);
        IObjectPK[] pks = super._delete(ctx, oql);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PEPersonRewardPunishInfo info = col.get(i);
                if (info.getTalent() == null) continue;
                personSet.add(info.getTalent().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance((Context)ctx).batchUpdateEmpVipInfo("T_HR_PEPersonRewardPunish", "FVIP", "FTalentID", personSet, true);
        }
        return pks;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String temp = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("talent.id"));
        sic.add(new SelectorItemInfo("talent.name"));
        sic.add(new SelectorItemInfo("talent.number"));
        sic.add(new SelectorItemInfo("content"));
        PEPersonRewardPunishInfo info = (PEPersonRewardPunishInfo)this._getValue(ctx, pk, sic);
        temp = info.getTalent().getNumber() + info.getTalent().getName() + " " + info.getContent();
        return temp;
    }
}

