/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.classloader;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.commons.io.FilenameUtils;

public class CreateClassPathJar {
    public static void main(String[] args) {
        String path = "w://eas//server";
        String tempPath = CreateClassPathJar.generateClassPath(path);
        System.out.println("classPath = " + tempPath);
    }

    public static String generateClassPath(String easPath) {
        String[] paths = new String[]{"/server/lib/service/"};
        StringBuffer path = new StringBuffer();
        if (System.getProperty("devclasspath") != null) {
            path.append(FilenameUtils.normalize((String)System.getProperty("devclasspath")));
        }
        StringBuffer tempBuffer = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            tempBuffer = CreateClassPathJar.generateJarFileWithoutSubDir(easPath + paths[i]);
            if (tempBuffer.length() <= 0) continue;
            if (path.length() > 0) {
                path.append(";");
            }
            path.append(tempBuffer);
        }
        return path.toString();
    }

    public static StringBuffer generateClassPath(String path, boolean includeAllSubDir) {
        File file = new File(path);
        StringBuffer classPath = new StringBuffer("");
        if (file.exists()) {
            File[] dirList = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (dirList != null && dirList.length > 0) {
                for (int i = 0; i < dirList.length; ++i) {
                    File tempDirFile = dirList[i];
                    File[] fileList = tempDirFile.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.substring(name.lastIndexOf(".") + 1).equalsIgnoreCase("jar") || name.substring(name.lastIndexOf(".") + 1).equalsIgnoreCase("zip");
                        }
                    });
                    if (fileList == null) continue;
                    for (int j = 0; j < fileList.length; ++j) {
                        if (classPath.length() > 0) {
                            classPath.append(";");
                        }
                        classPath.append(fileList[j].getAbsolutePath());
                    }
                }
                if (includeAllSubDir) {
                    if (classPath == null || classPath.length() > 0) {
                        // empty if block
                    }
                    classPath = new StringBuffer("");
                }
            } else {
                CreateClassPathJar.clearClassPathJar(path);
                CreateClassPathJar.generateJarFileWithoutSubDir(path);
            }
        }
        return classPath;
    }

    private static StringBuffer generateJarFileWithoutSubDir(String filePath) {
        File[] jarList;
        File fileDir = new File(SHRCheck.checkFilePath(filePath));
        StringBuffer classPath = new StringBuffer();
        if (!fileDir.isDirectory()) {
            classPath.append(fileDir.getAbsolutePath());
        }
        if (fileDir.exists() && (jarList = fileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.substring(name.lastIndexOf(".") + 1).equalsIgnoreCase("jar") || name.substring(name.lastIndexOf(".") + 1).equalsIgnoreCase("zip");
            }
        })) != null && jarList.length > 0) {
            for (int j = 0; j < jarList.length; ++j) {
                if (classPath.length() > 0) {
                    classPath.append(";");
                }
                classPath.append(jarList[j].getAbsolutePath());
            }
        }
        return classPath;
    }

    private static void clearClassPathJar(String filePath) {
        String jarName = filePath.substring(filePath.lastIndexOf(92)) + "_classpath.jar";
        File file = new File(filePath + jarName);
        if (file.exists()) {
            file.delete();
        }
    }
}

