/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.BaseItemLevelUpRecordFactory;
import com.kingdee.shr.base.syssetting.IBaseItemLevelUpRecord;
import com.kingdee.shr.base.syssetting.ListFilterSolutionFactory;
import com.kingdee.shr.base.syssetting.ListSetSolutionFactory;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewExtCollection;
import com.kingdee.shr.base.syssetting.UIViewExtFactory;
import com.kingdee.shr.base.syssetting.UIViewExtInfo;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.AbstractUIViewControllerBean;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.HTMLUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class UIViewControllerBean
extends AbstractUIViewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.UIViewControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UIViewInfo uiViewInfo = (UIViewInfo)model;
        String uipk = uiViewInfo.getUipk();
        this.trimValue(uiViewInfo);
        this.checkData(ctx, uiViewInfo);
        this.checkURI(ctx, uiViewInfo);
        uiViewInfo.setUipk(this.getUIPK(uiViewInfo));
        this.checkDup(ctx, uiViewInfo);
        return super._save(ctx, model);
    }

    private void trimValue(UIViewInfo uiViewInfo) {
        if (uiViewInfo.getModel() != null) {
            uiViewInfo.setModel(uiViewInfo.getModel().trim());
        }
        if (uiViewInfo.getUipk() != null) {
            uiViewInfo.setUipk(uiViewInfo.getUipk().trim());
        }
        if (uiViewInfo.getUri() != null) {
            uiViewInfo.setUri(uiViewInfo.getUri().trim());
        }
    }

    private void checkData(Context ctx, UIViewInfo uiViewInfo) throws EASBizException, BOSException {
        this.checkConfigContent(uiViewInfo.getContent());
    }

    private void checkConfigContent(String content) throws SyssettinException, BOSException {
        if (!StringUtils.isEmpty((String)content)) {
            try {
                XMLUtil.parseXML(content);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String message = HTMLUtil.escape(e.getMessage());
                throw new SyssettinException(SyssettinException.CONFIG_INCORRECT, new Object[]{"<br>" + message});
            }
        }
    }

    private void checkURI(Context ctx, UIViewInfo uiViewInfo) throws SyssettinException {
        String uri = uiViewInfo.getUri();
        if (StringUtils.isEmpty((String)uri)) {
            return;
        }
        Set set = UIType.getEnumMap().keySet();
        Iterator it = set.iterator();
        String item = null;
        String model = uiViewInfo.getModel();
        while (it.hasNext()) {
            item = (String)it.next();
            if (!uri.equalsIgnoreCase(model + "." + item)) continue;
            throw new SyssettinException(SyssettinException.URI_INVALID);
        }
    }

    private String getUIPK(UIViewInfo uiViewInfo) {
        String uipk = null;
        uipk = !StringUtils.isEmpty((String)uiViewInfo.getUri()) ? uiViewInfo.getUri() : uiViewInfo.getModel() + "." + uiViewInfo.getType().getName();
        return uipk;
    }

    private void checkDup(Context ctx, UIViewInfo uiViewInfo) throws EASBizException, BOSException {
        this.checkUIPKDup(ctx, uiViewInfo);
    }

    private void checkUIPKDup(Context ctx, UIViewInfo uiViewInfo) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uiViewInfo.getUipk()));
        if (uiViewInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)uiViewInfo.getId(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{uiViewInfo.getUipk()});
        }
    }

    @Override
    protected IObjectPK _extendSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UIViewInfo info = (UIViewInfo)model;
        String uipk = info.getUipk();
        if (uipk.equals("systembasicdatainitialize")) {
            try {
                int n = 1 / 0;
            }
            catch (Exception e) {
                System.out.println("debugxggg1111");
                e.printStackTrace();
            }
        }
        String extendConfig = info.getExtend();
        info.setExtend(null);
        IObjectPK pk = null;
        if (!info.isInner()) {
            pk = this._save(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        } else if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId().toString());
        }
        UIViewExtInfo extInfo = this.assembleExtInfo(info, extendConfig);
        UIViewExtFactory.getLocalInstance(ctx).save((CoreBaseInfo)extInfo);
        return pk;
    }

    private UIViewExtInfo assembleExtInfo(UIViewInfo info, String config) {
        UIViewExtInfo extInfo = new UIViewExtInfo();
        extInfo.setParent(info);
        extInfo.setUipk(info.getUipk());
        extInfo.setContent(config);
        return extInfo;
    }

    @Override
    protected IObjectValue _getValueByUipk(Context ctx, String uipk, SelectorItemCollection selector) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(selector);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        entityViewInfo.setFilter(filterInfo);
        UIViewCollection collection = this.getUIViewCollection(ctx, entityViewInfo);
        if (collection != null && collection.size() > 0) {
            if (collection.size() > 1) {
                logger.error((Object)("UIView has more than 1, filter: " + filterInfo));
            }
            return this.mergeExtInfo(ctx, collection.get(0));
        }
        return null;
    }

    private UIViewInfo mergeExtInfo(Context ctx, UIViewInfo info) throws BOSException {
        if (info == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("content"));
        UIViewExtCollection collection = UIViewExtFactory.getLocalInstance(ctx).getUIViewExtCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            UIViewExtInfo extInfo = collection.get(0);
            info.setExtend(extInfo.getContent());
        }
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UIViewInfo info = (UIViewInfo)super._getValue(ctx, pk);
        return this.mergeExtInfo(ctx, info);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        UIViewInfo info = (UIViewInfo)super._getValue(ctx, pk, selector);
        return this.mergeExtInfo(ctx, info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("inner", (Object)true));
        if (this._exists(ctx, filter)) {
            throw new SyssettinException(SyssettinException.DEFAULT_VIEW_NOT_DELETE);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("uipk"));
        UIViewInfo model = (UIViewInfo)this._getValue(ctx, pk, selector);
        this.deleteExtInfo(ctx, pk);
        this.deleteListSetSolution(ctx, pk);
        this.deleteListFilterSolution(ctx, pk);
        UIViewUtil.cleanViewInfo((String[])new String[]{model.getUipk()});
        super._delete(ctx, pk);
    }

    private void deleteExtInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString()));
        UIViewExtFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteListSetSolution(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)pk.toString()));
        ListSetSolutionFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private void deleteListFilterSolution(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)pk.toString()));
        ListFilterSolutionFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    @Override
    protected IObjectPK _createBaseItemUIViews(Context ctx, IObjectValue model, boolean isProductionMode) throws BOSException, EASBizException {
        IBaseItemLevelUpRecord iBaseItemLevelUpRecord = BaseItemLevelUpRecordFactory.getLocalInstance(ctx);
        int batchNumber = iBaseItemLevelUpRecord.getMaxBatchNumber() + 1;
        return SysSettingUIViewUtil.batchCreateBaseItemUIViews(ctx, (UIViewInfo)model, isProductionMode, iBaseItemLevelUpRecord, batchNumber);
    }
}

