/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.ValidateSettingInfo;
import com.kingdee.shr.base.syssetting.app.AbstractValidateSettingControllerBean;
import com.kingdee.shr.base.syssetting.app.validate.IValidate;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ValidateSettingControllerBean
extends AbstractValidateSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.ValidateSettingControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ValidateSettingInfo info = this.getValidateSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.ENABLE);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)info);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ValidateSettingInfo info = this.getValidateSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.DISABLE);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)info);
    }

    @Override
    protected void _validateAll(Context ctx) throws BOSException, EASBizException {
        try {
            IValidate validate = (IValidate)MsfClassLoaderFactory.forName("com.kingdee.shr.base.syssetting.app.validate.Validate").newInstance();
            validate.validateAll(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _validateOne(Context ctx, String objectID, String entityName) throws BOSException, EASBizException {
        try {
            IValidate validate = (IValidate)MsfClassLoaderFactory.forName("com.kingdee.shr.base.syssetting.app.validate.Validate").newInstance();
            validate.validateOneObject(ctx, objectID, entityName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public IObjectPK save(Context ctx, CoreBaseInfo arg1) throws BOSException, EASBizException {
        ValidateSettingInfo model = (ValidateSettingInfo)arg1;
        this.checkParamValidate(model.getParam());
        this.checkTableAndFieldIsMapping(ctx, model);
        return super.save(ctx, arg1);
    }

    private void checkTableAndFieldIsMapping(Context ctx, ValidateSettingInfo model) throws EASBizException {
        if (StringUtils.isEmpty((String)model.getTableName())) {
            throw new SyssettinException(SyssettinException.TABLE_NAME_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)model.getMainObjectField())) {
            throw new SyssettinException(SyssettinException.FIELD_NOT_NULL);
        }
        try {
            DbUtil.executeQuery((Context)ctx, (String)new StringBuffer().append("select top 1 * from ").append(model.getTableName()).toString());
        }
        catch (BOSException e) {
            throw new SyssettinException(SyssettinException.TABLE_NOT_EXIST, new Object[]{model.getTableName()});
        }
        try {
            DbUtil.executeQuery((Context)ctx, (String)new StringBuffer().append("select top 1 ").append(model.getMainObjectField()).append(" from ").append(model.getTableName()).toString());
        }
        catch (BOSException e) {
            throw new SyssettinException(SyssettinException.FIELD_NOT_IN_TABLE, new Object[]{model.getMainObjectField(), model.getTableName()});
        }
        if (!StringUtils.isEmpty((String)model.getFieldName())) {
            try {
                DbUtil.executeQuery((Context)ctx, (String)new StringBuffer().append("select top 1 ").append(model.getFieldName()).append(" from ").append(model.getTableName()).toString());
            }
            catch (BOSException e) {
                throw new SyssettinException(SyssettinException.FIELD_NOT_IN_TABLE, new Object[]{model.getFieldName(), model.getTableName()});
            }
        }
    }

    private void checkParamValidate(String param) throws EASBizException {
        String[] params;
        if (StringUtils.isEmpty((String)param)) {
            return;
        }
        for (String each : params = StringUtils.split((String)param, (String)"&")) {
            int pos = each.indexOf("=");
            if (pos != -1) continue;
            throw new SyssettinException(SyssettinException.PARAM_FORMAT_ERROR);
        }
    }
}

