/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.WorkPlatformCollection;
import com.kingdee.shr.base.syssetting.WorkPlatformInfo;
import com.kingdee.shr.base.syssetting.app.AbstractWorkPlatformControllerBean;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WorkPlatformControllerBean
extends AbstractWorkPlatformControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.WorkPlatformControllerBean");

    @Override
    protected IObjectCollection _getMyWorkPlatform(Context ctx) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (null == ContextUtil.getCurrentOrgUnit((Context)ctx)) {
            return null;
        }
        boolean isOracleDB = SystemContextUtil.isOracleDB(ctx);
        FilterInfo filter = new FilterInfo();
        if (isOracleDB) {
            String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getMyWorkPlatformIdSql(permissionSql, isOracleDB), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getNewMyWorkPlatformIdSql(permissionSql), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getMyWorkPlatformIdFilterSql(ctx, isOracleDB), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        }
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("index");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorter.add(sorterItemInfo);
        entityViewInfo.setSorter(sorter);
        entityViewInfo.setFilter(filter);
        WorkPlatformCollection result = this.getWorkPlatformCollection(ctx, entityViewInfo);
        long end = System.currentTimeMillis();
        logger.error((Object)("WorkPlatformControllerBean _getMyWorkPlatform cost:" + (end - begin)));
        return result;
    }

    @Override
    protected IObjectValue _getWorkPlatformByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        WorkPlatformInfo workPlatformInfo = null;
        if (StringUtils.isEmpty((String)uipk)) {
            workPlatformInfo = this.getWorkPlatformInfo(ctx, (IObjectPK)new ObjectUuidPK("Lq05UWZSH0SmJU3sr2GJokRLkh4="));
        } else if (this.exists(ctx, "where uipk = '" + uipk + "'")) {
            workPlatformInfo = this.getWorkPlatformInfo(ctx, "where uipk = '" + uipk + "'");
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getWorkPlatformByUipkSQL(uipk), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            WorkPlatformCollection wfcc = this.getWorkPlatformCollection(ctx, viewInfo);
            if (wfcc.size() > 0) {
                workPlatformInfo = wfcc.get(0);
                return this.getWorkPlatformInfo(ctx, workPlatformInfo);
            }
        }
        return workPlatformInfo;
    }

    @Override
    protected IObjectValue _getWorkPlatform(Context ctx, String uipk, String serviceId) throws BOSException, EASBizException {
        WorkPlatformInfo workPlatformInfo = null;
        if (StringUtils.isEmpty((String)serviceId)) {
            if (!StringUtils.isEmpty((String)uipk)) {
                String oql = "where uipk = '" + uipk + "'";
                if (this.exists(ctx, oql)) {
                    workPlatformInfo = this.getWorkPlatformInfo(ctx, oql);
                }
            } else {
                workPlatformInfo = this.getWorkPlatformInfo(ctx, (IObjectPK)new ObjectUuidPK("Lq05UWZSH0SmJU3sr2GJokRLkh4="));
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT t0.FWorkPlatformID FROM T_BS_ServiceCategory t0").append(" WHERE exists(SELECT 1 FROM T_BS_Service t1 where t0.FID = t1.FCategoryID").append(" and t1.FID = '").append(serviceId).append("')");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            WorkPlatformCollection wfcc = this.getWorkPlatformCollection(ctx, viewInfo);
            if (wfcc.size() > 0) {
                workPlatformInfo = wfcc.get(0);
                return this.getWorkPlatformInfo(ctx, workPlatformInfo);
            }
        }
        return workPlatformInfo;
    }

    private WorkPlatformInfo getWorkPlatformInfo(Context ctx, WorkPlatformInfo workPlatformInfo) throws EASBizException, BOSException {
        IObjectPK pk;
        WorkPlatformInfo result = workPlatformInfo;
        if (!WorkPlatformUtil.isShowOldWorkbench(ctx) && null != (pk = WorkPlatformUtil.getOld2NewTransPk(workPlatformInfo.getId().toString()))) {
            result = this.getWorkPlatformInfo(ctx, pk);
        }
        return result;
    }
}

