/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.util.Rijndael_Util;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.tools.ISHRJsonExportAndImport;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.security.InvalidKeyException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SHRJsonExportAndImport
implements ISHRJsonExportAndImport {
    protected static final String FIELD_NAME = "fieldName";
    protected static final String DATA_TYPE = "dataType";
    protected static final String KEY_VALUE = "SHRImportAndExport";
    protected static final String CREATOR_ID = "FCreatorID";
    protected static final String LAST_UPDATE_USER_ID = "FLastUpdateUserID";
    protected static final String CONTROL_UNIT_ID = "FControlUnitID";
    protected static final String CREATE_TIME = "FCreateTime";
    protected static final String LAST_UPDATE_TIME = "FLastUpdateTime";

    @Override
    public void importByJsonData(Context ctx, String jsonData) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)jsonData)) {
            throw new SyssettinException(SyssettinException.IMPORT_DATA_NOT_NULL);
        }
        HashMap importMap = JSONUtils.convertJsonToObject(ctx, jsonData);
        for (BOSObjectType bosType : this.getBOSObjectTypeList()) {
            List eachList = (List)importMap.get(bosType.toString());
            DataTableInfo tableInfo = this.getDataTableInfo(ctx, bosType);
            List<Map<String, Object>> columns = this.getColumnInfo(tableInfo);
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
            ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
            for (Map map : eachList) {
                int total = columns.size();
                Object[] delete = new Object[]{map.get("FID")};
                deleteParams.add(delete);
                Object[] insert = new Object[total];
                for (int i = 0; i < total; ++i) {
                    Object realValue;
                    Map<String, Object> colounInfo = columns.get(i);
                    int type = (Integer)colounInfo.get(DATA_TYPE);
                    String field = (String)colounInfo.get(FIELD_NAME);
                    Object obj = map.get(field);
                    insert[i] = realValue = this.fillFeildValue(ctx, field, type, obj, Boolean.TRUE);
                }
                insertParams.add(insert);
            }
            if (null != deleteParams && deleteParams.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)this.generateDeleteSql(tableInfo.getName()), deleteParams);
            }
            if (null == insertParams || insertParams.size() <= 0) continue;
            DbUtil.executeBatch((Context)ctx, (String)this.generateInsertSql(columns, tableInfo.getName()), insertParams);
        }
    }

    @Override
    public String exportJsonData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>();
        for (BOSObjectType bosType : this.getBOSObjectTypeList()) {
            DataTableInfo tableInfo = this.getDataTableInfo(ctx, bosType);
            List<Map<String, Object>> columns = this.getColumnInfo(tableInfo);
            List<Map<String, Object>> eachList = this.queryData(ctx, this.generateSelectSql(columns, tableInfo.getName()), columns);
            resultMap.put(bosType.toString(), eachList);
        }
        return JSONUtils.convertObjectToJson(ctx, resultMap);
    }

    protected abstract List<BOSObjectType> getBOSObjectTypeList() throws BOSException, EASBizException;

    protected abstract String generateWhereSql(List<Map<String, Object>> var1, String var2);

    protected abstract String generateSortorSql(List<Map<String, Object>> var1, String var2);

    protected DataTableInfo getDataTableInfo(Context ctx, BOSObjectType bosType) throws BOSException, EASBizException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        if (null != entityInfo) {
            return entityInfo.getTable();
        }
        throw new SyssettinException(SyssettinException.BOSTYPE_NOT_NULL, new Object[]{bosType.toString()});
    }

    protected List<Map<String, Object>> getColumnInfo(DataTableInfo tableInfo) throws BOSException, EASBizException {
        if (null == tableInfo) {
            throw new SyssettinException(SyssettinException.TABLE_INFO_NOT_NULL);
        }
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        int total = tableInfo.getColumns().size();
        for (int i = 0; i < total; ++i) {
            ColumnInfo colounInfo = tableInfo.getColumns().get(i);
            HashMap<String, Object> map = null;
            if (colounInfo.isMultilingual()) {
                for (int j = 1; j <= 3; ++j) {
                    map = new HashMap();
                    map.put(FIELD_NAME, colounInfo.getName() + "_L" + j);
                    map.put(DATA_TYPE, colounInfo.getSQLType());
                    columns.add(map);
                }
                continue;
            }
            map = new HashMap<String, Object>();
            map.put(FIELD_NAME, colounInfo.getName());
            map.put(DATA_TYPE, colounInfo.getSQLType());
            columns.add(map);
        }
        return columns;
    }

    protected String generateSelectSql(List<Map<String, Object>> columns, String tableName) {
        StringBuffer sb = new StringBuffer("select ");
        int total = columns.size();
        for (int i = 0; i < total; ++i) {
            Map<String, Object> colounInfo = columns.get(i);
            sb.append(colounInfo.get(FIELD_NAME));
            if (i >= total - 1) continue;
            sb.append(", ");
        }
        sb.append(" from ").append(tableName);
        String whereSql = this.generateWhereSql(columns, tableName);
        String sortorSql = this.generateSortorSql(columns, tableName);
        if (!StringUtils.isEmpty((String)whereSql)) {
            sb.append(" ").append(whereSql);
        }
        if (!StringUtils.isEmpty((String)sortorSql)) {
            sb.append(" ").append(sortorSql);
        }
        return sb.toString();
    }

    protected String generateInsertSql(List<Map<String, Object>> columns, String tableName) {
        StringBuffer sb = new StringBuffer("insert into ").append(tableName).append(" (");
        StringBuffer sbParam = new StringBuffer(" values (");
        int total = columns.size();
        for (int i = 0; i < total; ++i) {
            Map<String, Object> colounInfo = columns.get(i);
            sb.append(colounInfo.get(FIELD_NAME));
            sbParam.append("?");
            if (i >= total - 1) continue;
            sb.append(", ");
            sbParam.append(", ");
        }
        sb.append(")");
        sbParam.append(")");
        return sb.toString() + sbParam.toString();
    }

    protected String generateDeleteSql(String tableName) {
        StringBuffer sb = new StringBuffer("delete from ").append(tableName).append(" where fid = ?");
        return sb.toString();
    }

    protected List<Map<String, Object>> queryData(Context ctx, String sql, List<Map<String, Object>> columns) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> eachList = new ArrayList<Map<String, Object>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                int total = columns.size();
                for (int i = 0; i < total; ++i) {
                    Map<String, Object> colounInfo = columns.get(i);
                    int type = (Integer)colounInfo.get(DATA_TYPE);
                    String field = (String)colounInfo.get(FIELD_NAME);
                    Object value = rs.getObject(field);
                    obj.put(field, this.fillFeildValue(ctx, field, type, value, Boolean.FALSE));
                }
                eachList.add(obj);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return eachList;
    }

    protected Object fillFeildValue(Context ctx, String filedName, int sqlType, Object value, boolean isImport) throws BOSException {
        Object result = null;
        if (null == value) {
            return result;
        }
        String tempValue = String.valueOf(value);
        if (2005 == sqlType) {
            try {
                if (isImport) {
                    result = Rijndael_Util.decode((String)KEY_VALUE, (String)tempValue);
                }
                result = Rijndael_Util.encode((String)KEY_VALUE, (String)tempValue);
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        } else if (4 == sqlType) {
            result = tempValue.indexOf(".") != -1 ? Integer.valueOf(Integer.parseInt(tempValue.substring(0, tempValue.indexOf(".")))) : Integer.valueOf(Integer.parseInt(tempValue));
        } else if (1 == sqlType || 12 == sqlType) {
            result = tempValue;
        } else if (93 == sqlType) {
            try {
                Date date = DateTimeUtils.parseDate((String)tempValue, (String)"yyyy-MM-dd HH:mm:ss");
                result = new Timestamp(date.getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        } else if (2 == sqlType) {
            result = Double.parseDouble(tempValue);
        } else if (-3 == sqlType || -2 == sqlType || 2004 == sqlType) {
            // empty if block
        }
        return result;
    }

    protected Object getObjectBaseValue(Context ctx, String filedName, int sqlType, Object value, boolean isImport) throws BOSException {
        Object result = null;
        if (!isImport) {
            return result;
        }
        String userId = HRFilterUtils.getCurrentUserId(ctx);
        String cuId = HRFilterUtils.getCurrentCUID(ctx);
        Timestamp tm = new Timestamp(System.currentTimeMillis());
        if (CREATOR_ID.equals(filedName) || LAST_UPDATE_USER_ID.equals(filedName)) {
            result = userId;
        } else if (CONTROL_UNIT_ID.equals(filedName)) {
            result = cuId;
        } else if (CREATE_TIME.equals(filedName) || LAST_UPDATE_TIME.equals(filedName)) {
            result = tm;
        }
        return result;
    }
}

