/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.TransformerFactory;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class XMLUtil {
    public static XMLOutputter getXMLOutputter() {
        XMLOutputter outter = new XMLOutputter();
        Format prettyFormat = Format.getCompactFormat();
        prettyFormat.setLineSeparator("\n");
        prettyFormat.setIndent("    ");
        prettyFormat.setEncoding("UTF-8");
        outter.setFormat(prettyFormat);
        return outter;
    }

    public static String attributesToString(Element element) {
        return XMLUtil.attributesToString(element, null);
    }

    public static String attributesToString(Element element, Collection<String> excludeAttribute) {
        if (element == null) {
            return "";
        }
        List attributes = element.getAttributes();
        Attribute attribute = null;
        StringBuilder sb = new StringBuilder();
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            if (excludeAttribute != null && excludeAttribute.contains(attribute.getName())) continue;
            sb.append(XMLUtil.attributeToString(attribute));
        }
        return sb.toString();
    }

    public static String attributeToString(Attribute attribute) {
        StringBuilder sb = new StringBuilder();
        String value = attribute.getValue();
        if (!StringUtils.isEmpty((String)value)) {
            sb.append(" ");
            sb.append(attribute.getName());
            sb.append("=");
            sb.append("\"");
            sb.append(value);
            sb.append("\"");
        }
        return sb.toString();
    }

    public static void setTransformerFactoryFeature(TransformerFactory tf) {
        if (null == tf) {
            return;
        }
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    public static void setReaderFeature(SAXBuilder reader) {
        if (null == reader) {
            return;
        }
        reader.setExpandEntities(false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public static Document parseXML(String xml) throws BOSException {
        SAXBuilder builder = new SAXBuilder();
        XMLUtil.setReaderFeature(builder);
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return doc;
    }

    public static String xmlToString(Document document) throws IOException {
        StringWriter out = null;
        String sReturn = "";
        XMLOutputter outputter = XMLUtil.getXMLOutputter();
        out = new StringWriter();
        outputter.output(document, (Writer)out);
        sReturn = out.toString();
        return sReturn;
    }

    public static List<Element> getElements(Document doc, String searchPattern) throws JDOMException {
        Element rootElement = doc.getRootElement();
        XPath xPath = XPath.newInstance((String)searchPattern);
        List fields = xPath.selectNodes((Object)rootElement);
        return fields;
    }

    public static Element getElement(Element root, String elementName) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            return root;
        }
        Element element = null;
        Element result = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size && (result = XMLUtil.getElement(element = (Element)children.get(i), elementName)) == null; ++i) {
            }
        }
        return result;
    }

    public static List<Element> getElements(Element root, String elementName, List<Element> elements) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            elements.add(root);
        }
        Element element = null;
        Object result = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                XMLUtil.getElements(element, elementName, elements);
            }
        }
        return elements;
    }

    public static Element mergeElement(Element base, Element newElement) {
        if (!base.getName().equalsIgnoreCase(newElement.getName())) {
            return base;
        }
        XMLUtil.overwriteAttribute(base, newElement);
        List children = base.getChildren();
        Element subElement = null;
        Element newSubElement = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            subElement = (Element)children.get(i);
            newSubElement = XMLUtil.getElement(newElement, subElement.getName());
            if (newSubElement == null) continue;
            XMLUtil.mergeElement(subElement, newSubElement);
            newSubElement.detach();
        }
        children = newElement.getChildren();
        while (children.size() > 0) {
            subElement = (Element)children.get(0);
            subElement.detach();
            base.addContent((Content)subElement);
        }
        return base;
    }

    public static void overwriteAttribute(Element base, Element newElement) {
        List attributes = newElement.getAttributes();
        Attribute attribute = null;
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            base.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static void removeExcludeAttribute(Element element, Collection<String> excludeAttribute) {
        for (String item : excludeAttribute) {
            element.removeAttribute(item);
        }
    }
}

