/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.runtime;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.fieldrule.formula.FieldRuleFormulaException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.IObjectLoaderProvider;
import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.ArrayIndexerExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BigDecimalExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BinaryOpExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BoolExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CodeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.DoubleExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.FloatExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.IdentifierExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.IntExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.LongExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.MethodInvokeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.NullExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.ObjectCreateExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.PropertyExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.StringExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.UnaryExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.VectorCreateExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.ExprParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.FieldRuleScriptParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Lexer;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Token;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.TokenList;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.ArrayIterator;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.ArrayIterator2;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.SingleIterator;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.CodeStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ElseIfItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ExprStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.IfStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ReturnStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclStmt;
import com.kingdee.util.TODOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleFormulaUtil {
    private static Logger log = LoggerFactory.getLogger(FieldRuleFormulaUtil.class);
    private static IObjectLoaderProvider bizObjectProvider = null;

    private FieldRuleFormulaUtil() {
    }

    public static IObjectLoaderProvider getBizObjectProvider() {
        return bizObjectProvider;
    }

    public static void setBizObjectProvider(IObjectLoaderProvider bizObjectProvider) {
        FieldRuleFormulaUtil.bizObjectProvider = bizObjectProvider;
    }

    public static Boolean isBoolExpr(String script) throws FieldRuleFormulaException {
        Boolean rtnVal = null;
        ExprParser parser = new ExprParser(script);
        CodeExpr expr = parser.expr();
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            switch (binaryOpExpr.operator) {
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 18: {
                    rtnVal = Boolean.TRUE;
                    break;
                }
                default: {
                    rtnVal = Boolean.FALSE;
                }
            }
        }
        return rtnVal;
    }

    public static void computeIdent(String script, Collection<Object> identCol) throws FieldRuleFormulaException {
        if (script == null) {
            return;
        }
        FieldRuleScriptParser parser = new FieldRuleScriptParser(script);
        parser.parse();
        List<CodeStmt> stmtList = parser.stmtList;
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = stmtList.get(i);
            FieldRuleFormulaUtil.computeIdent(stmt, identCol);
        }
    }

    public static void computeIdent(CodeStmt stmt, Collection<Object> identCol) throws FieldRuleFormulaException {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            FieldRuleFormulaUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            FieldRuleFormulaUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof VarDeclStmt) {
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (int i = 0; i < declStmt.varDeclList.size(); ++i) {
                VarDeclItem item = declStmt.varDeclList.get(i);
                if (item.initExpr == null) continue;
                FieldRuleFormulaUtil.computeIdent(item.initExpr, identCol);
            }
        } else if (stmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)stmt;
            FieldRuleFormulaUtil.computeIdent(ifStmt.testExpr, identCol);
            for (i = 0; i < ifStmt.trueStmtList.size(); ++i) {
                FieldRuleFormulaUtil.computeIdent(ifStmt.trueStmtList.get(i), identCol);
            }
            if (ifStmt.elseStmtList != null) {
                for (i = 0; i < ifStmt.elseStmtList.size(); ++i) {
                    FieldRuleFormulaUtil.computeIdent(ifStmt.elseStmtList.get(i), identCol);
                }
            }
            if (ifStmt.elseIfList != null) {
                for (i = 0; i < ifStmt.elseIfList.size(); ++i) {
                    ElseIfItem elseIf = (ElseIfItem)ifStmt.elseIfList.get(i);
                    FieldRuleFormulaUtil.computeIdent(elseIf.testExpr, identCol);
                    if (elseIf.stmtList == null) continue;
                    for (int j = 0; j < elseIf.stmtList.size(); ++j) {
                        FieldRuleFormulaUtil.computeIdent(elseIf.stmtList.get(j), identCol);
                    }
                }
            }
        } else {
            throw new TODOException();
        }
    }

    public static void computeIdent(CodeExpr expr, Collection<Object> identCollection) throws FieldRuleFormulaException {
        if (expr == null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof PropertyExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)expr;
            FieldRuleFormulaUtil.computeIdent(unaryExpr.expr, identCollection);
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            FieldRuleFormulaUtil.computeIdent(binaryOpExpr.left, identCollection);
            FieldRuleFormulaUtil.computeIdent(binaryOpExpr.right, identCollection);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                FieldRuleFormulaUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (CodeExpr pramExpr : objCreateExpr.paramList) {
                FieldRuleFormulaUtil.computeIdent(pramExpr, identCollection);
            }
        } else {
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                return;
            }
            if (expr instanceof ArrayIndexerExpr) {
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                FieldRuleFormulaUtil.computeIdent(arrayIndexerExpr.targetObjExpr, identCollection);
                FieldRuleFormulaUtil.computeIdent(arrayIndexerExpr.indexExpr, identCollection);
            } else if (expr instanceof VectorCreateExpr) {
                VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                    CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                    FieldRuleFormulaUtil.computeIdent(pramExpr, identCollection);
                }
            } else {
                throw new TODOException();
            }
        }
    }

    public static String replaceIdent(String text, String oldString, String newString) throws ParserException {
        String[] textStrings = text.split("\n|\r\n|\r|\n\r");
        StringBuffer resultBuf = new StringBuffer();
        for (int i = 0; i < textStrings.length; ++i) {
            String textStr = textStrings[i];
            Lexer lexer = new Lexer(textStr);
            TokenList tokList = new TokenList(lexer);
            while (!tokList.lookup(0).equals(Token.EOFToken)) {
                Token token = tokList.next();
                if (token.type == 1 && token.value.equals(oldString)) {
                    token.value = newString;
                }
                if (token.type == 6) {
                    resultBuf.append("\"" + token.value + "\" ");
                    continue;
                }
                if (token.type == 7) {
                    resultBuf.append("'" + token.value + "'");
                    continue;
                }
                if (token.type == 0 || token.type == 14) {
                    throw new ParserException("todo.", token, "unsuport LineComment and MultiLineComment token now");
                }
                resultBuf.append(token.value + " ");
            }
            if (textStr.indexOf("//") > -1) {
                String scriptComments = textStr.substring(textStr.indexOf("//"));
                resultBuf.append(scriptComments);
            }
            resultBuf.append("\n");
        }
        return resultBuf.substring(0, resultBuf.length() - 1);
    }

    public static boolean isCollection(Object obj) {
        if (obj == null) {
            return false;
        }
        return bizObjectProvider != null && bizObjectProvider.isObjectCollection(obj) || obj instanceof Collection || obj instanceof Array || obj.getClass().isArray();
    }

    public static Iterator<?> getIterator(Object obj) {
        if (bizObjectProvider != null && bizObjectProvider.isObjectCollection(obj)) {
            return bizObjectProvider.getObjectCollectionIterator(obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Array) {
            return new ArrayIterator((Array)obj);
        }
        if (obj != null && obj.getClass().isArray()) {
            return new ArrayIterator2(obj);
        }
        return new SingleIterator(obj);
    }

    public static Object evalJavaMethod(Object object, Method method, Object[] params) throws SecurityException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> objCls = method.getDeclaringClass();
        String methodName = method.getName();
        Class<?>[] argCls = method.getParameterTypes();
        try {
            method.setAccessible(true);
            if (object instanceof IObjectValue) {
                CoreBaseInfo info = (CoreBaseInfo)object;
                info.get("entrys.position");
            }
            return method.invoke(object, params);
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException : FieldRuleFormulaUtil.evalJavaMethod");
            Class<?>[] inters = objCls.getInterfaces();
            for (int i = 0; i < inters.length; ++i) {
                try {
                    method = inters[i].getMethod(methodName, argCls);
                    return method.invoke(object, null);
                }
                catch (NoSuchMethodException ex) {
                    log.error("NoSuchMethodException : FieldRuleFormulaUtil.evalJavaMethod");
                    continue;
                }
                catch (IllegalAccessException e2) {
                    log.error("IllegalAccessException : FieldRuleFormulaUtil.evalJavaMethod");
                }
            }
            while (true) {
                if ((objCls = objCls.getSuperclass()) == null) {
                    throw new IllegalAccessException("Can't find method " + methodName + " in Class " + objCls + " and its super class with modifier public.");
                }
                try {
                    method = objCls.getMethod(methodName, argCls);
                    return method.invoke(object, null);
                }
                catch (NoSuchMethodException ex) {
                    log.error("NoSuchMethodException : FieldRuleFormulaUtil.evalJavaMethod");
                    continue;
                }
                catch (IllegalAccessException e3) {
                    log.error("IllegalAccessException : FieldRuleFormulaUtil.evalJavaMethod");
                    continue;
                }
                break;
            }
        }
    }

    public static Method findGetMethod(Class<?> c, String fieldName) {
        Method[] methodArray = c.getMethods();
        String[] methNameArray = Character.isLowerCase(fieldName.charAt(0)) ? new String[]{"get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), fieldName, "get" + fieldName, "get" + fieldName} : new String[]{fieldName, "get" + fieldName, "is" + fieldName};
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 0) continue;
            for (int j = 0; j < methNameArray.length; ++j) {
                if (!methodArray[i].getName().equals(methNameArray[j])) continue;
                return methodArray[i];
            }
        }
        return null;
    }

    public static Method findSetMethod(Class<?> c, String fieldName) {
        Method[] methodArray = c.getMethods();
        String[] methNameArray = Character.isLowerCase(fieldName.charAt(0)) ? new String[]{"set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), fieldName, "set" + fieldName} : new String[]{fieldName, "set" + fieldName};
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 1) continue;
            for (int j = 0; j < methNameArray.length; ++j) {
                if (!methodArray[i].getName().equals(methNameArray[j])) continue;
                return methodArray[i];
            }
        }
        return null;
    }

    static {
        try {
            bizObjectProvider = (IObjectLoaderProvider)Class.forName("com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleScriptObjectLoader").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

