/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.baseconfig.IStructureConfig;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FunUtils {
    private static Map<String, Object> sessionMap = new HashMap<String, Object>();

    public static void clearSessionMap() {
        sessionMap.clear();
    }

    public static String decodeSorter(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] split = str.split(",");
        StringBuffer res = new StringBuffer();
        for (String s : split) {
            if (StringUtils.isEmpty((String)s) || s.trim() == "") continue;
            if (s.contains(".")) {
                res.append(",\"" + s.trim().split("\\s")[0] + "\"");
                continue;
            }
            res.append("," + s.trim());
        }
        return res.toString().startsWith(",") ? res.toString().substring(1) : res.toString();
    }

    public static Object filterConvertData(String value, String dataType) {
        if (value.indexOf(",") > -1 || value.indexOf("\uff0c") > -1) {
            String[] str = value.split(",");
            if (str.length == 1) {
                str = value.split("\uff0c");
            }
            HashSet set = new HashSet();
            Collections.addAll(set, str);
            return set;
        }
        if ("String".equalsIgnoreCase(dataType) || "StringEnum".equalsIgnoreCase(dataType)) {
            return value;
        }
        if ("Date".equalsIgnoreCase(dataType)) {
            java.util.Date dateValue = null;
            try {
                dateValue = DateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return dateValue;
        }
        if ("Boolean".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("Integer".equalsIgnoreCase(dataType) || "IntEnum".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("BigDecimal".equalsIgnoreCase(dataType)) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static String getDateStr(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static FilterInfo getFilterQuery(Context ctx, String filters) throws BOSException, ParserException {
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((String)filters) || "false".equalsIgnoreCase(filters) || "[]".equalsIgnoreCase(filters) || "[[]]".equalsIgnoreCase(filters)) {
            return filter;
        }
        if (!(filters.contains("prop_field") && filters.contains("prop_op") && filters.contains("prop_value"))) {
            filter = new FilterInfo(filters.replace("[\"", "").replace("\"]", ""));
            return filter;
        }
        List filterList = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)filters, List.class);
        if (filterList != null && filterList.size() > 0) {
            Map filterMap = null;
            List eachListFilter = null;
            for (int k = 0; k < filterList.size(); ++k) {
                eachListFilter = (List)filterList.get(k);
                String prop_field = null;
                String prop_op = null;
                String prop_value = null;
                String field_type = null;
                Object value = null;
                FilterInfo filterInfo = new FilterInfo();
                for (int i = 0; i < eachListFilter.size(); ++i) {
                    filterMap = (Map)eachListFilter.get(i);
                    prop_field = (String)filterMap.get("prop_field");
                    prop_op = (String)filterMap.get("prop_op");
                    prop_value = (String)filterMap.get("prop_value");
                    field_type = (String)filterMap.get("field_type");
                    try {
                        value = FunUtils.filterConvertData(prop_value, field_type);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    CompareType compareType = CompareType.getEnum((String)prop_op);
                    if (value != null && value instanceof Set) {
                        if (compareType.equals((Object)CompareType.LIKE)) {
                            compareType = CompareType.INCLUDE;
                        } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                            compareType = CompareType.NOTINCLUDE;
                        }
                    }
                    if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && field_type.equals("String")) {
                        value = "%" + value + "%";
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
                }
                if (filterList.size() == 1) {
                    return filterInfo;
                }
                try {
                    filter.mergeFilter(filterInfo, "or");
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    public static String getRound(int pre, double v) {
        if (pre < 0) {
            return String.valueOf(v);
        }
        int maxPre = 30;
        BigDecimal b = new BigDecimal(Double.toString(v));
        b = pre > maxPre ? b.setScale(pre, 4) : b.setScale(maxPre, 4).setScale(pre, 4);
        StringBuffer f = new StringBuffer(pre == 0 ? "" : "0.");
        for (int i = 0; i < pre; ++i) {
            f.append("0");
        }
        DecimalFormat format = new DecimalFormat(f.toString());
        String value = format.format(b.doubleValue());
        return value.replaceAll(",", "").replaceAll(" ", "");
    }

    public static String getSessionKey(String key) {
        java.util.Date date = new java.util.Date();
        key = FunUtils.MD5(key + "_" + FunUtils.getDateStr(date));
        return key;
    }

    public static Object getSessionMap(String key) {
        key = FunUtils.getSessionKey(key);
        if (sessionMap.size() > 1000) {
            FunUtils.clearSessionMap();
            return null;
        }
        if (sessionMap.containsKey(key)) {
            return sessionMap.get(key);
        }
        return null;
    }

    public static String getUserAdminRangeSql(Context ctx, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND FType = ");
        sql.append(20);
        return sql.toString();
    }

    public static String getUserAdminRangeSqlAndCalOrgInUserAdminRang(Context ctx, String userID) {
        String orgRangeSql = FunUtils.getUserAdminRangeSql(ctx, userID);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPersonID from T_HR_EmpOrgRelation where FAdminOrgID in (");
        sql.append(orgRangeSql.toString());
        sql.append(") or ");
        sql.append(" FPersonID in (select FPersonID from T_HR_SCmpCalOrg  where FCluOrgID in (" + orgRangeSql.toString() + "))");
        return sql.toString();
    }

    public static int index(List<Map<String, Object>> list, String key, Object value) {
        if (list == null || list.size() < 1) {
            return -1;
        }
        Map<String, Object> map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            if (!map.get(key).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(Object ... objs) {
        boolean flag = false;
        for (Object o : objs) {
            if (o == null || String.valueOf(o).trim().length() == 0) {
                return true;
            }
            if (o instanceof Collection && ((Collection)o).size() == 0) {
                return true;
            }
            if (o instanceof Set && ((Set)o).size() == 0) {
                return true;
            }
            if (o instanceof List && ((List)o).size() == 0) {
                return true;
            }
            if (!(o instanceof IObjectCollection) || ((IObjectCollection)o).size() != 0) continue;
            return true;
        }
        return flag;
    }

    public static String join(List<String> list, String str) {
        StringBuffer sb = new StringBuffer();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            string = list.get(i);
            if (StringUtils.isEmpty((String)string)) {
                string = "";
            }
            sb.append(string);
            if (i >= list.size() - 1) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    public static String join(Object[] o, String str) {
        StringBuffer str_buff = new StringBuffer();
        int len = o.length;
        for (int i = 0; i < len; ++i) {
            str_buff.append(String.valueOf(o[i]));
            if (i >= len - 1) continue;
            str_buff.append(str);
        }
        return str_buff.toString();
    }

    public static String join(Set<String> list, String str) {
        StringBuffer sb = new StringBuffer();
        for (String string : list) {
            if (StringUtils.isEmpty((String)string)) {
                string = "";
            }
            sb.append(str + string);
        }
        return sb.toString().replaceFirst(str, "");
    }

    public static String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            String md5Str = new String(str);
            return md5Str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static java.util.Date parseDate(String dateStr) throws ParseException {
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(dateStr);
    }

    public static List removeDuplicateWithOrder(List list) {
        HashSet set = new HashSet();
        ArrayList newList = new ArrayList();
        for (Object element : list) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        list.clear();
        list.addAll(newList);
        return list;
    }

    public static Map<String, Object> replaceMapKey(Map<String, Object> map, String key1, String key2) {
        map.put(key2, map.get(key1));
        map.remove(key1);
        return map;
    }

    public static void setSessionMap(String key, Object value) {
        key = FunUtils.getSessionKey(key);
        sessionMap.put(key, value);
        System.out.println("FunUtil  key:" + key + "*****sessionMap.size:" + sessionMap.size());
    }

    public static Object[] sort(Object[] list, String sidx, String sord) {
        int i = 0;
        int j = 0;
        Object[] array = (Map[])list;
        Object map1 = null;
        Object map2 = null;
        String value1 = null;
        String value2 = null;
        for (i = 0; i < array.length; ++i) {
            for (j = 1 + i; j < array.length; ++j) {
                map1 = array[i];
                value1 = String.valueOf(map1.get(sidx));
                map2 = array[j];
                value2 = String.valueOf(map2.get(sidx));
                if ("desc".equalsIgnoreCase(sord)) {
                    if (value1.compareTo(value2) >= 0) continue;
                    array[i] = map2;
                    array[j] = map1;
                    continue;
                }
                if (value1.compareTo(value2) <= 0) continue;
                array[i] = map2;
                array[j] = map1;
            }
        }
        return array;
    }

    public static String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal res = new BigDecimal(0);
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)(str = str.replace(",", "")))) {
            try {
                res = new BigDecimal(str);
            }
            catch (Exception e) {
                res = new BigDecimal(0);
            }
        }
        return res;
    }

    public static Boolean toBoolean(Object obj) {
        boolean res = false;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            if ("null".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "0".equalsIgnoreCase(str) || "-1".equalsIgnoreCase(str) || "undefind".equalsIgnoreCase(str) || "[]".equalsIgnoreCase(str) || "[[]]".equalsIgnoreCase(str) || "{}".equalsIgnoreCase(str) || "".equalsIgnoreCase(str)) {
                return res;
            }
            return true;
        }
        return res;
    }

    public static java.util.Date toDate(Object obj) {
        java.util.Date res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                res = sdf.parse(str);
            }
            catch (ParseException e) {
                sdf = new SimpleDateFormat("yyyy/M/d");
                try {
                    res = sdf.parse(str);
                }
                catch (ParseException e1) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd");
                    try {
                        res = sdf.parse(str);
                    }
                    catch (ParseException e2) {
                        sdf = new SimpleDateFormat("yyyy-M-d");
                        try {
                            res = sdf.parse(str);
                        }
                        catch (ParseException e3) {
                            sdf = new SimpleDateFormat("EEE MMM d H:m:s z y");
                            try {
                                res = sdf.parse(str);
                            }
                            catch (ParseException e4) {
                                sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyy", Locale.US);
                                try {
                                    res = sdf.parse(str);
                                }
                                catch (ParseException e5) {
                                    res = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    public static Double toDouble(Object obj) {
        Double res = FunUtils.toBigDecimal(obj).doubleValue();
        return res;
    }

    public static Integer toInt(Object obj) {
        Integer res = 0;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = Integer.parseInt(str);
            }
            catch (Exception e5) {
                res = 0;
            }
        }
        return res;
    }

    public static Long toLong(Object obj) {
        Long res = 0L;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = Long.parseLong(str);
            }
            catch (Exception e5) {
                res = 0L;
            }
        }
        return res;
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof java.util.Date || obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(obj);
            }
            return obj.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Timestamp toTimestamp(Object obj) {
        Object res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS", Locale.ENGLISH);
                dateFormat.setLenient(false);
                java.util.Date timeDate = dateFormat.parse(str);
                Timestamp dateTime = new Timestamp(timeDate.getTime());
                return dateTime;
            }
            catch (Exception e5) {
                res = null;
            }
        }
        return res;
    }

    public static Map<String, StructureConfigInfo> getCmpStructureMapByNum(Context ctx, String configNum) throws BOSException {
        HashMap<String, StructureConfigInfo> map = new HashMap<String, StructureConfigInfo>();
        IStructureConfig structureConfig = StructureConfigFactory.getLocalInstance((Context)ctx);
        String oql = "select id,clientNumber,name,EntityName where scheme.number='" + configNum + "'";
        StructureConfigCollection coll = structureConfig.getStructureConfigCollection(oql);
        String number = "";
        StructureConfigInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            number = info.getClientNumber();
            map.put(number, info);
        }
        return map;
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        String tableField = "";
        ColumnInfo column = null;
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            column = propertyInfo.getMappingField();
            if (column == null) continue;
            tableField = column.getName();
            if (propertyInfo instanceof OwnPropertyInfo && ((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                map.put(tableField, propertyInfo);
                map.put(tableField + "_L1", propertyInfo);
                map.put(tableField + "_L2", propertyInfo);
                map.put(tableField + "_L3", propertyInfo);
                continue;
            }
            map.put(tableField, propertyInfo);
        }
        return map;
    }

    public static String toKSqlDate(java.util.Date date) {
        String res = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            res = "{ts '" + sdf.format(date) + "'}";
        }
        catch (Exception e5) {
            return null;
        }
        return res;
    }
}

