/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.DownloadPrecessHelper;
import com.kingdee.eas.client.startup.precess.UpdateListener;
import com.kingdee.eas.client.startup.update.BatchUpdater;
import com.kingdee.eas.client.startup.update.check.CacheStateFactory;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import com.kingdee.eas.client.startup.update.handler.cdn.CdnUpdateHandler;
import com.kingdee.eas.client.startup.update.handler.odds.OddsUpdateHandler;
import com.kingdee.eas.client.startup.update.handler.server.EasServerUpdateHandler;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import com.kingdee.eas.client.startup.update.model.UpdateModelFactory;
import com.kingdee.eas.client.startup.util.CostTimeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EasClientExplicitUpdater {
    private static final Logger logger = ClientStartLogger.getLogger();
    private final ICacheState cacheState = CacheStateFactory.createCurrentCacheState();
    private BatchUpdater odds;
    private BatchUpdater cdn;
    private BatchUpdater easServer;
    private UpdateModel model = UpdateModelFactory.getDefaultUpdateModel(this.cacheState);

    public static EasClientExplicitUpdater getInstance() {
        return new EasClientExplicitUpdater();
    }

    private EasClientExplicitUpdater() {
        this.odds = new BatchUpdater(this.model, new OddsUpdateHandler(this.model));
        this.cdn = new BatchUpdater(this.model, new CdnUpdateHandler(this.model));
        this.easServer = new BatchUpdater(this.model, new EasServerUpdateHandler(this.model));
    }

    public synchronized Map<EASClientFile, List<String>> update() {
        if (0 == this.model.getNeedUpdate().size()) {
            logger.info((Object)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6587\u4ef6");
            return new HashMap<EASClientFile, List<String>>();
        }
        UpdateListener.startStep("\u4e0b\u8f7d\u9700\u8981\u66f4\u65b0\u7684\u6587\u4ef6");
        UpdateListener.setProgressDetail("\u4e0b\u8f7d\u9700\u8981\u66f4\u65b0\u7684\u6587\u4ef6,\u5f00\u59cb...");
        CostTimeUtil util = CostTimeUtil.createInstance();
        DownloadPrecessHelper.startProgress(this.model.getNeedUpdate());
        this.odds.update();
        this.cdn.update();
        this.easServer.update();
        UpdateListener.setProgressTip("\u66f4\u65b0\u5b8c\u6210");
        UpdateListener.setProgressDetail("\u4e0b\u8f7d\u9700\u8981\u66f4\u65b0\u7684\u6587\u4ef6,\u5b8c\u6210,\u7528\u65f6" + util.costBySecond() + "\u79d2");
        Map<EASClientFile, List<String>> updateFailed = this.model.getUpdateFailed();
        logger.info((Object)("\u66f4\u65b0\u5931\u8d25\u7684\u6587\u4ef6\u5171\u6709" + updateFailed.size() + "\u4e2a"));
        int counter = 1;
        for (EASClientFile file : updateFailed.keySet()) {
            StringBuffer sb = new StringBuffer("\u7b2c" + counter + "\u4e2a\u6587\u4ef6" + file.getPath() + ":\u66f4\u65b0\u5931\u8d25\u7684\u539f\u56e0{");
            List<String> failReasons = updateFailed.get(file);
            for (String failReason : failReasons) {
                sb.append("\r\n");
                sb.append("[");
                sb.append(failReason);
                sb.append("]");
            }
            sb.append("\r\n");
            sb.append("}");
            logger.info((Object)sb.toString());
            UpdateListener.setProgressDetail(sb.toString());
        }
        UpdateListener.stopStep();
        return this.model.getUpdateFailed();
    }
}

