/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload;

import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.exception.NetworkException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadTask;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadWorker;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpSiteInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.HttpTimeoutHandler;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.LimitedInputStream;
import com.kingdee.eas.client.startup.util.NetworkExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HttpClientDownloadWorker
extends DownloadWorker {
    private static final Logger logger = ClientStartLogger.getLogger();
    private HttpURLConnection httpConnection = null;

    public HttpClientDownloadWorker(DownloadTask task, HttpFileInfo file) {
        super(task, file);
    }

    protected void closeWorker() {
        if (this.httpConnection != null) {
            try {
                this.httpConnection.disconnect();
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
        }
    }

    protected InputStream getHttpInputStream(Properties requetProps, String fileToDownload) throws IOException {
        HttpSiteInfo server = this.task.getSiteInfo();
        String downloadURL = "http://" + server.getAddress() + ":" + server.getPort() + fileToDownload;
        logger.info((Object)("[download] start to download from [" + downloadURL + "]..."));
        URL url = null;
        try {
            url = new URL((URL)null, downloadURL, new HttpTimeoutHandler(downloadTimeOut * 2));
            this.httpConnection = (HttpURLConnection)url.openConnection();
            this.httpConnection.setRequestProperty("Connection", "Close");
            if (requetProps != null) {
                String key = "";
                Enumeration<Object> en = requetProps.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    this.httpConnection.setRequestProperty(key, requetProps.getProperty(key));
                }
            }
            this.httpConnection.setRequestMethod("GET");
            this.httpConnection.connect();
        }
        catch (IOException e) {
            NetworkException networkException = NetworkExceptionHandler.handle(url, e);
            throw EASClientException.convert("\u4e0b\u8f7d\u5931\u8d25", networkException);
        }
        int contentLength = this.httpConnection.getContentLength();
        logger.info((Object)("[download] server return content-length[" + contentLength + "] from [" + downloadURL + "], "));
        if (contentLength == -1) {
            return this.httpConnection.getInputStream();
        }
        return new LimitedInputStream(this.httpConnection.getInputStream(), contentLength);
    }
}

