/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload.kill;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.httpdownload.kill.DOSCommand;
import com.kingdee.eas.client.startup.update.download.httpdownload.kill.ShowOwnPID;
import com.kingdee.eas.client.startup.update.download.httpdownload.kill.WmicProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DeleteFileUtil {
    private static final Logger logger = ClientStartLogger.getLogger();

    public static void deleteFile(File destFile) throws IOException {
        DeleteFileUtil.deleteFile(destFile, false);
    }

    public static void deleteFile(File destFile, boolean forceKill) throws IOException {
        if (DeleteFileUtil.retryDeleteSuccess(destFile)) {
            return;
        }
        logger.info((Object)("delete " + destFile + " failed, file has been locked."));
        logger.info((Object)("\u66f4\u65b0\u5931\u8d25\uff0c\u6587\u4ef6" + destFile + " \u88ab\u5176\u4ed6\u8fdb\u7a0b\u5360\u7528"));
        boolean isOnDemandUpdate = ClientConfigUtil.isOndemandUpdate();
        System.out.println("isOnDemandUpdate=" + isOnDemandUpdate);
        logger.info((Object)("\u662f\u5426\u6309\u9700\u66f4\u65b0\uff1f" + (isOnDemandUpdate ? " \u662f" : "\u5426")));
        List easClientProcessList = DeleteFileUtil.getOtherEasClientProcessList();
        if (isOnDemandUpdate) {
            logger.info((Object)"\u6309\u9700\u66f4\u65b0\u7684\u573a\u666f\u6bd4\u8f83\u590d\u6742,\u6682\u4e0d\u5904\u7406,\u4e0a\u8ff0\u8fdb\u7a0b\u4fe1\u606f\u4f9b\u6536\u96c6\u5206\u6790");
            return;
        }
        logger.info((Object)"\u5168\u66f4\u65b0\u7684\u573a\u666f\uff0c\u63d0\u793a\u7528\u6237\u5173\u6389\u5176\u4ed6\u8fdb\u7a0b");
        if (easClientProcessList.size() == 0) {
            JOptionPane.showMessageDialog(null, "\u6b63\u5728\u66f4\u65b0\u7684\u6587\u4ef6" + destFile.getAbsolutePath() + "\u88ab\u5176\u4ed6\u5e94\u7528\u7a0b\u5e8f\u5360\u7528\u3002" + "\r\n" + "\u8bf7\u5173\u95ed\u8be5\u5e94\u7528\u7a0b\u5e8f\u540e\u91cd\u8bd5\u3002" + "\r\n" + "\u662f\u5426\u73b0\u5728\u91cd\u8bd5?\uff1f", "\u66f4\u65b0\u5931\u8d25", 1);
            DeleteFileUtil.deleteFile(destFile);
        } else if (forceKill) {
            int select = JOptionPane.showConfirmDialog(null, "\u6b63\u5728\u66f4\u65b0\u7684\u6587\u4ef6\u4ecd\u7136\u88ab\u88ab\u5176\u4ed6EAS\u5ba2\u6237\u7aef\u5360\u7528\uff0c\u662f\u5426\u5f3a\u5236\u5173\u95ed\u5176\u4ed6\u6240\u6709EAS\u5ba2\u6237\u7aef\uff1f", "\u66f4\u65b0\u5931\u8d25", 0);
            if (0 == select) {
                DeleteFileUtil.killProcesses(easClientProcessList);
            }
            DeleteFileUtil.deleteFile(destFile);
        } else {
            JOptionPane.showMessageDialog(null, "\u6b63\u5728\u66f4\u65b0\u7684\u6587\u4ef6\u88ab\u5176\u4ed6EAS\u5ba2\u6237\u7aef\u5360\u7528\u3002\r\n\u8bf7\u5173\u95ed\u6240\u6709\u5176\u4ed6EAS\u5ba2\u6237\u7aef\u540e\u91cd\u8bd5\u3002\r\n\u662f\u5426\u73b0\u5728\u91cd\u8bd5\uff1f", "\u66f4\u65b0\u5931\u8d25", 1);
            DeleteFileUtil.deleteFile(destFile, true);
        }
    }

    private static boolean retryDeleteSuccess(File destFile) {
        for (int i = 0; i < 2; ++i) {
            if (DeleteFileUtil.deteteSuccess(destFile)) {
                return true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean deteteSuccess(File destFile) {
        if (!destFile.exists()) {
            return true;
        }
        return destFile.delete();
    }

    private static List getOtherEasClientProcessList() throws IOException {
        WmicProcess[] javaProcesses = DeleteFileUtil.getAllJavaProcesses();
        List easClientProcessList = DeleteFileUtil.getOtherEasClientProcessList(javaProcesses);
        logger.info((Object)("\u9700\u8981\u780d\u6740\u7684EAS\u5ba2\u6237\u7aef\u8fdb\u7a0b\u6709" + easClientProcessList.size() + "\u4e2a"));
        return easClientProcessList;
    }

    private static void killProcesses(List easClientProcessList) throws IOException {
        for (int i = 0; i < easClientProcessList.size(); ++i) {
            WmicProcess result = (WmicProcess)easClientProcessList.get(i);
            logger.info((Object)("\u6740\u6b7beas\u5ba2\u6237\u7aef\u8fdb\u7a0b" + result.toString()));
            DOSCommand cmd = new DOSCommand();
            cmd.executeQuiety("wmic process where ProcessId=\"" + result.getProcessId() + "\"  call terminate");
        }
    }

    private static WmicProcess[] getAllJavaProcesses() throws IOException {
        DOSCommand cmd = new DOSCommand();
        cmd.executeQuiety("wmic process where name=\"javaw.exe\" list full");
        String line = cmd.getOutput();
        logger.info((Object)("wmic list \u547d\u4ee4 \u8fd4\u56de{" + line + "}"));
        WmicProcess[] ss = WmicProcess.parseResults(line);
        logger.info((Object)("\u67e5\u5230\u7684java\u8fdb\u7a0b\u6709" + ss.length + "\u4e2a:"));
        for (int i = 0; i < ss.length; ++i) {
            logger.info((Object)ss[i].toString());
        }
        return ss;
    }

    private static List getOtherEasClientProcessList(WmicProcess[] javaProcesses) {
        String selfPid = DeleteFileUtil.getCurrentPid();
        String easHome = System.getProperty("EAS_HOME");
        String easHomeTow = easHome.toLowerCase().replaceAll("\\\\", "/");
        logger.info((Object)("easHomeTow=" + easHomeTow));
        ArrayList<WmicProcess> easClientProcessList = new ArrayList<WmicProcess>();
        for (int i = 0; i < javaProcesses.length; ++i) {
            WmicProcess s = javaProcesses[i];
            if (selfPid.equals(s.getProcessId())) {
                logger.info((Object)("\u8fdb\u7a0b" + selfPid + "\u662f\u81ea\u5df1\uff0c\u5ffd\u7565\uff08\u4e0d\u81ea\u6740\uff09"));
                continue;
            }
            String CommandLine = s.getCommandLine().toLowerCase().replaceAll("\\\\", "/");
            if (-1 == CommandLine.indexOf(easHomeTow)) continue;
            easClientProcessList.add(s);
        }
        return easClientProcessList;
    }

    private static String getCurrentPid() {
        String selfPid = String.valueOf(ShowOwnPID.getCurrentPid());
        return selfPid;
    }
}

