/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.handler.odds;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import com.kingdee.eas.client.startup.update.download.DownloadResult;
import com.kingdee.eas.client.startup.update.download.URLUtils;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.handler.AbstractUpdateHandler;
import com.kingdee.eas.client.startup.update.handler.odds.OddsJARUtil;
import com.kingdee.eas.client.startup.update.handler.odds.OddsUpdateSuccessListener;
import com.kingdee.eas.client.startup.update.handler.odds.config.OddsConfigs;
import com.kingdee.eas.client.startup.update.handler.odds.config.OddsJar;
import com.kingdee.eas.client.startup.update.handler.server.EasDownloadUtil;
import com.kingdee.eas.client.startup.update.model.UpdateModel;
import com.kingdee.eas.client.startup.util.FileUtil;
import com.twmacinta.util.MD5;
import java.io.File;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OddsUpdateHandler
extends AbstractUpdateHandler {
    public OddsUpdateHandler(UpdateModel model) {
        super(model);
        this.model.addUpdateSuccessListener(new OddsUpdateSuccessListener());
        OddsConfigs.getInstance();
    }

    @Override
    public boolean isAvailable() {
        ICacheState cacheState = this.model.getCacheState();
        URL urlInJNLPCodebase = cacheState.getServerCacheEntryInfo().getHref();
        logger.info((Object)("\u5dee\u5f02\u5305\u66f4\u65b0\u529f\u80fd\u5f00\u5173\u72b6\u6001URL:" + urlInJNLPCodebase));
        String useOddsJarFunction = URLUtils.getParameter(urlInJNLPCodebase.getQuery(), "useOddsJarFunction");
        logger.info((Object)("isUseOdds =" + useOddsJarFunction));
        if (useOddsJarFunction != null && useOddsJarFunction.trim().equalsIgnoreCase("true")) {
            logger.info((Object)"\u670d\u52a1\u7aef \u5dee\u5f02\u5305\u66f4\u65b0\u529f\u80fd\u5f00\u5173\u72b6\u6001:\u5f00\u542f");
            return true;
        }
        logger.info((Object)"\u670d\u52a1\u7aef \u5dee\u5f02\u5305\u66f4\u65b0\u529f\u80fd\u5f00\u5173\u72b6\u6001:\u5173\u95ed");
        return false;
    }

    @Override
    public HttpFileInfo convert2Download(EASClientFile entryInfo) {
        OddsJar OddsJar2;
        String filePath = entryInfo.getPath();
        if (this.inCompressedFile(filePath) && null != (OddsJar2 = OddsConfigs.getInstance().findOddJar(filePath))) {
            HttpFileInfo file = new HttpFileInfo(OddsJar2.getRelativePath(), OddsJar2.getRelativePath(), OddsJar2.getMd5(), filePath);
            return file;
        }
        return null;
    }

    private boolean inCompressedFile(String filePath) {
        if (!filePath.startsWith("lib/") && !filePath.startsWith("metas/")) {
            return false;
        }
        return filePath.endsWith(".jar") || filePath.endsWith(".zip");
    }

    @Override
    public DownloadResult download(List<HttpFileInfo> files2Download) {
        return EasDownloadUtil.download(files2Download);
    }

    @Override
    public void processDownloadSuccess(HttpFileInfo downloadSuccessFile, EASClientFile entryInfo) {
        String baseDir = ClientConfigUtil.getLocalDirPath();
        String key = entryInfo.getPath();
        File oldJarFile = new File(baseDir, key);
        String oddsJarRelativePath = downloadSuccessFile.getSavePath();
        File oddsJarFile = new File(baseDir, oddsJarRelativePath);
        File newJarFile = new File(baseDir, oddsJarRelativePath.substring(0, oddsJarRelativePath.lastIndexOf("/")) + key.substring(key.lastIndexOf("/")));
        OddsJARUtil.mergeOddsJAR(oldJarFile, oddsJarFile, newJarFile);
        String newJarFileMD5 = "";
        try {
            newJarFileMD5 = MD5.getMD5(newJarFile);
        }
        catch (Throwable t) {
            throw new EASClientException("\u8ba1\u7b97\u6587\u4ef6MD5\u503c\u51fa\u9519" + newJarFile.getAbsolutePath(), t);
        }
        if (newJarFileMD5.equals(entryInfo.getMd5VersionNew())) {
            FileUtil.replace(newJarFile, oldJarFile);
            logger.info((Object)"\u5408\u5e76\u540e\u7684\u66f4\u65b0\u5305\u4e0e\u670d\u52a1\u7aef\u7684\u5b8c\u6574\u66f4\u65b0\u5305MD5\u503c\u4e00\u81f4\uff0c\u5408\u5e76\u6210\u529f\u3002");
            this.model.updateSuccess(entryInfo);
        } else {
            logger.info((Object)"---------------------------------------------");
            logger.info((Object)"\u5408\u5e76\u540e\u7684\u66f4\u65b0\u5305\u4e0e\u670d\u52a1\u7aef\u7684\u5b8c\u6574\u66f4\u65b0\u5305MD5\u503c\u4e0d\u4e00\u81f4\uff0c\u5408\u5e76\u5931\u8d25\u3002");
            logger.info((Object)("\u5408\u5e76\u5305\uff1a" + newJarFile.getAbsolutePath() + " MD5\uff1a" + newJarFileMD5));
            logger.info((Object)("\u670d\u52a1\u7aef\u5b8c\u6574\u66f4\u65b0\u5305MD5\uff1a" + entryInfo.getMd5VersionNew()));
            logger.info((Object)"---------------------------------------------");
            this.model.updateFail(entryInfo, "\u5408\u5e76\u540e\u7684\u66f4\u65b0\u5305\u4e0e\u670d\u52a1\u7aef\u7684\u5b8c\u6574\u66f4\u65b0\u5305MD5\u503c\u4e0d\u4e00\u81f4\uff0c\u5408\u5e76\u5931\u8d25\u3002");
        }
        try {
            newJarFile.delete();
            oddsJarFile.delete();
        }
        catch (Throwable t) {
            logger.error((Object)"\u5220\u9664\u5dee\u5f02\u5305\u53ca\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", t);
        }
    }

    @Override
    public String getName() {
        return "\u589e\u91cf\u66f4\u65b0";
    }
}

